/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.inputstack;

import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.spoofax.jsglr2.inputstack.InputStack;
import org.spoofax.jsglr2.parser.Position;

public class LayoutSensitiveInputStack
extends InputStack {
    private static final int TAB_SIZE = 8;
    private int currentLine = 1;
    private int currentColumn = 1;

    public LayoutSensitiveInputStack(String inputString) {
        super(inputString);
    }

    public Position currentPosition() {
        return new Position(this.currentOffset, this.currentLine, this.currentColumn);
    }

    @Override
    public void next() {
        super.next();
        if (this.currentOffset < this.inputLength) {
            if (CharacterClassFactory.isNewLine(this.currentChar)) {
                ++this.currentLine;
                this.currentColumn = 0;
            } else {
                this.currentColumn = CharacterClassFactory.isTab(this.currentChar) ? (this.currentColumn / 8 + 1) * 8 : ++this.currentColumn;
            }
        }
        if (this.currentOffset == this.inputLength) {
            ++this.currentColumn;
        }
    }
}

