/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.inputstack.incremental;

import org.spoofax.jsglr2.inputstack.IInputStack;

public abstract class AbstractInputStack
implements IInputStack {
    protected final String inputString;
    protected final int inputLength;
    protected int currentOffset = 0;

    public AbstractInputStack(String inputString) {
        this.inputString = inputString;
        this.inputLength = inputString.length();
    }

    @Override
    public abstract IInputStack clone();

    @Override
    public String inputString() {
        return this.inputString;
    }

    @Override
    public int offset() {
        return this.currentOffset;
    }

    @Override
    public int length() {
        return this.inputLength;
    }

    @Override
    public int actionQueryCharacter() {
        if (this.currentOffset < this.inputLength) {
            return this.inputString.codePointAt(this.currentOffset);
        }
        if (this.currentOffset == this.inputLength) {
            return -1;
        }
        return -1;
    }

    @Override
    public int[] actionQueryLookahead(int length) {
        int[] res = new int[length];
        int nextOffset = this.currentOffset + Character.charCount(this.getChar(this.currentOffset));
        int i = 0;
        while (i < length) {
            if (nextOffset >= this.inputLength) {
                int[] resShort = new int[i];
                System.arraycopy(res, 0, resShort, 0, i);
                return resShort;
            }
            res[i] = this.inputString.codePointAt(nextOffset);
            nextOffset += Character.charCount(res[i]);
            ++i;
        }
        return res;
    }

    @Override
    public int getChar(int offset) {
        if (offset < this.inputLength) {
            int c = this.inputString.codePointAt(offset);
            if (c > 0x10FFFF) {
                throw new IllegalStateException("Character " + c + " not supported");
            }
            return c;
        }
        return -1;
    }
}

