/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.inputstack.incremental;

import java.util.Stack;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalCharacterNode;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseForest;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseNode;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalSkippedNode;
import org.spoofax.jsglr2.inputstack.incremental.AbstractInputStack;
import org.spoofax.jsglr2.inputstack.incremental.IIncrementalInputStack;

public class EagerIncrementalInputStack
extends AbstractInputStack
implements IIncrementalInputStack {
    protected final Stack<IncrementalParseForest> stack = new Stack();

    public EagerIncrementalInputStack(IncrementalParseForest root, String inputString) {
        super(inputString);
        this.stack.push(IncrementalCharacterNode.EOF_NODE);
        this.stack.push(root);
    }

    EagerIncrementalInputStack(IncrementalParseForest root) {
        this(root, root.getYield());
    }

    @Override
    public EagerIncrementalInputStack clone() {
        EagerIncrementalInputStack clone = new EagerIncrementalInputStack(IncrementalCharacterNode.EOF_NODE, this.inputString);
        clone.stack.clear();
        for (IncrementalParseForest node : this.stack) {
            clone.stack.push(node);
        }
        clone.currentOffset = this.currentOffset;
        return clone;
    }

    @Override
    public void breakDown() {
        if (this.stack.isEmpty()) {
            return;
        }
        IncrementalParseForest current = this.stack.peek();
        if (current.isTerminal()) {
            if (current instanceof IncrementalSkippedNode) {
                this.stack.pop();
                int i = this.currentOffset + current.width();
                while (i > this.currentOffset) {
                    int c = this.inputString.codePointBefore(i);
                    this.stack.push(new IncrementalCharacterNode(c));
                    i -= Character.charCount(c);
                }
            }
            return;
        }
        this.stack.pop();
        IncrementalParseForest[] children = ((IncrementalParseNode)current).getFirstDerivation().parseForests();
        int i = children.length - 1;
        while (i >= 0) {
            this.stack.push(children[i]);
            --i;
        }
    }

    @Override
    public void next() {
        this.currentOffset += this.stack.pop().width();
    }

    @Override
    public IncrementalParseForest getNode() {
        return this.stack.empty() ? null : this.stack.peek();
    }
}

