/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.inputstack.incremental;

import org.spoofax.jsglr2.incremental.parseforest.IncrementalCharacterNode;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseForest;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseNode;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalSkippedNode;
import org.spoofax.jsglr2.inputstack.incremental.AbstractInputStack;
import org.spoofax.jsglr2.inputstack.incremental.IIncrementalInputStack;

public class LinkedIncrementalInputStack
extends AbstractInputStack
implements IIncrementalInputStack {
    private StackTuple head;

    public LinkedIncrementalInputStack(IncrementalParseForest root, String inputString) {
        super(inputString);
        this.head = new StackTuple(root, new StackTuple(IncrementalCharacterNode.EOF_NODE));
    }

    LinkedIncrementalInputStack(IncrementalParseForest root) {
        this(root, root.getYield());
    }

    @Override
    public IncrementalParseForest getNode() {
        return this.head == null ? null : this.head.node;
    }

    @Override
    public LinkedIncrementalInputStack clone() {
        LinkedIncrementalInputStack clone = new LinkedIncrementalInputStack(IncrementalCharacterNode.EOF_NODE, this.inputString);
        clone.head = this.head;
        clone.currentOffset = this.currentOffset;
        return clone;
    }

    @Override
    public void breakDown() {
        if (this.head == null) {
            return;
        }
        IncrementalParseForest current = this.head.node;
        if (current.isTerminal()) {
            if (current instanceof IncrementalSkippedNode) {
                this.head = this.head.next;
                int i = this.currentOffset + current.width();
                while (i > this.currentOffset) {
                    int c = this.inputString.codePointBefore(i);
                    this.head = new StackTuple(new IncrementalCharacterNode(c), this.head);
                    i -= Character.charCount(c);
                }
            }
            return;
        }
        this.head = this.head.next;
        IncrementalParseForest[] children = ((IncrementalParseNode)current).getFirstDerivation().parseForests();
        int i = children.length - 1;
        while (i >= 0) {
            this.head = new StackTuple(children[i], this.head);
            --i;
        }
    }

    @Override
    public void next() {
        this.currentOffset += this.head.node.width();
        this.head = this.head.next;
    }

    private static class StackTuple {
        final IncrementalParseForest node;
        final StackTuple next;

        StackTuple(IncrementalParseForest node, StackTuple next) {
            this.node = node;
            this.next = next;
        }

        StackTuple(IncrementalParseForest node) {
            this(node, null);
        }
    }
}

