/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.layoutsensitive;

import java.util.Optional;
import org.metaborg.sdf2table.grammar.layoutconstraints.ArithmeticLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.BooleanLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.ComparisonLayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.ConstraintElement;
import org.metaborg.sdf2table.grammar.layoutconstraints.ILayoutConstraint;
import org.metaborg.sdf2table.grammar.layoutconstraints.NumericLayoutConstraint;
import org.spoofax.jsglr2.layoutsensitive.ILayoutSensitiveParseForest;
import org.spoofax.jsglr2.layoutsensitive.ILayoutSensitiveParseNode;
import org.spoofax.jsglr2.layoutsensitive.LayoutSensitiveParseNode;

public class LayoutConstraintEvaluator {
    public static <ParseForest extends ILayoutSensitiveParseForest> Optional<Boolean> evaluate(ILayoutConstraint layoutConstraint, ParseForest[] parseNodes) {
        Optional c1ResultOpt;
        if (layoutConstraint instanceof BooleanLayoutConstraint) {
            BooleanLayoutConstraint booleanLayoutConstraint = (BooleanLayoutConstraint)layoutConstraint;
            c1ResultOpt = LayoutConstraintEvaluator.evaluate((ILayoutConstraint)booleanLayoutConstraint.getC1(), parseNodes);
            boolean c1Result = !c1ResultOpt.isPresent() ? true : (Boolean)c1ResultOpt.get();
            switch (booleanLayoutConstraint.getOp()) {
                case AND: 
                case OR: {
                    Optional c2ResultOpt = LayoutConstraintEvaluator.evaluate((ILayoutConstraint)booleanLayoutConstraint.getC2(), parseNodes);
                    boolean c2Result = !c2ResultOpt.isPresent() ? true : (Boolean)c2ResultOpt.get();
                    switch (booleanLayoutConstraint.getOp()) {
                        case AND: {
                            return Optional.of(c1Result && c2Result);
                        }
                        case OR: {
                            return Optional.of(c1Result || c2Result);
                        }
                    }
                }
                case NOT: {
                    return Optional.of(!c1Result);
                }
            }
        }
        if (layoutConstraint instanceof ComparisonLayoutConstraint) {
            ComparisonLayoutConstraint comparisonLayoutConstraint = (ComparisonLayoutConstraint)layoutConstraint;
            c1ResultOpt = LayoutConstraintEvaluator.evaluateNumeric((ILayoutConstraint)comparisonLayoutConstraint.getC1(), parseNodes);
            Optional c2ResultOpt = LayoutConstraintEvaluator.evaluateNumeric((ILayoutConstraint)comparisonLayoutConstraint.getC2(), parseNodes);
            if (!c1ResultOpt.isPresent() || !c2ResultOpt.isPresent()) {
                return Optional.empty();
            }
            int c1Result = (Integer)c1ResultOpt.get();
            int c2Result = (Integer)c2ResultOpt.get();
            switch (comparisonLayoutConstraint.getOp()) {
                case EQ: {
                    return Optional.of(c1Result == c2Result);
                }
                case GE: {
                    return Optional.of(c1Result >= c2Result);
                }
                case GT: {
                    return Optional.of(c1Result > c2Result);
                }
                case LE: {
                    return Optional.of(c1Result <= c2Result);
                }
                case LT: {
                    return Optional.of(c1Result < c2Result);
                }
            }
        }
        throw new IllegalStateException("Could not evaluate constraint: " + layoutConstraint);
    }

    private static <ParseForest extends ILayoutSensitiveParseForest> Optional<Integer> evaluateNumeric(ILayoutConstraint layoutConstraint, ParseForest[] parseNodes) {
        if (layoutConstraint instanceof NumericLayoutConstraint) {
            NumericLayoutConstraint numericLayoutConstraint = (NumericLayoutConstraint)layoutConstraint;
            ParseForest tree = parseNodes[numericLayoutConstraint.getTree()];
            if (tree instanceof LayoutSensitiveParseNode && ((ILayoutSensitiveParseNode)tree).production().isIgnoreLayoutConstraint()) {
                return Optional.empty();
            }
            switch (numericLayoutConstraint.getToken()) {
                case FIRST: {
                    if (numericLayoutConstraint.getElem() == ConstraintElement.COL) {
                        return Optional.of(tree.getStartPosition().column);
                    }
                    return Optional.of(tree.getStartPosition().line);
                }
                case LAST: {
                    if (numericLayoutConstraint.getElem() == ConstraintElement.COL) {
                        return Optional.of(tree.getEndPosition().column);
                    }
                    return Optional.of(tree.getEndPosition().line);
                }
                case LEFT: {
                    if (tree instanceof ILayoutSensitiveParseNode) {
                        ILayoutSensitiveParseNode layoutSensitiveParseNode = (ILayoutSensitiveParseNode)tree;
                        if (layoutSensitiveParseNode.getLeftPosition() == null) {
                            return Optional.empty();
                        }
                        if (numericLayoutConstraint.getElem() == ConstraintElement.COL) {
                            return Optional.of(layoutSensitiveParseNode.getLeftPosition().column);
                        }
                        return Optional.of(layoutSensitiveParseNode.getLeftPosition().line);
                    }
                    return Optional.empty();
                }
                case RIGHT: {
                    return Optional.empty();
                }
            }
        }
        if (layoutConstraint instanceof ArithmeticLayoutConstraint) {
            ArithmeticLayoutConstraint arithmeticLayoutConstraint = (ArithmeticLayoutConstraint)layoutConstraint;
            Optional c1ResultOpt = LayoutConstraintEvaluator.evaluateNumeric((ILayoutConstraint)arithmeticLayoutConstraint.getC1(), parseNodes);
            Optional c2ResultOpt = LayoutConstraintEvaluator.evaluateNumeric((ILayoutConstraint)arithmeticLayoutConstraint.getC2(), parseNodes);
            if (!c1ResultOpt.isPresent() || !c2ResultOpt.isPresent()) {
                return Optional.empty();
            }
            int c1Result = (Integer)c1ResultOpt.get();
            int c2Result = (Integer)c2ResultOpt.get();
            switch (arithmeticLayoutConstraint.getOp()) {
                case ADD: {
                    return Optional.of(c1Result + c2Result);
                }
                case DIV: {
                    return Optional.of(c1Result / c2Result);
                }
                case MUL: {
                    return Optional.of(c1Result * c2Result);
                }
                case SUB: {
                    return Optional.of(c1Result - c2Result);
                }
            }
        }
        throw new IllegalStateException("Could not evaluate constraint: " + layoutConstraint);
    }
}

