/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.messages;

import org.spoofax.jsglr2.messages.Severity;
import org.spoofax.jsglr2.messages.SourceRegion;
import org.spoofax.jsglr2.parser.Position;

public class Message {
    public final String message;
    public final Severity severity;
    public final SourceRegion region;

    public Message(String message, Severity severity, SourceRegion region) {
        this.message = message;
        this.severity = severity;
        this.region = region;
    }

    public Message atRegion(SourceRegion otherRegion) {
        return new Message(this.message, this.severity, otherRegion);
    }

    public String toString() {
        return "\"" + this.message + "\" " + (Object)((Object)this.severity) + " @ " + this.region;
    }

    public static Message error(String message, Position position) {
        if (position == null) {
            return Message.errorAtTop(message);
        }
        SourceRegion region = new SourceRegion(position);
        return new Message(message, Severity.ERROR, region);
    }

    public static Message error(String message, SourceRegion region) {
        return new Message(message, Severity.ERROR, region);
    }

    public static Message atTop(String message, Severity severity) {
        return new Message(message, severity, null);
    }

    public static Message errorAtTop(String message) {
        return Message.atTop(message, Severity.ERROR);
    }
}

