/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.parseforest;

import java.util.Stack;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.parseforest.ICharacterNode;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.ParseNodeVisitor;
import org.spoofax.jsglr2.parser.Position;

public interface ParseNodeVisiting<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>> {
    default public void visit(JSGLR2Request request, ParseForest root, ParseNodeVisitor<ParseForest, Derivation, ParseNode> visitor) {
        Stack<Position> positionStack = new Stack<Position>();
        Stack<Object> inputStack = new Stack<Object>();
        Stack outputStack = new Stack();
        Position pivotPosition = Position.START_POSITION;
        positionStack.push(Position.START_POSITION);
        inputStack.push(root);
        outputStack.push(new Visit());
        while (!inputStack.isEmpty() || !outputStack.isEmpty()) {
            IParseNode parseNode;
            if (!outputStack.isEmpty() && ((Visit)outputStack.peek()).done()) {
                outputStack.pop();
                if (outputStack.isEmpty()) break;
                --((Visit)outputStack.peek()).remainingChildren;
                if (outputStack.isEmpty() || !((Visit)outputStack.peek()).done()) continue;
                parseNode = (IParseNode)((Visit)outputStack.pop()).parseNode;
                visitor.postVisit(parseNode, (Position)positionStack.pop(), pivotPosition);
                --((Visit)outputStack.peek()).remainingChildren;
                continue;
            }
            if (inputStack.peek() instanceof IDerivation) {
                IDerivation derivation = (IDerivation)inputStack.pop();
                outputStack.push(new Visit(derivation));
                IParseForest[] children = derivation.parseForests();
                int i = children.length - 1;
                while (i >= 0) {
                    inputStack.push(children[i]);
                    --i;
                }
                pivotPosition = (Position)positionStack.peek();
                continue;
            }
            if (inputStack.peek() instanceof ICharacterNode) {
                pivotPosition = pivotPosition.step(request.input, ((ICharacterNode)inputStack.pop()).width());
                --((Visit)outputStack.peek()).remainingChildren;
                continue;
            }
            if (!(inputStack.peek() instanceof IParseNode)) continue;
            parseNode = (IParseNode)inputStack.pop();
            positionStack.push(pivotPosition);
            boolean visitChildren = visitor.preVisit(parseNode, pivotPosition);
            if (visitChildren && parseNode.hasDerivations()) {
                int derivations = 0;
                for (IDerivation derivation : parseNode.getDerivations()) {
                    inputStack.push(derivation);
                    ++derivations;
                }
                outputStack.push(new Visit<IParseNode>(derivations, parseNode));
                continue;
            }
            pivotPosition = pivotPosition.step(request.input, parseNode.width());
            visitor.postVisit(parseNode, (Position)positionStack.pop(), pivotPosition);
            --((Visit)outputStack.peek()).remainingChildren;
        }
    }

    public static class Visit<ParseNode> {
        int remainingChildren;
        ParseNode parseNode;

        Visit() {
            this.remainingChildren = 1;
            this.parseNode = null;
        }

        Visit(IDerivation<?> derivation) {
            this.remainingChildren = derivation.parseForests().length;
            this.parseNode = null;
        }

        Visit(int remainingChildren, ParseNode parseNode) {
            this.remainingChildren = remainingChildren;
            this.parseNode = parseNode;
        }

        boolean done() {
            return this.remainingChildren == 0;
        }
    }
}

