/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.parser.observing;

import java.util.HashMap;
import java.util.Queue;
import java.util.function.Consumer;
import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.productions.IProduction;
import org.spoofax.jsglr2.JSGLR2Logging;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.elkhound.AbstractElkhoundStackNode;
import org.spoofax.jsglr2.inputstack.IInputStack;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.ForShifterElement;
import org.spoofax.jsglr2.parser.observing.RegisteringParserObserver;
import org.spoofax.jsglr2.parser.result.ParseFailure;
import org.spoofax.jsglr2.parser.result.ParseSuccess;
import org.spoofax.jsglr2.recovery.IRecoveryParseState;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.StackLink;
import org.spoofax.jsglr2.stack.collections.IForActorStacks;

public class LogParserObserver<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>, StackNode extends IStackNode, ParseState extends AbstractParseState<?, StackNode>>
extends RegisteringParserObserver<ParseForest, Derivation, ParseNode, StackNode, ParseState> {
    private final Consumer<String> logger;
    private final JSGLR2Logging[] scopes;
    private final HashMap<JSGLR2Request, Long> startTimes;

    public LogParserObserver(Consumer<String> logger, JSGLR2Logging ... scopes) {
        this.logger = logger;
        this.scopes = scopes;
        this.startTimes = new HashMap();
    }

    public LogParserObserver(Consumer<String> logger) {
        this(logger, JSGLR2Logging.All);
    }

    public LogParserObserver(JSGLR2Logging ... scopes) {
        this(System.out::println, scopes);
    }

    @Override
    public void parseStart(ParseState parseState) {
        super.parseStart(parseState);
        this.log("Starting parse" + (((AbstractParseState)parseState).request.isCompletion() ? " for completion at offset " + ((AbstractParseState)parseState).request.completionCursorOffset.get() : ""), JSGLR2Logging.Parsing, JSGLR2Logging.Minimal);
        this.startTimes.put(((AbstractParseState)parseState).request, System.currentTimeMillis());
    }

    @Override
    public void parseRound(ParseState parseState, Iterable<StackNode> activeStacks) {
        this.log("Parse character '" + this.characterToString(((IInputStack)((AbstractParseState)parseState).inputStack).getChar()) + "' (active stacks: " + this.stackQueueToString(activeStacks) + ")", JSGLR2Logging.Parsing);
    }

    @Override
    public void createStackNode(StackNode stack) {
        super.createStackNode(stack);
        this.log("    Create stack " + this.stackNodeString(stack), JSGLR2Logging.Parsing);
    }

    @Override
    public void createStackLink(StackLink<ParseForest, StackNode> link) {
        super.createStackLink(link);
        this.log("    Create link " + this.stackNodeString(link.to) + " <-- " + this.id(link) + " --- " + this.stackNodeString(link.from), JSGLR2Logging.Parsing);
    }

    @Override
    public void resetDeterministicDepth(AbstractElkhoundStackNode<ParseForest> stack) {
        this.log("    Reset deterministic depth for stack " + this.stackNodeString(stack), JSGLR2Logging.Parsing);
    }

    @Override
    public void rejectStackLink(StackLink<ParseForest, StackNode> link) {
        this.log("Reject link " + this.id(link), JSGLR2Logging.Parsing);
    }

    @Override
    public void forActorStacks(IForActorStacks<StackNode> forActorStacks) {
        this.log("For actor stacks: " + this.stackQueueToString(forActorStacks), JSGLR2Logging.Parsing);
    }

    @Override
    public void actor(StackNode stack, ParseState parseState, Iterable<IAction> applicableActions) {
        this.log("  Actor for stack " + this.stackNodeString(stack) + " (applicable actions: " + this.applicableActionsToString(applicableActions) + ")", JSGLR2Logging.Parsing);
    }

    @Override
    public void skipRejectedStack(StackNode stack) {
        this.log("    Skipping stack " + this.stackNodeString(stack) + " since all links to it are rejected", JSGLR2Logging.Parsing);
    }

    @Override
    public void addForShifter(ForShifterElement<StackNode> forShifterElement) {
        this.log("    Add for shifter " + this.forShifterElementToString(forShifterElement), JSGLR2Logging.Parsing);
    }

    @Override
    public void doLimitedReductions(ParseState parseState, StackNode stack, IReduce reduce, StackLink<ParseForest, StackNode> link) {
    }

    @Override
    public void reducer(ParseState parseState, StackNode activeStack, StackNode originStack, IReduce reduce, ParseForest[] parseNodes, StackNode gotoStack) {
        this.log("    Reduce by production [" + reduce.production().descriptor() + "] (" + reduce.productionType().toString() + ") with parse nodes " + this.parseForestsToString((IParseForest[])parseNodes) + ", target stack: " + this.stackNodeString(gotoStack), JSGLR2Logging.Parsing, this.conditional(JSGLR2Logging.Recovery, reduce.production().isRecovery()));
    }

    @Override
    public void reducerElkhound(StackNode stack, IReduce reduce, ParseForest[] parseNodes) {
        this.log("    Reduce (Elkhound) by production [" + reduce.production().descriptor() + "] (" + reduce.productionType().toString() + ") with parse nodes " + this.parseForestsToString((IParseForest[])parseNodes), JSGLR2Logging.Parsing, this.conditional(JSGLR2Logging.Recovery, reduce.production().isRecovery()));
    }

    @Override
    public void directLinkFound(ParseState parseState, StackLink<ParseForest, StackNode> directLink) {
        this.log("    Direct link " + (directLink != null ? this.id(directLink) : "not") + " found", JSGLR2Logging.Parsing);
    }

    @Override
    public void accept(StackNode acceptingStack) {
        this.log("    Accept stack " + this.stackNodeString(acceptingStack), JSGLR2Logging.Parsing);
    }

    @Override
    public void createParseNode(ParseNode parseNode, IProduction production) {
        super.createParseNode(parseNode, production);
        this.log("    Create parse node " + this.id(parseNode) + " for production " + (production == null ? null : Integer.valueOf(production.id())), JSGLR2Logging.Parsing);
    }

    @Override
    public void createDerivation(Derivation derivation, IProduction production, ParseForest[] parseNodes) {
        super.createDerivation(derivation, production, parseNodes);
        this.log("    Create derivation with parse nodes " + this.parseForestsToString((IParseForest[])parseNodes), JSGLR2Logging.Parsing);
    }

    @Override
    public void createCharacterNode(ParseForest characterNode, int character) {
        super.createCharacterNode(characterNode, character);
        this.log("    Create character node " + this.id(characterNode) + " for character '" + this.characterToString(character) + "'", JSGLR2Logging.Parsing);
    }

    @Override
    public void addDerivation(ParseNode parseNode, Derivation derivation) {
        this.log("    Add derivation " + this.id(derivation) + " to parse node " + this.id(parseNode), JSGLR2Logging.Parsing);
    }

    @Override
    public void shifter(ParseForest termNode, Queue<ForShifterElement<StackNode>> forShifter) {
        this.log("    Shifter for elements " + this.forShifterQueueToString(forShifter) + " with character node " + this.id(termNode), JSGLR2Logging.Parsing);
    }

    @Override
    public void startRecovery(ParseState parseState) {
        this.log("    Recovery started at offset " + ((IInputStack)((AbstractParseState)parseState).inputStack).offset(), JSGLR2Logging.Recovery);
    }

    @Override
    public void recoveryIteration(ParseState parseState) {
        this.log("    Recovery iteration " + ((IRecoveryParseState)parseState).recoveryJob().iteration, JSGLR2Logging.Recovery);
    }

    @Override
    public void endRecovery(ParseState parseState) {
        this.log("    Recovery ended at offset " + ((IInputStack)((AbstractParseState)parseState).inputStack).offset(), JSGLR2Logging.Recovery);
    }

    @Override
    public void remark(String remark) {
        this.log(remark, JSGLR2Logging.All);
    }

    @Override
    public void success(ParseSuccess<ParseForest> success) {
        this.log("Parsing succeeded " + this.timing(success.parseState.request), JSGLR2Logging.Parsing, JSGLR2Logging.Minimal);
    }

    @Override
    public void failure(ParseFailure<ParseForest> failure) {
        this.log("Parsing failed " + this.timing(failure.parseState.request), JSGLR2Logging.Parsing, JSGLR2Logging.Minimal);
    }

    private String timing(JSGLR2Request request) {
        return "(in " + (System.currentTimeMillis() - this.startTimes.get(request)) + "ms)";
    }

    private String characterToString(int character) {
        return CharacterClassFactory.intToString(character).replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private JSGLR2Logging conditional(JSGLR2Logging scope, boolean condition) {
        if (condition) {
            return scope;
        }
        return JSGLR2Logging.None;
    }

    private void log(String message, JSGLR2Logging ... eventJSGLR2Loggings) {
        JSGLR2Logging[] jSGLR2LoggingArray = this.scopes;
        int n = this.scopes.length;
        int n2 = 0;
        while (n2 < n) {
            JSGLR2Logging scope = jSGLR2LoggingArray[n2];
            if (scope == JSGLR2Logging.All) {
                this.logger.accept(message);
                return;
            }
            JSGLR2Logging[] jSGLR2LoggingArray2 = eventJSGLR2Loggings;
            int n3 = eventJSGLR2Loggings.length;
            int n4 = 0;
            while (n4 < n3) {
                JSGLR2Logging eventJSGLR2Logging = jSGLR2LoggingArray2[n4];
                if (scope == eventJSGLR2Logging || eventJSGLR2Logging == JSGLR2Logging.Minimal) {
                    this.logger.accept(message);
                    return;
                }
                ++n4;
            }
            ++n2;
        }
    }
}

