/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.parser.observing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.productions.IProduction;
import org.spoofax.jsglr2.parseforest.ICharacterNode;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.ForShifterElement;
import org.spoofax.jsglr2.parser.observing.IParserObserver;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.StackLink;

public abstract class RegisteringParserObserver<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>, StackNode extends IStackNode, ParseState extends AbstractParseState<?, StackNode>>
implements IParserObserver<ParseForest, Derivation, ParseNode, StackNode, ParseState> {
    private int parseNodeCount = 0;
    private int stackNodeCount = 0;
    private int stackLinkCount = 0;
    private final Map<IDerivation<ParseForest>, Integer> derivationId = new HashMap<IDerivation<ParseForest>, Integer>();
    private final Map<ParseForest, Integer> parseNodeId = new HashMap<ParseForest, Integer>();
    private final Map<StackNode, Integer> stackNodeId = new HashMap<StackNode, Integer>();
    private final Map<StackLink<ParseForest, StackNode>, Integer> stackLinkId = new HashMap<StackLink<ParseForest, StackNode>, Integer>();

    private void registerDerivationNode(IDerivation<ParseForest> derivation) {
        this.derivationId.put(derivation, this.parseNodeCount++);
    }

    private void registerParseNode(ParseForest parseNode) {
        this.parseNodeId.put(parseNode, this.parseNodeCount++);
    }

    private void registerStackNode(StackNode stackNode) {
        this.stackNodeId.put(stackNode, this.stackNodeCount++);
    }

    private void registerStackLink(StackLink<ParseForest, StackNode> stackLink) {
        this.stackLinkId.put(stackLink, this.stackLinkCount++);
    }

    protected int id(IDerivation<ParseForest> derivation) {
        return this.derivationId.get(derivation);
    }

    protected int id(ParseForest parseNode) {
        if (!this.parseNodeId.containsKey(parseNode)) {
            if (parseNode instanceof IParseNode) {
                this.createParseNode((IParseNode)parseNode, ((IParseNode)parseNode).production());
            } else {
                this.createCharacterNode(parseNode, ((ICharacterNode)parseNode).character());
            }
        }
        return this.parseNodeId.get(parseNode);
    }

    protected int id(StackNode stackNode) {
        return this.stackNodeId.get(stackNode);
    }

    protected String stackNodeString(StackNode stackNode) {
        return String.valueOf(this.id(stackNode)) + "[state=" + stackNode.state().id() + "]";
    }

    protected String id(StackLink<ParseForest, StackNode> stackLink) {
        return this.stackLinkId.get(stackLink) + "[parseNode=" + (stackLink.parseForest != null ? Integer.valueOf(this.id((StackNode)((IParseForest)stackLink.parseForest))) : "null") + "]";
    }

    @Override
    public void parseStart(ParseState parseState) {
        this.parseNodeCount = 0;
        this.stackNodeCount = 0;
        this.stackLinkCount = 0;
        this.derivationId.clear();
        this.parseNodeId.clear();
        this.stackNodeId.clear();
        this.stackLinkId.clear();
    }

    @Override
    public void createStackNode(StackNode stack) {
        this.registerStackNode(stack);
    }

    @Override
    public void createStackLink(StackLink<ParseForest, StackNode> link) {
        this.registerStackLink(link);
    }

    @Override
    public void createParseNode(ParseNode parseNode, IProduction production) {
        this.registerParseNode(parseNode);
    }

    @Override
    public void createDerivation(Derivation derivation, IProduction production, ParseForest[] parseNodes) {
        this.registerDerivationNode((IDerivation<ParseForest>)derivation);
    }

    @Override
    public void createCharacterNode(ParseForest characterNode, int character) {
        this.registerParseNode(characterNode);
    }

    protected String stackQueueToString(Iterable<StackNode> stacks) {
        return "[" + StreamSupport.stream(stacks.spliterator(), false).map(this::id).map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    protected String applicableActionsToString(Iterable<IAction> applicableActions) {
        return "[" + StreamSupport.stream(applicableActions.spliterator(), false).map(action -> {
            if (action instanceof IReduce) {
                return String.valueOf(action.toString()) + "[" + ((IReduce)action).production().toString() + "]";
            }
            return action.toString();
        }).collect(Collectors.joining(",")) + "]";
    }

    protected String forShifterQueueToString(Queue<ForShifterElement<StackNode>> forShifter) {
        return "[" + forShifter.stream().map(this::forShifterElementToString).collect(Collectors.joining(",")) + "]";
    }

    protected String forShifterElementToString(ForShifterElement<StackNode> forShifterElement) {
        return "(" + this.id((StackNode)forShifterElement.stack) + "," + forShifterElement.state.id() + ")";
    }

    protected String parseForestsToString(ParseForest[] parseForests) {
        return "[" + Arrays.stream(parseForests).map(parseForest -> parseForest != null ? "" + this.id((StackNode)parseForest) : "null").collect(Collectors.joining(",")) + "]";
    }
}

