/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.recovery;

import java.util.HashMap;
import java.util.Map;

public class RecoveryJob<StackNode> {
    public int offset;
    public int iteration;
    final int iterationsQuota;
    public Map<StackNode, Integer> quota;

    public RecoveryJob(int offset, int iterationsQuota) {
        this.offset = offset;
        this.iteration = -1;
        this.iterationsQuota = iterationsQuota;
        this.quota = new HashMap<StackNode, Integer>();
    }

    boolean hasNextIteration() {
        return this.iteration + 1 < this.iterationsQuota;
    }

    int nextIteration() {
        return ++this.iteration;
    }

    void initQuota(Iterable<StackNode> activeStacks) {
        int quotaPerStack = this.iteration + 1;
        this.quota.clear();
        activeStacks.forEach(stack -> {
            Integer n2 = this.quota.put(stack, quotaPerStack);
        });
    }

    int getQuota(StackNode stack) {
        return this.quota.getOrDefault(stack, 0);
    }

    void updateQuota(StackNode stack, int newQuota) {
        this.quota.merge(stack, newQuota, Math::max);
    }
}

