/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.reducing;

import java.util.ArrayList;
import java.util.List;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.query.IActionQuery;
import org.metaborg.parsetable.states.IState;
import org.spoofax.jsglr2.inputstack.IInputStack;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.ParseForestManager;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.observing.ParserObserving;
import org.spoofax.jsglr2.reducing.ReduceActionFilter;
import org.spoofax.jsglr2.reducing.ReduceManagerFactory;
import org.spoofax.jsglr2.reducing.Reducer;
import org.spoofax.jsglr2.reducing.ReducerFactory;
import org.spoofax.jsglr2.stack.AbstractStackManager;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.StackLink;
import org.spoofax.jsglr2.stack.paths.StackPath;

public class ReduceManager<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>, StackNode extends IStackNode, InputStack extends IInputStack, ParseState extends AbstractParseState<InputStack, StackNode>> {
    protected final IParseTable parseTable;
    protected final AbstractStackManager<ParseForest, Derivation, ParseNode, StackNode, ParseState> stackManager;
    protected final ParseForestManager<ParseForest, Derivation, ParseNode, StackNode, ParseState> parseForestManager;
    protected final Reducer<ParseForest, Derivation, ParseNode, StackNode, InputStack, ParseState> reducer;
    protected final List<ReduceActionFilter<ParseForest, StackNode, ParseState>> reduceActionFilters;

    public ReduceManager(IParseTable parseTable, AbstractStackManager<ParseForest, Derivation, ParseNode, StackNode, ParseState> stackManager, ParseForestManager<ParseForest, Derivation, ParseNode, StackNode, ParseState> parseForestManager, ReducerFactory<ParseForest, Derivation, ParseNode, StackNode, InputStack, ParseState> reducerFactory) {
        this.parseTable = parseTable;
        this.stackManager = stackManager;
        this.parseForestManager = parseForestManager;
        this.reduceActionFilters = new ArrayList<ReduceActionFilter<ParseForest, StackNode, ParseState>>();
        this.reducer = reducerFactory.get(stackManager, parseForestManager);
    }

    public static <ParseForest_ extends IParseForest, Derivation_ extends IDerivation<ParseForest_>, ParseNode_ extends IParseNode<ParseForest_, Derivation_>, StackNode_ extends IStackNode, InputStack_ extends IInputStack, ParseState_ extends AbstractParseState<InputStack_, StackNode_>, StackManager_ extends AbstractStackManager<ParseForest_, Derivation_, ParseNode_, StackNode_, ParseState_>> ReduceManagerFactory<ParseForest_, Derivation_, ParseNode_, StackNode_, InputStack_, ParseState_, StackManager_, ReduceManager<ParseForest_, Derivation_, ParseNode_, StackNode_, InputStack_, ParseState_>> factory(ReducerFactory<ParseForest_, Derivation_, ParseNode_, StackNode_, InputStack_, ParseState_> reducerFactory) {
        return (parseTable, stackManager, parseForestManager) -> new ReduceManager(parseTable, stackManager, parseForestManager, reducerFactory);
    }

    public void addFilter(ReduceActionFilter<ParseForest, StackNode, ParseState> reduceActionFilter) {
        this.reduceActionFilters.add(reduceActionFilter);
    }

    public void doReductions(ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing, ParseState parseState, StackNode activeStack, IReduce reduce) {
        if (this.ignoreReduceAction(parseState, activeStack, reduce)) {
            return;
        }
        observing.notify(observer -> observer.doReductions(parseState, activeStack, reduce));
        this.doReductionsHelper(observing, parseState, activeStack, reduce, null);
    }

    private void doLimitedReductions(ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing, ParseState parseState, StackNode stack, IReduce reduce, StackLink<ParseForest, StackNode> throughLink) {
        if (this.ignoreReduceAction(parseState, stack, reduce)) {
            return;
        }
        observing.notify(observer -> observer.doLimitedReductions(parseState, stack, reduce, throughLink));
        this.doReductionsHelper(observing, parseState, stack, reduce, throughLink);
    }

    private boolean ignoreReduceAction(ParseState parseState, StackNode stack, IReduce reduce) {
        for (ReduceActionFilter<ParseForest, StackNode, ParseState> reduceActionFilter : this.reduceActionFilters) {
            if (!reduceActionFilter.ignoreReduce(parseState, stack, reduce)) continue;
            return true;
        }
        return false;
    }

    protected void doReductionsHelper(ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing, ParseState parseState, StackNode activeStack, IReduce reduce, StackLink<ParseForest, StackNode> throughLink) {
        for (StackPath<ParseForest, StackNode> path : this.stackManager.findAllPathsOfLength(activeStack, reduce.arity())) {
            IParseForest[] parseNodes;
            StackNode originStack;
            if (throughLink != null && !path.contains(throughLink) || this.ignoreReducePath((IStackNode)(originStack = path.head()), reduce, parseNodes = this.stackManager.getParseForests(this.parseForestManager, path))) continue;
            this.reducer(observing, (AbstractParseState)parseState, (IStackNode)activeStack, (IStackNode)originStack, reduce, parseNodes);
        }
    }

    protected boolean ignoreReducePath(StackNode pathBegin, IReduce reduce, ParseForest[] parseNodes) {
        return false;
    }

    protected void reducer(ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing, ParseState parseState, StackNode activeStack, StackNode originStack, IReduce reduce, ParseForest[] parseForests) {
        int gotoId = originStack.state().getGotoId(reduce.production().id());
        IState gotoState = this.parseTable.getState(gotoId);
        Object gotoStack = ((AbstractParseState)parseState).activeStacks.findWithState(gotoState);
        if (gotoStack != null) {
            StackLink directLink = this.stackManager.findDirectLink(gotoStack, originStack);
            observing.notify(observer -> observer.directLinkFound(parseState, directLink));
            if (directLink != null) {
                this.reducer.reducerExistingStackWithDirectLink(observing, (AbstractParseState)parseState, reduce, directLink, (IParseForest[])parseForests);
            } else {
                StackLink link = this.reducer.reducerExistingStackWithoutDirectLink(observing, (AbstractParseState)parseState, reduce, (IStackNode)gotoStack, (IStackNode)originStack, (IParseForest[])parseForests);
                for (IStackNode activeStackForLimitedReductions : ((AbstractParseState)parseState).activeStacks.forLimitedReductions(((AbstractParseState)parseState).forActorStacks)) {
                    for (IReduce reduceAction : activeStackForLimitedReductions.state().getApplicableReduceActions((IActionQuery)((AbstractParseState)parseState).inputStack)) {
                        this.doLimitedReductions(observing, parseState, activeStackForLimitedReductions, reduceAction, link);
                    }
                }
            }
        } else {
            gotoStack = this.reducer.reducerNoExistingStack(observing, (AbstractParseState)parseState, reduce, (IStackNode)originStack, gotoState, (IParseForest[])parseForests);
            ((AbstractParseState)parseState).activeStacks.add(gotoStack);
            ((AbstractParseState)parseState).forActorStacks.add(gotoStack);
        }
        Object finalGotoStack = gotoStack;
        observing.notify(observer -> observer.reducer((AbstractParseState)parseState, (IStackNode)activeStack, (IStackNode)originStack, reduce, (IParseForest[])parseForests, (IStackNode)finalGotoStack));
    }
}

