/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterErrorExit;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.StackTracer;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.core.UndefinedStrategyException;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.util.IAsyncCancellable;
import org.spoofax.terms.StrategoConstructor;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.TermTransformer;
import org.spoofax.terms.attachments.AbstractWrappedTermFactory;
import org.strategoxt.IncompatibleJarException;
import org.strategoxt.NoInteropRegistererJarException;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.InteropRegisterer;
import org.strategoxt.lang.InteropSDefT;
import org.strategoxt.lang.MissingStrategyException;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.stratego_rtg.Main;
import org.strategoxt.strc.desugar_0_0;
import org.strategoxt.strc.desugar_list_matching_0_0;
import org.strategoxt.strc.pre_desugar_0_0;
import org.strategoxt.strc.raise_annotations_0_0;
import org.strategoxt.strc.simplify_0_0;

public class HybridInterpreter
extends Interpreter
implements IAsyncCancellable {
    protected static final String USAGE = "Uses: run [FILE.ctree | FILE.jar]... MAINCLASS [ARGUMENT]...\n      run                    PACKAGE.MAINCLASS [ARGUMENT]...";
    private final HybridCompiledContext compiledContext;
    private boolean registeredLibraries;
    private boolean loadedJars;
    private final ConstructorRecordingTermFactory recordingFactory;
    private final ArrayList<URLClassLoader> classLoaders = new ArrayList();

    public HybridInterpreter() {
        this(new TermFactory());
    }

    public HybridInterpreter(ITermFactory factory) {
        this(factory, factory);
    }

    public HybridInterpreter(ITermFactory termFactory, ITermFactory programFactory) {
        super(termFactory, programFactory);
        this.compiledContext = new HybridCompiledContext(termFactory);
        this.recordingFactory = new ConstructorRecordingTermFactory(termFactory);
    }

    public HybridInterpreter(HybridInterpreter interpreter, String ... reuseRegistries) {
        this(interpreter.getFactory(), ((org.spoofax.interpreter.core.Context)interpreter.getContext()).getProgramFactory());
        Set<String> reusable = HybridInterpreter.asSet(reuseRegistries);
        this.getContext().setVarScope(new VarScope(interpreter.getContext().getVarScope()));
        interpreter.init();
        for (IOperatorRegistry registry : interpreter.getCompiledContext().getOperatorRegistries().values()) {
            IOperatorRegistry existing = this.getContext().getOperatorRegistry(registry.getOperatorRegistryName());
            if (existing != null && !reusable.contains(registry.getOperatorRegistryName())) continue;
            this.addOperatorRegistry(registry);
        }
        this.registeredLibraries = interpreter.registeredLibraries;
        this.loadedJars = interpreter.loadedJars;
        this.setIOAgent(interpreter.getIOAgent());
        this.setCurrent(interpreter.current());
    }

    public static void main(String ... args) {
        HybridInterpreter interpreter;
        int i;
        if (args == null || args.length < 1) {
            System.out.println(USAGE);
            System.exit(127);
        }
        boolean nothingLoaded = (i = HybridInterpreter.mainLoadAll(interpreter = new HybridInterpreter(), args)) == 0;
        String main = args[i++];
        if (nothingLoaded) {
            HybridInterpreter.warnUnqualifiedInvoke(interpreter, main);
        }
        IStrategoTerm[] mainArgs = new IStrategoString[args.length - i + 1];
        mainArgs[0] = interpreter.getFactory().makeString(main);
        int j = 1;
        while (j < mainArgs.length) {
            mainArgs[j] = interpreter.getFactory().makeString(args[i]);
            ++i;
            ++j;
        }
        interpreter.setCurrent(interpreter.getFactory().makeList(mainArgs));
        try {
            interpreter.invoke(main);
        }
        catch (InterpreterExit e) {
            System.exit(e.getValue());
        }
        catch (UndefinedStrategyException e) {
            System.err.println(e.getMessage());
            System.exit(125);
        }
        catch (InterpreterException e) {
            if (e.getCause() instanceof InterpreterExit) {
                System.exit(((InterpreterExit)e.getCause()).getValue());
            }
            e.printStackTrace();
            System.exit(124);
        }
    }

    private static Set<String> asSet(String ... reuseRegistries) {
        HashSet<String> reusable = new HashSet<String>();
        if (reuseRegistries != null) {
            String[] stringArray = reuseRegistries;
            int n = reuseRegistries.length;
            int n2 = 0;
            while (n2 < n) {
                String reuse = stringArray[n2];
                reusable.add(reuse);
                ++n2;
            }
        }
        return reusable;
    }

    protected static void warnUnqualifiedInvoke(HybridInterpreter interpreter, String main) {
        interpreter.init();
        SDefT invoked = interpreter.lookupUncifiedSVar(main);
        if (invoked != null) {
            String name = ((InteropSDefT)invoked).getStrategy().getClass().getName();
            System.err.println("Warning: unqualified invocation of " + name);
        }
    }

    protected static int mainLoadAll(HybridInterpreter interpreter, String ... args) {
        boolean nothingLoaded;
        int i = 0;
        while (i < args.length) {
            try {
                if (args[i].endsWith(".ctree")) {
                    interpreter.load(args[i++]);
                    continue;
                }
                if (!args[i].endsWith(".jar")) break;
                URL[] jars = new URL[]{new File(args[i++]).toURI().toURL()};
                interpreter.loadJars(jars);
            }
            catch (Exception e) {
                System.err.println("Could not open input file " + args[i - 1] + ": " + e.getClass().getSimpleName() + " - " + e.getMessage());
                System.exit(126);
            }
        }
        boolean bl = nothingLoaded = i == 0;
        if (i == args.length) {
            System.err.println(USAGE);
            System.exit(1);
        } else if (nothingLoaded && args[i].indexOf(46) > -1) {
            HybridInterpreter.mainLocalJar(args);
        }
        return i;
    }

    private static void mainLocalJar(String ... args) {
        String strategy = args[0];
        String[] mainArgs = new String[args.length - 1];
        System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
        try {
            IStrategoTerm result;
            Context context = new Context();
            try {
                result = context.invokeStrategyCLI(strategy, strategy, mainArgs);
            }
            finally {
                context.getIOAgent().closeAllFiles();
            }
            if (result == null) {
                System.err.println(String.valueOf(strategy) + (context.getTraceDepth() != 0 ? ": rewriting failed, trace:" : ": rewriting failed"));
                context.printStackTrace();
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (MissingStrategyException e) {
            System.err.println(e.getMessage());
            System.exit(125);
        }
        catch (StrategoExit e) {
            System.exit(e.getValue());
        }
    }

    @Override
    protected org.spoofax.interpreter.core.Context createContext(ITermFactory termFactory, ITermFactory programFactory) {
        return new HybridContext(termFactory, programFactory);
    }

    @Override
    public void load(IStrategoTerm term) throws InterpreterException {
        this.init();
        super.load(term);
    }

    public void loadJars(URL ... jars) throws SecurityException, NoInteropRegistererJarException, IncompatibleJarException, IOException {
        this.loadJars(HybridInterpreter.class.getClassLoader(), jars);
    }

    public void loadJars(ClassLoader parentClassLoader, URL ... jars) throws SecurityException, NoInteropRegistererJarException, IncompatibleJarException, IOException {
        URLClassLoader classLoader = new URLClassLoader(jars, parentClassLoader);
        this.classLoaders.add(classLoader);
        boolean foundRegisterer = false;
        this.loadedJars = true;
        URL[] uRLArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            URL jar = uRLArray[n2];
            foundRegisterer |= this.registerJar(classLoader, jar);
            ++n2;
        }
        if (!foundRegisterer) {
            throw new NoInteropRegistererJarException(jars);
        }
    }

    public void registerClass(InteropRegisterer registerer) {
        this.registerClass(registerer, this.getClass().getClassLoader());
    }

    public void registerClass(InteropRegisterer registerer, ClassLoader classLoader) {
        assert (this.recordingFactory.getWrappedFactory() == this.getCompiledContext().getFactory());
        this.getCompiledContext().setFactory(this.recordingFactory);
        registerer.registerLazy(this.getContext(), this.getCompiledContext(), classLoader);
        this.getCompiledContext().addConstructors(this.recordingFactory.getAndClearConstructorRecord());
        this.getCompiledContext().setFactory(this.recordingFactory.getWrappedFactory());
    }

    private boolean registerJar(URLClassLoader classLoader, URL jar) throws SecurityException, IncompatibleJarException, IOException {
        URL protocolfulUrl = new URL("jar", "", jar + "!/");
        JarURLConnection connection = (JarURLConnection)protocolfulUrl.openConnection();
        connection.setUseCaches(false);
        boolean foundRegisterer = false;
        try (JarFile jarFile = connection.getJarFile();){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                String entry = jarEntries.nextElement().getName();
                if (!entry.endsWith("/InteropRegisterer.class") && !entry.endsWith("$InteropRegisterer.class") && !entry.equals("InteropRegisterer.class")) continue;
                int POSTFIX = ".class".length();
                String className = entry.substring(0, entry.length() - POSTFIX);
                className = className.replace('/', '.');
                try {
                    Class<?> registerClass = classLoader.loadClass(className);
                    Object registerObject = registerClass.newInstance();
                    if (registerObject instanceof InteropRegisterer) {
                        this.registerClass((InteropRegisterer)registerObject, classLoader);
                        foundRegisterer = true;
                        continue;
                    }
                    throw new IncompatibleJarException(jar, (Throwable)new ClassCastException("Unknown type for InteropRegisterer"));
                }
                catch (InstantiationException e) {
                    throw new IncompatibleJarException(jar, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new IncompatibleJarException(jar, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new IncompatibleJarException(jar, (Throwable)e);
                }
                catch (RuntimeException e) {
                    throw new IncompatibleJarException(jar, (Throwable)e);
                }
                catch (Error e) {
                    throw new IncompatibleJarException(jar, (Throwable)e);
                }
            }
        }
        return foundRegisterer;
    }

    public void init() {
        if (!this.registeredLibraries && !this.loadedJars) {
            this.registeredLibraries = true;
            this.registerLibraries();
        }
    }

    public void uninit() {
        this.loadedJars = false;
        this.getContext().getVarScope().clear();
        SSLLibrary lib = SSLLibrary.instance(this.getContext());
        if (lib != null) {
            lib.getIOAgent().closeAllFiles();
        }
        try {
            try {
                for (URLClassLoader classLoader : this.classLoaders) {
                    classLoader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.classLoaders.clear();
        }
    }

    protected void registerLibraries() {
        IContext context = this.getContext();
        Context compiledContext = this.getCompiledContext();
        org.strategoxt.tools.Main.registerInterop(context, compiledContext);
        org.strategoxt.stratego_gpp.Main.registerInterop(context, compiledContext);
        org.strategoxt.stratego_aterm.Main.registerInterop(context, compiledContext);
        Main.registerInterop(context, compiledContext);
        org.strategoxt.stratego_sdf.Main.registerInterop(context, compiledContext);
        org.strategoxt.stratego_sglr.Main.registerInterop(context, compiledContext);
        org.strategoxt.stratego_tool_doc.Main.registerInterop(context, compiledContext);
        org.strategoxt.stratego_xtc.Main.registerInterop(context, compiledContext);
        org.strategoxt.java_front.Main.registerInterop(context, compiledContext);
        org.strategoxt.stratego_lib.Main.registerInterop(context, compiledContext);
        org.strategoxt.strc.Main.registerInterop(context, compiledContext);
    }

    public final Context getCompiledContext() {
        return this.compiledContext;
    }

    public static Context getCompiledContext(IContext context) {
        return ((HybridContext)context).getCompiledContext();
    }

    public static IContext getContext(Context context) {
        return context instanceof HybridCompiledContext ? ((HybridCompiledContext)context).getContext() : null;
    }

    public static HybridInterpreter getInterpreter(Context context) {
        return context instanceof HybridCompiledContext ? ((HybridCompiledContext)context).getInterpreter() : null;
    }

    @Override
    public boolean invoke(String name) throws InterpreterErrorExit, InterpreterExit, UndefinedStrategyException, InterpreterException {
        try {
            if (!this.loadedJars) {
                this.init();
            }
            return super.invoke(name);
        }
        catch (StrategoErrorExit e) {
            throw new InterpreterErrorExit(e.getMessage(), e.getTerm(), e.getTrace(), e.getCause());
        }
        catch (StrategoExit e) {
            throw new InterpreterExit(e.getValue(), (Throwable)e);
        }
        catch (MissingStrategyException e) {
            throw new UndefinedStrategyException(e);
        }
        catch (StrategoException e) {
            throw new InterpreterException(e);
        }
    }

    @Override
    public boolean evaluate(IStrategoAppl s) throws InterpreterErrorExit, InterpreterExit, UndefinedStrategyException, InterpreterException {
        this.init();
        return super.evaluate(s);
    }

    public boolean evaluate(IStrategoAppl s, boolean desugar2) throws InterpreterErrorExit, InterpreterExit, UndefinedStrategyException, InterpreterException {
        if (desugar2) {
            this.init();
            s = this.desugar(s);
        }
        return this.evaluate(s);
    }

    private IStrategoAppl desugar(IStrategoAppl s) {
        final ITermFactory factory = this.getProgramFactory();
        final IStrategoConstructor callT = factory.makeConstructor("CallT", 3);
        final IStrategoConstructor sdefT = factory.makeConstructor("SDefT", 4);
        s = (IStrategoAppl)pre_desugar_0_0.instance.invoke(this.getCompiledContext(), s);
        s = (IStrategoAppl)desugar_list_matching_0_0.instance.invoke(this.getCompiledContext(), s);
        s = (IStrategoAppl)desugar_0_0.instance.invoke(this.getCompiledContext(), s);
        s = (IStrategoAppl)raise_annotations_0_0.instance.invoke(this.getCompiledContext(), s);
        s = (IStrategoAppl)simplify_0_0.instance.invoke(this.getCompiledContext(), s);
        s = (IStrategoAppl)new TermTransformer(factory, false){

            @Override
            public IStrategoTerm preTransform(IStrategoTerm term) {
                if (Tools.isTermAppl(term)) {
                    term = HybridInterpreter.this.cifyAndAddParams(factory, callT, sdefT, (IStrategoAppl)term);
                }
                return term;
            }
        }.transform(s);
        return s;
    }

    private IStrategoTerm cifyAndAddParams(ITermFactory factory, IStrategoConstructor callT, IStrategoConstructor sdefT, IStrategoAppl current) {
        IStrategoConstructor cons = current.getConstructor();
        if (cons == sdefT || cons == callT) {
            Object s = Tools.termAt(current, 1);
            Object t = Tools.termAt(current, 2);
            if (cons == sdefT) {
                IStrategoString name = (IStrategoString)Tools.termAt(current, 0);
                name = factory.makeString(String.valueOf(HybridInterpreter.cify(Tools.asJavaString(name))) + "_" + s.getSubtermCount() + "_" + t.getSubtermCount());
                current = factory.makeAppl(cons, new IStrategoTerm[]{name, s, t, Tools.termAt(current, 3)});
            } else {
                IStrategoAppl svar = (IStrategoAppl)Tools.termAt(current, 0);
                Object name = Tools.termAt(svar, 0);
                name = factory.makeString(String.valueOf(HybridInterpreter.cify(Tools.asJavaString(name))) + "_" + s.getSubtermCount() + "_" + t.getSubtermCount());
                name = factory.makeAppl(svar.getConstructor(), new IStrategoTerm[]{name});
                current = factory.makeAppl(cons, new IStrategoTerm[]{name, s, t});
            }
        }
        return current;
    }

    @Override
    public void asyncCancel() {
        this.getCompiledContext().asyncCancel();
        this.getContext().asyncCancel();
    }

    @Override
    public void asyncCancelReset() {
        this.getCompiledContext().asyncCancelReset();
        this.getContext().asyncCancelReset();
    }

    private static class ConstructorRecordingTermFactory
    extends AbstractWrappedTermFactory {
        private final Collection<IStrategoConstructor> constructors = new ArrayList<IStrategoConstructor>();
        private final ITermFactory theBaseFactory;

        public ConstructorRecordingTermFactory(ITermFactory baseFactory) {
            super(baseFactory);
            this.theBaseFactory = baseFactory;
        }

        @Override
        public StrategoConstructor makeConstructor(String name, int arity) {
            StrategoConstructor r = super.makeConstructor(name, arity);
            this.constructors.add(r);
            return r;
        }

        public Collection<IStrategoConstructor> getAndClearConstructorRecord() {
            ArrayList<IStrategoConstructor> r = new ArrayList<IStrategoConstructor>(this.constructors);
            this.constructors.clear();
            return r;
        }

        public ITermFactory getWrappedFactory() {
            return this.theBaseFactory;
        }
    }

    private class HybridCompiledContext
    extends Context {
        public HybridCompiledContext(ITermFactory factory) {
            super(factory);
        }

        public HybridInterpreter getInterpreter() {
            return HybridInterpreter.this;
        }

        public IContext getContext() {
            return this.getInterpreter().getContext();
        }

        @Override
        public void addOperatorRegistry(IOperatorRegistry or) {
            super.addOperatorRegistry(or);
            ((HybridContext)this.getContext()).internalAddOperatorRegistryNoCompiledContext(or);
        }

        protected final void internalAddOperatorRegistry(IOperatorRegistry or) {
            super.addOperatorRegistry(or);
        }

        @Override
        public IStrategoTerm invokeStrategy(String strategy, IStrategoTerm input) throws MissingStrategyException, StrategoErrorExit, StrategoExit, StrategoException {
            IStrategoTerm oldCurrent = HybridInterpreter.this.current();
            try {
                HybridInterpreter.this.setCurrent(input);
                HybridInterpreter.this.invoke(strategy);
                IStrategoTerm iStrategoTerm = HybridInterpreter.this.current();
                return iStrategoTerm;
            }
            catch (InterpreterErrorExit e) {
                throw new StrategoErrorExit(e.getMessage(), e.getTerm(), e.getTrace(), e.getCause());
            }
            catch (InterpreterExit e) {
                throw new StrategoExit(e.getValue(), (Throwable)e);
            }
            catch (UndefinedStrategyException e) {
                throw new MissingStrategyException(e.getMessage(), e);
            }
            catch (InterpreterException e) {
                throw new StrategoException(e.getMessage(), e);
            }
            finally {
                HybridInterpreter.this.setCurrent(oldCurrent);
            }
        }

        @Override
        protected void cancel() {
            this.getContext().asyncCancelReset();
            super.cancel();
        }
    }

    private class HybridContext
    extends org.spoofax.interpreter.core.Context {
        public HybridContext(ITermFactory termFactory, ITermFactory programFactory) {
            super(termFactory, programFactory, true);
        }

        @Override
        public void addOperatorRegistry(IOperatorRegistry or) {
            super.addOperatorRegistry(or);
            HybridInterpreter.this.compiledContext.internalAddOperatorRegistry(or);
        }

        private final void internalAddOperatorRegistryNoCompiledContext(IOperatorRegistry or) {
            super.addOperatorRegistry(or);
        }

        @Override
        public StackTracer getStackTracer() {
            return HybridInterpreter.this.compiledContext;
        }

        public Context getCompiledContext() {
            return HybridInterpreter.this.compiledContext;
        }

        @Override
        public void setFactory(ITermFactory factory) {
            super.setFactory(factory);
            HybridInterpreter.this.compiledContext.setFactory(factory);
        }

        @Override
        protected void cancel() {
            this.getCompiledContext().asyncCancelReset();
            super.cancel();
        }
    }
}

