/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.StackTracer;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.library.PrimitiveCache;
import org.spoofax.interpreter.library.java.JFFLibrary;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.util.IAsyncCancellable;
import org.spoofax.terms.TermFactory;
import org.strategoxt.lang.InteropCallT;
import org.strategoxt.lang.InteropContext;
import org.strategoxt.lang.MissingStrategyException;
import org.strategoxt.lang.StackSaver;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.Term;
import org.strategoxt.lang.UncaughtExceptionHandler;
import org.strategoxt.lang.compat.CompatManager;
import org.strategoxt.lang.compat.SSL_EXT_java_call;

public class Context
extends StackTracer
implements IAsyncCancellable {
    private final InteropContext interopContext = new InteropContext(this);
    private final Map<String, IOperatorRegistry> operatorRegistries;
    private final PrimitiveCache operatorCache;
    private final CompatManager compat = new CompatManager(this);
    private final UncaughtExceptionHandler exceptionHandler = new UncaughtExceptionHandler(this);
    private final UncaughtExceptionHandler.Finalizer exceptionHandlerFinalizer = new UncaughtExceptionHandler.Finalizer(this.exceptionHandler);
    private ITermFactory factory;
    private volatile transient boolean asyncCancelled;

    public Context() {
        this(new TermFactory());
    }

    public Context(ITermFactory factory) {
        this(factory, null);
    }

    public Context(ITermFactory factory, IOAgent ioAgent) {
        this.factory = factory;
        this.operatorRegistries = new HashMap<String, IOperatorRegistry>();
        this.operatorCache = new PrimitiveCache(2, 16);
        this.addOperatorRegistry(new SSLLibrary());
        this.addOperatorRegistry(new JFFLibrary(factory));
        if (ioAgent != null) {
            this.setIOAgent(ioAgent);
        }
        this.compat.init();
    }

    protected Context(ITermFactory factory, Map<String, IOperatorRegistry> operatorRegistries, boolean skipCompat) {
        this.factory = factory;
        this.operatorRegistries = operatorRegistries;
        this.operatorCache = new PrimitiveCache(2, 16);
        if (!skipCompat) {
            this.compat.init();
        }
    }

    public final ITermFactory getFactory() {
        if (this.asyncCancelled) {
            this.cancel();
        }
        return this.factory;
    }

    public void setFactory(ITermFactory factory) {
        this.factory = factory;
    }

    public Map<String, IOperatorRegistry> getOperatorRegistries() {
        return this.operatorRegistries;
    }

    public UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public IOAgent getIOAgent() {
        SSLLibrary op = (SSLLibrary)this.getOperatorRegistry("SSL");
        return op == null ? null : op.getIOAgent();
    }

    @Override
    public void setIOAgent(IOAgent ioAgent) {
        SSLLibrary op = (SSLLibrary)this.getOperatorRegistry("SSL");
        if (op == null) {
            throw new IllegalStateException("No SSL library");
        }
        op.setIOAgent(ioAgent);
        super.setIOAgent(ioAgent);
    }

    public void registerClassLoader(ClassLoader classLoader) {
        SSL_EXT_java_call.registerClassLoader(classLoader);
    }

    public final IOperatorRegistry getOperatorRegistry(String domain) {
        return this.operatorRegistries.get(domain);
    }

    public void addOperatorRegistry(IOperatorRegistry or) {
        this.operatorRegistries.put(or.getOperatorRegistryName(), or);
    }

    public void addConstructors(Collection<IStrategoConstructor> newConstructors) {
        this.interopContext.addConstructors(newConstructors);
    }

    public void registerComponent(String componentName) {
        this.compat.registerComponent(componentName);
    }

    public CompatManager getCompatManager() {
        return this.compat;
    }

    public void setStandAlone(boolean isStandAlone) {
        this.exceptionHandler.setEnabled(isStandAlone);
    }

    public IStrategoTerm invokeStrategyCLI(Strategy strategy, String appName, String ... args) throws StrategoExit, StrategoException {
        IStrategoList input = this.toCLITerm(appName, args);
        if (new Exception().getStackTrace().length > 20) {
            return new StackSaver(strategy).invokeStackFriendly(this, input, Term.NO_STRATEGIES, Term.NO_TERMS);
        }
        return strategy.invoke(this, input);
    }

    public IStrategoTerm invokeStrategyCLI(String strategy, String appName, String ... args) throws MissingStrategyException, StrategoErrorExit, StrategoExit, StrategoException {
        return this.invokeStrategy(strategy, this.toCLITerm(appName, args));
    }

    public IStrategoTerm invokeStrategy(String strategy, IStrategoTerm input) throws MissingStrategyException, StrategoErrorExit, StrategoExit, StrategoException {
        SSL_EXT_java_call caller = (SSL_EXT_java_call)this.lookupPrimitive("SSL_EXT_java_call");
        if (caller == null) {
            caller = new SSL_EXT_java_call();
        }
        return caller.call(this, strategy, input, false);
    }

    private IStrategoList toCLITerm(String appName, String ... args) {
        ITermFactory factory = this.getFactory();
        IStrategoTerm[] termArgs = new IStrategoTerm[args.length + 1];
        termArgs[0] = factory.makeString(appName);
        int i = 0;
        while (i < args.length) {
            termArgs[i + 1] = factory.makeString(args[i]);
            ++i;
        }
        IStrategoList term = factory.makeList(termArgs);
        return term;
    }

    public final IStrategoTerm invokePrimitive(String name, IStrategoTerm term, Strategy[] sargs, IStrategoTerm[] targs) {
        AbstractPrimitive primitive = this.lookupPrimitive(name);
        if (primitive == null) {
            throw new StrategoException("Primitive not defined: " + name);
        }
        return this.invokePrimitive(primitive, term, sargs, targs);
    }

    public IStrategoTerm invokePrimitive(AbstractPrimitive primitive, IStrategoTerm term, Strategy[] sargs, IStrategoTerm[] targs) {
        if (primitive == null) {
            throw new StrategoException("Calling undefined primitive");
        }
        if (this.asyncCancelled) {
            this.cancel();
        }
        this.interopContext.setCurrent(term);
        try {
            if (primitive.call(this.interopContext, InteropCallT.toInteropCallTs(sargs, this), targs)) {
                IStrategoTerm result = this.interopContext.current();
                this.interopContext.setCurrent(null);
                return result;
            }
            return null;
        }
        catch (InterpreterExit e) {
            throw new StrategoExit(e.getValue());
        }
        catch (InterpreterException e) {
            throw new StrategoException("Exception in execution of primitive '" + primitive.getName() + "'", e);
        }
        catch (RuntimeException e) {
            throw new StrategoException("Exception in execution of primitive '" + primitive.getName() + "'", e);
        }
    }

    public AbstractPrimitive lookupPrimitive(String name) {
        if (this.asyncCancelled) {
            this.cancel();
        }
        AbstractPrimitive p = null;
        p = this.operatorCache.get(name);
        if (p != null) {
            return p;
        }
        for (IOperatorRegistry or : this.operatorRegistries.values()) {
            p = or.get(name);
            if (p != null) break;
        }
        this.operatorCache.put(name, p);
        return p;
    }

    @Override
    public void asyncCancel() {
        this.asyncCancelled = true;
    }

    @Override
    public void asyncCancelReset() {
        this.asyncCancelled = false;
    }

    protected void cancel() {
        this.asyncCancelled = false;
        this.getIOAgent().closeAllFiles();
        throw new CancellationException("Stratego interpreter cancelled");
    }

    public Object contextObject() {
        return this.interopContext.contextObject();
    }

    public void setContextObject(Object context) {
        this.interopContext.setContextObject(context);
    }
}

