/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import javax.swing.DefaultFocusManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.FindDialog;
import oracle.ide.ceditor.find.FindIncrementalGhost;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindToolbar;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.ceditor.find.GotoLineDialog;
import oracle.ide.ceditor.find.ReplaceToolbar;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.find.PromptedReplacer;
import oracle.javatools.editor.find.ReplaceCriteria;
import oracle.javatools.editor.find.ReplaceResult;
import oracle.javatools.editor.find.Replacer;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Pair;

final class FindController
implements Controller {
    private static FindController INSTANCE;
    private static IdeAction ideSearchAgainAction;
    private static IdeAction ideSearchBackwardAction;
    private static final Integer FIND_NEXT_AT_CURSOR_CMD_ID;
    private static final Integer FIND_PREVIOUS_AT_CURSOR_CMD_ID;
    private GotoLineDialog gotoLiner;
    private FindIncrementalGhost findIncrementalGhost;
    static final String EDITOR_PROPERTY_FIND_CRITERIA = "find-criteria";

    private FindController() {
        ideSearchAgainAction = IdeActions.getSearchFindNextAction();
        ideSearchBackwardAction = IdeActions.getSearchFindPreviousAction();
        ideSearchAgainAction.addController((Controller)this);
        ideSearchBackwardAction.addController((Controller)this);
        IdeActions.getSearchFindAction().addController((Controller)this);
        IdeActions.getSearchReplaceAction().addController((Controller)this);
        IdeActions.getNavigateGoToLineAction().addController((Controller)this);
        IdeActions.getSearchIncrementalFindForwardAction().addController((Controller)this);
        IdeActions.getSearchIncrementalFindBackwardAction().addController((Controller)this);
        this.findIncrementalGhost = new FindIncrementalGhost(this);
        this.gotoLiner = new GotoLineDialog();
        FindOptions findOptions = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        Ide.getSettings().putLegacyData("FindOptions", (Copyable)findOptions);
    }

    static FindController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FindController();
        }
        return INSTANCE;
    }

    void dispose() {
        IdeAction.find((int)23).removeController((Controller)this);
        ideSearchAgainAction.removeController((Controller)this);
        ideSearchBackwardAction.removeController((Controller)this);
        IdeAction.find((int)24).removeController((Controller)this);
        IdeAction.find((int)29).removeController((Controller)this);
        IdeAction.find((int)26).removeController((Controller)this);
        IdeAction.find((int)27).removeController((Controller)this);
        this.gotoLiner = null;
        this.findIncrementalGhost = null;
    }

    String getSearchText() {
        return FindController.getFindOptions().getSearchText();
    }

    private static BasicEditorPane getBasicEditorPane(Context context) {
        View view;
        BasicEditorPane ret = null;
        if (context != null && (view = context.getView()) instanceof BasicEditorPaneContainer) {
            BasicEditorPaneContainer findableEditor = (BasicEditorPaneContainer)view;
            ret = findableEditor.getFocusedEditorPane();
        }
        return ret;
    }

    public boolean update(IdeAction action, Context context) {
        boolean canHandle;
        BasicEditorPane editorPane = FindController.getBasicEditorPane(context);
        int cmdId = action.getCommandId();
        if (editorPane == null) {
            return false;
        }
        if (cmdId == 23 || cmdId == FIND_NEXT_AT_CURSOR_CMD_ID || cmdId == FIND_PREVIOUS_AT_CURSOR_CMD_ID || cmdId == 24) {
            canHandle = true;
        } else if (cmdId == 25 || cmdId == 53) {
            String text = this.getSearchText();
            canHandle = text != null && text.length() > 0;
        } else if (cmdId == 29) {
            canHandle = this.gotoLiner.canPerformGotoLine(context);
        } else if (cmdId == 26) {
            canHandle = true;
        } else if (cmdId == 27) {
            canHandle = true;
        } else {
            return false;
        }
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        String iString;
        String text;
        BasicEditorPane editor = FindController.getBasicEditorPane(context);
        if (editor == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        FindCriteria criteria = (FindCriteria)editor.getProperty(EDITOR_PROPERTY_FIND_CRITERIA);
        FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(editor);
        if (findToolbarController != null) {
            FindToolbar findToolbar;
            if (cmdId == 26) {
                findToolbar = FindToolbar.getFindToolbar(editor);
                cmdId = !findToolbar.getSearchField().getTextField().hasFocus() ? 23 : 25;
            } else if (cmdId == 27) {
                findToolbar = FindToolbar.getFindToolbar(editor);
                cmdId = !findToolbar.getSearchField().getTextField().hasFocus() ? 23 : 53;
            }
        }
        if (cmdId == 23) {
            boolean refind;
            text = Utilities.getCurrentWord((BasicEditorPane)editor);
            FindController.getFindOptions().updateHistory(true, text);
            ideSearchAgainAction.updateAction();
            ideSearchBackwardAction.updateAction();
            boolean bl = refind = DefaultFocusManager.getCurrentManager().getPermanentFocusOwner() == editor;
            if (findToolbarController != null) {
                findToolbarController.setFindShowing(true);
                if (refind) {
                    FindToolbar findToolbar = FindToolbar.getFindToolbar(editor);
                    findToolbar.setSearchFieldText(text);
                    findToolbar.refind(editor.getSelectionStart());
                }
            } else {
                this.invokeFindDialog(editor, false);
            }
        } else if (cmdId == 25) {
            iString = FindToolbar.getIncrementalSearchString(editor);
            if (iString.length() > 0) {
                FindController.getFindOptions().updateHistory(true, iString);
            }
            if (criteria == null) {
                criteria = FindOptions.createFindCriteria(editor);
            }
            criteria.setDirection(FindCriteria.Direction.FORWARD);
            criteria.setLocation(editor.getSelectionEnd());
            FindController.find(editor, criteria);
        } else if (cmdId == 53) {
            iString = FindToolbar.getIncrementalSearchString(editor);
            if (iString.length() > 0) {
                FindController.getFindOptions().updateHistory(true, iString);
            }
            if (criteria == null) {
                criteria = FindOptions.createFindCriteria(editor);
            }
            criteria.setDirection(FindCriteria.Direction.BACKWARD);
            criteria.setLocation(editor.getSelectionStart());
            FindController.find(editor, criteria);
            criteria.setDirection(FindCriteria.Direction.FORWARD);
            criteria.setLocation(editor.getSelectionEnd());
        } else if (cmdId == 24) {
            if (findToolbarController == null) {
                FindOptions options = FindController.getFindOptions();
                String text2 = Utilities.getCurrentWord((BasicEditorPane)editor);
                this.invokeFindDialog(editor, true);
                Replacer.clearHighlights((BasicEditorPane)editor);
                return true;
            }
            String findText = null;
            String replaceText = null;
            boolean doSearch = false;
            int searchOffset = editor.getCaretPosition();
            if (editor == DefaultFocusManager.getCurrentManager().getPermanentFocusOwner()) {
                FindOptions options = FindController.getFindOptions();
                Pair word = Utilities.getCurrentWordAndOffset((BasicEditorPane)editor);
                findText = (String)word.first;
                searchOffset = (Integer)word.second;
                replaceText = findText;
                doSearch = true;
            }
            FindToolbar findToolbar = FindToolbar.getFindToolbar(editor);
            ReplaceToolbar replaceToolbar = ReplaceToolbar.getReplaceToolbar(editor);
            if (!findToolbarController.isReplaceShowing()) {
                findToolbarController.setReplaceShowing(true);
                if (replaceText == null) {
                    replaceText = findToolbar.getSearchField().getText();
                }
                replaceToolbar.getReplaceField().requestFocus();
            } else if (replaceToolbar != null) {
                replaceToolbar.getReplaceField().requestFocus();
            }
            if (findText != null && findToolbar != null) {
                findToolbar.setSearchFieldText(findText);
                if (doSearch) {
                    findToolbar.refind(searchOffset);
                }
            }
            if (replaceText != null && replaceToolbar != null) {
                replaceToolbar.setSearchFieldText(replaceText);
            }
        } else if (cmdId == FIND_NEXT_AT_CURSOR_CMD_ID || cmdId == FIND_PREVIOUS_AT_CURSOR_CMD_ID) {
            if (criteria == null) {
                criteria = FindOptions.createFindCriteria(editor);
            }
            criteria.setRegEx(false);
            if (cmdId == FIND_PREVIOUS_AT_CURSOR_CMD_ID) {
                criteria.setDirection(FindCriteria.Direction.BACKWARD);
            } else {
                criteria.setDirection(FindCriteria.Direction.FORWARD);
            }
            text = Utilities.getCurrentWord((BasicEditorPane)editor);
            if (text != null) {
                criteria.setText(text);
                FindController.find(editor, criteria);
                FindToolbar is = FindToolbar.getFindToolbar(editor);
                if (is != null) {
                    is.setSearchFieldText(text);
                }
            }
        } else if (cmdId == 29) {
            this.gotoLiner.performGotoLine(context);
        } else if (cmdId == 26) {
            Finder.clearHighlights((BasicEditorPane)editor);
            this.findIncrementalGhost.performISearchForward(context);
        } else if (cmdId == 27) {
            Finder.clearHighlights((BasicEditorPane)editor);
            this.findIncrementalGhost.performISearchBackward(context);
        } else {
            return false;
        }
        return true;
    }

    static FindResult find(BasicEditorPane editor, FindCriteria criteria) {
        editor.putProperty(EDITOR_PROPERTY_FIND_CRITERIA, (Object)criteria);
        FindResult result = Finder.find((BasicEditorPane)editor, (FindCriteria)criteria);
        FindController.updateFindCount(editor, result);
        if (result == null || result.getFind() == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            Find find = result.getFind();
            FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(editor);
            if (findToolbarController != null) {
                findToolbarController.navigate(find.getStartOffset(), find.getEndOffset() - find.getStartOffset());
            } else {
                editor.select(find.getStartOffset(), find.getEndOffset());
                editor.ensureCaretVisible();
            }
        }
        return result;
    }

    static void updateFindCount(BasicEditorPane editor, FindResult result) {
        FindToolbar findToolbar = FindToolbar.getFindToolbar(editor);
        if (findToolbar != null) {
            int index;
            int count = result == null ? 0 : result.getFinds().size();
            int n = index = count > 0 ? result.getFinds().indexOf(result.getFind()) + 1 : -1;
            if (count > 0 && result.getFind() == null) {
                if (((Find)result.getFinds().get(0)).getEndOffset() == editor.getCaretPosition()) {
                    index = 1;
                } else if (((Find)result.getFinds().get(result.getFinds().size() - 1)).getEndOffset() == editor.getCaretPosition()) {
                    index = result.getFinds().size();
                }
            }
            findToolbar.setFindCount(count, index);
        }
    }

    private void invokeFindDialog(BasicEditorPane editor, boolean isReplace) {
        FindController.getFindOptions().setSearchSelected(false);
        FindDialog findDialog = new FindDialog();
        if (findDialog.showDialog(editor, isReplace)) {
            FindOptions options;
            FindToolbarController findToolbarController;
            FindCriteria findCriteria = FindOptions.createFindCriteria(editor);
            editor.putProperty(EDITOR_PROPERTY_FIND_CRITERIA, (Object)findCriteria);
            String searchText = findCriteria.getText();
            FindToolbar findToolbar = FindToolbar.getFindToolbar(editor);
            if (findToolbar != null) {
                findToolbar.setSearchFieldText(searchText);
            }
            if ((findToolbarController = AbstractFindToolbarController.getFindController(editor)) != null && findToolbarController.isReplaceShowing()) {
                findToolbarController.getReplaceToolbar().setSearchFieldText(searchText);
            }
            if ((options = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences())).getSearchFromBeginning()) {
                findCriteria.setLocation(0);
            } else if (!findCriteria.isWrap()) {
                if (findCriteria.getDirection() == FindCriteria.Direction.FORWARD) {
                    if (findDialog.isReplace()) {
                        findCriteria.setLocation(editor.getSelectionStart());
                        findCriteria.setLowerBound(editor.getSelectionStart());
                    } else {
                        findCriteria.setLocation(editor.getSelectionEnd());
                        findCriteria.setLowerBound(editor.getSelectionEnd());
                    }
                    findCriteria.setUpperBound(-1);
                } else if (findDialog.isReplace()) {
                    findCriteria.setLocation(editor.getSelectionEnd());
                    findCriteria.setLowerBound(0);
                    findCriteria.setUpperBound(editor.getSelectionEnd());
                } else {
                    findCriteria.setLocation(editor.getSelectionEnd());
                    findCriteria.setLowerBound(0);
                    findCriteria.setUpperBound(editor.getSelectionStart());
                }
            }
            if (options.getSearchSelected()) {
                findCriteria.setLowerBound(editor.getSelectionStart());
                findCriteria.setUpperBound(editor.getSelectionEnd());
            }
            if (findDialog.isReplace()) {
                ReplaceResult replaceResult;
                ReplaceCriteria replaceCriteria = FindOptions.createReplaceCriteria();
                replaceCriteria.setAdvanceAfterReplace(false);
                Finder.find((BasicEditorPane)editor, (FindCriteria)findCriteria);
                if (replaceCriteria.getScope() == ReplaceCriteria.Scope.PROMPTED) {
                    PromptedReplacer promptedReplacer = new PromptedReplacer(editor, findCriteria, replaceCriteria);
                    replaceResult = promptedReplacer.start();
                } else {
                    replaceResult = Replacer.replace((BasicEditorPane)editor, (ReplaceCriteria)replaceCriteria);
                }
                if (replaceResult.getState() == ReplaceResult.State.NOT_FOUND) {
                    FindController.showErrorDialog(editor, findCriteria.getText());
                }
                findCriteria = (FindCriteria)editor.getProperty(EDITOR_PROPERTY_FIND_CRITERIA);
                FindResult result = Finder.find((BasicEditorPane)editor, (FindCriteria)findCriteria);
                FindController.updateFindCount(editor, result);
            } else {
                FindController.find(editor, findCriteria);
            }
        }
    }

    static FindOptions getFindOptions() {
        FindOptions ret = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        return ret;
    }

    static void showErrorDialog(BasicEditorPane editor, String searchText) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        String notFoundText = Bundle.format("FD_NOTFOUND", searchText);
        String errorTitle = Bundle.get("FD_RESULT_TITLE");
        MessageDialog.information((Component)editor, (Object)notFoundText, (String)errorTitle, (String)"f1_idedfindreplacenotfound_html");
    }

    static {
        FIND_NEXT_AT_CURSOR_CMD_ID = Ide.findCmdID((String)"oracle.ide.ceditor.find.next");
        FIND_PREVIOUS_AT_CURSOR_CMD_ID = Ide.findCmdID((String)"oracle.ide.ceditor.find.previous");
    }
}

