/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration.method;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.beanmodel.annotation.MethodIdentifier;
import oracle.bali.xml.beanmodel.apigeneration.method.MethodContext;
import oracle.bali.xml.beanmodel.apigeneration.method.MethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.attribute.AttributeGetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.attribute.AttributeIsSetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.attribute.AttributeMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.attribute.AttributeSetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.attribute.AttributeUnsetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.element.ElementCreateMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.element.ElementGetListMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.element.ElementGetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.element.ElementMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.element.ElementSetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.element.ElementUnsetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.element.ElementWildcardGetListMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.type.TypeGetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.type.TypeGetTextMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.type.TypeMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.type.TypeSetMethodProvider;
import oracle.bali.xml.beanmodel.apigeneration.method.type.TypeSetTextMethodProvider;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.Wildcard;
import oracle.javatools.parser.java.v2.model.SourceMethod;

public class MethodGenerationManager {
    private final List<TypeMethodProvider> _typeMethodProviders = new CopyOnWriteArrayList<TypeMethodProvider>();
    private final List<AttributeMethodProvider> _attributeMethodProviders = new CopyOnWriteArrayList<AttributeMethodProvider>();
    private final List<ElementMethodProvider> _elementMethodProviders = new CopyOnWriteArrayList<ElementMethodProvider>();
    private final Set<MethodIdentifier> _methodIdentifiers = new CopyOnWriteArraySet<MethodIdentifier>();
    private static volatile MethodGenerationManager _manager = null;
    private static final Logger _LOGGER = Logger.getLogger(MethodGenerationManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodGenerationManager getInstance() {
        if (_manager != null) return _manager;
        Class<MethodGenerationManager> clazz = MethodGenerationManager.class;
        synchronized (MethodGenerationManager.class) {
            if (_manager != null) return _manager;
            MethodGenerationManager newManager = new MethodGenerationManager();
            newManager.registerTypeMethodProvider(new TypeSetMethodProvider());
            newManager.registerTypeMethodProvider(new TypeGetMethodProvider());
            newManager.registerTypeMethodProvider(new TypeSetTextMethodProvider());
            newManager.registerTypeMethodProvider(new TypeGetTextMethodProvider());
            newManager.registerAttributeMethodProvider(new AttributeGetMethodProvider());
            newManager.registerAttributeMethodProvider(new AttributeSetMethodProvider());
            newManager.registerAttributeMethodProvider(new AttributeUnsetMethodProvider());
            newManager.registerAttributeMethodProvider(new AttributeIsSetMethodProvider());
            newManager.registerElementMethodProvider(new ElementCreateMethodProvider());
            newManager.registerElementMethodProvider(new ElementGetMethodProvider());
            newManager.registerElementMethodProvider(new ElementSetMethodProvider());
            newManager.registerElementMethodProvider(new ElementUnsetMethodProvider());
            newManager.registerElementMethodProvider(new ElementGetListMethodProvider());
            newManager.registerElementMethodProvider(new ElementWildcardGetListMethodProvider());
            _manager = newManager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return _manager;
        }
    }

    public List<SourceMethod> getMethods(MethodContext context, GrammarComponent component) throws Exception {
        return this.getMethods(context, component, false);
    }

    public List<SourceMethod> getMethods(MethodContext context, GrammarComponent component, boolean isList) throws Exception {
        List<MethodProvider> providers = null;
        if (component instanceof ComplexType) {
            providers = this._typeMethodProviders;
        } else if (component instanceof AttributeDef) {
            providers = this._attributeMethodProviders;
        } else if (component instanceof ElementDef || component instanceof Wildcard) {
            providers = this._elementMethodProviders;
        }
        ArrayList<SourceMethod> methods = new ArrayList<SourceMethod>();
        if (providers != null) {
            for (MethodProvider provider : providers) {
                if (!provider.shouldAddMethod(context, component, isList)) continue;
                methods.add(provider.getMethod(context, component, isList));
            }
        }
        return methods;
    }

    public void registerTypeMethodProvider(TypeMethodProvider typeMethodProvider) {
        this.checkMethodIdentifier(typeMethodProvider);
        this._typeMethodProviders.add(typeMethodProvider);
    }

    public void registerAttributeMethodProvider(AttributeMethodProvider attributeMethodProvider) {
        this.checkMethodIdentifier(attributeMethodProvider);
        this._attributeMethodProviders.add(attributeMethodProvider);
    }

    public void registerElementMethodProvider(ElementMethodProvider elementMethodProvider) {
        this.checkMethodIdentifier(elementMethodProvider);
        this._elementMethodProviders.add(elementMethodProvider);
    }

    private void checkMethodIdentifier(MethodProvider provider) {
        MethodIdentifier identifier = provider.getMethodIdentifier();
        if (this._methodIdentifiers.contains(identifier)) {
            _LOGGER.log(Level.SEVERE, "Duplicate Method Provider registered for " + identifier);
        }
        this._methodIdentifiers.add(identifier);
    }
}

