/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.indexing.IndexingFactory;
import oracle.bali.xml.indexing.IndexingMetadataMapper;
import oracle.bali.xml.indexing.IndexingMetadataParser;
import oracle.bali.xml.metadata.BaliElEvaluator;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.LayeredMetadataEvaluator;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;

public class IndexingProvider {
    private static final QualifiedName REFERENCE_FACTORY = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"reference");
    private static final QualifiedName INDEXING_FACTORY = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"indexingFactory");
    private static final QualifiedName SCHEMA_LOCATION = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema-instance", (String)"schemaLocation");
    private static final QualifiedName NO_NAMESPACE = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema-instance", (String)"noNamespaceSchemaLocation");
    private static final ArrayList<QualifiedName> _qnList = new ArrayList();
    private static final IndexingMetadataParser _parser;
    private static final ConcurrentHashMap _factoryClassMap;
    private static final Logger _LOGGER;
    private IndexingMetadataMapper _mapper;
    private BaliElEvaluator _evaluator = null;
    private List<Map<XmlKey, Map<QualifiedName, List<String>>>> _metadataList;
    private HashMap<XmlKey, List<IndexingFactory>> _factoryMap = new HashMap();

    public IndexingProvider(IndexingMetadataMapper mapper, Set<StandaloneMetadataFile> files) {
        this(mapper, files, null);
    }

    public IndexingProvider(IndexingMetadataMapper mapper, Set<StandaloneMetadataFile> files, MetadataProvider indexingMDProvider) {
        this._mapper = mapper;
        if (indexingMDProvider != null) {
            this._evaluator = new BaliElEvaluator(indexingMDProvider, null);
        }
        if (!files.isEmpty()) {
            this._metadataList = new ArrayList<Map<XmlKey, Map<QualifiedName, List<String>>>>();
            for (StandaloneMetadataFile file : files) {
                Map<XmlKey, Map<QualifiedName, List<String>>> metadata = _parser.getMetadataMap(file);
                this._metadataList.add(metadata);
            }
        }
    }

    public final List<IndexingFactory> getIndexingFactories(QualifiedName elementQN, QualifiedName attrQN, String value) {
        if (this._mapper != null) {
            XmlKey newKey = this._mapper.getXmlKeyFor(this._getXmlKey(elementQN, attrQN), true);
            elementQN = newKey.getElementQName();
            attrQN = newKey.getAttributeQName();
        }
        return this.getIndexingFactoriesImpl(elementQN, attrQN, value);
    }

    public List<IndexingFactory.IndexEntry> getCommentIndexEntries(String value) {
        return Collections.emptyList();
    }

    protected List<IndexingFactory> getIndexingFactoriesImpl(QualifiedName elementQN, QualifiedName attrQN, String value) {
        XmlKey key = this._getXmlKey(elementQN, attrQN);
        if (this._factoryMap.containsKey(key)) {
            return this._factoryMap.get(key);
        }
        ArrayList<IndexingFactory> factories = null;
        if (this._metadataList != null) {
            for (Map<XmlKey, Map<QualifiedName, List<String>>> metadata : this._metadataList) {
                if (!metadata.containsKey(key)) continue;
                Map<QualifiedName, List<String>> factoryMap = metadata.get(key);
                for (QualifiedName qName : _qnList) {
                    if (!factoryMap.containsKey(qName)) continue;
                    if (factories == null) {
                        factories = new ArrayList();
                    }
                    factories.addAll(this._getIndexingFactories(factoryMap.get(qName)));
                }
            }
        }
        if (attrQN != null) {
            if (NO_NAMESPACE.equals((Object)attrQN)) {
                if (factories == null) {
                    factories = new ArrayList<IndexingFactory>();
                }
                factories.addAll(this._getIndexingFactories(Collections.singletonList("oracle.bali.xml.gui.jdev.dependency.url.NoSchemaLocReferenceFactory")));
            }
            if (SCHEMA_LOCATION.equals((Object)attrQN)) {
                if (factories == null) {
                    factories = new ArrayList();
                }
                factories.addAll(this._getIndexingFactories(Collections.singletonList("oracle.bali.xml.gui.jdev.dependency.url.SchemaLocReferenceFactory")));
            }
        }
        this._factoryMap.put(key, factories);
        return factories;
    }

    private XmlKey _getXmlKey(QualifiedName elementQN, QualifiedName attrQN) {
        XmlKey key = null;
        key = attrQN == null ? ImmutableXmlKey.createElementKey((QualifiedName)elementQN) : (attrQN.getNamespace() != null ? ImmutableXmlKey.createAttributeKey((QualifiedName)attrQN) : ImmutableXmlKey.createAttributeKey((QualifiedName)elementQN, (QualifiedName)attrQN));
        return key;
    }

    private Collection<IndexingFactory> _getIndexingFactories(List<String> classes) {
        ArrayList<IndexingFactory> factories = new ArrayList<IndexingFactory>();
        for (String clazz : classes) {
            try {
                IndexingFactory factory = null;
                if (_factoryClassMap.contains(clazz)) {
                    factory = (IndexingFactory)_factoryClassMap.get(clazz);
                } else {
                    SimpleTypeConverter converter;
                    Class factoryClass;
                    String classStr = clazz;
                    try {
                        LayeredMetadataEvaluator.MetadataInfo info = this._evaluator.evaluateValue(clazz, Object.class, null, null);
                        if (info.value instanceof IndexingFactory) {
                            factory = (IndexingFactory)info.value;
                        } else {
                            classStr = (String)info.value;
                        }
                    }
                    catch (MetadataException e) {
                        _LOGGER.log(Level.WARNING, "Unable to evaluate value: {0}", clazz);
                    }
                    if (factory == null && IndexingFactory.class.isAssignableFrom(factoryClass = (Class)(converter = JavaTypeManager.getInstance().getSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASS)).convertToJavaType(classStr, null))) {
                        factory = (IndexingFactory)factoryClass.newInstance();
                    }
                    if (factory != null) {
                        _factoryClassMap.put(clazz, factory);
                    }
                }
                if (factory == null) continue;
                factories.add(factory);
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "Unable to load class: {0}", clazz);
            }
        }
        return factories;
    }

    static {
        _qnList.add(REFERENCE_FACTORY);
        _qnList.add(INDEXING_FACTORY);
        _parser = new IndexingMetadataParser(_qnList);
        _factoryClassMap = new ConcurrentHashMap();
        _LOGGER = Logger.getLogger(IndexingProvider.class.getName());
    }
}

