/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.creatable;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.creatable.IllegalCreatablePluginException;
import oracle.bali.xml.model.creatable.XmlCreatablePlugin;

public class XmlCreatablePluginFactory {
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.model.creatable");

    public static XmlCreatablePlugin createCreatablePlugin(XmlContext context, StructuredMetadataBean plugin) throws IllegalCreatablePluginException {
        if (plugin == null || !XmlMetadataConstants.CREATABLE_PLUGIN.equals((Object)plugin.getName())) {
            throw new IllegalCreatablePluginException("Unexpected StructuredMetadataBean passed to createCreatablePlugin: " + plugin);
        }
        String classAttr = plugin.getProperty(XmlMetadataConstants.CLASS_ATTR);
        try {
            SimpleTypeConverter converter = JavaTypeManager.getInstance().getSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASSINSTANCE);
            XmlCreatablePlugin creatablePlugin = (XmlCreatablePlugin)converter.convertToJavaType(classAttr, null);
            creatablePlugin.init(context, plugin);
            return creatablePlugin;
        }
        catch (Exception e) {
            throw new IllegalCreatablePluginException("Unexpected class name passed to createCreatablePlugins: " + classAttr);
        }
    }

    public static List<XmlCreatablePlugin> createCreatablePlugins(XmlContext context, List<StructuredMetadataBean> creatablePlugins) {
        ArrayList<XmlCreatablePlugin> resultList = new ArrayList<XmlCreatablePlugin>();
        for (StructuredMetadataBean plugins : creatablePlugins) {
            if (creatablePlugins == null || !XmlMetadataConstants.CREATABLE_PLUGINS.equals((Object)plugins.getName())) continue;
            List pluginList = plugins.getChildren();
            for (StructuredMetadataBean plugin : pluginList) {
                try {
                    XmlCreatablePlugin result = XmlCreatablePluginFactory.createCreatablePlugin(context, plugin);
                    resultList.add(result);
                }
                catch (IllegalCreatablePluginException e) {
                    _LOGGER.log(Level.WARNING, "Invalid creatable plugin encountered (and ignored)", e);
                }
                catch (RuntimeException rE) {
                    _LOGGER.log(Level.SEVERE, "Unexpected exception encountered while processing creatable plugins", rE);
                }
            }
        }
        return resultList;
    }

    private XmlCreatablePluginFactory() {
    }

    private static <T> T _instantiate(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            _LOGGER.log(Level.WARNING, "Could not instantiate class " + clazz, e);
            return null;
        }
    }
}

