/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.grammar;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import oracle.bali.xml.beanmodel.apigeneration.ant.task.TaskUtils;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DirectoryEntityResolver
implements EntityResolver {
    private Set<URL> _directories = new HashSet<URL>();

    public DirectoryEntityResolver(Set<URL> directories) {
        this._directories.addAll(directories);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null && systemId.startsWith("http://")) {
            String extra = URLFileSystem.getFileName((URL)URLFactory.newURL((String)systemId));
            if (ModelUtil.hasLength((String)extra)) {
                for (URL directory : this._directories) {
                    URL fileURL = URLFactory.newURL((URL)directory, (String)extra);
                    if (!URLFileSystem.exists((URL)fileURL)) continue;
                    return new InputSource(fileURL.toExternalForm());
                }
            }
            this._log(systemId);
        }
        return null;
    }

    private void _log(String systemId) {
        StringBuffer msg = new StringBuffer();
        msg.append("DirectoryEntityResolver could not locate a local resource using the systemId:");
        msg.append(" ");
        msg.append(systemId);
        TaskUtils.log(msg.toString());
    }
}

