/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.Iterator;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.event.XmlModelAdapter;
import org.w3c.dom.Node;

public abstract class AbstractTextSelectionSynchronizer
extends XmlModelAdapter {
    @Override
    public void modelChanged(XmlModelEvent event) {
        if (event.isSelectionOrRangeSelectionChanged()) {
            this.syncTextSelection((GuiXmlContext)event.getModel().getContext());
        }
    }

    public final void syncTextSelection(GuiXmlContext context) {
        this.syncTextSelection(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void syncTextSelection(GuiXmlContext context, Object arg) {
        XmlModel model = context.getModel();
        Selection selection = model.getSelection();
        if (this.shouldSyncTextSelection(context)) {
            int start = Integer.MAX_VALUE;
            int end = Integer.MIN_VALUE;
            model.acquireReadLock();
            try {
                if (selection.hasRangeSelection()) {
                    int e;
                    DomRange range = selection.getRangeSelection();
                    int s = model.getTextOffset(range.getStart());
                    if (s != -1) {
                        start = s;
                    }
                    if ((e = model.getTextOffset(range.getEnd())) != -1) {
                        end = e;
                    }
                } else {
                    Iterator<Node> itor = selection.getSelectedNodes();
                    while (itor.hasNext()) {
                        int nodeEnd;
                        Node node = itor.next();
                        if (node.getNodeType() == 9) continue;
                        int nodeStart = model.getTextOffset(DomPositionFactory.createDomPosition((Node)node, (int)1));
                        if (nodeStart != -1) {
                            start = Math.min(start, nodeStart);
                        }
                        if ((nodeEnd = model.getTextOffset(DomPositionFactory.createDomPosition((Node)node, (int)2))) == -1) continue;
                        end = Math.max(end, nodeEnd);
                    }
                }
            }
            finally {
                model.releaseReadLock();
            }
            if (start != Integer.MAX_VALUE && end != Integer.MIN_VALUE) {
                this.syncTextSelection(model, start, end, arg);
            }
        }
    }

    protected boolean shouldSyncTextSelection(GuiXmlContext context) {
        XmlGui activeGui = context.getActiveGui();
        if (activeGui != null) {
            return activeGui.getUsage() != XmlUsage.XML_CODE_EDITOR;
        }
        return true;
    }

    public abstract void syncTextSelection(XmlModel var1, int var2, int var3, Object var4);
}

