/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.PageManager;
import oracle.xml.scalable.PageManagerPool;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.ThreadSerialNum;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.XQPageManagerPool;
import oracle.xquery.XQueryContext;
import oracle.xquery.exec.Utils;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XPath;

public class XQLPlus {
    private static XQMesg msg = XQMesg.newInstance(null);
    static final String XQLPLUS_VERSION = "Version 1.0";
    static final String XQLPROMPT = "XQL> ";
    static final String XQLTERMINATOR = "/;";
    static final String _varStr = msg.getMessage0("XQE-0306") + ": ";
    static final String _valStr = " " + msg.getMessage0("XQE-0307") + ": ";
    static final String _oldStr = msg.getMessage0("XQE-0308") + ": ";
    static final String _newStr = msg.getMessage0("XQE-0309") + ": ";
    static final String _nodeStr = " " + msg.getMessage0("XQE-0402");
    static final String _timeStr = msg.getMessage0("XQE-0407");
    private static boolean echo = false;
    private static boolean serverExec = false;
    private static boolean useXMLQryOnServer = false;
    private static boolean timing = false;
    private static boolean lazyDom = false;
    private static boolean cloneDOM = false;
    private static boolean debug = false;
    private static boolean executingFromFile = false;
    private static boolean printPlan = false;
    private static boolean printStaticTypeInfo = false;
    private static boolean noStaticTyping = false;
    private static boolean xqueryxOnly = false;
    private static boolean xdbDirectConn = false;
    private static boolean printUpdateResult = false;
    private static String fileEncoding;
    private static Connection defconn;
    private static String initialctx_filename;
    private static XMLDocument initialDoc;
    private static Hashtable varHash;
    private static Hashtable numHash;
    private static String baseURI;
    private static String declareBaseURI;
    private static BufferedReader rdr;
    private static PrintWriter printWriter;
    private static Configuration config;
    private static boolean silent;
    private static boolean errorCodeOnly;
    private static String separator;
    private static Hashtable pgmHash;

    private static void printBanner() throws IOException {
        printWriter.println("");
        printWriter.println(msg.getMessage0("XQE-0403"));
        printWriter.println(XQLPLUS_VERSION);
        printWriter.println(msg.getMessage0("XQE-0406"));
        printWriter.println("");
    }

    private static void printHelp(String string) throws IOException {
        printWriter.println("");
        printWriter.println(msg.getMessage0("XQE-0403"));
        printWriter.println(msg.getMessage0("XQE-0406"));
        printWriter.println(msg.getMessage0("XQE-0408"));
        printWriter.println(msg.getMessage0("XQE-0409"));
        XQLPlus.printSetHelp();
        printWriter.println("");
    }

    private static void printResultBanner(String string) throws IOException {
        if (!silent) {
            printWriter.println("");
            printWriter.println(msg.getMessage0("XQE-0404"));
            printWriter.println("----------------------------------------------------");
        }
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = false;
        Object var2_2 = null;
        Object var3_3 = null;
        fileEncoding = System.getProperty("oracle.local.char.encoding");
        rdr = fileEncoding == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(System.in, fileEncoding));
        printWriter = fileEncoding == null ? new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(System.out)), true) : new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, fileEncoding)), true);
        XQueryContext xQueryContext = new XQueryContext(msg);
        try {
            if (stringArray.length == 0) {
                XQLPlus.printBanner();
                XQLPlus.executeXQLPlus(xQueryContext, null);
            } else if (stringArray.length >= 1) {
                Object object;
                for (int i = 0; i <= stringArray.length - 1 && stringArray[i].startsWith("-"); ++i) {
                    if (stringArray[i].equals("-server")) {
                        serverExec = true;
                        continue;
                    }
                    if (stringArray[i].equals("-xqueryxOnly")) {
                        XPath.newXQueryXGrammar = true;
                        XPath.printLeadingPIs = true;
                        config.setPrintXQueryx(new PrintWriter(System.out));
                        silent = true;
                        continue;
                    }
                    if (stringArray[i].equals("-useXMLQuery")) {
                        useXMLQryOnServer = true;
                        continue;
                    }
                    if (stringArray[i].equals("-useXMLTable")) {
                        useXMLQryOnServer = false;
                        continue;
                    }
                    if (stringArray[i].equals("-debug")) {
                        debug = true;
                        continue;
                    }
                    if (stringArray[i].equals("-printStaticType")) {
                        printStaticTypeInfo = true;
                        continue;
                    }
                    if (stringArray[i].equals("-noStaticTyping")) {
                        noStaticTyping = true;
                        continue;
                    }
                    if (stringArray[i].equals("-xdbDirectConn")) {
                        xdbDirectConn = true;
                        continue;
                    }
                    if (stringArray[i].equals("-xqueryPushdown")) {
                        XQLPlus.setPushdownXquery();
                        continue;
                    }
                    if (stringArray[i].equals("-s")) {
                        silent = true;
                        echo = false;
                        continue;
                    }
                    if (stringArray[i].equals("-errorCodeOnly")) {
                        errorCodeOnly = true;
                        continue;
                    }
                    if (stringArray[i].equals("-separator")) {
                        if (i < stringArray.length - 1 && stringArray[i + 1].startsWith("-") && stringArray[i + 1].endsWith("-")) {
                            separator = stringArray[++i].substring(1, stringArray[i].length() - 1);
                            continue;
                        }
                        separator = " ";
                        continue;
                    }
                    if (stringArray[i].equals("-lazydom")) {
                        lazyDom = true;
                        config.setLazyDom(lazyDom);
                        object = XQPageManagerPool.getInstance();
                        if (defconn != null) {
                            ((XQPageManagerPool)object).setConnection(defconn);
                        }
                        xQueryContext.setPageManagerPool((PageManagerPool)object);
                        continue;
                    }
                    if (stringArray[i].equals("-baseuri")) {
                        baseURI = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-declareBaseuri")) {
                        declareBaseURI = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equals("-conn")) {
                        defconn = XQueryUtils.getConnection(null, stringArray[++i]);
                        xQueryContext.setDefaultConnection(defconn);
                        if (!lazyDom) continue;
                        object = xQueryContext.getPageManagerPool();
                        ((XQPageManagerPool)object).setConnection(defconn);
                        continue;
                    }
                    printWriter.println(msg.getMessage0("XQE-0409"));
                }
                if (!silent) {
                    XQLPlus.printBanner();
                }
                if ((object = stringArray[stringArray.length - 1]) != null && !((String)object).startsWith("-")) {
                    XQLPlus.processFileExecute("@" + stringArray[stringArray.length - 1], xQueryContext);
                } else {
                    XQLPlus.executeXQLPlus(xQueryContext, null);
                }
            } else {
                XQLPlus.printBanner();
                printWriter.println(msg.getMessage0("XQE-0409"));
            }
        }
        catch (Exception exception) {
            printWriter.println(msg.getMessage0("XQE-0423"));
            exception.printStackTrace(printWriter);
        }
    }

    private static void executeXQLPlus(XQueryContext xQueryContext, String string) throws IOException {
        while (true) {
            try {
                while (true) {
                    String string2;
                    StringBuffer stringBuffer = new StringBuffer(200);
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = 1;
                    if (!executingFromFile || echo) {
                        printWriter.print(XQLPROMPT);
                        printWriter.flush();
                    }
                    while (true) {
                        string2 = rdr.readLine();
                        if (n == 1 && string2 == null) {
                            return;
                        }
                        if (echo) {
                            printWriter.println(string2);
                        }
                        if (n == 1) {
                            if (string2.toLowerCase().startsWith("rem ") || string2.equalsIgnoreCase("rem")) {
                                bl = true;
                                break;
                            }
                            if (string2.startsWith("help")) {
                                XQLPlus.printHelp(string2);
                                bl = true;
                                break;
                            }
                            if (string2.startsWith("set")) {
                                XQLPlus.processSet(string2, xQueryContext);
                                bl = true;
                                break;
                            }
                            if (string2.startsWith("version")) {
                                printWriter.println(System.getProperty("xquery.version"));
                                printWriter.println();
                                bl = true;
                                break;
                            }
                            if (string2 != null && string2.length() == 0) {
                                bl = true;
                                break;
                            }
                            if (string2.startsWith("@")) {
                                XQLPlus.processFileExecute(string2, xQueryContext);
                                bl = true;
                                break;
                            }
                            if (string2.equals("exit")) {
                                if (lazyDom) {
                                    xQueryContext.getPageManagerPool().close();
                                    XQLPlus.cleanup();
                                }
                                return;
                            }
                        }
                        ++n;
                        if (string2 == null) {
                            bl2 = true;
                            break;
                        }
                        if (string2.trim().equals(XQLTERMINATOR)) break;
                        if (!executingFromFile || echo) {
                            printWriter.write("  " + n + "  ");
                            printWriter.flush();
                        }
                        if (numHash != null || varHash != null) {
                            string2 = XQLPlus.processVarSubst(string2);
                        }
                        stringBuffer.append(string2);
                        stringBuffer.append("\n");
                    }
                    if (bl) continue;
                    if (stringBuffer != null) {
                        string2 = stringBuffer.toString();
                    }
                    if (string2 == null || string2.length() == 0) {
                        printWriter.println(msg.getMessage0("XQE-0400"));
                        printWriter.println("");
                        continue;
                    }
                    XQLPlus.executeQuery(string2, xQueryContext, string);
                    if (bl2) break;
                }
            }
            catch (Exception exception) {
                printWriter.println(msg.getMessage0("XQE-0422"));
                exception.printStackTrace(printWriter);
                continue;
            }
            break;
        }
    }

    private static String processVarSubst(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringReader stringReader = new StringReader(string);
        boolean bl = false;
        if (string.indexOf(38) == -1) {
            return string;
        }
        int n = stringReader.read();
        while (n != -1) {
            if (n != 38) {
                stringBuffer.append((char)n);
            } else {
                StringBuffer stringBuffer2 = new StringBuffer(10);
                while ((n = stringReader.read()) != -1 && Character.isLetterOrDigit((char)n)) {
                    stringBuffer2.append((char)n);
                }
                if (stringBuffer2.length() == 0) {
                    stringBuffer.append('&');
                } else {
                    String string2 = stringBuffer2.toString();
                    if (numHash != null && numHash.containsKey(string2)) {
                        stringBuffer.append(numHash.get(string2));
                        bl = true;
                    } else if (varHash != null && varHash.containsKey(string2)) {
                        stringBuffer.append((String)varHash.get(string2));
                        bl = true;
                    } else {
                        stringBuffer.append(string2);
                    }
                    if (n != -1) {
                        stringBuffer.append((char)n);
                    }
                }
            }
            n = stringReader.read();
        }
        String string3 = stringBuffer.toString();
        if (bl) {
            printWriter.println("");
            printWriter.println(_oldStr + string);
            printWriter.println(_newStr + string3);
            printWriter.println("");
        }
        return string3;
    }

    private static void processFileExecute(String string, XQueryContext xQueryContext) throws Exception {
        executingFromFile = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1));
        String string2 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            numHash = new Hashtable(stringTokenizer.countTokens());
            int n = 1;
            do {
                numHash.put(Integer.toString(n), stringTokenizer.nextToken());
            } while (stringTokenizer.hasMoreTokens());
        }
        rdr = fileEncoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(string2))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), fileEncoding));
        String string3 = XQueryUtils.baseUriOf(string2);
        try {
            XQLPlus.executeXQLPlus(xQueryContext, string3);
        }
        catch (Exception exception) {
            throw (Exception)exception.fillInStackTrace();
        }
        finally {
            numHash = null;
            if (lazyDom) {
                xQueryContext.getPageManagerPool().close();
                XQLPlus.cleanup();
            }
        }
    }

    private static void executeQuery(String string, XQueryContext xQueryContext, String string2) throws IOException {
        block12: {
            try {
                XQLPlus.executeQueryInt(string, xQueryContext, string2);
            }
            catch (Exception exception) {
                String string3;
                if (!errorCodeOnly) {
                    printWriter.println("XQE: " + msg.getMessage0("XQE-0401"));
                    printWriter.println(msg.getMessage1("XQE-0418", string));
                }
                if ((string3 = exception.getMessage()) != null && string3.length() > 9 && string3.charAt(8) == ':') {
                    if (errorCodeOnly) {
                        printWriter.println(string3.substring(0, 8));
                    } else {
                        printWriter.println(string3);
                    }
                } else if (errorCodeOnly) {
                    printWriter.println(exception.getMessage());
                } else {
                    printWriter.println("XQE: " + exception.getMessage());
                }
                if (!debug) break block12;
                if (exception instanceof XQException) {
                    Exception exception2 = ((XQException)exception).getParentException();
                    if (exception2 != null) {
                        exception2.printStackTrace(printWriter);
                    } else {
                        exception.printStackTrace(printWriter);
                    }
                }
                exception.printStackTrace(printWriter);
            }
        }
    }

    private static void printServerResult(String string) {
        int n;
        if (fileEncoding != null && string.startsWith("<?xml") && (string.charAt((n = string.indexOf("<?xml")) + 5) == '\r' || string.charAt(n + 5) == ' ' || string.charAt(n + 5) == '\t' || string.charAt(n + 5) == '\n')) {
            String string2 = "<?xml version=\"1.0\" encoding=\"" + fileEncoding + "\"?>";
            printWriter.print(string2);
            int n2 = string.indexOf("?>");
            string = string.substring(n2 + 2);
        }
        printWriter.print(string);
    }

    private static void executeQueryInt(String string, XQueryContext xQueryContext, String string2) throws Exception {
        Object object;
        long l = 0L;
        long l2 = 0L;
        String string3 = "";
        if (timing) {
            l = System.currentTimeMillis();
        }
        if (serverExec) {
            Object object2;
            if (defconn == null) {
                System.out.println(msg.getMessage0("XQE-0413"));
                return;
            }
            if (baseURI != null) {
                string = string.replaceAll("doc\\(\"", "doc(\"" + baseURI);
                string = string.replaceAll("doc\\('", "doc('" + baseURI);
                string = string.replaceAll("collection\\(\"", "collection(\"" + baseURI);
                string = string.replaceAll("collection\\('", "collection('" + baseURI);
            }
            if (declareBaseURI != null) {
                object2 = new StringBuffer(string.length() + 108);
                if (string.startsWith("xquery")) {
                    int n = string.indexOf(";");
                    ((StringBuffer)object2).append(string.substring(0, n + 1));
                    ((StringBuffer)object2).append("declare base-uri \"" + declareBaseURI + "\"; ");
                    ((StringBuffer)object2).append(string.substring(n + 1));
                } else {
                    ((StringBuffer)object2).append("declare base-uri \"" + declareBaseURI + "\"; ");
                    ((StringBuffer)object2).append(string);
                }
                string = ((StringBuffer)object2).toString();
            }
            string = string.replaceAll("'", "''");
            if (initialctx_filename != null) {
                string3 = declareBaseURI != null ? " passing xmlquery('declare base-uri \"" + declareBaseURI + "\"; doc(\"" + initialctx_filename + "\")' returning content)  " : " passing xmlquery('doc(\"" + (baseURI == null ? "" : baseURI) + initialctx_filename + "\")' returning content)  ";
            }
            String string4 = useXMLQryOnServer ? "select xmlquery('" + string + "'" + string3 + " returning content).getclobval() from dual" : "select e.column_value.getclobval() from xmltable('" + string + "'" + string3 + " ) e";
            if (debug) {
                printWriter.println(" ---------- SQL statement executed --------");
                printWriter.println(string4);
                printWriter.println("");
            }
            object2 = null;
            ResultSet resultSet = null;
            try {
                object2 = defconn.prepareStatement(string4);
                resultSet = object2.executeQuery();
                if (resultSet.next()) {
                    XQLPlus.printResultBanner("");
                    boolean bl = false;
                    boolean bl2 = false;
                    String string5 = resultSet.getString(1);
                    if (string5 != null) {
                        bl = true;
                        XQLPlus.printServerResult(string5);
                    }
                    while (resultSet.next()) {
                        bl2 = true;
                        string5 = resultSet.getString(1);
                        if (string5 == null) continue;
                        if (separator != null) {
                            printWriter.print(separator);
                        } else {
                            printWriter.println();
                        }
                        XQLPlus.printServerResult(string5);
                    }
                    if (bl2 || bl) {
                        printWriter.println();
                    }
                } else {
                    XQLPlus.printResultBanner("");
                }
            }
            catch (Exception exception) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (object2 != null) {
                    object2.close();
                }
                throw exception;
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (object2 != null) {
                object2.close();
            }
            return;
        }
        String string6 = baseURI != null ? baseURI : string2;
        config.setBaseURI(string6);
        if (noStaticTyping) {
            config.setXQueryOption(16);
        } else {
            XQLPlus.clearXQueryOption(16);
        }
        if (xdbDirectConn) {
            if (defconn == null) {
                System.out.println(msg.getMessage0("XQE-0413"));
                return;
            }
            if (baseURI != null) {
                string = string.replaceAll("doc\\(\"", "doc(\"" + baseURI);
                string = string.replaceAll("doc\\('", "doc('" + baseURI);
                string = string.replaceAll("collection\\(\"", "collection(\"" + baseURI);
                string = string.replaceAll("collection\\('", "collection('" + baseURI);
            }
            if (declareBaseURI != null) {
                object = new StringBuffer(string.length() + 108);
                if (string.startsWith("xquery")) {
                    int n = string.indexOf(";");
                    ((StringBuffer)object).append(string.substring(0, n + 1));
                    ((StringBuffer)object).append("declare base-uri \"" + declareBaseURI + "\"; ");
                    ((StringBuffer)object).append(string.substring(n + 1));
                } else {
                    ((StringBuffer)object).append("declare base-uri \"" + declareBaseURI + "\"; ");
                    ((StringBuffer)object).append(string);
                }
                string = ((StringBuffer)object).toString();
            }
            config.setXQueryOption(128);
        } else {
            XQLPlus.clearXQueryOption(128);
        }
        object = xQueryContext.prepareXQuery(string, config);
        if (initialDoc != null) {
            OXMLItem oXMLItem = ((PreparedXQuery)object).createItem();
            oXMLItem.setNode((XMLNode)initialDoc);
            ((PreparedXQuery)object).setContextItem((XMLItem)oXMLItem);
        }
        if (printPlan) {
            ((PreparedXQuery)object).printPlan();
        }
        if (printStaticTypeInfo) {
            ((PreparedXQuery)object).printStaticTypeInfo();
        }
        if (printUpdateResult) {
            ((PreparedXQuery)object).setDebugFlag(1);
        }
        if (XPath.newXQueryXGrammar) {
            return;
        }
        OXMLSequence oXMLSequence = (OXMLSequence)((PreparedXQuery)object).executeQuery();
        if (oXMLSequence.next()) {
            XQLPlus.printResultBanner("");
            OXMLItem oXMLItem = oXMLSequence.getItem();
            XQueryUtils.printResult(oXMLItem, printWriter, xQueryContext.msg, errorCodeOnly, separator == null);
            while (oXMLSequence.next()) {
                if (separator != null) {
                    printWriter.print(separator);
                } else {
                    printWriter.println();
                }
                oXMLItem = oXMLSequence.getItem();
                XQueryUtils.printResult(oXMLItem, printWriter, xQueryContext.msg, errorCodeOnly, separator == null);
            }
            if (separator == null) {
                printWriter.println();
            }
        } else {
            XQLPlus.printResultBanner("");
        }
        ((PreparedXQuery)object).cleanup();
        if (timing) {
            l2 = System.currentTimeMillis();
            printWriter.println(_timeStr + (l2 - l) + "ms");
            printWriter.println("");
        }
    }

    private static void processSet(String string, XQueryContext xQueryContext) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            XQLPlus.printSetHelp();
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("sqlconn")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equals("default")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    XQLPlus.printSetHelp();
                } else {
                    defconn = XQueryUtils.getConnection(null, stringTokenizer.nextToken());
                    xQueryContext.setDefaultConnection(defconn);
                }
            } else if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
            } else {
                Connection connection = XQueryUtils.getConnection(null, stringTokenizer.nextToken());
                xQueryContext.setConnectionDesc(string2, connection);
            }
        } else if (string2.equals("echo")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                echo = true;
                printWriter.print("  Echo On ");
                printWriter.println("");
            } else if (string2.equalsIgnoreCase("off")) {
                echo = false;
                printWriter.print("  Echo Off");
                printWriter.println("");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("server")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                serverExec = true;
                printWriter.println("  Server Side Execution ");
            } else if (string2.equalsIgnoreCase("off")) {
                serverExec = false;
                printWriter.println("  Client Side Execution ");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("debug")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                debug = true;
                printWriter.print("  Debug On ");
                printWriter.println("");
            } else if (string2.equalsIgnoreCase("off")) {
                debug = false;
                printWriter.println("  Debug Off ");
                printWriter.println("");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("timing")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                timing = true;
                printWriter.println("  Timing On ");
                printWriter.println("");
            } else if (string2.equalsIgnoreCase("off")) {
                timing = false;
                printWriter.println("  Timing Off ");
                printWriter.println("");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("var")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            if (varHash == null) {
                varHash = new Hashtable(10);
            }
            String string3 = stringTokenizer.nextToken();
            varHash.put(string2, string3);
            printWriter.println("");
            printWriter.println(_varStr + string2 + _valStr + string3);
            printWriter.println("");
        } else if (string2.equals("print_plan")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                printPlan = true;
                printWriter.print("  print_plan On ");
                printWriter.println("");
            } else if (string2.equalsIgnoreCase("off")) {
                printPlan = false;
                printWriter.println("  print_plan Off ");
                printWriter.println("");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("print_xqueryx")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                config.setPrintXQueryx(new PrintWriter(System.out));
                printWriter.print("  print_xqueryx On ");
                printWriter.println("");
            } else if (string2.equalsIgnoreCase("off")) {
                config.setPrintXQueryx(null);
                printWriter.println("  print_xqueryx Off");
                printWriter.println("");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("xquery_pushdown")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                XQLPlus.setPushdownXquery();
                printWriter.println("  xquery_pushdown On ");
                printWriter.println("");
            } else if (string2.equalsIgnoreCase("off")) {
                XQLPlus.clearXQueryOption(1);
                printWriter.println("  xquery_pushdown Off");
                printWriter.println("");
            }
        } else if (string2.equals("lazydom")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("on")) {
                lazyDom = true;
                xQueryContext.setPageManagerPool(XQPageManagerPool.getInstance());
            } else {
                lazyDom = false;
            }
            config.setLazyDom(lazyDom);
        } else if (string2.equals("xdb_direct_conn")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                xdbDirectConn = true;
                printWriter.println("  xdb_direct_conn on");
            } else if (string2.equalsIgnoreCase("off")) {
                xdbDirectConn = false;
                printWriter.println("  xdb_direct_conn off");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("print_staticType")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                printStaticTypeInfo = true;
                printWriter.println("  print_staticType on");
            } else if (string2.equalsIgnoreCase("off")) {
                printStaticTypeInfo = false;
                printWriter.println("  print_staticType off");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("staticTyping")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                noStaticTyping = false;
                printWriter.println("  staticTyping on");
            } else if (string2.equalsIgnoreCase("off")) {
                noStaticTyping = true;
                printWriter.println("  staticTyping off");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("clonedom")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            String string5 = stringTokenizer.nextToken();
            cloneDOM = string5.equals("on");
            config.setCloneDom(cloneDOM);
        } else if (string2.equals("print_update_result")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("on")) {
                printUpdateResult = true;
                printWriter.print("  print_update_result On ");
                printWriter.println("");
            } else if (string2.equalsIgnoreCase("off")) {
                printUpdateResult = false;
                printWriter.println("  print_update_result Off");
                printWriter.println("");
            } else {
                XQLPlus.printSetHelp();
            }
        } else if (string2.equals("initialctx")) {
            if (!stringTokenizer.hasMoreTokens()) {
                XQLPlus.printSetHelp();
                return;
            }
            initialctx_filename = stringTokenizer.nextToken();
            if (serverExec) {
                return;
            }
            try {
                InputStream inputStream = Utils.getStream(initialctx_filename);
                DOMParser dOMParser = new DOMParser();
                dOMParser.reset();
                if (lazyDom) {
                    String string6 = initialctx_filename + ThreadSerialNum.getNextNum();
                    PageManager pageManager = xQueryContext.getPageManagerPool().getPageManager(string6);
                    if (pageManager != null) {
                        dOMParser.setAttribute("oracle.xml.parser.DOMParser.PartialDOM", (Object)Boolean.TRUE);
                        dOMParser.setAttribute("oracle.xml.parser.DOMParser.PageManager", (Object)pageManager);
                        if (pgmHash == null) {
                            pgmHash = new Hashtable();
                        }
                        pgmHash.put(string6, pageManager);
                    }
                }
                dOMParser.parse(inputStream);
                initialDoc = dOMParser.getDocument();
            }
            catch (Exception exception) {
                printWriter.println(exception);
            }
        } else {
            XQLPlus.printSetHelp();
        }
    }

    private static void printSetHelp() throws IOException {
        printWriter.println(msg.getMessage0("XQE-0412"));
        printWriter.println(msg.getMessage0("XQE-0413"));
        printWriter.println(msg.getMessage0("XQE-0414"));
        printWriter.println(msg.getMessage0("XQE-0415"));
        printWriter.println(msg.getMessage0("XQE-0416"));
        printWriter.println(msg.getMessage0("XQE-0417"));
        printWriter.println(msg.getMessage0("XQE-0421"));
        printWriter.println("");
    }

    private static void setPushdownXquery() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        XQLPlus.config.xqoption |= 1;
    }

    private static void clearXQueryOption(int n) {
        XQLPlus.config.xqoption &= ~n;
    }

    private static void cleanup() {
        if (lazyDom && pgmHash != null) {
            Enumeration enumeration = pgmHash.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                File file = new File(string);
                file.delete();
            }
        }
    }

    static {
        defconn = null;
        initialctx_filename = null;
        initialDoc = null;
        varHash = null;
        numHash = null;
        baseURI = null;
        declareBaseURI = null;
        config = new Configuration();
        silent = false;
        errorCodeOnly = false;
        separator = null;
        pgmHash = null;
    }
}

