/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.Variable;
import oracle.xquery.func.FunctionDefn;
import oracle.xquery.func.FunctionId;

public class LibraryModule {
    private String id;
    private String prefix;
    private String targetURI;
    private HashMap prologVars;
    private HashMap functionDefns;
    protected HashMap importedModules;

    LibraryModule() {
    }

    void setPrefix(String string) {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    void setTargetURI(String string) {
        this.targetURI = string;
    }

    public String getTargetURI() {
        return this.targetURI;
    }

    String getModuleId() {
        return this.id;
    }

    public void setModuleId(String string) {
        this.id = string;
    }

    void setImportedModules(HashMap hashMap) {
        this.importedModules = hashMap;
    }

    HashMap getImportedModules() {
        return this.importedModules;
    }

    void addImportedModule(LibraryModule libraryModule) {
        if (this.importedModules == null) {
            this.importedModules = new HashMap();
        }
        this.importedModules.put(libraryModule.getTargetURI(), libraryModule);
    }

    void setPrologVars(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        this.prologVars = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)arrayList.get(i);
            this.prologVars.put(variable.getVariableQName(), variable);
        }
    }

    HashMap getPrologVars() {
        return this.prologVars;
    }

    void setFunctionDefns(HashMap hashMap) {
        this.functionDefns = hashMap;
    }

    HashMap getFunctionDefns() {
        return this.functionDefns;
    }

    void addPrologVar(Variable variable) {
        if (this.prologVars == null) {
            this.prologVars = new HashMap();
        }
        this.prologVars.put(variable.getVariableQName(), variable);
    }

    void addFunctionDefns(FunctionId functionId, FunctionDefn functionDefn) {
        if (this.functionDefns == null) {
            this.functionDefns = new HashMap();
        }
        this.functionDefns.put(functionId, functionDefn);
    }

    public void append(LibraryModule libraryModule) {
        if (libraryModule.functionDefns != null) {
            if (this.functionDefns == null) {
                this.functionDefns = libraryModule.functionDefns;
            } else {
                for (Object object : libraryModule.functionDefns.keySet()) {
                    FunctionDefn functionDefn = (FunctionDefn)this.functionDefns.get(object);
                    if (functionDefn != null) {
                        throw new XQException(XQMesg.getInstance().getMessage0("XQST0034"), XQMesg.getInstance().getMessage1("XQE-0230", functionDefn.getFunctionName()));
                    }
                    this.functionDefns.put(object, libraryModule.functionDefns.get(object));
                }
            }
        }
        if (libraryModule.prologVars != null) {
            if (this.prologVars == null) {
                this.prologVars = libraryModule.prologVars;
            } else {
                for (Object object : libraryModule.prologVars.keySet()) {
                    if (this.prologVars.containsKey(object)) {
                        throw new XQException(XQMesg.getInstance().getMessage0("XQST0049"), XQMesg.getInstance().getMessage1("XQE-0242", ((QName)object).toString()));
                    }
                    this.prologVars.put(object, libraryModule.prologVars.get(object));
                }
            }
        }
        this.copyImportedModules(libraryModule);
        this.id = this.id + libraryModule.getModuleId();
    }

    private void copyImportedModules(LibraryModule libraryModule) {
        if (libraryModule.importedModules == null) {
            return;
        }
        if (this.importedModules == null) {
            this.importedModules = libraryModule.importedModules;
            return;
        }
        for (Object k : libraryModule.importedModules.keySet()) {
            if (this.importedModules.containsKey(k)) {
                throw new XQException(XQMesg.getInstance().getMessage0("XQST0047"));
            }
            this.importedModules.put(k, libraryModule.importedModules.get(k));
        }
    }

    FunctionDefn getFunctionDefn(FunctionId functionId) {
        LibraryModule libraryModule;
        FunctionDefn functionDefn = this.getOwnFuncDefn(functionId);
        if (functionDefn != null) {
            return functionDefn;
        }
        if (this.importedModules != null && (libraryModule = (LibraryModule)this.importedModules.get(functionId.getNamespaceURI())) != null) {
            functionDefn = libraryModule.getOwnFuncDefn(functionId);
        }
        return functionDefn;
    }

    FunctionDefn getOwnFuncDefn(FunctionId functionId) {
        FunctionDefn functionDefn = null;
        if (this.functionDefns != null) {
            functionDefn = (FunctionDefn)this.functionDefns.get(functionId);
        }
        return functionDefn;
    }

    Variable getPrologVar(QName qName) {
        String string;
        LibraryModule libraryModule;
        Variable variable = this.getOwnPrologVar(qName);
        if (variable != null) {
            return variable;
        }
        if (this.importedModules != null && (libraryModule = (LibraryModule)this.importedModules.get(string = qName.getNamespaceURI())) != null) {
            variable = libraryModule.getOwnPrologVar(qName);
        }
        return variable;
    }

    Variable getOwnPrologVar(QName qName) {
        Variable variable = null;
        if (this.prologVars != null) {
            variable = (Variable)this.prologVars.get(qName);
        }
        return variable;
    }
}

