/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.OXMLSQLExprFunction;
import oracle.xml.xqxp.functions.builtIns.FNFunctionLibrary;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.OXQuerySequence;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.RuntimeFrame;
import oracle.xquery.exec.SQLQuery;
import oracle.xquery.exec.Variable;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.func.FunctionDefn;
import oracle.xquery.parser.XQXGen;

public class FunctionCall
extends Expr {
    FunctionDefn fd;
    private static final boolean debug = false;
    private boolean dbtentwo = false;

    public XMLNode DefinitionToXML() {
        XMLElement xMLElement = (XMLElement)FunctionCall.getDoc().createElement("FunctionCall");
        xMLElement.setAttribute("name", this.fd.getFunctionName());
        xMLElement.setAttribute("ebv", this.getEBVString());
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    @Override
    public XMLNode toXML() {
        return this.DefinitionToXML();
    }

    @Override
    public ConvertXML DefinitionFromXML(XMLElement xMLElement) {
        return this;
    }

    public void toSqlDefn(XQXGen xQXGen) {
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        this.toSqlDefn(xQXGen);
    }

    protected void toSqlSuper(XQXGen xQXGen) {
        super.toSql(xQXGen);
    }

    @Override
    public void getStrRep(StringBuffer stringBuffer) {
        stringBuffer.append(this.fd.getFunctionName());
        stringBuffer.append("(");
        if (this.kids != null && this.kids.length > 0) {
            int n;
            for (n = 0; n < this.kids.length - 1; ++n) {
                this.kids[n].getStrRep(stringBuffer);
                stringBuffer.append(",");
            }
            this.kids[n].getStrRep(stringBuffer);
        }
        stringBuffer.append(")");
    }

    @Override
    public int getDatatype() {
        return this.fd.getFunctionExpr().getDatatype();
    }

    public FunctionCall(FunctionDefn functionDefn, Expr[] exprArray) {
        super(exprArray);
        this.setFunctionDefn(functionDefn);
    }

    public FunctionCall(Expr[] exprArray) {
        super(exprArray);
    }

    @Override
    public int getPositionTest() {
        if (XQueryUtils.isBuiltInFunction(this, "last")) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    @Override
    public int getPositionTestExact() {
        return this.getPositionTest();
    }

    public void setFunctionDefn(FunctionDefn functionDefn) {
        this.fd = functionDefn;
        OXMLFunction oXMLFunction = this.fd.getFunctionObj();
        if (oXMLFunction != null) {
            if (oXMLFunction == FNFunctionLibrary.getInstance().getFunction("true", 0)) {
                this.setEBV(true);
            } else if (oXMLFunction == FNFunctionLibrary.getInstance().getFunction("false", 0)) {
                this.setEBV(false);
            }
        }
    }

    public FunctionDefn getFunctionDefn() {
        return this.fd;
    }

    public void setDBVsn(boolean bl) {
        this.dbtentwo = bl;
    }

    public boolean getDBVsn() {
        return this.dbtentwo;
    }

    public void optimizeGeneral(OptimizeContext optimizeContext) {
        boolean bl = XQueryUtils.isBuiltIn(this.fd.getNamespace());
        if (optimizeContext != null && this.fd.isExternalFunction() && !bl) {
            optimizeContext.setXqPushdown(false);
        }
        super.optimize(optimizeContext);
    }

    @Override
    public Expr optimize(OptimizeContext optimizeContext) {
        this.optimizeGeneral(optimizeContext);
        if (optimizeContext != null && this.verifyXpPushdown()) {
            StringBuffer stringBuffer = null;
            return this.pushdownRewrite(stringBuffer);
        }
        return this;
    }

    public boolean verifyXpPushdown() {
        int n;
        OXMLFunction oXMLFunction = this.fd.getFunctionObj();
        String string = null;
        Connection connection = null;
        int n2 = 0;
        int n3 = 0;
        if (oXMLFunction == null) {
            return false;
        }
        if (!(oXMLFunction instanceof OXMLSQLExprFunction)) {
            return false;
        }
        OXMLSQLExprFunction oXMLSQLExprFunction = (OXMLSQLExprFunction)oXMLFunction;
        try {
            if (!oXMLSQLExprFunction.willDelegateSQL()) {
                return false;
            }
            string = oXMLSQLExprFunction.getSQLExprString();
            if (string == null) {
                return false;
            }
            connection = oXMLSQLExprFunction.getDBConnection();
            if (connection == null) {
                return false;
            }
            n = oXMLSQLExprFunction.isXMLType();
            int n4 = oXMLSQLExprFunction.getSQLExprColumnCount();
            if (n4 == 0) {
                return false;
            }
            for (int i = 0; i < n4; ++i) {
                String string2 = oXMLSQLExprFunction.getSQLExprColumnName(i + 1);
                if (string2 != null) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            n2 = databaseMetaData.getDatabaseMajorVersion();
            n3 = databaseMetaData.getDatabaseMinorVersion();
        }
        catch (Exception exception) {
            return false;
        }
        if (n2 < 10 || n2 == 10 && n3 < 1) {
            return false;
        }
        if (n2 == 10 && n3 == 1) {
            this.setDBVsn(false);
        } else {
            this.setDBVsn(true);
        }
        int n5 = oXMLSQLExprFunction.getNumberArgs();
        if (n5 > 0) {
            n = 0;
            if (oXMLSQLExprFunction.isFirstArgSQLExpr()) {
                n = 1;
            }
            while (n < n5) {
                OXMLSequenceType oXMLSequenceType = oXMLSQLExprFunction.getArgType(n);
                if (!(oXMLSequenceType.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE) || oXMLSequenceType.isOfType(OXMLSequenceType.TSTRING_ZERO_OR_ONE) || oXMLSequenceType.isOfType(OXMLSequenceType.TDATETIME))) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public Expr pushdownRewrite(StringBuffer stringBuffer) {
        SQLQuery sQLQuery;
        int n;
        int n2;
        boolean bl = true;
        OXMLSQLExprFunction oXMLSQLExprFunction = (OXMLSQLExprFunction)this.fd.getFunctionObj();
        String string = oXMLSQLExprFunction.getSQLExprString();
        Connection connection = oXMLSQLExprFunction.getDBConnection();
        if (connection == null) {
            return this;
        }
        bl = oXMLSQLExprFunction.isXMLType();
        String string2 = string;
        if (stringBuffer != null) {
            n2 = oXMLSQLExprFunction.getSQLExprColumnCount();
            String string3 = null;
            string3 = bl ? "select xmlagg(" : "select xmlagg(xmlelement(\"ROW\", xmlforest(";
            for (n = 0; n < n2; ++n) {
                if (n != 0) {
                    string3 = string3 + ",";
                }
                string3 = string3 + oXMLSQLExprFunction.getSQLExprColumnName(n + 1);
            }
            string2 = bl ? string3 + ") from (" + string + ")" : string3 + "))) from (" + string + ")";
            string2 = "select p.column_value.getclobval() from table(xmlsequence(extract((" + string2 + "), '" + stringBuffer + "'))) p";
        }
        if (this.kids != null) {
            n2 = 0;
            int n3 = this.kids.length;
            n = oXMLSQLExprFunction.getNumberArgs();
            if (oXMLSQLExprFunction.isFirstArgSQLExpr() && n3 == 1) {
                sQLQuery = new SQLQuery(connection, string2);
            } else {
                int n4;
                Expr[] exprArray;
                OXMLSequenceType[] oXMLSequenceTypeArray;
                if (oXMLSQLExprFunction.isFirstArgSQLExpr()) {
                    oXMLSequenceTypeArray = new OXMLSequenceType[n - 1];
                    n2 = 1;
                    exprArray = new Expr[n3 - 1];
                    for (n4 = 1; n4 < n3; ++n4) {
                        exprArray[n4 - 1] = this.kids[n4];
                    }
                } else {
                    oXMLSequenceTypeArray = new OXMLSequenceType[n];
                    exprArray = this.kids;
                }
                sQLQuery = new SQLQuery(connection, string2, exprArray);
                n4 = 0;
                while (n2 < n) {
                    oXMLSequenceTypeArray[n4] = oXMLSQLExprFunction.getArgType(n2);
                    ++n2;
                    ++n4;
                }
                sQLQuery.setBindVarType(oXMLSequenceTypeArray);
            }
        } else {
            sQLQuery = new SQLQuery(connection, string2);
        }
        if (stringBuffer == null && !bl) {
            sQLQuery.setNeedRowTag(true);
        } else {
            sQLQuery.setNeedRowTag(false);
            sQLQuery.setNeedXMLRes(true);
            if (stringBuffer != null) {
                sQLQuery.setXMLType(null, null);
            }
        }
        return sQLQuery;
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        if (this.fd.getFunctionObj() != null) {
            return this.EvaluateJavaFunction(queryState);
        }
        return this.EvaluateUDF(queryState);
    }

    private OXMLSequence EvaluateJavaFunction(QueryState queryState) {
        OXMLSequence oXMLSequence;
        String string;
        Object object;
        OXMLFunction oXMLFunction = this.fd.getFunctionObj();
        Variable[] variableArray = this.fd.getParameters();
        boolean bl = XQueryUtils.isBuiltIn(this.fd.getNamespace());
        OXMLSequence[] oXMLSequenceArray = null;
        if (this.kids != null) {
            oXMLSequenceArray = new OXMLSequence[this.kids.length];
            for (int i = 0; i < this.kids.length; ++i) {
                oXMLSequenceArray[i] = this.kids[i].Evaluate(queryState);
                if (!this.kids[i].needRuntimeTyping()) continue;
                object = oXMLFunction.getArgType(i);
                if (!bl && (string = variableArray[i].getDefinedType()) != null) {
                    object = string;
                }
                ((OXQuerySequence)oXMLSequenceArray[i]).setExpectedType((OXMLSequenceType)object, this.kids[i].staticTypingStatus);
            }
        }
        try {
            oXMLSequence = oXMLFunction.invoke((OXMLFunctionContext)queryState, oXMLSequenceArray);
        }
        catch (oracle.xml.xqxp.XQException xQException) {
            string = null;
            String string2 = xQException.getErrorCode();
            try {
                string = queryState.getMesg().getMessage0(string2);
            }
            catch (Exception exception) {
                string = string2;
            }
            String string3 = xQException.getDescription();
            if (string3 == null) {
                throw new XQException(string);
            }
            throw new XQException(string, string3);
        }
        object = this.fd.getReturnType();
        Object object2 = string = bl || object == null ? oXMLFunction.getReturnType() : object;
        if (!bl && !(oXMLSequence = XQueryUtils.normalizeParameter(queryState, (OXMLSequenceType)string, oXMLSequence, 15)).isOfType((OXMLSequenceType)string)) {
            throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
        }
        oXMLSequence.setKnownType((OXMLSequenceType)string);
        return oXMLSequence;
    }

    private OXMLSequence EvaluateUDF(QueryState queryState) {
        OXMLSequence oXMLSequence;
        Variable[] variableArray = this.fd.getParameters();
        OXMLSequence[] oXMLSequenceArray = null;
        if (this.kids != null) {
            oXMLSequenceArray = new OXMLSequence[this.kids.length];
            for (int i = 0; i < this.kids.length; ++i) {
                oXMLSequenceArray[i] = this.kids[i].Evaluate(queryState);
                ((OXQuerySequence)oXMLSequenceArray[i]).materializeMe();
            }
        }
        RuntimeFrame runtimeFrame = queryState.getRuntimeFrame();
        queryState.initializeFunctionFrame();
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i].needRuntimeTyping() && (oXMLSequence = variableArray[i].getDefinedType()) != null) {
                    oXMLSequenceArray[i] = XQueryUtils.normalizeParameter(queryState, (OXMLSequenceType)oXMLSequence, oXMLSequenceArray[i], this.kids[i].staticTypingStatus);
                }
                variableArray[i].setValue(this.kids[i].unknownStaticType(), oXMLSequenceArray[i], queryState);
            }
        }
        Expr expr = this.fd.getFunctionExpr();
        oXMLSequence = expr.Evaluate(queryState);
        ((OXQuerySequence)oXMLSequence).materializeMe();
        OXMLSequenceType oXMLSequenceType = this.fd.getReturnType();
        oXMLSequence = XQueryUtils.normalizeParameter(queryState, oXMLSequenceType, oXMLSequence, expr.staticTypingStatus);
        if (expr.unknownStaticType() && oXMLSequenceType != null && !oXMLSequence.isOfType(oXMLSequenceType)) {
            throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
        }
        oXMLSequence.setKnownType(oXMLSequenceType);
        queryState.setRuntimeFrame(runtimeFrame);
        return oXMLSequence;
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitFunctionCall(this);
    }
}

