/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.io.IOException;
import java.net.URL;
import oracle.help.common.Target;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class View {
    private Book _book;
    private String _basePath;
    private String _type;
    private String _title;
    private String _label;
    private String _name;
    private String _encoding;
    private Target _titleImageTarget;
    private Target _labelImageTarget;
    private DataEngine _engine;
    private URL _dataLocation;
    private Object _viewData;
    private boolean _isMasterView = false;

    public View(Book book, String basePath, String type, DataEngine engine, URL dataLocation, String encoding) {
        this._book = book;
        this._basePath = basePath;
        this._type = type;
        this._engine = engine;
        this._dataLocation = dataLocation;
        this._title = null;
        this._titleImageTarget = null;
        this._label = null;
        this._labelImageTarget = null;
        this._name = null;
        this._viewData = null;
        this._encoding = encoding;
    }

    public View(Book book, String basePath, String type, DataEngine engine, URL dataLocation, String encoding, String title) {
        this(book, basePath, type, engine, dataLocation, encoding);
        this._title = title;
    }

    public View(Book book, String basePath, String type, DataEngine engine, URL dataLocation, String encoding, String title, String label) {
        this(book, basePath, type, engine, dataLocation, encoding, title);
        this._label = label;
    }

    public View(Book book, String basePath, String type, DataEngine engine, URL dataLocation, String encoding, String title, String label, String name) {
        this(book, basePath, type, engine, dataLocation, encoding, title, label);
        this._name = name;
    }

    public Book getBook() {
        return this._book;
    }

    public String getBasePath() {
        return this._basePath;
    }

    public String getType() {
        return this._type;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Target getTitleImage() {
        return this._titleImageTarget;
    }

    public void setTitleImage(Target imageTarget) {
        this._titleImageTarget = imageTarget;
    }

    public Target getLabelImage() {
        return this._labelImageTarget;
    }

    public void setLabelImage(Target imageTarget) {
        this._labelImageTarget = imageTarget;
    }

    public URL getDataLocation() {
        return this._dataLocation;
    }

    public boolean isMasterView() {
        return this._isMasterView;
    }

    public void setMasterView(boolean isMasterView) {
        this._isMasterView = isMasterView;
    }

    public synchronized Object getViewData() throws IOException {
        if (this._viewData == null && this._engine != null) {
            this._viewData = this._engine.createDataObject(this, this._basePath, this._dataLocation, this._encoding);
        }
        return this._viewData;
    }
}

