/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.awt.Color;
import java.awt.Rectangle;
import oracle.help.common.WindowCoordinate;
import oracle.help.common.WindowToolbar;
import oracle.help.library.Book;

public class WindowType {
    private Book _book = null;
    private String _name = null;
    private WindowCoordinate _height = null;
    private WindowCoordinate _width = null;
    private WindowCoordinate _x = null;
    private WindowCoordinate _y = null;
    private Color _textFG = null;
    private Color _linkFG = null;
    private Color _pageBG = null;
    private String _title = null;
    private WindowToolbar _toolbar = null;
    private boolean _isDefault = false;

    public WindowType(Book book) {
        this._book = book;
        this._toolbar = new WindowToolbar(0);
    }

    public void setName(String name) {
        if (name != null && name.length() > 0) {
            this._name = name;
        }
    }

    public String getName() {
        return this._name;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public void setDefault(boolean value) {
        this._isDefault = value;
    }

    public void setHeight(String string) {
        WindowCoordinate coordinate = this._stringToCoordinate(string, false);
        if (coordinate != null) {
            this._height = coordinate;
        }
    }

    public WindowCoordinate getHeight() {
        return this._height;
    }

    public void setWidth(String string) {
        WindowCoordinate coordinate = this._stringToCoordinate(string, true);
        if (coordinate != null) {
            this._width = coordinate;
        }
    }

    public WindowCoordinate getWidth() {
        return this._width;
    }

    public void setX(String string) {
        WindowCoordinate coordinate = this._stringToCoordinate(string, true);
        if (coordinate != null) {
            this._x = coordinate;
        }
    }

    public WindowCoordinate getX() {
        return this._x;
    }

    public void setY(String string) {
        WindowCoordinate coordinate = this._stringToCoordinate(string, false);
        if (coordinate != null) {
            this._y = coordinate;
        }
    }

    public WindowCoordinate getY() {
        return this._y;
    }

    public void setTextFG(String string) {
        Color color = this._stringToColor(string);
        this.setTextFG(color);
    }

    public void setTextFG(Color color) {
        if (color != null) {
            this._textFG = color;
        }
    }

    public Color getTextFG() {
        return this._textFG;
    }

    public void setLinkFG(String string) {
        Color color = this._stringToColor(string);
        this.setLinkFG(color);
    }

    public void setLinkFG(Color color) {
        if (color != null) {
            this._linkFG = color;
        }
    }

    public Color getLinkFG() {
        return this._linkFG;
    }

    public void setPageBG(String string) {
        Color color = this._stringToColor(string);
        this.setPageBG(color);
    }

    public void setPageBG(Color color) {
        if (color != null) {
            this._pageBG = color;
        }
    }

    public Color getPageBG() {
        return this._pageBG;
    }

    public void setTitle(String title) {
        if (title != null && title.length() > 0) {
            this._title = title;
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setToolbar(String string) {
        if (string != null) {
            string = string.trim();
            try {
                int number = Integer.parseInt(string, 16);
                this._toolbar = new WindowToolbar(number);
            }
            catch (NumberFormatException e) {
                System.err.println(e);
            }
        }
    }

    public void setToolbar(WindowToolbar toolbar) {
        this._toolbar = toolbar;
    }

    public WindowToolbar getToolbar() {
        return this._toolbar;
    }

    public void setBounds(Rectangle rect) {
        this._height = new WindowCoordinate(rect.height, false, false, false);
        this._width = new WindowCoordinate(rect.width, false, false, true);
        this._x = new WindowCoordinate(rect.x, false, false, true);
        this._y = new WindowCoordinate(rect.y, false, false, false);
    }

    public Book getBook() {
        return this._book;
    }

    private Color _stringToColor(String string) {
        Color theColor = null;
        if (string != null) {
            if ((string = string.trim()).charAt(0) == '#') {
                string = string.substring(1);
            }
            try {
                int colorValue = Integer.parseInt(string, 16);
                theColor = new Color(colorValue);
            }
            catch (NumberFormatException e) {
                theColor = null;
            }
        }
        return theColor;
    }

    private WindowCoordinate _stringToCoordinate(String string, boolean horiz) {
        WindowCoordinate newCoord = null;
        boolean isNegative = false;
        boolean isPercent = false;
        if (string != null) {
            if ((string = string.trim()).charAt(0) == '-') {
                string = string.substring(1);
                isNegative = true;
            }
            if (string.charAt(string.length() - 1) == '%') {
                string = string.substring(0, string.length() - 1);
                isPercent = true;
            }
            try {
                int number = Integer.parseInt(string);
                newCoord = new WindowCoordinate(number, isNegative, isPercent, horiz);
            }
            catch (NumberFormatException e) {
                newCoord = null;
            }
        }
        return newCoord;
    }
}

