/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.HashMap;
import oracle.help.common.WindowType;
import oracle.help.library.Book;

public class WindowTypeRepository {
    private HashMap _table = new HashMap();
    private WindowType _default = new WindowType(null);

    public void addWindowType(WindowType winType) {
        if (winType != null) {
            this._table.put(winType.getName(), winType);
            if (winType.isDefault()) {
                this._default = winType;
            }
        }
    }

    public void removeWindowType(WindowType winType) {
        if (winType != null && this._table.containsValue(winType)) {
            this._table.remove(winType.getName());
            if (winType == this._default) {
                this._default = null;
            }
        }
    }

    public void addWindowTypesInBook(Book book) {
        WindowType[] bookWinTypes = book.getWindowTypes();
        if (bookWinTypes != null) {
            for (int iter = 0; iter < bookWinTypes.length; ++iter) {
                this.addWindowType(bookWinTypes[iter]);
            }
        }
    }

    public void removeWindowTypesInBook(Book book) {
        WindowType[] bookWinTypes = book.getWindowTypes();
        if (bookWinTypes != null) {
            for (int iter = 0; iter < bookWinTypes.length; ++iter) {
                this.removeWindowType(bookWinTypes[iter]);
            }
        }
    }

    public WindowType getWindowType(String name) {
        return (WindowType)this._table.get(name);
    }

    public WindowType getDefaultWindowType() {
        return this._default;
    }
}

