/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.xml;

import java.util.HashMap;
import java.util.Set;
import oracle.help.common.xml.XMLParseException;
import oracle.help.common.xml.XMLToken;

public class XMLNode {
    private XMLNode _parent;
    private XMLToken _token;
    private String _string;
    private XMLNode _firstChild;
    private XMLNode _lastChild;
    private XMLNode _previousSibling;
    private XMLNode _nextSibling;
    private int _lineNumber = 0;

    XMLNode() {
        this._parent = null;
        this._token = null;
    }

    XMLNode(XMLToken token, XMLNode parent) throws XMLParseException {
        this._parent = parent;
        this._token = token;
        this._firstChild = null;
        this._lastChild = null;
        this._previousSibling = null;
        this._nextSibling = null;
        if (this._token.getType() != 1) {
            throw new XMLParseException("Creating a node with a type that isn't OPEN_TAG");
        }
        this._parent._addChild(this);
    }

    public XMLNode getParent() {
        return this._parent;
    }

    public String getTokenValue() {
        return this._token.getTokenValue();
    }

    public HashMap getTokenProperties() {
        return this._token.getProperties();
    }

    public String getTokenProperty(String property) {
        if (this._token.getProperties() != null) {
            return (String)this._token.getProperties().get(property);
        }
        return null;
    }

    public String getString() {
        if (this._string != null) {
            return this._string.trim();
        }
        return null;
    }

    public void setString(String string) throws XMLParseException {
        if (this._string != null) {
            throw new XMLParseException("Setting a second string on a node. Old string: " + this._string + "  New string: " + string);
        }
        this._string = string;
    }

    public boolean tokenEquals(String string) {
        return this.getTokenValue().equalsIgnoreCase(string);
    }

    public XMLNode getFirstChild() {
        return this._firstChild;
    }

    public XMLNode getLastChild() {
        return this._lastChild;
    }

    public XMLNode getPreviousSibling() {
        return this._previousSibling;
    }

    public XMLNode getNextSibling() {
        return this._nextSibling;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setLineNumber(int num) {
        this._lineNumber = num;
    }

    public String toString() {
        String outString = super.toString() + ": Token is " + this._token + ", string is " + this._string;
        return outString;
    }

    public void print() {
        this._printTree("");
    }

    void _printTree(String indent) {
        if (this.getParent() != null) {
            System.out.print(indent + "<" + this.getTokenValue());
            HashMap properties = this.getTokenProperties();
            if (properties != null) {
                Set propSet = properties.keySet();
                for (String key : propSet) {
                    System.out.print(" " + key + "=\"" + properties.get(key) + "\"");
                }
            }
            System.out.print(">");
            if (this.getString() != null) {
                System.out.print(this.getString());
            }
            if (this.getFirstChild() != null) {
                System.out.println("");
                this.getFirstChild()._printTree(indent + "  ");
                System.out.println(indent + "</" + this.getTokenValue() + ">");
            } else {
                System.out.println("</" + this.getTokenValue() + ">");
            }
            if (this.getNextSibling() != null) {
                this.getNextSibling()._printTree(indent);
            }
        } else if (this.getFirstChild() != null) {
            this.getFirstChild()._printTree(indent);
        } else {
            System.out.println(indent + "EMPTY ROOT NODE");
        }
    }

    void _clearString() {
        this._string = null;
    }

    void _setTokenProperty(String name, String property) {
        HashMap<String, String> hash = this.getTokenProperties();
        if (hash == null) {
            XMLToken newToken;
            hash = new HashMap<String, String>(7);
            this._token = newToken = new XMLToken(this._token.getTokenValue(), this._token.getType(), hash);
        }
        hash.put(name, property);
    }

    private void _addChild(XMLNode newChild) {
        if (this._firstChild == null) {
            this._firstChild = this._lastChild = newChild;
        } else {
            this._lastChild._nextSibling = newChild;
            newChild._previousSibling = this._lastChild;
            this._lastChild = newChild;
        }
    }
}

