/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpset;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import oracle.help.common.AssociativeLink;
import oracle.help.common.TopicMap;
import oracle.help.common.View;
import oracle.help.common.WindowType;
import oracle.help.common.util.Canonicalizer;
import oracle.help.common.util.LocaleUtils;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSetParseException;
import oracle.help.library.helpset.HelpSetSection;
import oracle.help.library.helpset.XMLLinkParser;

public class HelpSet
implements Book {
    public static final String TAG_HELPSET = "helpset";
    public static final String TAG_TITLE = "title";
    public static final String TAG_HOMEID = "homeid";
    public static final String TAG_SUBHELPSET = "subhelpset";
    public static final String TAG_WINTYPE = "wintype";
    public static final String TAG_HEIGHT = "height";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_X = "x";
    public static final String TAG_Y = "y";
    public static final String TAG_TEXTFG = "textfg";
    public static final String TAG_LINKFG = "linkfg";
    public static final String TAG_BG = "bg";
    public static final String TAG_TOOLBAR = "toolbar";
    public static final String TAG_LINKS = "links";
    public static final String TAG_MAP = "maps";
    public static final String TAG_VIEW = "view";
    public static final String TAG_DATA = "data";
    public static final String TAG_KEY = "key";
    public static final String TAG_NAME = "name";
    public static final String TAG_TYPE = "type";
    public static final String TAG_MERGETYPE = "mergetype";
    public static final String TAG_LABEL = "label";
    public static final String TAG_MAPREF = "mapref";
    public static final String TAG_LINKREF = "linkref";
    public static final String PARAM_ID = "id";
    public static final String PARAM_URL = "url";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_DEFAULT = "default";
    public static final String PARAM_ENGINE = "engine";
    public static final String PARAM_ENGINEPARAMS = "engineParams";
    public static final String PARAM_LOCATION = "location";
    public static final String PARAM_IMAGE = "image";
    private ArrayList _helpSetSections = new ArrayList();
    private ArrayList _views = new ArrayList();
    private ArrayList _windowTypes = new ArrayList();
    private ArrayList _associativeLinks = null;
    private ArrayList _maps = new ArrayList();
    private Object _viewLock = new Object();
    private Object _mapLock = new Object();
    private Object _linkLock = new Object();
    private String _controlFileEncoding = null;
    private String _helpSetDir = null;
    private URL _fileURL = null;
    private String _homeID = null;
    private String _title = null;
    private static final String TYPE_JAVAHELP_TOC_NEW = "javax.help.TOCView";
    private static final String TYPE_JAVAHELP_TOC_OLD = "javax.javahelp.TOC";
    private static final String TYPE_JAVAHELP_KEYWORD_NEW = "javax.help.IndexView";
    private static final String TYPE_JAVAHELP_KEYWORD_OLD = "javax.javahelp.Index";
    private static final String TYPE_JAVAHELP_SEARCH_NEW = "javax.help.SearchView";
    private static final String TYPE_JAVAHELP_SEARCH_OLD = "javax.javahelp.Search";
    private static final String TYPE_DEFAULT_ORACLE_TOC = "oracle.help.navigator.tocNavigator.TOCNavigator";
    private static final String TYPE_DEFAULT_ORACLE_KEYWORD = "oracle.help.navigator.keywordNavigator.KeywordNavigator";
    private static final String TYPE_DEFAULT_ORACLE_SEARCH = "oracle.help.navigator.searchNavigator.SearchNavigator";
    private static final String ENGINE_ORACLE_HHC_OLD = "oracle.help.HHC";
    private static final String ENGINE_ORACLE_HHC_NEW = "oracle.help.engine.HHCEngine";
    private static final String ENGINE_ORACLE_TOC_OLD = "oracle.help.TOC";
    private static final String ENGINE_ORACLE_TOC_NEW = "oracle.help.engine.TOCEngine";
    private static final String ENGINE_ORACLE_XMLTOC_OLD = "oracle.help.XMLTOC";
    private static final String ENGINE_ORACLE_XMLTOC_NEW = "oracle.help.engine.XMLTOCEngine";
    private static final String ENGINE_JAVAHELP_TOC_OLD = "javax.javahelp.TOC";
    private static final String ENGINE_JAVAHELP_TOC_NEW = "oracle.help.engine.XMLTOCEngine";
    private static final String ENGINE_ORACLE_HHK_OLD = "oracle.help.HHK";
    private static final String ENGINE_ORACLE_HHK_NEW = "oracle.help.engine.HHKEngine";
    private static final String ENGINE_ORACLE_TOK_OLD = "oracle.help.TOK";
    private static final String ENGINE_ORACLE_TOK_NEW = "oracle.help.engine.TOKEngine";
    private static final String ENGINE_ORACLE_XMLINDEX_OLD = "oracle.help.XMLIndex";
    private static final String ENGINE_ORACLE_XMLINDEX_NEW = "oracle.help.engine.XMLIndexEngine";
    private static final String ENGINE_JAVAHELP_INDEX_OLD = "javax.javahelp.Index";
    private static final String ENGINE_JAVAHELP_INDEX_NEW = "oracle.help.engine.XMLIndexEngine";
    private static final String ENGINE_ORACLE_SEARCH_OLD = "oracle.help.Search";
    private static final String ENGINE_ORACLE_SEARCH_NEW = "oracle.help.engine.SearchEngine";
    private static final String ENGINE_ORACLE_XMLMAP_NEW = "oracle.help.engine.XMLMapEngine";
    private static final String ENGINE_ORACLE_XMLMAPCONVENTION_NEW = "oracle.help.engine.XMLMapConventionEngine";

    public HelpSet() {
    }

    public HelpSet(Class pathClass, String pathExtension) throws HelpSetParseException {
        this(pathClass, pathExtension, StaticLocaleContext.getEncoding());
    }

    public HelpSet(Class pathClass, String pathExtension, String helpDefaultEncoding) throws HelpSetParseException {
        this();
        URL aURL = null;
        pathExtension = Canonicalizer.fixSeparators(pathExtension);
        if (pathClass == null || pathExtension == null) {
            throw new HelpSetParseException("Invalid Parameters to HelpSet constructor");
        }
        try {
            aURL = pathClass.getResource(pathExtension);
        }
        catch (Exception e) {
            throw new HelpSetParseException("Exception encountered in HelpSet constructor" + e.getMessage(), e);
        }
        this._initHelpSet(aURL, helpDefaultEncoding);
    }

    public HelpSet(URL fileURL) throws HelpSetParseException {
        this(fileURL, StaticLocaleContext.getEncoding());
    }

    public HelpSet(URL fileURL, String helpDefaultEncoding) throws HelpSetParseException {
        this();
        this._initHelpSet(fileURL, helpDefaultEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL mapIDToURL(String id) {
        URL found = null;
        Object object = this._mapLock;
        synchronized (object) {
            if (this._maps.size() == 0) {
                this._createMaps();
            }
        }
        for (int i = 0; i < this._maps.size(); ++i) {
            try {
                TopicMap map = (TopicMap)this._maps.get(i);
                found = map.mapIDToURL(id);
                if (found == null) continue;
                return found;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String mapURLToWindowTypeName(URL url) {
        String found = null;
        Object object = this._mapLock;
        synchronized (object) {
            if (this._maps.size() == 0) {
                this._createMaps();
            }
        }
        for (int i = 0; i < this._maps.size(); ++i) {
            TopicMap map = (TopicMap)this._maps.get(i);
            found = map.mapURLToWindowTypeName(url);
            if (found == null) continue;
            return found;
        }
        return found;
    }

    @Override
    public String getBookTitle() {
        return this._title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public View[] getViewsByType(String type) {
        View[] theViews = null;
        ArrayList<View> thisType = new ArrayList<View>();
        if (type == null) {
            return null;
        }
        Object object = this._viewLock;
        synchronized (object) {
            this._createViewObjects(true, type);
            for (int iter = 0; iter < this._views.size(); ++iter) {
                View aView = (View)this._views.get(iter);
                if (!aView.getType().equals(type)) continue;
                thisType.add(aView);
            }
        }
        if (thisType.size() > 0) {
            theViews = new View[thisType.size()];
            thisType.toArray(theViews);
        }
        return theViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public View[] getAllViews() {
        View[] allViews = null;
        Object object = this._viewLock;
        synchronized (object) {
            this._createViewObjects(false, "");
            if (this._views.size() > 0) {
                allViews = new View[this._views.size()];
                this._views.toArray(allViews);
            }
        }
        return allViews;
    }

    @Override
    public WindowType[] getWindowTypes() {
        WindowType[] winArr = null;
        if (this._windowTypes.size() > 0) {
            winArr = new WindowType[this._windowTypes.size()];
            this._windowTypes.toArray(winArr);
        }
        return winArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociativeLink[] getAssociativeLinks() {
        AssociativeLink[] linkArr = null;
        Object object = this._linkLock;
        synchronized (object) {
            if (this._associativeLinks == null) {
                this._associativeLinks = new ArrayList();
                for (int iter = 0; iter < this._helpSetSections.size(); ++iter) {
                    HelpSetSection aSection = (HelpSetSection)this._helpSetSections.get(iter);
                    AssociativeLink[] parsedLinks = null;
                    if (!aSection.getIdentifier().equals(TAG_LINKS) || aSection.isCompleted()) continue;
                    try {
                        XMLLinkParser lParser = new XMLLinkParser();
                        parsedLinks = lParser.parseLinkFile(aSection.getDataLocationURL(), this._controlFileEncoding, this);
                    }
                    catch (Exception e) {
                        System.err.println("Unable to parse link file" + aSection.getDataLocationString());
                        e.printStackTrace();
                        parsedLinks = null;
                    }
                    aSection.setCompleted(true);
                    if (parsedLinks == null) continue;
                    for (int i = 0; i < parsedLinks.length; ++i) {
                        this._associativeLinks.add(parsedLinks[i]);
                    }
                }
            }
        }
        if (this._associativeLinks.size() > 0) {
            linkArr = new AssociativeLink[this._associativeLinks.size()];
            this._associativeLinks.toArray(linkArr);
        }
        return linkArr;
    }

    public HelpSetSection[] getHelpSetSections() {
        HelpSetSection[] sections = null;
        if (this._helpSetSections.size() > 0) {
            sections = new HelpSetSection[this._helpSetSections.size()];
            this._helpSetSections.toArray(sections);
        }
        return sections;
    }

    public void setHomeID(String homeID) {
        this._homeID = homeID;
    }

    public String getHomeID() {
        return this._homeID;
    }

    public String getHelpSetEncoding() {
        return this._controlFileEncoding;
    }

    private void _initHelpSet(URL fileURL, String helpDefaultEncoding) throws HelpSetParseException {
        this._fileURL = fileURL;
        this._helpSetDir = this._fileURL.toString();
        Canonicalizer.fixSeparators(this._helpSetDir);
        this._helpSetDir = this._helpSetDir.substring(0, this._helpSetDir.lastIndexOf(47) + 1);
        try {
            this._parseFile(this._fileURL, helpDefaultEncoding);
        }
        catch (Exception e) {
            throw new HelpSetParseException("Unknown error when parsing hs file: " + e.getMessage(), e);
        }
    }

    private void _parseFile(URL fileURL, String helpDefaultEncoding) throws HelpSetParseException {
        this._controlFileEncoding = LocaleUtils.determineHelpSetEncoding(fileURL);
        if (this._controlFileEncoding == null) {
            this._controlFileEncoding = helpDefaultEncoding;
        }
        InputStreamReader reader = null;
        try {
            reader = LocaleUtils.createInputStreamReader(fileURL.openStream(), this._controlFileEncoding);
            Parser parser = ParserFactory.createParser(reader, fileURL.toExternalForm());
            XMLNode root = parser.getRoot();
            this._handleHelpset(root.getFirstChild());
        }
        catch (XMLParseException xmlE) {
            throw new HelpSetParseException(xmlE.getMessage(), xmlE);
        }
        catch (IOException ioE) {
            throw new HelpSetParseException("Unexpected IOException opening helpset file: " + fileURL.toExternalForm(), ioE);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void _handleHelpset(XMLNode node) throws HelpSetParseException {
        if (node == null) {
            throw new HelpSetParseException("No toplevel tag in helpset file");
        }
        if (!node.tokenEquals(TAG_HELPSET)) {
            throw new HelpSetParseException("Toplevel tag is not <helpset>");
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.tokenEquals(TAG_TITLE)) {
                this._handleTitle(node);
                continue;
            }
            if (node.tokenEquals(TAG_WINTYPE)) {
                this._handleWinType(node);
                continue;
            }
            if (node.tokenEquals(TAG_LINKS)) {
                this._handleLinkSection(node);
                continue;
            }
            if (node.tokenEquals(TAG_MAP)) {
                this._handleMap(node);
                continue;
            }
            if (node.tokenEquals(TAG_SUBHELPSET)) {
                this._handleSubhelpset(node);
                continue;
            }
            if (node.tokenEquals(TAG_VIEW)) {
                this._handleView(node);
                continue;
            }
            throw new HelpSetParseException("Unknown tag under helpset " + node.getTokenValue());
        }
    }

    private void _handleTitle(XMLNode node) throws HelpSetParseException {
        String title = node.getString();
        if (title != null) {
            this._title = title;
        }
    }

    private void _handleHomeID(XMLNode node) throws HelpSetParseException {
        String homeID = node.getString();
        this.setHomeID(homeID);
    }

    private void _handleSubhelpset(XMLNode node) throws HelpSetParseException {
        HelpSetSection subHelpSet = new HelpSetSection(this, this._helpSetDir);
        subHelpSet.setIdentifier(TAG_SUBHELPSET);
        URL subData = null;
        subHelpSet.setDataLocationString(node.getTokenProperty(PARAM_LOCATION));
        subHelpSet.setClassAttribute(node.getTokenProperty(PARAM_CLASS));
        this._helpSetSections.add(subHelpSet);
        try {
            subData = subHelpSet.getDataLocationURL();
            subData.openStream().close();
        }
        catch (Exception e) {
            subData = null;
        }
        HelpSet subHelp = null;
        if (subData != null) {
            try {
                subHelp = new HelpSet(subData, this._controlFileEncoding);
            }
            catch (Exception e) {
                throw new HelpSetParseException("Error parsing subhelpset " + e.getMessage(), e);
            }
        }
        if (subHelp != null) {
            int iter;
            for (iter = 0; iter < subHelp._helpSetSections.size(); ++iter) {
                this._helpSetSections.add(subHelp._helpSetSections.get(iter));
            }
            for (iter = 0; iter < subHelp._windowTypes.size(); ++iter) {
                this._windowTypes.add(subHelp._windowTypes.get(iter));
            }
        }
    }

    private void _handleMap(XMLNode node) throws HelpSetParseException {
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.tokenEquals(TAG_MAPREF)) {
                HelpSetSection mapSection = new HelpSetSection(this, this._helpSetDir);
                mapSection.setIdentifier(TAG_MAP);
                String dataLocationString = node.getTokenProperty(PARAM_LOCATION);
                if (dataLocationString == null) {
                    dataLocationString = "fakeFile";
                }
                mapSection.setDataLocationString(dataLocationString);
                mapSection.setClassAttribute(node.getTokenProperty(PARAM_CLASS));
                String mapEngine = node.getTokenProperty(PARAM_ENGINE);
                if (mapEngine == null) {
                    mapEngine = ENGINE_ORACLE_XMLMAP_NEW;
                }
                mapSection.setEngineClass(mapEngine);
                String mapEngineParams = node.getTokenProperty(PARAM_ENGINEPARAMS);
                mapSection.setEngineParams(mapEngineParams);
                try {
                    URL uRL = mapSection.getDataLocationURL();
                }
                catch (Exception e) {
                    throw new HelpSetParseException("Unable to build url to mapfile" + e.getMessage(), e);
                }
                this._helpSetSections.add(mapSection);
                continue;
            }
            if (node.tokenEquals(TAG_HOMEID)) {
                this._handleHomeID(node);
                continue;
            }
            throw new HelpSetParseException("Unknown tag in map: " + node.getTokenValue());
        }
    }

    private void _handleView(XMLNode node) throws HelpSetParseException {
        HelpSetSection viewSection = new HelpSetSection(this, this._helpSetDir);
        viewSection.setIdentifier(TAG_VIEW);
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            String token = node.getTokenValue();
            if (token.equalsIgnoreCase(TAG_LABEL)) {
                viewSection.setViewLabel(node.getString());
                if (node.getTokenProperty(PARAM_IMAGE) == null) continue;
                viewSection.setLabelImageString(node.getTokenProperty(PARAM_IMAGE));
                continue;
            }
            if (token.equalsIgnoreCase(TAG_NAME)) {
                viewSection.setViewName(node.getString());
                continue;
            }
            if (token.equalsIgnoreCase(TAG_TITLE)) {
                viewSection.setViewTitle(node.getString());
                if (node.getTokenProperty(PARAM_IMAGE) == null) continue;
                viewSection.setTitleImageString(node.getTokenProperty(PARAM_IMAGE));
                continue;
            }
            if (token.equalsIgnoreCase("type")) {
                viewSection.setTypeClass(node.getString());
                continue;
            }
            if (token.equalsIgnoreCase(TAG_DATA)) {
                viewSection.setEngineClass(node.getTokenProperty(PARAM_ENGINE));
                viewSection.setDataLocationString(node.getString());
                viewSection.setClassAttribute(node.getTokenProperty(PARAM_CLASS));
                continue;
            }
            if (!token.equalsIgnoreCase(TAG_MERGETYPE)) continue;
        }
        viewSection.setTypeClass(this._checkTypeBackwardCompatibility(viewSection.getTypeClass()));
        viewSection.setEngineClass(this._checkEngineBackwardCompatibility(viewSection.getTypeClass(), viewSection.getEngineClass()));
        URL viewData = viewSection.getDataLocationURL();
        if (viewSection.getEngineClass() == null || viewSection.getTypeClass() == null || viewData == null) {
            throw new HelpSetParseException("Missing necessary data in view");
        }
        this._helpSetSections.add(viewSection);
    }

    private void _handleWinType(XMLNode node) throws HelpSetParseException {
        WindowType winType = new WindowType(this);
        String defaultProp = node.getTokenProperty(PARAM_DEFAULT);
        if (defaultProp != null && defaultProp.equalsIgnoreCase("true")) {
            winType.setDefault(true);
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.tokenEquals(TAG_NAME)) {
                winType.setName(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_HEIGHT)) {
                winType.setHeight(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_WIDTH)) {
                winType.setWidth(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_X)) {
                winType.setX(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_Y)) {
                winType.setY(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_TEXTFG)) {
                winType.setTextFG(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_LINKFG)) {
                winType.setLinkFG(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_BG)) {
                winType.setPageBG(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_TITLE)) {
                winType.setTitle(node.getString());
                continue;
            }
            if (node.tokenEquals(TAG_TOOLBAR)) {
                winType.setToolbar(node.getString());
                continue;
            }
            throw new HelpSetParseException("Unknown tag in wintype: " + node.getTokenValue());
        }
        if (winType.getName() != null) {
            this._windowTypes.add(winType);
        }
    }

    private void _handleLinkSection(XMLNode node) throws HelpSetParseException {
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.tokenEquals(TAG_LINKREF)) {
                throw new HelpSetParseException("Unknown tag in link: " + node.getTokenValue());
            }
            HelpSetSection linkSection = new HelpSetSection(this, this._helpSetDir);
            linkSection.setIdentifier(TAG_LINKS);
            linkSection.setDataLocationString(node.getTokenProperty(PARAM_LOCATION));
            linkSection.setClassAttribute(node.getTokenProperty(PARAM_CLASS));
            try {
                URL uRL = linkSection.getDataLocationURL();
            }
            catch (Exception e) {
                throw new HelpSetParseException("Error parsing link section" + e.getMessage(), e);
            }
            this._helpSetSections.add(linkSection);
        }
    }

    private String _checkTypeBackwardCompatibility(String type) {
        if (type != null) {
            if (type.equals(TYPE_JAVAHELP_TOC_NEW) || type.equals("javax.javahelp.TOC")) {
                type = TYPE_DEFAULT_ORACLE_TOC;
            } else if (type.equals(TYPE_JAVAHELP_KEYWORD_NEW) || type.equals("javax.javahelp.Index")) {
                type = TYPE_DEFAULT_ORACLE_KEYWORD;
            } else if (type.equals(TYPE_JAVAHELP_SEARCH_NEW) || type.equals(TYPE_JAVAHELP_SEARCH_OLD)) {
                type = TYPE_DEFAULT_ORACLE_SEARCH;
            }
        }
        return type;
    }

    private String _checkEngineBackwardCompatibility(String type, String engine) {
        if (type != null) {
            if (type.equals(TYPE_DEFAULT_ORACLE_TOC)) {
                if (engine != null) {
                    if (engine.equals(ENGINE_ORACLE_HHC_OLD)) {
                        engine = ENGINE_ORACLE_HHC_NEW;
                    } else if (engine.equals(ENGINE_ORACLE_TOC_OLD)) {
                        engine = ENGINE_ORACLE_TOC_NEW;
                    } else if (engine.equals(ENGINE_ORACLE_XMLTOC_OLD)) {
                        engine = "oracle.help.engine.XMLTOCEngine";
                    } else if (engine.equals("javax.javahelp.TOC")) {
                        engine = "oracle.help.engine.XMLTOCEngine";
                    }
                } else {
                    engine = "oracle.help.engine.XMLTOCEngine";
                }
            } else if (type.equals(TYPE_DEFAULT_ORACLE_KEYWORD)) {
                if (engine != null) {
                    if (engine.equals(ENGINE_ORACLE_HHK_OLD)) {
                        engine = ENGINE_ORACLE_HHK_NEW;
                    } else if (engine.equals(ENGINE_ORACLE_TOK_OLD)) {
                        engine = ENGINE_ORACLE_TOK_NEW;
                    } else if (engine.equals(ENGINE_ORACLE_XMLINDEX_OLD)) {
                        engine = "oracle.help.engine.XMLIndexEngine";
                    } else if (engine.equals("javax.javahelp.Index")) {
                        engine = "oracle.help.engine.XMLIndexEngine";
                    }
                } else {
                    engine = "oracle.help.engine.XMLIndexEngine";
                }
            } else if (type.equals(TYPE_DEFAULT_ORACLE_SEARCH)) {
                if (engine != null) {
                    if (engine.equals(ENGINE_ORACLE_SEARCH_OLD)) {
                        engine = ENGINE_ORACLE_SEARCH_NEW;
                    }
                } else {
                    engine = ENGINE_ORACLE_SEARCH_NEW;
                }
            }
        }
        return engine;
    }

    private void _createViewObjects(boolean byType, String type) {
        if (byType && type == null) {
            return;
        }
        for (int iter = 0; iter < this._helpSetSections.size(); ++iter) {
            HelpSetSection aSection = (HelpSetSection)this._helpSetSections.get(iter);
            if (!aSection.getIdentifier().equals(TAG_VIEW) || byType && !aSection.getTypeClass().equals(type) || aSection.isCompleted()) continue;
            View theView = null;
            DataEngine engine = null;
            try {
                Class<?> eClass = Class.forName(aSection.getEngineClass());
                if (eClass != null) {
                    engine = (DataEngine)eClass.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not find specified engine class.  Make sure " + aSection.getEngineClass() + "is on your class path.");
            }
            catch (ClassCastException e2) {
                System.err.println("Specified engine " + aSection.getEngineClass() + " not a subclass of oracle.help.engine.DataEngine");
            }
            catch (Exception e3) {
                System.err.println("Unable to create specified engine " + aSection.getEngineClass());
            }
            if (engine != null) {
                try {
                    theView = new View(this, aSection.getViewBasePath(), aSection.getTypeClass(), engine, aSection.getDataLocationURL(), aSection.getHelpSetEncoding(), aSection.getViewTitle(), aSection.getViewLabel(), aSection.getViewName());
                    theView.setTitleImage(aSection.getTitleImageTarget());
                    theView.setLabelImage(aSection.getLabelImageTarget());
                    this._views.add(theView);
                }
                catch (Exception viewE) {
                    theView = null;
                    System.err.println("Exception encountered while creating View Object" + viewE);
                }
            }
            aSection.setCompleted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMaps() {
        Object object = this._mapLock;
        synchronized (object) {
            if (this._maps.size() == 0) {
                this._createMaps();
            }
        }
    }

    private void _createMaps() {
        for (int iter = 0; iter < this._helpSetSections.size(); ++iter) {
            HelpSetSection aSection = (HelpSetSection)this._helpSetSections.get(iter);
            if (!aSection.getIdentifier().equals(TAG_MAP) || aSection.isCompleted()) continue;
            DataEngine engine = null;
            try {
                Class<?> eClass = Class.forName(aSection.getEngineClass());
                if (eClass != null) {
                    engine = (DataEngine)eClass.newInstance();
                    URL url = aSection.getDataLocationURL();
                    String engineParams = aSection.getEngineParams();
                    this._maps.add(engine.createDataObject(null, null, url, this._controlFileEncoding, engineParams));
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not find specified engine class.  Make sure " + aSection.getEngineClass() + "is on your class path.");
            }
            catch (ClassCastException e2) {
                System.err.println("Specified engine " + aSection.getEngineClass() + " not a subclass of oracle.help.engine.DataEngine");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (HelpSetParseException hspe) {
                hspe.printStackTrace();
            }
            catch (Exception e3) {
                e3.printStackTrace();
                System.err.println("Unable to create specified engine " + aSection.getEngineClass());
            }
            aSection.setCompleted(true);
        }
    }
}

