/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MyXmlPullApp {
    public static final String SAMPLE_XML = "<?xml version=\"1.0\"?>\n\n<poem xmlns=\"http://www.megginson.com/ns/exp/poetry\">\n<title>Roses are Red</title>\n<l>Roses are red,</l>\n<l>Violets are blue;</l>\n<l>Sugar is sweet,</l>\n<l>And I love you.</l>\n</poem>";
    int[] holderForStartAndLength = new int[2];

    public static void main(String[] stringArray) throws XmlPullParserException, IOException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        xmlPullParserFactory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        System.out.println("parser implementation class is " + xmlPullParser.getClass());
        MyXmlPullApp myXmlPullApp = new MyXmlPullApp();
        if (stringArray.length == 0) {
            System.out.println("Parsing simple sample XML");
            xmlPullParser.setInput(new StringReader(SAMPLE_XML));
            myXmlPullApp.processDocument(xmlPullParser);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("Parsing file: " + stringArray[i]);
                xmlPullParser.setInput(new FileReader(stringArray[i]));
                myXmlPullApp.processDocument(xmlPullParser);
            }
        }
    }

    public void processDocument(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getEventType();
        do {
            if (n == 0) {
                System.out.println("Start document");
                continue;
            }
            if (n == 1) {
                System.out.println("End document");
                continue;
            }
            if (n == 2) {
                this.processStartElement(xmlPullParser);
                continue;
            }
            if (n == 3) {
                this.processEndElement(xmlPullParser);
                continue;
            }
            if (n != 4) continue;
            this.processText(xmlPullParser);
        } while ((n = xmlPullParser.next()) != 1);
    }

    public void processStartElement(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getName();
        String string2 = xmlPullParser.getNamespace();
        if ("".equals(string2)) {
            System.out.println("Start element: " + string);
        } else {
            System.out.println("Start element: {" + string2 + "}" + string);
        }
    }

    public void processEndElement(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getName();
        String string2 = xmlPullParser.getNamespace();
        if ("".equals(string2)) {
            System.out.println("End element: " + string);
        } else {
            System.out.println("End element:   {" + string2 + "}" + string);
        }
    }

    public void processText(XmlPullParser xmlPullParser) throws XmlPullParserException {
        char[] cArray = xmlPullParser.getTextCharacters(this.holderForStartAndLength);
        int n = this.holderForStartAndLength[0];
        int n2 = this.holderForStartAndLength[1];
        System.out.print("Characters:    \"");
        block7: for (int i = n; i < n + n2; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    System.out.print("\\\\");
                    continue block7;
                }
                case '\"': {
                    System.out.print("\\\"");
                    continue block7;
                }
                case '\n': {
                    System.out.print("\\n");
                    continue block7;
                }
                case '\r': {
                    System.out.print("\\r");
                    continue block7;
                }
                case '\t': {
                    System.out.print("\\t");
                    continue block7;
                }
                default: {
                    System.out.print(cArray[i]);
                }
            }
        }
        System.out.print("\"\n");
    }
}

