/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.deploy.ArchiveEntry;

public class ArchiveEntryFactory {
    private final List _packets;
    private Logger _logger = Logger.getLogger(ArchiveEntryFactory.class.getName());

    public ArchiveEntryFactory() {
        this(null);
    }

    public ArchiveEntryFactory(List packets) {
        this._packets = packets != null ? packets : new ArrayList();
    }

    public List getPackets() {
        return this._packets;
    }

    public void recurseInDirectory(URL dir) {
        if (dir != null) {
            this.recurseInDirectory("", dir);
        }
    }

    public void recurseInPath(URLPath path) {
        this.recurseInDirectories(path.getEntries());
    }

    public void recurseInDirectories(URL[] dirs) {
        if (dirs != null) {
            int n = dirs.length;
            for (int i = 0; i < n; ++i) {
                this.recurseInDirectory("", dirs[i]);
            }
        }
    }

    public void recurseInDirectory(String prefix, URL dir) {
        if (dir == null) {
            return;
        }
        long begin = System.currentTimeMillis();
        if (prefix == null) {
            prefix = "";
        }
        if (this.shouldRecurseInto(dir)) {
            if (!dir.getPath().endsWith("/")) {
                dir = URLFactory.newDirURL((URL)dir, (String)"/");
            }
            long startLs = System.currentTimeMillis();
            URLFileSystem.FileInfo[] list = URLFileSystem.ls((URL)dir);
            long lsElapsed = System.currentTimeMillis() - startLs;
            if (lsElapsed > 100L) {
                this._logger.log(Level.FINE, String.format("Slow file system: %s (%d)\n", dir, lsElapsed));
            }
            if (list != null) {
                for (int i = list.length - 1; i >= 0; --i) {
                    String name;
                    URLFileSystem.FileInfo childFileInfo = list[i];
                    URL childURL = childFileInfo.getURL();
                    if (childFileInfo.isDirectory()) {
                        name = URLFileSystem.getFileName((URL)childURL);
                        String newPrefix = prefix + name + "/";
                        this.recurseInDirectory(newPrefix, childURL);
                        continue;
                    }
                    if (!this.shouldAdd(childURL)) continue;
                    name = URLFileSystem.getFileName((URL)childURL);
                    ArchiveEntry packet = this.newArchiveEntry(prefix + name, childURL);
                    this.add(packet);
                }
            }
            long elapsed = System.currentTimeMillis() - begin;
            this._logger.log(Level.FINEST, String.format("%d %s %s\n", elapsed, "ArchiveEntryFactory.recurseInDirectory", dir));
        }
    }

    protected ArchiveEntry newArchiveEntry(String name, URL url) {
        return new ArchiveEntry(name, url);
    }

    public static ArchiveEntry[] toArray(Collection archiveEntries) {
        Iterator iter = archiveEntries.iterator();
        int n = archiveEntries.size();
        ArchiveEntry[] entries = new ArchiveEntry[n];
        int i = 0;
        while (iter.hasNext()) {
            try {
                while (iter.hasNext()) {
                    ArchiveEntry entry = (ArchiveEntry)iter.next();
                    if (entry == null) continue;
                    entries[i++] = entry;
                }
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        if (i != n) {
            ArchiveEntry[] entries2 = new ArchiveEntry[i];
            System.arraycopy(entries, 0, entries2, 0, i);
            return entries2;
        }
        return entries;
    }

    protected boolean shouldRecurseInto(URL url) {
        return true;
    }

    protected boolean shouldAdd(URL url) {
        return true;
    }

    protected void add(ArchiveEntry packet) {
        this._packets.add(packet);
    }
}

