/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.HashMap;
import oracle.jdeveloper.deploy.StateException;
import oracle.jdeveloper.deploy.Stateful;
import oracle.jdeveloper.deploy.common.CompositeState;

public class DefaultCompositeState
implements CompositeState {
    private HashMap<Object, Stateful> childStates_ = new HashMap();
    private volatile boolean initialized = false;
    private volatile boolean released = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stateful get(Object key) {
        Object object = this.stateLockObject();
        synchronized (object) {
            return this.childStates_.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stateful put(Object key, Stateful state) {
        Object object = this.stateLockObject();
        synchronized (object) {
            return this.childStates_.put(key, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stateful remove(Object key) {
        Object object = this.stateLockObject();
        synchronized (object) {
            return this.childStates_.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseState() {
        assert (this.childStates_ != null);
        if (this.released) {
            throw new StateException("State already released");
        }
        Object object = this.stateLockObject();
        synchronized (object) {
            for (Stateful state : this.childStates_.values()) {
                state.releaseState();
            }
            this.childStates_.clear();
            this.released = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateState() {
        Object object = this.stateLockObject();
        synchronized (object) {
            assert (this.childStates_ != null);
            for (Stateful state : this.childStates_.values()) {
                state.invalidateState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeState() {
        Object object = this.stateLockObject();
        synchronized (object) {
            if (this.initialized) {
                throw new StateException("State already initialized");
            }
            for (Stateful state : this.childStates_.values()) {
                state.initializeState();
            }
            this.initialized = true;
        }
    }

    protected Object stateLockObject() {
        return this;
    }
}

