/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta;

import javax.swing.Icon;
import oracle.ide.model.Displayable;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.meta.PlatformRegistry;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.meta.PlatformVersion;

public class Platform
implements Displayable,
Comparable {
    private PlatformType type_;
    private PlatformVersion version_;
    private String longLabel_;
    private String shortLabel_;
    private Icon icon_;
    private static final String PLATFORM_TYPE = "Platform.platformType";
    private static final String PLATFORM_VERSION = "Platform.platformVersion";

    public Platform(PlatformType type, PlatformVersion version, String longLabel, String shortLabel, Icon icon) {
        this.type_ = type;
        this.version_ = version;
        this.longLabel_ = longLabel;
        this.shortLabel_ = shortLabel;
        this.icon_ = icon;
    }

    public Platform(PlatformType type, PlatformVersion version, String longLabel, String shortLabel) {
        this(type, version, longLabel, shortLabel, null);
    }

    public Platform(PlatformType type, String version, String longLabel, String shortLabel) {
        this(type, new PlatformVersion(version), longLabel, shortLabel);
    }

    public Platform(PlatformType type, PlatformVersion version) {
        this(type, version, null, null, null);
    }

    public Platform(PlatformType type, String version) {
        this(type, new PlatformVersion(version));
    }

    public static HashStructure toHashStructure(Platform platform) {
        HashStructure hash = HashStructure.newInstance();
        hash.putString(PLATFORM_TYPE, platform.getType().name());
        hash.putString(PLATFORM_VERSION, platform.getVersion().toCanonicalString());
        return hash;
    }

    public static Platform fromHashStructure(HashStructure hash) {
        PlatformType type = PlatformType.valueOf(hash.getString(PLATFORM_TYPE));
        String version = hash.getString(PLATFORM_VERSION);
        try {
            return PlatformRegistry.getPlatform(type, version);
        }
        catch (Exception e) {
            try {
                return new Platform(type, version);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Not a Platform HashStructure", e);
            }
        }
    }

    public PlatformVersion getVersion() {
        return this.version_;
    }

    public PlatformType getType() {
        return this.type_;
    }

    public boolean supports(Platform other, Object[] features) {
        if (other == null) {
            return false;
        }
        if (features == null) {
            return this.type_.isExtensionOf(other.getType());
        }
        Assert.println((String)"Specific feature checks not implemented yet");
        return false;
    }

    public String toString() {
        return this.getLongLabel();
    }

    public String getShortLabel() {
        return this.shortLabel_ != null ? this.shortLabel_ : this.type_.getDisplayable().getShortLabel() + " " + this.version_.toCanonicalString();
    }

    public String getLongLabel() {
        return this.longLabel_ != null ? this.longLabel_ : this.type_.getDisplayable().getLongLabel() + " " + this.version_.toCanonicalString();
    }

    public Icon getIcon() {
        return this.icon_ != null ? this.icon_ : this.type_.getDisplayable().getIcon();
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Platform)) {
            return false;
        }
        Platform other = (Platform)o;
        return this.type_.equals(other.type_) && this.version_.equals((Object)other.version_);
    }

    public int hashCode() {
        return this.type_.hashCode() ^ this.version_.hashCode();
    }

    public int compareTo(Object o) {
        Platform other = (Platform)o;
        return this.type_.compareTo(other.type_);
    }
}

