/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.ProfileStorage;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.HashProfileReader;
import oracle.jdeveloper.deploy.spi.HashProfileWriter;
import oracle.jdeveloper.deploy.spi.providers.AbstractProfileIOProvider;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class LegacyProfileIOProvider
extends AbstractProfileIOProvider {
    static final String LEGACY_DATA_KEY = "oracle.jdeveloper.deploy.dt.DeploymentProfiles";
    static final String LEGACY_PROFILE_DEFINITIONS = "profileDefinitions";
    static final String LEGACY_PROFILE_LIST = "profileList";

    HashStructure getHashStructure(Element element) {
        HashStructure possibleHash = null;
        if (element instanceof ProfileStorage) {
            ProfileStorage ps = (ProfileStorage)element;
            possibleHash = ps.getProperties();
        } else if (element instanceof PropertyStorage) {
            PropertyStorage ps = (PropertyStorage)element;
            possibleHash = ps.getProperties();
        }
        return possibleHash;
    }

    synchronized HashStructure getDeploymentProfiles(Element element, boolean create) {
        HashStructure hash = this.getHashStructure(element);
        if (create) {
            return hash.getOrCreateHashStructure(LEGACY_DATA_KEY);
        }
        return hash.getHashStructure(LEGACY_DATA_KEY);
    }

    synchronized HashStructure getProfileDefinitions(Element element, boolean create) {
        HashStructure hash = this.getDeploymentProfiles(element, create);
        if (hash == null) {
            return null;
        }
        if (create) {
            return hash.getOrCreateHashStructure(LEGACY_PROFILE_DEFINITIONS);
        }
        return hash.getHashStructure(LEGACY_PROFILE_DEFINITIONS);
    }

    synchronized ListStructure getProfilesList(Element element, boolean create) {
        HashStructure hash = this.getDeploymentProfiles(element, create);
        if (hash == null) {
            return null;
        }
        if (create) {
            return hash.getOrCreateListStructure(LEGACY_PROFILE_LIST);
        }
        return hash.getListStructure(LEGACY_PROFILE_LIST);
    }

    @Override
    protected boolean canRead(Element element, ToolkitContext context, Cookie cookie) {
        if (this.getHashStructure(element) != null) {
            cookie.bind(Context.class, context.getIdeContext());
            return true;
        }
        return false;
    }

    @Override
    protected boolean canWrite(Element element, ToolkitContext context, Cookie cookie) {
        if (this.getHashStructure(element) != null) {
            cookie.bind(Context.class, context.getIdeContext());
            return true;
        }
        return false;
    }

    @Override
    protected Iterator<Profile> iterator(Element element, Cookie cookie) {
        HashStructure hash = this.getProfileDefinitions(element, false);
        if (hash == null) {
            return Collections.emptyList().iterator();
        }
        Context context = cookie.get(Context.class);
        return new ProfileIterator(new HashProfileReaderIterator(hash, element, context));
    }

    @Override
    protected List<Profile> getAllProfiles(Element element, Cookie cookie) {
        ArrayList<Profile> list = new ArrayList<Profile>();
        Iterator<Profile> iter = this.iterator(element, cookie);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    @Override
    protected Profile getProfileByName(String name, Element element, Cookie cookie) {
        HashStructure hash = this.getProfileDefinitions(element, false);
        if (hash == null) {
            return null;
        }
        Context context = cookie.get(Context.class);
        HashProfileReaderIterator iter = new HashProfileReaderIterator(hash, element, context);
        while (iter.hasNext()) {
            HashProfileReader reader = (HashProfileReader)iter.next();
            if (!name.equals(reader.getName())) continue;
            return reader.read();
        }
        return null;
    }

    @Override
    protected Set<String> getProfileNames(Element element, Cookie cookie) {
        HashStructure hash = this.getProfileDefinitions(element, false);
        TreeSet<String> set = new TreeSet<String>();
        if (hash == null) {
            return set;
        }
        for (String name : hash.keySet()) {
            set.add(name);
        }
        return set;
    }

    @Override
    protected boolean remove(Profile profile, Element element, Cookie cookie) {
        Iterator<Profile> iter = this.iterator(element, cookie);
        while (iter.hasNext()) {
            Profile p = iter.next();
            if (!profile.equals(p)) continue;
            this.removeFromHash(element, p.getName());
            return true;
        }
        return false;
    }

    @Override
    protected void removeAll(Element element, Cookie cookie) {
        List<Profile> allProfiles = this.getAllProfiles(element, cookie);
        ArrayList<String> profileNames = new ArrayList<String>();
        for (Profile p : allProfiles) {
            profileNames.add(p.getName());
        }
        for (String name : profileNames) {
            this.removeFromHash(element, name);
        }
    }

    @Override
    protected boolean removeByName(String name, Element element, Cookie cookie) {
        Set<String> names = this.getProfileNames(element, cookie);
        if (names.contains(name)) {
            this.removeFromHash(element, name);
            return true;
        }
        return false;
    }

    private void removeFromHash(Element element, String key) {
        HashStructure defn = this.getProfileDefinitions(element, false);
        ListStructure list = this.getProfilesList(element, false);
        assert (defn == null || defn != null && list != null);
        if (defn == null) {
            return;
        }
        defn.remove(key);
        list.remove((Object)key);
    }

    @Override
    protected boolean write(Profile profile, Element element, Cookie cookie) {
        Context ideContext = cookie.get(Context.class);
        HashProfileWriter.SpiData spi = HashProfileWriter.SpiData.getInstance(ideContext);
        spi.setProfile(profile);
        ToolkitRegistry reg = ToolkitRegistry.getInstance();
        ToolkitBuilder builder = reg.getBuilder(element, ideContext, HashProfileWriter.class);
        HashProfileWriter writer = (HashProfileWriter)builder.narrowBuildToolkits()[0];
        HashStructure hash = HashStructure.newInstance();
        writer.write(hash);
        String key = profile.getName();
        HashStructure defn = this.getProfileDefinitions(element, true);
        defn.putHashStructure(key, hash);
        ListStructure list = this.getProfilesList(element, true);
        list.add((Object)key);
        return true;
    }

    static class NameIterator
    implements Iterator<String> {
        final Iterator<HashProfileReader> iter;

        NameIterator(Iterator<HashProfileReader> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            return this.iter.next().getName();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ProfileIterator
    implements Iterator<Profile> {
        final Iterator<HashProfileReader> iter;

        ProfileIterator(Iterator<HashProfileReader> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Profile next() {
            return this.iter.next().read();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    static class HashProfileReaderIterator
    implements ToolkitFactory,
    Iterator<HashProfileReader> {
        final Iterator<String> iter;
        final HashStructure profileDefinitions;
        final Element element;
        final Context ideContext;
        HashProfileReader lastReader = null;
        String lastName = null;

        HashProfileReaderIterator(HashStructure profileDefinitions, Element element, Context ideContext) {
            assert (profileDefinitions != null);
            this.profileDefinitions = profileDefinitions;
            this.iter = profileDefinitions.keySet().iterator();
            this.element = element;
            this.ideContext = ideContext;
        }

        @Override
        public boolean hasNext() {
            while (this.lastReader == null && this.iter.hasNext()) {
                this.lastName = this.iter.next();
                this.lastReader = this.getReader(this.lastName);
            }
            return this.lastReader != null;
        }

        @Override
        public HashProfileReader next() {
            HashProfileReader ret = this.lastReader;
            this.lastReader = null;
            return ret;
        }

        @Override
        public void remove() {
            this.iter.remove();
            this.profileDefinitions.remove(this.lastName);
        }

        private HashProfileReader getReader(String name) {
            HashStructure hash = this.profileDefinitions.getHashStructure(name);
            Context context = new Context(this.ideContext);
            HashProfileReader.SpiData spi = HashProfileReader.SpiData.getInstance(context);
            spi.setHashStructure(hash);
            HashProfileReader reader = ToolkitFactory.Utils.narrowBuildFirstOrNull(this.element, context, HashProfileReader.class);
            return reader;
        }
    }
}

