/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi.profilesupport;

import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.ProfileFactory;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileFactory;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileInfo;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileSupport;
import oracle.jdeveloper.deploy.spi.providers.AbstractProfileFactoryProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.spi.profilesupport.PS;

public final class PSProfileFactoryProvider
extends AbstractProfileFactoryProvider {
    final PS ps;
    ProfileFactory factory = null;

    PSProfileFactoryProvider(MetaClass<ProfileSupport> profileSupportClass) {
        this.ps = new PS(profileSupportClass);
    }

    PSProfileFactoryProvider(ProfileSupport profileSupport) {
        this.ps = new PS(profileSupport);
    }

    private synchronized ProfileFactory getFactory() {
        if (this.factory == null) {
            ProfileSupport support = this.ps.getProfileSupport();
            this.factory = support.getProfileFactory();
            assert (this.factory != null);
        }
        return this.factory;
    }

    @Override
    protected boolean canCreate(ToolkitContext tkContext, Cookie cookie) {
        Context context = tkContext.getIdeContext();
        ProfileFactory.SpiData spi = ProfileFactory.SpiData.getInstance(context);
        DataContainer dataContainer = spi.getDataContainer();
        String requestedId = spi.getProfileId();
        ProfileInfo info = this.ps.getProfileInfo();
        if (info == null) {
            return false;
        }
        if (requestedId != null) {
            return requestedId.equals(info.getId());
        }
        Class<? extends Profile> profileClass = spi.getProfileClass();
        if (profileClass == null || !profileClass.getName().equals(info.getProfileClassName()) || profileClass != this.ps.getProfileClass()) {
            return false;
        }
        ProfileFactory factory = this.getFactory();
        if (factory == null) {
            return false;
        }
        cookie.bind(ProfileFactory.class, factory);
        cookie.bind(DataContainer.class, dataContainer);
        cookie.bind(Context.class, tkContext.getIdeContext());
        return true;
    }

    @Override
    protected Profile createProfile(String name, Cookie cookie) {
        ProfileFactory factory = cookie.get(ProfileFactory.class);
        Context ctx = cookie.get(Context.class);
        DataContainer dc = cookie.get(DataContainer.class);
        assert (factory != null);
        assert (dc != null);
        assert (ctx != null);
        return factory.create(name, dc, ctx);
    }
}

