/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.localesource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.servlet.ServletHelper;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.text.OraCollator;
import oracle.i18n.text.OraDecimalFormat;
import oracle.i18n.text.OraDecimalFormatSymbols;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;

public class DBLocaleSource
extends LocaleSource {
    public static final Class OBJECT_KEY = DBLocaleSource.class;
    private static final String M_C_DIAGNOSTICS_LEVEL = "diagnostics-level";
    private static final String M_C_DATA_SOURCE_NAME = "data-source-name";
    private static final String M_C_LOCALE_SOURCE_TABLE = "locale-source-table";
    private static final String M_C_USER_COLUMN = "user-column";
    private static final String M_C_USER_KEY = "user-key";
    private static final String M_C_LOCALE_COLUMN = "locale-column";
    private static final String M_C_LANGUAGE_COLUMN = "language-column";
    private static final String M_C_SHORT_LANGUAGE_COLUMN = "short-language-column";
    private static final String M_C_TERRITORY_COLUMN = "territory-column";
    private static final String M_C_CHARSET_COLUMN = "charset-column";
    private static final String M_C_TIMEZONE_COLUMN = "timezone-column";
    private static final String M_C_LINGUISTIC_SORT_COLUMN = "linguistic-sort-column";
    private static final String M_C_DATE_FORMAT_COLUMN = "date-format-column";
    private static final String M_C_LONG_DATE_FORMAT_COLUMN = "long-date-format-column";
    private static final String M_C_TIME_FORMAT_COLUMN = "time-format-column";
    private static final String M_C_DATE_TIME_FORMAT_COLUMN = "date-time-format-column";
    private static final String M_C_LONG_DATE_TIME_FORMAT_COLUMN = "long-date-time-format-column";
    private static final String M_C_NUMBER_FORMAT_COLUMN = "number-format-column";
    private static final String M_C_CURRENCY_FORMAT_COLUMN = "currency-format-column";
    private static final String M_C_WRITING_DIRECTION_COLUMN = "writing-direction-column";
    private static final String M_C_ISO_CURRENCY_COLUMN = "iso-currency-column";
    private String m_user;
    private final ApplicationContext m_appctx;
    private final Map m_params;
    private DataSource m_datasrc;
    private final ServletContext m_servletContext;
    private static final int LOG_CONFIG_ERRORS = 1;
    private static final int LOG_LOCALE_ERRORS = 2;
    private static final int LOG_TRACE_INFO = 3;
    private final int m_diagnosticsLevel;
    private final boolean m_is_locale;
    private final boolean m_is_short_lang;
    private final String m_loadStatement;
    private final String m_storeStatement;
    private final List m_paramList = new ArrayList();

    private DBLocaleSource(String string, Map map, ApplicationContext applicationContext, ServletContext servletContext, int n) throws Exception {
        super(DBLocaleSource.class, true, false, false);
        this.m_user = string;
        this.m_appctx = applicationContext;
        this.m_params = map;
        this.m_servletContext = servletContext;
        this.m_diagnosticsLevel = this.m_servletContext != null ? n : 0;
        String string2 = null;
        try {
            Object object;
            try {
                object = new InitialContext();
                string2 = (String)map.get(M_C_DATA_SOURCE_NAME);
                this.m_datasrc = (DataSource)object.lookup(string2);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException("Unable to locate the data source '" + string2 + "': " + namingException.getMessage());
            }
            object = DBLocaleSource.normalizeQualifiedSQLIdentifier((String)this.m_params.get(M_C_LOCALE_SOURCE_TABLE), M_C_LOCALE_SOURCE_TABLE);
            String string3 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_USER_COLUMN), M_C_USER_COLUMN);
            String string4 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_LOCALE_COLUMN), M_C_LOCALE_COLUMN);
            String string5 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_LANGUAGE_COLUMN), M_C_LANGUAGE_COLUMN);
            String string6 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_SHORT_LANGUAGE_COLUMN), M_C_SHORT_LANGUAGE_COLUMN);
            String string7 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_TERRITORY_COLUMN), M_C_TERRITORY_COLUMN);
            String string8 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_CHARSET_COLUMN), M_C_CHARSET_COLUMN);
            String string9 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_TIMEZONE_COLUMN), M_C_TIMEZONE_COLUMN);
            String string10 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_LINGUISTIC_SORT_COLUMN), M_C_LINGUISTIC_SORT_COLUMN);
            String string11 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_DATE_FORMAT_COLUMN), M_C_DATE_FORMAT_COLUMN);
            String string12 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_LONG_DATE_FORMAT_COLUMN), M_C_LONG_DATE_FORMAT_COLUMN);
            String string13 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_TIME_FORMAT_COLUMN), M_C_TIME_FORMAT_COLUMN);
            String string14 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_DATE_TIME_FORMAT_COLUMN), M_C_DATE_TIME_FORMAT_COLUMN);
            String string15 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_LONG_DATE_TIME_FORMAT_COLUMN), M_C_LONG_DATE_TIME_FORMAT_COLUMN);
            String string16 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_NUMBER_FORMAT_COLUMN), M_C_NUMBER_FORMAT_COLUMN);
            String string17 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_CURRENCY_FORMAT_COLUMN), M_C_CURRENCY_FORMAT_COLUMN);
            String string18 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_WRITING_DIRECTION_COLUMN), M_C_WRITING_DIRECTION_COLUMN);
            String string19 = DBLocaleSource.normalizeSQLIdentifier((String)this.m_params.get(M_C_ISO_CURRENCY_COLUMN), M_C_ISO_CURRENCY_COLUMN);
            this.checkDBNames((String)object, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19);
            if (object == null) {
                throw new IllegalArgumentException("Locale source table must be specified.");
            }
            if (string3 == null) {
                throw new IllegalArgumentException("User column must be specified.");
            }
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            StringBuffer stringBuffer2 = new StringBuffer("UPDATE ").append((String)object).append(" SET ");
            if (string6 == null && string5 == null || string7 == null) {
                if (string4 == null) {
                    throw new IllegalArgumentException("Locale column or language and territory columns must be specified.");
                }
                stringBuffer.append(string4);
                stringBuffer2.append(string4).append("=?");
                this.m_is_locale = true;
                this.m_is_short_lang = false;
            } else {
                this.m_is_locale = false;
                if (string5 == null) {
                    string5 = string6;
                    this.m_is_short_lang = true;
                } else {
                    this.m_is_short_lang = false;
                }
                stringBuffer.append(string5).append(", ").append(string7);
                stringBuffer2.append(string5).append("=?,").append(string7).append("=?");
            }
            if (string8 != null) {
                stringBuffer.append(",").append(string8);
                stringBuffer2.append(",").append(string8).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.CHARSET);
            }
            if (string9 != null) {
                stringBuffer.append(",").append(string9);
                stringBuffer2.append(",").append(string9).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.TIMEZONE);
            }
            if (string10 != null) {
                stringBuffer.append(",").append(string10);
                stringBuffer2.append(",").append(string10).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.LINGUISTIC_SORT);
            }
            if (string11 != null) {
                stringBuffer.append(",").append(string11);
                stringBuffer2.append(",").append(string11).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.DATE_FORMAT);
            }
            if (string12 != null) {
                stringBuffer.append(",").append(string12);
                stringBuffer2.append(",").append(string12).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.LONG_DATE_FORMAT);
            }
            if (string13 != null) {
                stringBuffer.append(",").append(string13);
                stringBuffer2.append(",").append(string13).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.TIME_FORMAT);
            }
            if (string14 != null) {
                stringBuffer.append(",").append(string14);
                stringBuffer2.append(",").append(string14).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.DATE_TIME_FORMAT);
            }
            if (string15 != null) {
                stringBuffer.append(",").append(string15);
                stringBuffer2.append(",").append(string15).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.LONG_DATE_TIME_FORMAT);
            }
            if (string16 != null) {
                stringBuffer.append(",").append(string16);
                stringBuffer2.append(",").append(string16).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.NUMBER_FORMAT);
            }
            if (string17 != null) {
                stringBuffer.append(",").append(string17);
                stringBuffer2.append(",").append(string17).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.CURRENCY_FORMAT);
            }
            if (string18 != null) {
                stringBuffer.append(",").append(string18);
                stringBuffer2.append(",").append(string18).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.WRITING_DIRECTION);
            }
            if (string19 != null) {
                stringBuffer.append(",").append(string19);
                stringBuffer2.append(",").append(string19).append("=?");
                this.m_paramList.add(LocaleSource.Parameter.ISO_CURRENCY);
            }
            this.m_loadStatement = stringBuffer.append(" FROM ").append((String)object).append(" WHERE LOWER(").append(string3).append(") = LOWER(?)").toString();
            this.m_storeStatement = stringBuffer2.append(" WHERE LOWER(").append(string3).append(") = LOWER(?)").toString();
            this.logTraceInfo("Load SQL: " + this.m_loadStatement);
            this.logTraceInfo("Store SQL: " + this.m_storeStatement);
        }
        catch (Exception exception) {
            this.logConfigError("Unable to instantiate DBLocaleSource", exception);
            throw exception;
        }
    }

    public static LocaleSource getInstance(HttpServletRequest httpServletRequest) {
        LocaleSource localeSource = (LocaleSource)httpServletRequest.getAttribute(OBJECT_KEY.getName());
        if (localeSource != null) {
            return localeSource;
        }
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        if (servletContext == null) {
            return null;
        }
        Map map = (Map)httpServletRequest.getAttribute("oracle.i18n.servlet.localesource.LocaleSource.paramkey");
        String string = (String)map.get(M_C_DIAGNOSTICS_LEVEL);
        int n = 0;
        if ("1".equals(string)) {
            n = 1;
        } else if ("2".equals(string)) {
            n = 2;
        } else if ("3".equals(string)) {
            n = 3;
        }
        if (n >= 1) {
            servletContext.log("Diagnostics level " + n);
        }
        String string2 = (String)map.get(M_C_USER_KEY);
        Object object = httpServletRequest.getSession().getAttribute(string2);
        if (object == null) {
            if (n >= 3) {
                servletContext.log("No user id found in the session (" + string2 + ")");
            }
            return null;
        }
        try {
            localeSource = new DBLocaleSource((String)object, map, ServletHelper.getApplicationContextInstance(httpServletRequest), httpServletRequest.getSession().getServletContext(), n);
        }
        catch (Exception exception) {
            return null;
        }
        if (!localeSource.load()) {
            return null;
        }
        if (localeSource.isCached()) {
            httpServletRequest.setAttribute(OBJECT_KEY.getName(), (Object)localeSource);
            if (n >= 3) {
                servletContext.log("Caching " + OBJECT_KEY.getName());
            }
        }
        return localeSource;
    }

    public static boolean isAccessible(HttpServletRequest httpServletRequest) {
        Map map = (Map)httpServletRequest.getAttribute("oracle.i18n.servlet.localesource.LocaleSource.paramkey");
        String string = (String)map.get(M_C_USER_KEY);
        Object object = httpServletRequest.getSession().getAttribute(string);
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean store() {
        block14: {
            block15: {
                var1_1 = null;
                var2_2 = null;
                if (this.m_user == null) {
                    this.logTraceInfo("Unable to store - null user id");
                    return false;
                }
                var1_1 = this.m_datasrc.getConnection();
                var2_2 = var1_1.prepareStatement(this.m_storeStatement);
                var3_3 = 1;
                if (!this.m_is_locale) break block15;
                var2_2.setString(var3_3++, this.getLocale().toString());
                ** GOTO lbl27
            }
            var4_5 = OraLocaleInfo.getInstance(this.getLocale());
            if (var4_5 != null) break block14;
            this.logConfigError("No Oracle locale info available for storing");
            var5_8 = false;
            DBLocaleSource.closeAllObjects(var1_1, var2_2, null);
            return var5_8;
        }
        try {
            if (this.m_is_short_lang) {
                var2_2.setString(var3_3++, var4_5.getShortLanguage());
            } else {
                var2_2.setString(var3_3++, var4_5.getLanguage());
            }
            var2_2.setString(var3_3++, var4_5.getTerritory());
lbl27:
            // 8 sources

            for (var4_6 = 0; var4_6 < this.m_paramList.size(); ++var4_6) {
                var5_9 = (LocaleSource.Parameter)this.m_paramList.get(var4_6);
                if (var5_9 == LocaleSource.Parameter.TIMEZONE) {
                    var6_10 = (TimeZone)this.getAttribute(var5_9);
                    var2_2.setString(var3_3++, var6_10 != null ? var6_10.getID() : null);
                    continue;
                }
                if (var5_9 == LocaleSource.Parameter.CURRENCY_FORMAT || var5_9 == LocaleSource.Parameter.NUMBER_FORMAT) {
                    var6_10 = (OraDecimalFormat)this.getAttribute(var5_9);
                    var2_2.setString(var3_3++, var6_10 != null ? var6_10.toPattern() : null);
                    continue;
                }
                if (var5_9 == LocaleSource.Parameter.LINGUISTIC_SORT) {
                    var6_10 = this.getCollator();
                    var2_2.setString(var3_3++, var6_10 != null ? var6_10.getName() : null);
                    continue;
                }
                if (var5_9 == LocaleSource.Parameter.WRITING_DIRECTION) {
                    var6_10 = this.getWritingDirection();
                    var2_2.setString(var3_3++, var6_10 != null ? var6_10.toString() : null);
                    continue;
                }
                if (var5_9 == LocaleSource.Parameter.DATE_FORMAT || var5_9 == LocaleSource.Parameter.DATE_TIME_FORMAT || var5_9 == LocaleSource.Parameter.LONG_DATE_FORMAT || var5_9 == LocaleSource.Parameter.LONG_DATE_TIME_FORMAT || var5_9 == LocaleSource.Parameter.TIME_FORMAT) {
                    var6_10 = (OraSimpleDateFormat)this.getAttribute(var5_9);
                    var2_2.setString(var3_3++, var6_10 != null ? var6_10.toPattern() : null);
                    continue;
                }
                var6_10 = this.getAttribute(var5_9);
                var2_2.setString(var3_3++, var6_10 != null ? (String)var6_10 : null);
            }
            var2_2.setString(var3_3, this.m_user);
            var2_2.execute();
        }
        catch (Exception var3_4) {
            try {
                this.logConfigError("Unable to store locale information for user '" + this.m_user.toLowerCase(Locale.US) + "'; resetting user id", var3_4);
                this.m_user = null;
                var4_7 = false;
            }
            catch (Throwable var7_11) {
                DBLocaleSource.closeAllObjects(var1_1, var2_2, null);
                throw var7_11;
            }
            DBLocaleSource.closeAllObjects(var1_1, var2_2, null);
            return var4_7;
        }
        DBLocaleSource.closeAllObjects(var1_1, var2_2, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean load() {
        block44: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block32: {
                                                            var1_1 = null;
                                                            var2_2 = null;
                                                            var3_3 = null;
                                                            if (this.m_user == null) {
                                                                this.logTraceInfo("Unable to load - null user id");
                                                                return false;
                                                            }
                                                            var4_4 = this.m_user.toLowerCase(Locale.US);
                                                            var1_1 = this.m_datasrc.getConnection();
                                                            var2_2 = var1_1.prepareStatement(this.m_loadStatement);
                                                            var2_2.setString(1, this.m_user);
                                                            var3_3 = var2_2.executeQuery();
                                                            if (var3_3.next()) break block32;
                                                            this.logLocaleError("No locale information for user '" + var4_4 + "'; resetting user id");
                                                            this.m_user = null;
                                                            var5_5 = false;
                                                            DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                                                            return var5_5;
                                                        }
                                                        this.logTraceInfo("Got locale information for user '" + var4_4 + "'");
                                                        var5_6 = 1;
                                                        if (!this.m_is_locale) ** GOTO lbl50
                                                        if ((var8_8 = var3_3.getString(var5_6++)) != null) break block33;
                                                        this.logLocaleError("No ISO locale specified for user '" + var4_4 + "'");
                                                        var10_9 = false;
                                                        DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                                                        return var10_9;
                                                    }
                                                    var7_20 = OraLocaleInfo.getLocaleFromString(var8_8);
                                                    if (var7_20 != null) break block34;
                                                    this.logLocaleError("Unable to obtain Java locale from ISO locale '" + var8_8 + "' for user '" + var4_4 + "'");
                                                    var10_10 = false;
                                                    DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                                                    return var10_10;
                                                }
                                                var7_20 = this.m_appctx.fallbackLocale(var7_20);
                                                if (var7_20 != null) break block35;
                                                this.logLocaleError("No fallback locale for user '" + var4_4 + "'");
                                                var10_11 = false;
                                                DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                                                return var10_11;
                                            }
                                            this.logTraceInfo("Setting locale for user '" + var4_4 + "' to '" + var7_20.toString() + "'");
                                            this.setLocale(var7_20);
                                            ** GOTO lbl128
lbl50:
                                            // 1 sources

                                            if (!this.m_is_short_lang) ** GOTO lbl94
                                            var8_8 = var3_3.getString(var5_6++);
                                            var9_21 = var3_3.getString(var5_6++);
                                            if (var8_8 != null) break block36;
                                            this.logLocaleError("No abbreviated Oracle language name specified for user '" + var4_4 + "'");
                                            var10_12 = false;
                                            DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                                            return var10_12;
                                        }
                                        if (var9_21 != null) break block37;
                                        this.logLocaleError("No Oracle territory name specified for user '" + var4_4 + "'");
                                        var10_13 = false;
                                        DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                                        return var10_13;
                                    }
                                    var10_14 = LocaleMapper.getOraLanguageFromShortName(var8_8);
                                    if (var10_14 != null) break block38;
                                    this.logLocaleError("Unrecognized abbreviated Oracle language name '" + var8_8 + "' for user '" + var4_4 + "'");
                                    var11_22 = false;
                                    DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                                    return var11_22;
                                }
                                var6_26 = OraLocaleInfo.getInstance(var10_14, var9_21);
                                if (var6_26 != null) break block39;
                                this.logLocaleError("Unable to obtain Oracle locale info '" + var10_14 + "_" + var9_21 + "' for user '" + var4_4 + "'");
                                var11_23 = false;
                                DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                                return var11_23;
                            }
                            var7_20 = this.m_appctx.fallbackLocale(var6_26.getLocale());
                            if (var7_20 != null) break block40;
                            this.logLocaleError("No fallback locale for user '" + var4_4 + "'");
                            var11_24 = false;
                            DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                            return var11_24;
                        }
                        this.logTraceInfo("Setting locale for user '" + var4_4 + "' to '" + var7_20.toString() + "'");
                        this.setLocale(var7_20);
                        ** GOTO lbl128
lbl94:
                        // 1 sources

                        var8_8 = var3_3.getString(var5_6++);
                        var9_21 = var3_3.getString(var5_6++);
                        if (var8_8 != null) break block41;
                        this.logLocaleError("No Oracle language name specified for user '" + var4_4 + "'");
                        var10_15 = false;
                        DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                        return var10_15;
                    }
                    if (var9_21 != null) break block42;
                    this.logLocaleError("No Oracle territory name specified for user '" + var4_4 + "'");
                    var10_16 = false;
                    DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                    return var10_16;
                }
                var6_26 = OraLocaleInfo.getInstance(var8_8, var9_21);
                if (var6_26 != null) break block43;
                this.logLocaleError("Unable to obtain Oracle locale info '" + var8_8 + "_" + var9_21 + "' for user '" + var4_4 + "'");
                var10_17 = false;
                DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                return var10_17;
            }
            var7_20 = this.m_appctx.fallbackLocale(var6_26.getLocale());
            if (var7_20 != null) break block44;
            this.logLocaleError("No fallback locale for user '" + var4_4 + "'");
            var10_18 = false;
            DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
            return var10_18;
        }
        try {
            this.logTraceInfo("Setting locale for user '" + var4_4 + "' to '" + var7_20.toString() + "'");
            this.setLocale(var7_20);
lbl128:
            // 3 sources

            var11_25 = this.m_paramList.size();
            for (var10_19 = 0; var10_19 < var11_25; ++var10_19) {
                var12_28 = (LocaleSource.Parameter)this.m_paramList.get(var10_19);
                if ((var8_8 = var3_3.getString(var5_6++)) == null) {
                    this.logTraceInfo("No " + var12_28.toString() + " for user '" + var4_4 + "'");
                    continue;
                }
                this.logTraceInfo(var12_28.toString() + " for user '" + var4_4 + "': " + var8_8);
                if (var12_28 == LocaleSource.Parameter.TIMEZONE) {
                    this.setTimeZone(TimeZone.getTimeZone(var8_8));
                    continue;
                }
                if (var12_28 == LocaleSource.Parameter.CURRENCY_FORMAT || var12_28 == LocaleSource.Parameter.NUMBER_FORMAT) {
                    try {
                        this.setAttribute(var12_28, (Object)new OraDecimalFormat(var8_8, new OraDecimalFormatSymbols(this.getLocale())));
                    }
                    catch (ParseException var13_30) {
                        this.logLocaleError("Unable to parse numeric format '" + var8_8 + "' for user '" + var4_4 + "'");
                    }
                    continue;
                }
                if (var12_28 == LocaleSource.Parameter.LINGUISTIC_SORT) {
                    try {
                        this.setAttribute(var12_28, (Object)OraCollator.getInstance((String)var8_8));
                    }
                    catch (IllegalArgumentException var13_31) {
                        this.logLocaleError("Unrecognized linguistic sort '" + var8_8 + "' for user '" + var4_4 + "'");
                    }
                    continue;
                }
                if (var12_28 == LocaleSource.Parameter.WRITING_DIRECTION) {
                    this.setAttribute(var12_28, (Object)LocaleSource.WritingDirection.getWritingDirection(var8_8));
                    continue;
                }
                if (var12_28 == LocaleSource.Parameter.DATE_FORMAT || var12_28 == LocaleSource.Parameter.DATE_TIME_FORMAT || var12_28 == LocaleSource.Parameter.LONG_DATE_FORMAT || var12_28 == LocaleSource.Parameter.LONG_DATE_TIME_FORMAT || var12_28 == LocaleSource.Parameter.TIME_FORMAT) {
                    try {
                        var13_29 = new OraSimpleDateFormat(var8_8, this.getLocale());
                        var14_33 = this.getTimeZone();
                        if (var14_33 != null) {
                            var13_29.setTimeZone(var14_33);
                        }
                        this.setAttribute(var12_28, (Object)var13_29);
                    }
                    catch (ParseException var13_32) {
                        this.logLocaleError("Unable to parse datetime format '" + var8_8 + "' for user '" + var4_4 + "'");
                    }
                    continue;
                }
                this.setAttribute(var12_28, (Object)var8_8);
            }
        }
        catch (Exception var5_7) {
            try {
                this.logConfigError("Unable to load locale information for user '" + var4_4 + "'; resetting user id", var5_7);
                this.m_user = null;
                var6_27 = false;
            }
            catch (Throwable var15_34) {
                DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
                throw var15_34;
            }
            DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
            return var6_27;
        }
        DBLocaleSource.closeAllObjects(var1_1, var2_2, var3_3);
        return true;
    }

    private static String normalizeSQLIdentifier(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = (string = string.trim()).length();
        if (n <= 0) {
            throw new IllegalArgumentException("database identifier with length 0" + (string2 != null ? " (" + string2 + ")" : ""));
        }
        int n2 = string.indexOf(34);
        if (n2 < 0) {
            return "\"" + string.toUpperCase(Locale.US) + "\"";
        }
        if (n2 > 0 || string.indexOf(34, 1) != n - 1) {
            throw new IllegalArgumentException("incorrect quote character in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
        }
        if (n == 2) {
            throw new IllegalArgumentException("quoted database identifier with length 0" + (string2 != null ? " (" + string2 + ")" : ""));
        }
        return string;
    }

    private static String normalizeQualifiedSQLIdentifier(String string, String string2) {
        String string3;
        int n;
        String string4;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = (string = string.trim()).length();
        if (n3 <= 0) {
            throw new IllegalArgumentException("database identifier with length 0" + (string2 != null ? " (" + string2 + ")" : ""));
        }
        int n4 = string.indexOf(34);
        if (n4 < 0) {
            int n5 = string.indexOf(46);
            if (n5 < 0) {
                return "\"" + string.toUpperCase(Locale.US) + "\"";
            }
            if (n5 == 0 || n5 == n3 - 1) {
                throw new IllegalArgumentException("incorrect period in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            if (string.indexOf(46, n5 + 1) >= 0) {
                throw new IllegalArgumentException("too many periods in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            String string5 = string.substring(0, n5).trim();
            String string6 = string.substring(n5 + 1, n3).trim();
            return "\"" + string5.toUpperCase(Locale.US) + "\".\"" + string6.toUpperCase(Locale.US) + "\"";
        }
        if (n4 == 0) {
            n2 = string.indexOf(34, 1);
            if (n2 <= 0) {
                throw new IllegalArgumentException("incorrect quote character in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            string4 = string.substring(0, n2 + 1);
            if (string4.length() == 2) {
                throw new IllegalArgumentException("incorrect quote character in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            if (n2 == n3 - 1) {
                return string4;
            }
            n = string.indexOf(46, n2 + 1);
            if (n <= 0) {
                throw new IllegalArgumentException("incorrect quote character in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            if (n == n3 - 1) {
                throw new IllegalArgumentException("incorrect period in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            if (string.substring(n2 + 1, n).trim().length() != 0) {
                throw new IllegalArgumentException("incorrect qualified database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
        } else {
            n = string.indexOf(46);
            if (n < 0 || n >= n4) {
                throw new IllegalArgumentException("incorrect quote character in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            if (n == 0) {
                throw new IllegalArgumentException("incorrect period in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            string4 = "\"" + string.substring(0, n).trim().toUpperCase(Locale.US) + "\"";
        }
        if ((n4 = (string3 = string.substring(n + 1).trim()).indexOf(34)) > 0) {
            throw new IllegalArgumentException("incorrect quote character in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
        }
        if (n4 == 0) {
            n2 = string3.indexOf(34, 1);
            if (n2 <= 0) {
                throw new IllegalArgumentException("incorrect quote character in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            if (n4 == n2 - 1) {
                throw new IllegalArgumentException("quoted database identifier with length 0" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            if (n2 != string3.length() - 1) {
                throw new IllegalArgumentException("incorrect quote character in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
            }
            return string4 + "." + string3;
        }
        n = string3.indexOf(46);
        if (n >= 0) {
            throw new IllegalArgumentException("incorrect period in the database identifier" + (string2 != null ? " (" + string2 + ")" : ""));
        }
        return string4 + ".\"" + string3.toUpperCase(Locale.US) + "\"";
    }

    private void checkDBNames(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder(0);
        try {
            connection = this.m_datasrc.getConnection();
            preparedStatement = connection.prepareStatement("SELECT ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? FROM sys.dual");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            preparedStatement.setString(4, string4);
            preparedStatement.setString(5, string5);
            preparedStatement.setString(6, string6);
            preparedStatement.setString(7, string7);
            preparedStatement.setString(8, string8);
            preparedStatement.setString(9, string9);
            preparedStatement.setString(10, string10);
            preparedStatement.setString(11, string11);
            preparedStatement.setString(12, string12);
            preparedStatement.setString(13, string13);
            preparedStatement.setString(14, string14);
            preparedStatement.setString(15, string15);
            preparedStatement.setString(16, string16);
            preparedStatement.setString(17, string17);
            preparedStatement.setString(18, string18);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            if (string != null && !string.equals(resultSet.getString(1))) {
                stringBuilder.append(", locale-source-table");
            }
            if (string2 != null && !string2.equals(resultSet.getString(2))) {
                stringBuilder.append(", user-column");
            }
            if (string3 != null && !string3.equals(resultSet.getString(3))) {
                stringBuilder.append(", locale-column");
            }
            if (string4 != null && !string4.equals(resultSet.getString(4))) {
                stringBuilder.append(", language-column");
            }
            if (string5 != null && !string5.equals(resultSet.getString(5))) {
                stringBuilder.append(", short-language-column");
            }
            if (string6 != null && !string6.equals(resultSet.getString(6))) {
                stringBuilder.append(", territory-column");
            }
            if (string7 != null && !string7.equals(resultSet.getString(7))) {
                stringBuilder.append(", charset-column");
            }
            if (string8 != null && !string8.equals(resultSet.getString(8))) {
                stringBuilder.append(", timezone-column");
            }
            if (string9 != null && !string9.equals(resultSet.getString(9))) {
                stringBuilder.append(", linguistic-sort-column");
            }
            if (string10 != null && !string10.equals(resultSet.getString(10))) {
                stringBuilder.append(", date-format-column");
            }
            if (string11 != null && !string11.equals(resultSet.getString(11))) {
                stringBuilder.append(", long-date-format-column");
            }
            if (string12 != null && !string12.equals(resultSet.getString(12))) {
                stringBuilder.append(", time-format-column");
            }
            if (string13 != null && !string13.equals(resultSet.getString(13))) {
                stringBuilder.append(", date-time-format-column");
            }
            if (string14 != null && !string14.equals(resultSet.getString(14))) {
                stringBuilder.append(", long-date-time-format-column");
            }
            if (string15 != null && !string15.equals(resultSet.getString(15))) {
                stringBuilder.append(", number-format-column");
            }
            if (string16 != null && !string16.equals(resultSet.getString(16))) {
                stringBuilder.append(", currency-format-column");
            }
            if (string17 != null && !string17.equals(resultSet.getString(17))) {
                stringBuilder.append(", writing-direction-column");
            }
            if (string18 != null && !string18.equals(resultSet.getString(18))) {
                stringBuilder.append(", iso-currency-column");
            }
            if (stringBuilder.length() > 0) {
                throw new IllegalArgumentException("Some configured SQL identifiers cannot be represented in the database character set: " + stringBuilder.substring(2));
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new IllegalArgumentException("Database connection failed", sQLException);
            }
            catch (Throwable throwable) {
                DBLocaleSource.closeAllObjects(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        DBLocaleSource.closeAllObjects(connection, preparedStatement, resultSet);
    }

    private void logConfigError(String string, Throwable throwable) {
        if (this.m_diagnosticsLevel >= 1) {
            if (throwable == null) {
                this.m_servletContext.log(string);
            } else {
                this.m_servletContext.log(string, throwable);
            }
        }
    }

    private void logConfigError(String string) {
        if (this.m_diagnosticsLevel >= 1) {
            this.m_servletContext.log(string);
        }
    }

    private void logLocaleError(String string) {
        if (this.m_diagnosticsLevel >= 2) {
            this.m_servletContext.log(string);
        }
    }

    private void logTraceInfo(String string) {
        if (this.m_diagnosticsLevel >= 3) {
            this.m_servletContext.log(string);
        }
    }

    private static void closeAllObjects(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

