/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SQLAnalyzer {
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_PACKAGE = "package";
    public static final String TYPE_TYPE = "type";
    public static final String TYPE_REF_TYPE = "ref type";
    public static final String TYPE_COLUMN = "column";
    private static final String t_ref = "table_reference";
    private static final String u_funct = "user_defined_function";
    private static final String dml_table = "aliased_dml_table_expression_clause";
    private static final String function_call = "function_call";
    private static final String prm_spec_type = "prm_spec_unconstrained_type";
    private static String column = "column";
    private static final String q_block = "query_block";
    private static final String select_list = "select_list";
    private static final String select_clause = "select_clause";
    private static final String unconstrained_type = "unconstrained_type";
    private static final String prm_spec = "prm_spec";
    private static final String aliased_expr = "\"aliased_expr\"";
    private static final String from_clause = "from_clause";
    private static final String subquery_factoring = "with_clause";

    private static boolean hasString(String[] split, String str) {
        for (int i = 1; i < split.length; ++i) {
            if (!str.equals(split[i].trim())) continue;
            return true;
        }
        return false;
    }

    private static String getContent(ParseNode pn, List<LexerToken> src) {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                sb.append(src.get((int)i).content);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseContentForTable(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            int i = pn.from;
            while (i < pn.to) {
                String temp = src.get((int)i).content;
                if ("PIVOT".equalsIgnoreCase(temp)) {
                    return;
                }
                if (p == 0) {
                    if (temp.startsWith("(")) {
                        return;
                    }
                    pd.name = temp.startsWith("\"") ? Token.getValBetweenDoubleQuotes(temp) : temp.toUpperCase(Locale.ROOT);
                    pd.valid = true;
                } else if (p == 1) {
                    if (!".".equals(temp)) {
                        pd.alias = Token.getValBetweenDoubleQuotes(temp);
                        return;
                    }
                    pd.schema = pd.name;
                    pd.name = null;
                } else if (p == 2) {
                    pd.name = temp.startsWith("\"") ? Token.getValBetweenDoubleQuotes(temp) : temp.toUpperCase(Locale.ROOT);
                } else if (p == 3) {
                    pd.alias = Token.getValBetweenDoubleQuotes(temp);
                }
                ++p;
                ++i;
            }
            return;
        }
        catch (IndexOutOfBoundsException e) {
            Logger.error(e);
        }
    }

    private static void parseContentForColumn(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (p == 0) {
                    if (temp.startsWith("(")) break;
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    pd.valid = true;
                } else if (p == 1) {
                    if (!".".equals(temp)) break;
                    pd.schema = pd.name;
                    pd.name = null;
                } else if (p == 2) {
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    break;
                }
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForColumnAndAlias(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (p == 0) {
                    if (!temp.startsWith("(")) {
                        pd.name = Token.getValBetweenDoubleQuotes(temp);
                        pd.valid = true;
                        ++p;
                        continue;
                    }
                    break;
                }
                if (p == 1) {
                    if (".".equals(temp)) {
                        pd.table = pd.name;
                        pd.name = null;
                        continue;
                    }
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    ++p;
                    continue;
                }
                if (p == 2) {
                    if (".".equals(temp)) {
                        pd.schema = pd.table;
                        pd.table = pd.name;
                        pd.name = null;
                        continue;
                    }
                    pd.name = Token.getValBetweenDoubleQuotes(temp);
                    ++p;
                    continue;
                }
                if (p != 3 || "AS".equalsIgnoreCase(temp) && i < pn.to - 1) continue;
                pd.alias = Token.getValBetweenDoubleQuotes(temp);
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
    }

    private static void parseContentForParameterSpec(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        try {
            boolean percentFound = false;
            String colName = null;
            int p = 0;
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (percentFound) {
                    if (temp.equalsIgnoreCase("TYPE")) {
                        if (pd.name != null) {
                            pd.valid = true;
                        }
                    } else if (temp.equalsIgnoreCase("ROWTYPE")) {
                        pd.schema = pd.name;
                        pd.name = colName;
                        pd.valid = true;
                    }
                    break;
                }
                if (p == 0) {
                    colName = temp.startsWith("\"") ? Token.getValBetweenDoubleQuotes(temp) : temp.toUpperCase(Locale.ROOT);
                } else if (p == 2) {
                    pd.name = colName;
                    colName = temp.startsWith("\"") ? Token.getValBetweenDoubleQuotes(temp) : temp.toUpperCase(Locale.ROOT);
                } else if (p == 4) {
                    pd.schema = pd.name;
                    pd.name = colName;
                    colName = Token.getValBetweenDoubleQuotes(temp);
                } else if ("%".equals(temp)) {
                    percentFound = true;
                } else if (!".".equals(temp)) break;
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.error(e);
        }
    }

    private static void parseContentForFunction(ParseNode pn, List<LexerToken> src, PDescriptor pd) {
        int p = 0;
        try {
            for (int i = pn.from; i < pn.to; ++i) {
                String temp = src.get((int)i).content;
                if (temp.startsWith("(")) {
                    pd.valid = p > 0;
                    return;
                }
                if (p == 0) {
                    pd.name = temp.startsWith("\"") ? Token.getValBetweenDoubleQuotes(temp) : temp.toUpperCase(Locale.ROOT);
                } else if (".".equals(temp)) {
                    if (p == 1) {
                        pd.schema = pd.name;
                        pd.name = null;
                    } else if (p == 3) {
                        pd.pack = pd.name;
                        pd.name = null;
                    }
                } else if (p == 2 || p == 4) {
                    pd.name = temp.startsWith("\"") ? Token.getValBetweenDoubleQuotes(temp) : temp.toUpperCase(Locale.ROOT);
                    if (p == 4) break;
                }
                ++p;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.error(e);
        }
    }

    public static List<PDescriptor> getTablesAndFunctions(String sql) {
        HashMap<String, PDescriptor> tmap = null;
        HashMap<String, PDescriptor> fmap = null;
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            if (root != null) {
                block2: for (ParseNode n : root.descendants()) {
                    PDescriptor pd;
                    String tostr = n.toString();
                    String[] split = tostr.split("  ");
                    if (split.length <= 1) continue;
                    if (SQLAnalyzer.hasString(split, t_ref) || SQLAnalyzer.hasString(split, dml_table)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        String name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap<String, PDescriptor>();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (SQLAnalyzer.hasString(split, u_funct) || SQLAnalyzer.hasString(split, function_call)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_FUNCTION;
                        SQLAnalyzer.parseContentForFunction(n, src, pd);
                        if (!pd.valid && pd.pack == null) continue;
                        String name = pd.toString();
                        if (fmap == null) {
                            fmap = new HashMap<String, PDescriptor>();
                        }
                        if (fmap.get(name) != null) continue;
                        list.add(pd);
                        fmap.put(name, pd);
                        continue;
                    }
                    if (split[1].trim().equals(prm_spec_type)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                        if (!pd.valid) continue;
                        String name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (!split[1].trim().equals("adt_field")) continue;
                    List descendants = n.descendants();
                    for (int i = 0; i < descendants.size(); ++i) {
                        ParseNode subNode = (ParseNode)descendants.get(i);
                        String subStr = subNode.toString();
                        String[] subSplit = subStr.split("  ");
                        if (subSplit.length <= 1 || !SQLAnalyzer.hasString(subSplit, "constrained_type")) continue;
                        String temp = ((LexerToken)src.get((int)subNode.from)).content;
                        boolean isRef = "REF".equalsIgnoreCase(temp);
                        if (isRef && i + 2 < descendants.size()) {
                            subNode = (ParseNode)descendants.get(i + 2);
                        }
                        if (!isRef && !SQLAnalyzer.hasString(subSplit, "dotted_name")) continue block2;
                        PDescriptor pd2 = new PDescriptor();
                        SQLAnalyzer.parseContentForTable(subNode, src, pd2);
                        if (!pd2.valid) continue block2;
                        pd2.type = isRef ? TYPE_REF_TYPE : TYPE_TYPE;
                        String name = pd2.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) != null) continue block2;
                        list.add(pd2);
                        tmap.put(name, pd2);
                        continue block2;
                    }
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        return list;
    }

    public static List<PDescriptor> getTables(String sql) {
        HashMap<String, PDescriptor> tmap = null;
        Object fmap = null;
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    String tostr = n.toString();
                    String[] split = tostr.split("  ");
                    if (split.length <= 1) continue;
                    if (SQLAnalyzer.hasString(split, t_ref) || SQLAnalyzer.hasString(split, dml_table)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap<String, PDescriptor>();
                        }
                        if (tmap.get(name) != null) continue;
                        list.add(pd);
                        tmap.put(name, pd);
                        continue;
                    }
                    if (!split[1].trim().equals(prm_spec_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        return list;
    }

    public static List<PDescriptor> getFirstColumnNamesAndTables(String sql) {
        HashMap<String, PDescriptor> tmap = new HashMap<String, PDescriptor>();
        Object fmap = null;
        HashMap<CallSite, PDescriptor> cmap = new HashMap<CallSite, PDescriptor>();
        HashMap c2map = new HashMap();
        HashMap<Object, Object> amap = new HashMap<Object, Object>();
        ArrayList cols = new ArrayList();
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        int table_ref = earley.getSymbol(t_ref);
        int column_ = earley.getSymbol(column);
        int dml_tab = earley.getSymbol(dml_table);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        int query_block = earley.getSymbol(q_block);
        int sel_list = earley.getSymbol(select_list);
        int sel_clause = earley.getSymbol(select_clause);
        int al_expr = earley.getSymbol(aliased_expr);
        int frm_clause = earley.getSymbol(from_clause);
        int subquery_fact_clause = earley.getSymbol(subquery_factoring);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            int count = 10;
            Integer qb = 10;
            int qb_end = root.to;
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(qb);
            stack.push(qb_end);
            int subq_fact_end = -1;
            int nextColumn = -1;
            Object last_col = null;
            boolean skipColumns = false;
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    if (n.from < subq_fact_end || n.from < nextColumn) continue;
                    if (n.contains(subquery_fact_clause)) {
                        subq_fact_end = n.to;
                        qb_end = n.to;
                        continue;
                    }
                    if (n.contains(query_block)) {
                        stack.push(qb);
                        stack.push(qb_end);
                        qb = ++count;
                        qb_end = n.to;
                    }
                    if (n.from == qb_end) {
                        qb_end = (Integer)stack.pop();
                        qb = (Integer)stack.pop();
                    }
                    String qb_id = String.valueOf(qb);
                    if (n.contains(frm_clause) && "10".equals(qb_id)) {
                        skipColumns = true;
                    }
                    String cont = SQLAnalyzer.getContent(n, src);
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        String alias;
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) == null) {
                            list.add(pd);
                            tmap.put(name, pd);
                        }
                        if ((alias = pd.alias) == null || alias.isEmpty()) {
                            alias = pd.name;
                        }
                        amap.put(qb_id + alias, pd);
                        HashMap<String, PDescriptor> tables = (HashMap<String, PDescriptor>)amap.get(qb_id);
                        if (tables == null) {
                            tables = new HashMap<String, PDescriptor>();
                            amap.put(qb_id, tables);
                        }
                        tables.put(name, pd);
                        continue;
                    }
                    if (!skipColumns && n.contains(column_)) {
                        String all_expr;
                        pd = new PDescriptor();
                        pd.element = cont;
                        pd.type = TYPE_COLUMN;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd);
                        if (pd.valid) {
                            name = pd.toString();
                            cmap.put((CallSite)((Object)(qb_id + name)), pd);
                        }
                        pd.condition = n.parent().contains("condition");
                        if (n.parent().contains(al_expr) && (all_expr = SQLAnalyzer.getContent(n.parent(), src)).length() > cont.length()) {
                            pd.alias = all_expr.substring(cont.length());
                            if (pd.alias.toUpperCase().startsWith("AS")) {
                                pd.alias = pd.alias.substring(2);
                            }
                        }
                        list.add(pd);
                        continue;
                    }
                    if (n.contains(al_expr)) {
                        ParseNode pn;
                        pd = new PDescriptor();
                        pd.element = cont;
                        pd.type = TYPE_COLUMN;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        String temp = ((LexerToken)src.get((int)(n.to - 1))).content;
                        nextColumn = n.to;
                        pd.valid = true;
                        pd.alias = temp;
                        int k = n.to - 1;
                        String as = ((LexerToken)src.get((int)(n.to - 2))).content;
                        if ("AS".equalsIgnoreCase(as)) {
                            --k;
                        }
                        if ((pn = n.childAt(n.from, k)) != null && pn.contains(column_)) {
                            SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd);
                            pd.expression = null;
                        } else if (pn != null) {
                            pd.expression = SQLAnalyzer.getContent(pn, src);
                            pd.queryExpression = pn.contains("scalar_subquery_expression");
                        }
                        if (pd.valid) {
                            String name2 = pd.toString();
                            cmap.put((CallSite)((Object)(qb_id + name2)), pd);
                        }
                        list.add(pd);
                        continue;
                    }
                    if (!skipColumns && n.contains("select_term")) {
                        if (cont.indexOf(".*") <= -1) continue;
                        pd = new PDescriptor();
                        pd.element = cont;
                        pd.type = TYPE_COLUMN;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd);
                        if (!"*".equals(pd.name)) continue;
                        list.add(pd);
                        continue;
                    }
                    if (!skipColumns && n.contains(sel_list) && "*".equals(cont)) {
                        pd = new PDescriptor();
                        pd.element = cont;
                        pd.type = TYPE_COLUMN;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd);
                        if (!"*".equals(pd.name)) continue;
                        list.add(pd);
                        continue;
                    }
                    if (parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    pd.start = n.from;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
            }
        }
        catch (StackOverflowError root) {
            // empty catch block
        }
        ArrayList<PDescriptor> tlist = new ArrayList<PDescriptor>();
        for (PDescriptor pd : list) {
            if (!"11".equals(pd.query_block_id) || pd.condition) continue;
            tlist.add(pd);
        }
        return tlist;
    }

    public static List<PDescriptor> getTablesAndColumns(String sql, String schema, Map containers) {
        HashMap<String, PDescriptor> tmap = new HashMap<String, PDescriptor>();
        Object fmap = null;
        HashMap<CallSite, PDescriptor> cmap = new HashMap<CallSite, PDescriptor>();
        HashMap<String, PDescriptor> c2map = new HashMap<String, PDescriptor>();
        HashMap<Object, Object> amap = new HashMap<Object, Object>();
        ArrayList cols = new ArrayList();
        ArrayList<PDescriptor> list = new ArrayList<PDescriptor>();
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        int table_ref = earley.getSymbol(t_ref);
        int column_ = earley.getSymbol(column);
        int dml_tab = earley.getSymbol(dml_table);
        int param_spec = earley.getSymbol(prm_spec);
        int unconstr_type = earley.getSymbol(unconstrained_type);
        int query_block = earley.getSymbol(q_block);
        int al_expr = earley.getSymbol(aliased_expr);
        int sel_clause = earley.getSymbol(select_clause);
        try {
            earley.parse(src, (Matriceable)matrix);
            ParseNode root = earley.forest(src, matrix);
            int count = 10;
            Integer qb = 10;
            int qb_end = root.to;
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(qb);
            stack.push(qb_end);
            if (root != null) {
                for (ParseNode n : root.descendants()) {
                    String name;
                    PDescriptor pd;
                    if (n.contains(query_block)) {
                        stack.push(qb);
                        stack.push(qb_end);
                        qb = ++count;
                        qb_end = n.to;
                    }
                    if (n.from == qb_end) {
                        qb_end = (Integer)stack.pop();
                        qb = (Integer)stack.pop();
                    }
                    String qb_id = String.valueOf(qb);
                    ParseNode parent = n.parent();
                    if (n.contains(table_ref) || n.contains(dml_tab)) {
                        pd = new PDescriptor();
                        pd.type = TYPE_TABLE;
                        pd.query_block_id = qb_id;
                        pd.start = n.from;
                        SQLAnalyzer.parseContentForTable(n, src, pd);
                        if (!pd.valid) continue;
                        name = pd.toString();
                        if (tmap == null) {
                            tmap = new HashMap();
                        }
                        if (tmap.get(name) == null) {
                            list.add(pd);
                            tmap.put(name, pd);
                        }
                        String alias = pd.getTableIdentifier();
                        amap.put(qb_id + alias, pd);
                        HashMap<String, PDescriptor> tables = (HashMap<String, PDescriptor>)amap.get(qb_id);
                        if (tables == null) {
                            tables = new HashMap<String, PDescriptor>();
                            amap.put(qb_id, tables);
                        }
                        tables.put(name, pd);
                        continue;
                    }
                    if (n.contains(column_)) {
                        String all_expr;
                        String cont = SQLAnalyzer.getContent(n, src);
                        PDescriptor pd2 = new PDescriptor();
                        pd2.element = cont;
                        pd2.type = TYPE_COLUMN;
                        pd2.query_block_id = qb_id;
                        pd2.start = n.from;
                        SQLAnalyzer.parseContentForColumnAndAlias(n, src, pd2);
                        if (n.parent().contains(al_expr) && (all_expr = SQLAnalyzer.getContent(n.parent(), src)).length() > cont.length()) {
                            pd2.alias = all_expr.substring(cont.length());
                            if (pd2.alias.toUpperCase().startsWith("AS")) {
                                pd2.alias = pd2.alias.substring(2);
                            }
                        }
                        if (!pd2.valid) continue;
                        String name2 = pd2.toString();
                        cmap.put((CallSite)((Object)(qb_id + name2)), pd2);
                        continue;
                    }
                    if (n.contains("select_term") || parent == null || !parent.contains(param_spec) || !n.contains(unconstr_type)) continue;
                    pd = new PDescriptor();
                    pd.type = TYPE_TABLE;
                    pd.start = n.from;
                    SQLAnalyzer.parseContentForParameterSpec(n, src, pd);
                    if (!pd.valid) continue;
                    name = pd.toString();
                    if (tmap == null) {
                        tmap = new HashMap();
                    }
                    if (tmap.get(name) != null) continue;
                    list.add(pd);
                    tmap.put(name, pd);
                }
                for (Map.Entry ent : cmap.entrySet()) {
                    String lname;
                    PDescriptor pd = (PDescriptor)ent.getValue();
                    if (pd.schema != null && !pd.schema.isEmpty() && pd.table != null && !pd.table.isEmpty()) {
                        String lname2 = pd.toString();
                        if (c2map.get(lname2) != null) continue;
                        c2map.put(lname2, pd);
                        list.add(pd);
                        continue;
                    }
                    if (pd.table != null && !pd.table.isEmpty()) {
                        PDescriptor td = (PDescriptor)amap.get(pd.query_block_id + pd.table);
                        if (td == null) continue;
                        pd.schema = td.schema;
                        pd.table = td.name;
                        String lname3 = pd.toString();
                        if (c2map.get(lname3) != null) continue;
                        c2map.put(lname3, pd);
                        list.add(pd);
                        continue;
                    }
                    if (containers == null) continue;
                    ArrayList<PDescriptor> tables = new ArrayList<PDescriptor>();
                    Map map = (Map)amap.get(pd.query_block_id);
                    if (map == null) continue;
                    tables.addAll(map.values());
                    if (pd.table == null) {
                        SQLAnalyzer.resolveContainer(pd, schema, tables, containers);
                    }
                    if (pd.table == null || pd.table.isEmpty() || c2map.get(lname = pd.toString()) != null) continue;
                    c2map.put(lname, pd);
                    list.add(pd);
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        Collections.sort(list);
        return list;
    }

    public static void resolveContainer(PDescriptor cd, String schema, List<PDescriptor> tables, Map containers) {
        for (PDescriptor td : tables) {
            ContainerObject co;
            String name = td.name;
            Object lname = name;
            String usedSchema = null;
            if (td.schema != null && !td.schema.isEmpty()) {
                usedSchema = td.schema;
                lname = td.schema + "." + name;
            } else if (schema != null && !schema.isEmpty()) {
                usedSchema = schema;
                lname = schema + "." + name;
            }
            if ((co = (ContainerObject)containers.get(((String)lname).toUpperCase())) == null || co.getElementByName(cd.name) == null) continue;
            cd.table = name;
            if (usedSchema != null) {
                cd.schema = usedSchema;
            }
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        String sql = Service.readFile((String)"D:/test_view_2.sql");
        String tsql = TableView.getQuery(sql);
        SqlEarley earley = SqlEarley.getInstance();
        List src = LexerToken.parse((String)sql);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src, (Matriceable)matrix);
        ParseNode root = earley.forest(src, matrix);
        for (ParseNode n : root.descendants()) {
            PDescriptor pd;
            String cont;
            String tostr = n.toString();
            String[] split = tostr.split("  ");
            if (SQLAnalyzer.hasString(split, t_ref) || SQLAnalyzer.hasString(split, dml_table)) {
                cont = SQLAnalyzer.getContent(n, src);
                pd = new PDescriptor();
                pd.element = cont;
                SQLAnalyzer.parseContentForTable(n, src, pd);
                continue;
            }
            if (!SQLAnalyzer.hasString(split, u_funct) && !SQLAnalyzer.hasString(split, function_call) || (cont = n.content(src)).indexOf("(") <= 0) continue;
            pd = new PDescriptor();
            pd.element = cont;
            pd.type = TYPE_FUNCTION;
            SQLAnalyzer.parseContentForFunction(n, src, pd);
        }
        root.printTree();
        List<PDescriptor> list = SQLAnalyzer.getTablesAndColumns(sql, null, null);
        for (PDescriptor pd : list) {
            System.out.println(pd.toString());
        }
        System.out.println("======================================================================\n\n");
        list = SQLAnalyzer.getFirstColumnNamesAndTables(sql);
        for (PDescriptor pd : list) {
            if (!"11".equals(pd.query_block_id) || pd.condition) continue;
            System.out.println(pd.toString() + "^^^^ " + String.valueOf(pd.expression));
        }
    }

    public static class PDescriptor
    implements Comparable<PDescriptor> {
        public String element;
        public String type = "";
        public String schema;
        public String name;
        public String pack;
        public String alias;
        public String table;
        public int start = 0;
        boolean valid = false;
        public String query_block_id = "";
        public boolean condition = false;
        public boolean queryExpression = false;
        public String expression;

        int getSortValue() {
            return Integer.valueOf(this.query_block_id) * 100000 + this.start;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_COLUMN.equalsIgnoreCase(this.type)) {
                sb.append(String.valueOf(this.schema)).append(".").append(String.valueOf(this.table)).append(".").append(this.name).append(".").append(this.alias + " -- ").append(this.element);
            } else if (SQLAnalyzer.TYPE_TABLE.equalsIgnoreCase(this.type)) {
                sb.append(String.valueOf(this.schema)).append(".").append(".").append(this.name).append("--").append(this.alias);
            } else {
                sb.append(String.valueOf(this.schema)).append(".").append(String.valueOf(this.pack)).append(".").append(this.name);
            }
            return sb.toString().toUpperCase();
        }

        public String getColumnPrefix() {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_COLUMN.equalsIgnoreCase(this.type)) {
                if (this.schema != null) {
                    sb.append(String.valueOf(this.schema)).append(".");
                }
                if (this.table != null) {
                    sb.append(String.valueOf(this.table));
                }
            }
            return sb.toString();
        }

        public String getTableLongName() {
            return this.getTableLongName(null);
        }

        public String getTableLongName(String usedSchema) {
            StringBuffer sb = new StringBuffer();
            if (SQLAnalyzer.TYPE_TABLE.equalsIgnoreCase(this.type)) {
                if (this.schema != null) {
                    sb.append(String.valueOf(this.schema)).append(".");
                } else if (usedSchema != null) {
                    sb.append(String.valueOf(usedSchema)).append(".");
                }
                if (this.name != null) {
                    sb.append(String.valueOf(this.name));
                }
            }
            return sb.toString();
        }

        public String getTableIdentifier() {
            if (SQLAnalyzer.TYPE_TABLE.equalsIgnoreCase(this.type)) {
                if (this.alias != null && !this.alias.isEmpty()) {
                    return this.alias;
                }
                if (this.name != null) {
                    return this.getTableLongName();
                }
            }
            return null;
        }

        @Override
        public int compareTo(PDescriptor pd) {
            int sv2;
            int sv1 = this.getSortValue();
            if (sv1 < (sv2 = pd.getSortValue())) {
                return -1;
            }
            if (sv1 > sv2) {
                return 1;
            }
            return 0;
        }
    }
}

