/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.scheduling.SSBSchedulerJob;
import oracle.dbtools.crest.exports.ddl.scheduling.SSBSchedulerProgram;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.CSSBScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerJobCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;

public class CSSBSchedulerJob
extends CSSBScheduler {
    private static final String NAMED = "NAMED";
    private static final String WINDOW = "WINDOW";
    private static final String WINDOW_GROUP = "WINDOW_GROUP";
    private static final String ONCE = "ONCE";
    private static final String CALENDAR = "CALENDAR";
    private static final String EVENT = "EVENT";
    Map<String, String> excludeNullsMap = new HashMap<String, String>();

    public CSSBSchedulerJob() {
        this.excludeNullsMap.put("NUMBER_OF_ARGUMENTS", "NUMBER_OF_ARGUMENTS");
    }

    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new HashMap();
        }
        this.excludeMap.put("JOB_NAME", "JOB_NAME");
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("JOB_TYPE", "JOB_TYPE");
        this.excludeMap.put("JOB_ACTION", "JOB_ACTION");
        this.excludeMap.put("PROGRAM_NAME", "PROGRAM_NAME");
        this.excludeMap.put("PROGRAM_OWNER", "PROGRAM_OWNER");
        this.excludeMap.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.excludeMap.put("FILE_WATCHER_OWNER", "FILE_WATCHER_OWNER");
        this.excludeMap.put("SCHEDULE_TYPE", "SCHEDULE_TYPE");
        this.excludeMap.put("SCHEDULE_OWNER", "SCHEDULE_OWNER");
        this.excludeMap.put("SCHEDULE_NAME", "SCHEDULE_NAME");
        this.excludeMap.put("EVENT_QUEUE_OWNER", "EVENT_QUEUE_OWNER");
        this.excludeMap.put("EVENT_QUEUE_NAME", "EVENT_QUEUE_NAME");
        this.excludeMap.put("EVENT_QUEUE_AGENT", "EVENT_QUEUE_AGENT");
        this.excludeMap.put("EVENT_CONDITION", "EVENT_CONDITION");
        this.excludeMap.put("NUMBER_OF_ARGUMENTS", "NUMBER_OF_ARGUMENTS");
        this.excludeMap.put("CREDENTIAL_OWNER", "CREDENTIAL_OWNER");
        this.excludeMap.put("CREDENTIAL_NAME", "CREDENTIAL_NAME");
        this.excludeMap.put("CONNECT_CREDENTIAL_OWNER", "CONNECT_CREDENTIAL_OWNER");
        this.excludeMap.put("CONNECT_CREDENTIAL_NAME", "CONNECT_CREDENTIAL_NAME");
        this.excludeMap.put("DESTINATION", "DESTINATION");
        this.excludeMap.put("DESTINATION_OWNER", "DESTINATION_OWNER");
        this.excludeMap.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
        this.excludeMap.put("RAISE_EVENTS", "RAISE_EVENTS");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SchedulerJobCompare comp;
        if (object instanceof SchedulerJobCompare && (comp = (SchedulerJobCompare)object).isModified()) {
            Map<String, String> excludeMap = this.getExcludeMap();
            StringBuffer buffer = new StringBuffer();
            CSSBSchedulerJob.appendStringWithSpace(buffer, "BEGIN");
            boolean disabled = false;
            if (comp.hasAttributesToSetNull(this.excludeNullsMap)) {
                CSSBSchedulerJob.appendDisable(buffer, comp, prettyPrint);
                disabled = true;
            }
            CSSBSchedulerJob.appendScheduleNulify(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendNullAtrtributes(buffer, comp, prettyPrint, excludeMap);
            CSSBSchedulerJob.appendJobTypeAction(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendProgramName(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendSchedule(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendFileWatcherQueueSpec(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendEventQueueDetails(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendDestination(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendCredential(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendConnectCredential(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendAtrtributes(buffer, comp, prettyPrint, excludeMap);
            CSSBSchedulerJob.appendRaiseEventsAttribute(buffer, comp, prettyPrint);
            this.appendArguments(buffer, comp, (SchedulerJob)comp.getSource(), prettyPrint, excludeMap);
            CSSBSchedulerJob.appendEnable(buffer, comp, disabled, prettyPrint);
            CSSBSchedulerJob.appendNewLine(buffer, prettyPrint, 0);
            CSSBSchedulerJob.appendString(buffer, "END");
            CSSBSchedulerJob.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, "");
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerJob obj, boolean prettyPrint) {
        CSSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
        CSSBSchedulerJob.appendString(buffer, "job_name => '" + obj.getNameFormatted() + "'");
    }

    public static void appendProgramName(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String res;
        String[] arr = new String[]{"PROGRAM_OWNER", "PROGRAM_NAME"};
        if (comp.propertyChanged(arr) && (res = comp.getFormattedName("PROGRAM_OWNER", "PROGRAM_NAME")) != null && !res.isEmpty()) {
            CSSBSchedulerJob.nullifyJobTypeAction(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "program_name", res, "VARCHAR", prettyPrint);
        }
    }

    public static void nullifyProgramName(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String val = comp.getTarget().getProperty("PROGRAM_NAME");
        if (val != null && !val.isEmpty()) {
            CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "program_name", prettyPrint);
        }
    }

    public static void setNumberOfArgumentsToZero(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String val = comp.getTarget().getProperty("NUMBER_OF_ARGUMENTS");
        if (val == null) {
            CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "NUMBER_OF_ARGUMENTS", "0", "NUMBER", prettyPrint);
        }
    }

    public static void setNumberOfArguments(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String val = comp.getProperty("NUMBER_OF_ARGUMENTS");
        if (val != null && !val.isEmpty()) {
            CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "NUMBER_OF_ARGUMENTS", val, "NUMBER", prettyPrint);
        } else if (comp.containsNullProp("NUMBER_OF_ARGUMENTS")) {
            CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "NUMBER_OF_ARGUMENTS", prettyPrint);
        }
    }

    public static void appendJobTypeAction(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String action;
        String[] arr = new String[]{"JOB_TYPE", "JOB_ACTION"};
        if (comp.propertyChanged(arr)) {
            CSSBSchedulerJob.nullifyProgramName(buffer, comp, prettyPrint);
        }
        CSSBSchedulerJob.setNumberOfArguments(buffer, comp, prettyPrint);
        String type = comp.getProperty("JOB_TYPE");
        if (type != null) {
            CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "job_type", type, "VARCHAR", prettyPrint);
        }
        if ((action = comp.getProperty("JOB_ACTION")) != null) {
            CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "job_action", CSSBSchedulerJob.replaceSingle_Quote(action), "VARCHAR", prettyPrint);
        }
    }

    public static void nullifyJobTypeAction(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String val = comp.getTarget().getProperty("JOB_TYPE");
        boolean added = false;
        if (val != null && !val.isEmpty()) {
            CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "job_type", prettyPrint);
            added = true;
        }
        if ((val = comp.getTarget().getProperty("JOB_ACTION")) != null && !val.isEmpty()) {
            CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "job_action", prettyPrint);
            added = true;
        }
        if (added) {
            CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "NUMBER_OF_ARGUMENTS", prettyPrint);
        }
    }

    public static void appendFileWatcherQueueSpec(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String res;
        String type = comp.getProperty("SCHEDULE_TYPE");
        if (type != null && "FILE_WATCHER".equalsIgnoreCase(type) && (res = comp.getFormattedName("FILE_WATCHER_OWNER", "FILE_WATCHER_NAME")) != null && !res.isEmpty()) {
            String condition = comp.getProperty("EVENT_CONDITION");
            CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "event_spec", condition, null, prettyPrint, true, res, null);
        }
    }

    public static void appendSchedule(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String type = comp.getProperty("SCHEDULE_TYPE");
        if (type != null && !type.isEmpty()) {
            if (NAMED.equalsIgnoreCase(type)) {
                String schedName = comp.getFormattedName("SCHEDULE_OWNER", "SCHEDULE_NAME");
                if (schedName != null && !schedName.isEmpty()) {
                    CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "schedule_name", schedName, "VARCHAR", prettyPrint);
                }
            } else if (CALENDAR.equalsIgnoreCase(type)) {
                // empty if block
            }
        }
    }

    public static void appendScheduleNulify(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String oldType;
        SchedulerJob target = (SchedulerJob)comp.getTarget();
        String sched_type = comp.getProperty("SCHEDULE_TYPE");
        if (sched_type != null && (oldType = target.getProperty("SCHEDULE_TYPE")) != null && !oldType.isEmpty()) {
            switch (oldType) {
                case "NAMED": 
                case "WINDOW": 
                case "WINDOW_GROUP": {
                    if (!comp.containsNullProp("SCHEDULE_NAME")) break;
                    CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "SCHEDULE_NAME", prettyPrint);
                    break;
                }
                case "IMMEDIATE": 
                case "ONCE": 
                case "CALENDAR": {
                    break;
                }
                case "EVENT": 
                case "FILE_WATCHER": {
                    if (!comp.containsNullProp("EVENT_QUEUE_NAME")) break;
                    CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "event_queue_spec", prettyPrint);
                }
            }
        }
    }

    public static void appendConnectCredential(StringBuffer buffer, SchedulerJobCompare comp, boolean prettyPrint) {
        String[] arr = new String[]{"CONNECT_CREDENTIAL_OWNER", "CONNECT_CREDENTIAL_NAME"};
        boolean changed = comp.propertyChanged(arr);
        if (changed) {
            String res = comp.getFormattedName("CONNECT_CREDENTIAL_OWNER", "CONNECT_CREDENTIAL_NAME");
            if (comp.containsNullProp("CONNECT_CREDENTIAL_NAME") || res == null || res.isEmpty()) {
                CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "connect_credential_name", prettyPrint);
            } else {
                CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "connect_credential_name", res, null, prettyPrint);
            }
        }
    }

    public static void appendEventQueueDetails(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String[] arr = new String[]{"EVENT_QUEUE_OWNER", "EVENT_QUEUE_NAME", "EVENT_QUEUE_AGENT", "EVENT_CONDITION"};
        boolean changed = comp.propertyChanged(arr);
        if (changed && comp.containsNullProp("EVENT_QUEUE_NAME") && comp instanceof SchedulerJobCompare) {
            CSSBSchedulerJob.appendNullAtrtribute(buffer, comp, "event_spec", prettyPrint);
            return;
        }
        if (changed) {
            String res = comp.getEventQueueSpecFormattedFormatted();
            String type = comp.getProperty("SCHEDULE_TYPE");
            if (type == null && !comp.containsNullProp("SCHEDULE_TYPE")) {
                type = comp.getTarget().getProperty("SCHEDULE_TYPE");
            }
            if (!(type != null && "FILE_WATCHER".equalsIgnoreCase(type) || res == null || res.isEmpty())) {
                String condition = comp.getProperty("EVENT_CONDITION");
                CSSBSchedulerJob.appendSetAttribute(buffer, comp.getObjectFormattedName(), "event_spec", condition, null, prettyPrint, true, res, null);
            }
        }
    }

    public static void appendConnecCredentialAttribute(StringBuffer buffer, SchedulerJob job, boolean prettyPrint) {
        String res1 = job.getConnectCredentialNameFormatted();
        if (res1 != null && !res1.isEmpty()) {
            Object name = "";
            String owner = job.getOwner();
            if (owner != null && !owner.isEmpty()) {
                name = SchedulerObject.getFormatedSimpleName(owner) + ".";
            }
            name = (String)name + SchedulerObject.getFormatedSimpleName(job.getName());
            CSSBSchedulerJob.appendNewLine(buffer, prettyPrint, 1);
            CSSBSchedulerJob.appendStringWithSpace(buffer, "DBMS_SCHEDULER.SET_ATTRIBUTE(");
            CSSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            CSSBSchedulerJob.appendString(buffer, "NAME".toLowerCase() + " => '" + (String)name + "',");
            CSSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            CSSBSchedulerJob.appendString(buffer, "ATTRIBUTE".toLowerCase() + " => 'connect_credential_name',");
            CSSBSchedulerJob.appendNewLine(buffer, prettyPrint, 2);
            CSSBSchedulerJob.appendString(buffer, "VALUE".toLowerCase() + " => '" + res1 + "',");
            CSSBSchedulerJob.appendString(buffer, ");");
        }
    }

    public static void appendRaiseEventsAttribute(StringBuffer buffer, SchedulerObjectCompare cmp, boolean prettyPrint) {
        String res = cmp.getProperty("RAISE_EVENTS");
        int numb = SchedulerJob.getRaiseEventsNumber(res);
        if (numb > 0) {
            String name = cmp.getSource().getNameFormatted();
            CSSBSchedulerJob.appendSetAttribute(buffer, name, "RAISE_EVENTS", String.valueOf(numb), "NUMBER", prettyPrint);
        }
    }

    public void appendArguments(StringBuffer buffer, SchedulerJobCompare comp, SchedulerJob source, boolean prettyPrint, Map<String, String> excludeMap) {
        if (comp.getArgsToRemove().size() > 0) {
            for (SchedulerArgument arg : comp.getArgsToRemove()) {
                CSSBSchedulerJob.resetJobArgument(buffer, comp, arg, prettyPrint);
            }
        }
        for (SchedulerArgument arg : comp.getArgsToAdd()) {
            SSBSchedulerJob.appendJobArgument(buffer, source, arg, prettyPrint);
        }
    }

    public static void resetJobArgument(StringBuffer buffer, SchedulerJobCompare comp, SchedulerArgument arg, boolean prettyPrint) {
        CSSBSchedulerJob.appendNewLine(buffer, prettyPrint, 1);
        CSSBSchedulerJob.appendStringWithSpace(buffer, "DBMS_SCHEDULER.RESET_JOB_ARGUMENT_VALUE(");
        SSBSchedulerProgram.appendStringAttribute(buffer, "job_name".toLowerCase(), comp.getObjectFormattedName(), prettyPrint);
        CSSBSchedulerJob.appendString(buffer, ',');
        SSBSchedulerProgram.appendNonStringAttribute(buffer, "ARGUMENT_POSITION".toLowerCase(), arg.getProperty("ARGUMENT_POSITION"), prettyPrint);
        CSSBSchedulerJob.appendNewLine(buffer, prettyPrint, 1);
        CSSBSchedulerJob.appendStringWithSpace(buffer, ");");
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerJobCompare && ((SchedulerJobCompare)object).getSource() instanceof SchedulerJob;
    }

    public static String getNullJobActionDDL(String owner, String name, String formattedName) {
        String ddl = "    declare\r\n        value sys.all_scheduler_jobs.job_action%type;\r\n    begin\r\n        select job_action into value from sys.all_scheduler_jobs where owner = '<owner>' AND job_name = '<name>';\r\n        if value is not null then\r\n            DBMS_SCHEDULER.set_attribute_null( name => '<formatted_name>', attribute => 'job_action');\r\n        end if;\r\n    end;\r\n";
        ddl = ddl.replace("<owner>", owner).replace("<name>", name).replace("<formatted_name>", formattedName);
        return ddl;
    }

    public static String getNullProgramNameDDL(String owner, String name, String formattedName) {
        String ddl = "declare\r\n        pname sys.all_scheduler_jobs.program_name%type;\r\n    begin\r\n        select program_name into pname from sys.all_scheduler_jobs where owner = '<owner>' AND job_name = '<name>';\r\n        if pname is not null then\r\n            DBMS_SCHEDULER.set_attribute_null( name => '<formatted_name>', attribute => 'program_name');\r\n        end if;\r\n    end;\r\n";
        ddl = ddl.replace("<owner>", owner).replace("<name>", name).replace("<formatted_name>", formattedName);
        return ddl;
    }

    public static String getNullJobTypeDDL(String owner, String name, String formattedName) {
        String ddl = "    declare\r\n        value sys.all_scheduler_jobs.job_type%type;\r\n    begin\r\n        select job_type into value from sys.all_scheduler_jobs where owner = '<owner>' AND job_name = '<name>';\r\n        if value is not null then\r\n            DBMS_SCHEDULER.set_attribute_null( name => '<formatted_name>', attribute => 'job_type');\r\n        end if;";
        ddl = ddl.replace("<owner>", owner).replace("<name>", name).replace("<formatted_name>", formattedName);
        return ddl;
    }

    public static String getSetNumberOfArgumentsZeroDDl(String owner, String name, String formattedName) {
        String ddl = "    declare\r\n        value sys.all_scheduler_jobs.number_of_arguments%type;\r\n    begin\r\n        select number_of_arguments into value from sys.all_scheduler_jobs where owner = '<owner>' AND job_name = '<name>';\r\n        if value is null or value > 0 then\r\n            DBMS_SCHEDULER.set_attribute( name => '<formatted_name>', attribute => 'number_of_arguments', value => 0);\r\n        end if;\r\n    end;\r\n";
        ddl = ddl.replace("<owner>", owner).replace("<name>", name).replace("<formatted_name>", formattedName);
        return ddl;
    }
}

