/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.oracle.DBMS_MD_DDL_Extractor;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.model.persistence.LogicalDataTypesReader;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.wizards.reports.HTMLReportSingleFileWeb;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerator;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.jdbc.OracleDriver;

public class DiagramProcessor {
    private static String webPath = "/WEB-INF/datamodeler";
    static String CT_JSON = "application/json;charset=UTF-8";
    static String CT_TEXT = "text/plain;charset=UTF-8";
    static String CT_HTML = "text/html;charset=UTF-8";
    public static Map<String, String> PARAM_NAMES = DBMS_MD_DDL_Extractor.PARAM_NAMES;
    public static List<String> PARAM_LIST = DBMS_MD_DDL_Extractor.PARAM_LIST;
    static String FL_MODEL_DEF_ONLY = "basicDefinitionsOnly";
    static String FL_OBJECT_TYPES = "types";
    static String FL_PARTITIONS = "partitions";
    static String FL_TRIGGERS = "triggers";
    static String FL_SPATIAL = "spatial";
    static String FL_COMMENTS_RDBMS = "comments";
    static String FL_INCLUDE_DEFAULTS = "includeDefaultSettings";
    static String FL_STORAGE_DETAILS = "storage";
    static String FL_OBJECT_GRANTS = "obj_grants";
    static String FL_CONSTRAINTS = "constraints";
    static String FL_TABLES = "tables";
    static String FL_VIEWS = "views";
    static String FL_MVIEWS = "mviews";
    static String FL_MV_NN_NOTNULL_CONSRAINT = "mvnnconst";
    static String FL_MVLOGS = "mvlog";
    static String FL_PROC = "proc";
    static String FL_FUNC = "func";
    static String FL_PACK = "pack";
    static String FL_SEQ = "seq";
    static String FL_SYN = "syn";
    static String FL_PSYN = "psyn";
    static String FL_DIM = "dim";
    static String FL_CLUST = "clust";
    static String FL_INDEXES = "indexes";
    static String FL_BYTESIZE = "bytesize";
    static String FL_FORM_OPTIONS = "formOptions";
    static String FL_INCL_SCHEMA = "showschema";
    static String FL_ALL_DEPENDENT = "all_dependent";
    static String FL_SYSTEM_GEN_NAMES = "systemNames";
    static String FL_USE_DBMETADATA_DDL = "useDBMetadataDDL";
    static String FL_QUOTED_IDENTIFIERS = "quoted";

    public static void main(String[] args) {
        Design.dmInternalsDistDir = "D:/Projects/DMWS/DistributedData/datamodeler";
        Design.dmInternalsDistDir = "D:/ProjectsGit/development/ORDS/dbtools-commons/modeler/src/main/resources/datamodeler";
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1522/pdb19.osddm", "SCHED_DEMO_USER", "SCHED_DEMO_USER");
            String diagram = DiagramProcessor.testDiagramForSchema(conn, false);
            DiagramProcessor.testDiagramFromDB(conn, true);
            DiagramProcessor.testThumbnailFromDB(conn, true);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public static String returnSchemaDiagram(Connection conn, boolean inclTOC, boolean inclTables, boolean inclViews, boolean dmwdef, String schema) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(schema);
            MetaFileLoader.DMWEB = true;
            Design des = DiagramProcessor.getDesign(false, false, false);
            RelationalDesign relModel = DiagramProcessor.importObjects(conn, des, list, inclTables, inclViews, false);
            Settings set = relModel.getDesign().getSettings();
            set.setGenerateHTMLReportTOCInSeparateFile(false);
            set.setIncludeSelectStatementInViewReport(true);
            DiagramToSVG.initNumIDs(relModel);
            DPVRelational dpv = new DPVRelational(relModel);
            DiagramProcessor.addTablesToDPV(relModel, dpv, dmwdef);
            dpv.rearrangeNewDiagram();
            TreeMap<String, DesignObject> map = new TreeMap<String, DesignObject>();
            String diagram = null;
            String idSufix = "";
            if (dpv != null) {
                if (inclTOC) {
                    for (TopView tv : dpv.getTVTablesAndTVViews()) {
                        DesignObject obj = tv.getModel();
                        map.put(obj.getLongName(), obj);
                    }
                }
                diagram = DiagramToSVG.getSVGForDiagram(dpv, true, idSufix, dmwdef);
            }
            StringBuffer buf = HTMLReportSingleFileWeb.createHTML(map, null, diagram, idSufix, null);
            return buf.toString();
        }
        catch (Exception e) {
            Logger.error(e);
            return "";
        }
    }

    public static void returnSchemaReport(Connection conn, OutputStream outStream, boolean inclTOC, boolean inclTables, boolean inclViews, boolean dmwdef, boolean inclDiagram, boolean inclComments, String schema) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(schema);
        MetaFileLoader.DMWEB = true;
        Design des = DiagramProcessor.getDesign(false, false, false);
        RelationalDesign relModel = DiagramProcessor.importObjects(conn, des, list, inclTables, inclViews, inclComments);
        Settings set = relModel.getDesign().getSettings();
        set.setGenerateHTMLReportTOCInSeparateFile(false);
        set.setIncludeSelectStatementInViewReport(true);
        DiagramToSVG.initNumIDs(relModel);
        DPVRelational dpv = null;
        if (inclDiagram) {
            dpv = new DPVRelational(relModel);
            DiagramProcessor.addTablesToDPV(relModel, dpv, dmwdef);
            dpv.rearrangeNewDiagram();
        }
        try {
            DiagramProcessor.returnReport(conn, outStream, relModel, dpv, inclTOC, inclTables, inclViews, dmwdef, "Report for schema " + schema, null);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    static String testDiagramForSchema(Connection conn, boolean dmwdef) {
        try {
            String schema = "HR";
            ArrayList<String> list = new ArrayList<String>();
            list.add("HR");
            Design des = DiagramProcessor.getDesign(false, false, false);
            ArrayList names = new ArrayList();
            RelationalDesign relModel = DiagramProcessor.importObjects(conn, des, list, true, true, true, names);
            Settings set = relModel.getDesign().getSettings();
            set.setGenerateHTMLReportTOCInSeparateFile(false);
            set.setIncludeSelectStatementInViewReport(true);
            DiagramToSVG.initNumIDs(relModel);
            DPVRelational dpv = new DPVRelational(relModel);
            DiagramProcessor.addTablesToDPV(relModel, dpv, dmwdef);
            dpv.rearrangeNewDiagram();
            TreeMap<String, String> map = new TreeMap<String, String>();
            String diagram = null;
            String idSufix = "";
            if (dpv != null) {
                for (TopView tv : dpv.getTVTablesAndTVViews()) {
                    DesignObject obj = tv.getModel();
                    map.put(obj.getLongName(), obj.getName());
                }
                diagram = DiagramToSVG.getSVGForDiagram(dpv, false, idSufix, dmwdef);
            }
            StringBuffer buf = HTMLReportSingleFileWeb.createHTML(null, null, diagram, idSufix, null);
            FileWriter fw = new FileWriter("d:/dmweb_svg_schema_diagr.html");
            fw.write(buf.toString());
            fw.flush();
            fw.close();
            File file = new File("d:/dmweb_svg_schema_rep.html");
            FileOutputStream fou = new FileOutputStream(file);
            DiagramToSVG.diagramToSVG((DesignPartView)dpv, "d:/dmweb_svg_44.html", false);
            DiagramProcessor.returnReport(conn, fou, relModel, dpv, true, true, true, dmwdef, "Report for schema " + schema, null);
            fou.flush();
            fou.close();
            return diagram;
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    private static void testDiagramFromDB(Connection conn, boolean dmwdef) {
        try {
            String id = "4";
            DHelper dh = DiagramProcessor.getDiagramHelperFromDB(conn, id);
            String layout = dh.layout;
            ArrayList<String> tables = new ArrayList<String>();
            ArrayList<String> views = new ArrayList<String>();
            ArrayList<String> ext_tables = new ArrayList<String>();
            ArrayList<DiagramToSVG.Line> lines = new ArrayList<DiagramToSVG.Line>();
            ArrayList<JoinsHolder> jholders = new ArrayList<JoinsHolder>();
            DiagramProcessor.getObjectsFomLayout(layout, tables, views, ext_tables, lines, jholders);
            RelationalDesign relModel = DiagramProcessor.importObjects(conn, tables, views, ext_tables, true);
            Settings set = relModel.getDesign().getSettings();
            set.setGenerateHTMLReportTOCInSeparateFile(false);
            set.setIncludeSelectStatementInViewReport(true);
            DiagramToSVG.initNumIDs(relModel);
            DPVRelational dpv = DiagramProcessor.createDiagram(relModel, layout);
            TreeMap<String, String> map = new TreeMap<String, String>();
            String diagram = null;
            String idSufix = "";
            if (dpv != null) {
                for (TopView tv : dpv.getTVTablesAndTVViews()) {
                    DesignObject obj = tv.getModel();
                    map.put(obj.getLongName(), obj.getName());
                }
                diagram = DiagramToSVG.getSVGForDiagram(dpv, true, idSufix, dmwdef);
            }
            StringBuffer buf = HTMLReportSingleFileWeb.createHTML(null, null, diagram, idSufix, null);
            BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("d:/dmweb_svg_45_diagr.html"), "UTF-8"));
            fw.write(buf.toString());
            ((Writer)fw).flush();
            ((Writer)fw).close();
            File file = new File("d:/dmweb_svg_44_1rep.html");
            FileOutputStream fou = new FileOutputStream(file);
            DiagramProcessor.returnReport(conn, fou, relModel, dpv, true, true, true, false, "Report for diagram " + dh.name, null);
            fou.flush();
            fou.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error(e);
        }
    }

    private static void testThumbnailFromDB(Connection conn, boolean dmwdef) {
        try {
            String id = "3";
            String layout = DiagramProcessor.getLayoutFromDB(conn, id);
            DiagramToSVG.DiagramThumbnailModel dm = DiagramProcessor.createDiagramThumbnailModel(layout);
            Rectangle2D.Double dim = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
            String diagram = DiagramToSVG.getSVGThumbnailFromModel(dm, "diagram_" + id, dim, false, dmwdef);
            FileWriter fw = new FileWriter("d:/dmweb_svg_2721_diagr_thumbn.html");
            fw.write("<html>");
            fw.write(diagram);
            String tn_test = DiagramToSVG.THUMBNAIL_TEST.replaceAll("#diagramxxxid", "#diagram_" + id);
            String width = "" + (int)(((RectangularShape)dim).getWidth() + 5.0);
            String height = "" + (int)(((RectangularShape)dim).getHeight() + 5.0);
            tn_test = tn_test.replace("def_width", width);
            tn_test = tn_test.replace("def_height", height);
            fw.write(tn_test);
            fw.write("</html>");
            fw.flush();
            fw.close();
            fw = new FileWriter("d:/dmweb_svg_45_diagr_thumbn_nosymbol.html");
            fw.write("<html>");
            byte[] enc = Base64.getEncoder().encode(diagram.getBytes(StandardCharsets.UTF_8));
            String str = new String(enc, StandardCharsets.UTF_8);
            String str3 = new String(enc, StandardCharsets.ISO_8859_1);
            byte[] dec = Base64.getDecoder().decode(enc);
            String diag2 = new String(dec, StandardCharsets.UTF_8);
            str3.equals(str);
            String img = "<img src=\"data:image/svg+xml;charset=utf-8;base64," + str + "\"/>";
            fw.write(img);
            fw.write("</html>");
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public static void createThumbnailTestfromDB(Connection conn, Writer wr, String id, boolean asSymbol) {
        String layout = DiagramProcessor.getLayoutFromDB(conn, id);
        DiagramProcessor.createThumbnailTest(id, layout, wr, asSymbol, true);
    }

    public static void createThumbnailTest(String id, String layout, Writer wr, boolean asSymbol, boolean dmwdef) {
        try {
            DiagramToSVG.DiagramThumbnailModel dm = DiagramProcessor.createDiagramThumbnailModel(layout);
            Rectangle2D.Double dim = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
            String diagram = DiagramToSVG.getSVGThumbnailFromModel(dm, "diagram_" + id, dim, asSymbol, dmwdef);
            wr.write("<html>");
            wr.write(diagram);
            String tn_test = DiagramToSVG.THUMBNAIL_TEST.replaceAll("#diagramxxxid", "#diagram_" + id);
            String width = "" + (int)(((RectangularShape)dim).getWidth() + 5.0);
            String height = "" + (int)(((RectangularShape)dim).getHeight() + 5.0);
            tn_test = tn_test.replace("def_width", width);
            tn_test = tn_test.replace("def_height", height);
            wr.write(tn_test);
            wr.write("</html>");
            wr.flush();
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public static String getThumbnailFromLayoutEncoded(String id, String layout) {
        return DiagramProcessor.getThumbnailFromLayoutEncoded(id, layout, true);
    }

    public static String getThumbnailFromLayoutEncoded(String id, String layout, boolean dmwdef) {
        try {
            DiagramToSVG.DiagramThumbnailModel dm = DiagramProcessor.createDiagramThumbnailModel(layout);
            Rectangle2D.Double dim = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
            String diagram = DiagramToSVG.getSVGThumbnailFromModel(dm, "diagram_" + id, dim, false, dmwdef);
            byte[] enc = Base64.getEncoder().encode(diagram.getBytes(StandardCharsets.UTF_8));
            return new String(enc, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    List<DBObject> getObjectsForSchemas(List<String> schemas, boolean itables, boolean iviews) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        return list;
    }

    public static void createDiagramFromDB(Connection conn, String id, Writer wr, boolean createTOC, boolean dmwebdef) {
        String layout = DiagramProcessor.getLayoutFromDB(conn, id);
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> views = new ArrayList<String>();
        ArrayList<String> ext_tables = new ArrayList<String>();
        ArrayList<DiagramToSVG.Line> lines = new ArrayList<DiagramToSVG.Line>();
        DiagramProcessor.getObjectsFomLayout(layout, tables, views, ext_tables, lines, null);
        RelationalDesign relModel = DiagramProcessor.importObjects(conn, tables, views, ext_tables, false);
        relModel.getDesign().getSettings().setGenerateHTMLReportTOCInSeparateFile(false);
        DiagramToSVG.initNumIDs(relModel);
        DPVRelational dpv = DiagramProcessor.createDiagram(relModel, layout);
        if (createTOC) {
            TreeMap<String, DesignObject> map = new TreeMap<String, DesignObject>();
            String diagram = null;
            String idSufix = "";
            if (dpv != null) {
                for (TopView tv : dpv.getTVTables()) {
                    DesignObject obj = tv.getModel();
                    map.put(obj.getLongName(), obj);
                }
                diagram = DiagramToSVG.getSVGForDiagram(dpv, true, idSufix, dmwebdef, lines);
            }
            StringBuffer buf = HTMLReportSingleFileWeb.createHTML(map, null, diagram, idSufix, null);
            try {
                wr.write(buf.toString());
            }
            catch (IOException e) {
                Logger.error(e);
            }
        } else {
            DiagramToSVG.diagramToSVG((DesignPartView)dpv, wr, false);
        }
    }

    static void createReportFromDB(Connection conn, String id, Writer wr, boolean dmwdef) {
        String layout = DiagramProcessor.getLayoutFromDB(conn, id);
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> views = new ArrayList<String>();
        ArrayList<String> ext_tables = new ArrayList<String>();
        ArrayList<DiagramToSVG.Line> lines = new ArrayList<DiagramToSVG.Line>();
        ArrayList<JoinsHolder> jholders = new ArrayList<JoinsHolder>();
        DiagramProcessor.getObjectsFomLayout(layout, tables, views, ext_tables, lines, jholders);
        RelationalDesign relModel = DiagramProcessor.importObjects(conn, tables, views, ext_tables, true);
        relModel.getDesign().getSettings().setGenerateHTMLReportTOCInSeparateFile(false);
        DiagramToSVG.initNumIDs(relModel);
        DPVRelational dpv = DiagramProcessor.createDiagram(relModel, layout);
        DiagramToSVG.diagramToSVG((DesignPartView)dpv, wr, false);
    }

    static void addTablesToDPV(RelationalDesign rm, DPVRelational dpv, boolean dmwdef) {
        TopView tv;
        TopView tv2;
        FKContainer cont;
        dmwdef = true;
        Iterator it = rm.getTableSet().iterator();
        while (it.hasNext()) {
            cont = (FKContainer)it.next();
            tv2 = dpv.createTopViewFor(cont);
            if (!dmwdef) continue;
            DiagramToSVG.setDMWebDefForTV(tv2);
        }
        it = rm.getTableViewSet().iterator();
        while (it.hasNext()) {
            cont = (FKContainer)it.next();
            tv2 = dpv.createTopViewFor(cont);
            if (!dmwdef) continue;
            DiagramToSVG.setDMWebDefForTV(tv2);
        }
        it = rm.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            TVFKRelation fkv;
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            TopView stv = dpv.getFirstViewFor(fk.getSourceObject());
            TopView ttv = dpv.getFirstViewFor(fk.getTargetObject());
            if (stv == null || ttv == null) continue;
            try {
                fk.setSourceTVTable((ContainerView)stv);
                fk.setTargetTVTable((ContainerView)ttv);
            }
            catch (Exception e) {
                Logger.error(e);
            }
            tv = fk.getViewFor(dpv);
            if (tv != null) {
                if (!dpv.getTopviewsList().contains(tv)) {
                    dpv.add(tv);
                }
                if (dmwdef) {
                    DiagramToSVG.setDMWebDefForTV(tv);
                }
            }
            if ((fkv = (TVFKRelation)fk.getViewFor(dpv)) == null) continue;
        }
        it = rm.getTypeSubstitutionSet().iterator();
        while (it.hasNext()) {
            TypeSubstitution ts = (TypeSubstitution)it.next();
            ContainerView childTV = (ContainerView)dpv.getFirstViewFor(ts.getChildContainerObject());
            ContainerView parentTV = (ContainerView)dpv.getFirstViewFor(ts.getParentContainerObject());
            ts.setChildCV(childTV);
            ts.setParentCV(parentTV);
            tv = ts.getViewFor(dpv);
            if (tv == null || dpv.getTopviewsList().contains(tv)) continue;
            dpv.add(tv);
        }
    }

    /*
     * Unable to fully structure code
     */
    static DPVRelational createDiagram(RelationalDesign rm, String layout) {
        TimeLog.log("createDiagram start");
        dpv = new DPVRelational(rm);
        if (layout != null && !layout.isEmpty()) {
            map = new HashMap<CallSite, TopView>();
            d = 40;
            ts = rm.getTableSet();
            stream = new ByteArrayInputStream(layout.getBytes(StandardCharsets.UTF_8));
            jo = Json.createReader((InputStream)stream).readObject();
            ja = jo.getJsonArray("items");
            size = ja.size();
            ** if (ja == null) goto lbl276
            for (i = 0; i < size; ++i) {
                job = ja.getJsonObject(i);
                type = job.getString("type");
                if ("TABLE".equalsIgnoreCase(type)) {
                    name = job.getString("name");
                    schema = job.getString("schema");
                    name = Token.getName(name);
                    schema = Token.getName(schema);
                    ext = job.getBoolean("external", false);
                    table = ts.getBySchemaAndName(schema, name);
                    if (table == null) continue;
                    tv = null;
                    jbounds = job.getJsonObject("bounds");
                    if (jbounds != null) {
                        jnum = jbounds.getJsonNumber("x");
                        x = jnum.intValue();
                        jnum = jbounds.getJsonNumber("y");
                        y = jnum.intValue();
                        jnum = jbounds.getJsonNumber("width");
                        width = jnum.intValue();
                        jnum = jbounds.getJsonNumber("height");
                        height = jnum.intValue();
                        tv = dpv.createTopViewFor(table);
                        r = new Rectangle(x + d, y + d, width, height);
                        tv.setBounds(r);
                        map.put((CallSite)(schema + "." + name), tv);
                    }
                    if (tv == null) continue;
                    jvn = job.getJsonNumber("viewNum");
                    if (jvn != null && (vnum = jvn.intValue()) > 0) {
                        tv.setViewNumber(vnum);
                    }
                    try {
                        cf = job.getBoolean("useCustomFormat");
                        dc = job.getBoolean("useDefaultColor");
                        tv.setUseCustomFormat(cf);
                        tv.setUseDefaultColor(dc);
                    }
                    catch (Exception e) {
                        tv.setUseCustomFormat(true);
                        tv.setUseDefaultColor(false);
                    }
                    bcol = 0;
                    fcol = 0;
                    try {
                        bcol = job.getJsonNumber("bgColor").intValue();
                        fcol = job.getJsonNumber("fgColor").intValue();
                    }
                    catch (Exception e) {
                        Logger.error(e);
                    }
                    try {
                        try {
                            bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            bgopacity = 1.0;
                        }
                        try {
                            fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            fgopacity = 1.0;
                        }
                        ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                        tv.setBackgroundColor(new Color(ncolor, true));
                        ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                        tv.setForegroundColor(new Color(ncolor, true));
                    }
                    catch (Exception e) {
                        Logger.error(e);
                        tv.setBackgroundColor(new Color(bcol));
                        tv.setForegroundColor(new Color(fcol));
                    }
                    continue;
                }
                if ("VIEW".equalsIgnoreCase(type)) {
                    name = job.getString("name");
                    schema = job.getString("schema");
                    name = Token.getName(name);
                    schema = Token.getName(schema);
                    view = (TableView)rm.getTableViewSet().getBySchemaAndName(schema, name);
                    if (view == null) continue;
                    tv = null;
                    jbounds = job.getJsonObject("bounds");
                    if (jbounds != null) {
                        jnum = jbounds.getJsonNumber("x");
                        x = jnum.intValue();
                        jnum = jbounds.getJsonNumber("y");
                        y = jnum.intValue();
                        jnum = jbounds.getJsonNumber("width");
                        width = jnum.intValue();
                        jnum = jbounds.getJsonNumber("height");
                        height = jnum.intValue();
                        tv = dpv.createTopViewFor(view);
                        r = new Rectangle(x + d, y + d, width, height);
                        tv.setBounds(r);
                        map.put((CallSite)(schema + "." + name), tv);
                    }
                    if (tv == null) continue;
                    jvn = job.getJsonNumber("viewNum");
                    if (jvn != null && (vnum = jvn.intValue()) > 0) {
                        tv.setViewNumber(vnum);
                    }
                    try {
                        cf = job.getBoolean("useCustomFormat");
                        dc = job.getBoolean("useDefaultColor");
                        tv.setUseCustomFormat(cf);
                        tv.setUseDefaultColor(dc);
                    }
                    catch (Exception e) {
                        tv.setUseCustomFormat(true);
                        tv.setUseDefaultColor(false);
                    }
                    bcol = job.getJsonNumber("bgColor").intValue();
                    fcol = job.getJsonNumber("fgColor").intValue();
                    try {
                        try {
                            bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            bgopacity = 1.0;
                        }
                        try {
                            fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            fgopacity = 1.0;
                        }
                        c = DiagramToSVG.ColorUtil.getColor(bcol, (int)(bgopacity * 255.0));
                        tv.setBackgroundColor(c);
                        c = DiagramToSVG.ColorUtil.getColor(fcol, (int)(fgopacity * 255.0));
                        tv.setForegroundColor(c);
                    }
                    catch (Exception e1) {
                        tv.setBackgroundColor(new Color(bcol));
                        tv.setForegroundColor(new Color(fcol));
                    }
                    continue;
                }
                if ("NOTE".equalsIgnoreCase(type)) {
                    tv = null;
                    viewID = job.getString("viewID");
                    text = job.getString("text");
                    fsize = job.getJsonNumber("fontSize");
                    note = rm.createNote();
                    note.setComment(text);
                    jbounds = job.getJsonObject("bounds");
                    if (jbounds != null) {
                        jnum = jbounds.getJsonNumber("x");
                        x = jnum.intValue();
                        jnum = jbounds.getJsonNumber("y");
                        y = jnum.intValue();
                        jnum = jbounds.getJsonNumber("width");
                        width = jnum.intValue();
                        jnum = jbounds.getJsonNumber("height");
                        height = jnum.intValue();
                        tv = (TVNote)dpv.createTopViewFor(note);
                        r = new Rectangle(x + d, y + d, width, height);
                        tv.setBounds(r);
                    }
                    if (tv == null) continue;
                    tv.setUseDefaultColor(false);
                    tv.setUseCustomFormat(true);
                    tcol = 0;
                    textColor = Color.BLACK;
                    jn1 = job.getJsonNumber("textColor");
                    if (jn1 != null) {
                        tcol = jn1.intValue();
                        textColor = new Color(tcol);
                    }
                    try {
                        topacity = job.getJsonNumber("textOpacity").doubleValue();
                    }
                    catch (Exception e) {
                        topacity = 1.0;
                    }
                    tcolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(tcol, (int)(topacity * 255.0));
                    textColor = new Color(tcolor, true);
                    bcol = 0;
                    fcol = 0;
                    jn = job.getJsonNumber("bgColor");
                    if (jn != null) {
                        bcol = jn.intValue();
                        bgCol = new Color(bcol);
                    } else {
                        bgCol = Color.GRAY;
                    }
                    jn = job.getJsonNumber("fgColor");
                    if (jn != null) {
                        fcol = jn.intValue();
                        fgCol = new Color(fcol);
                    } else {
                        fgCol = Color.BLACK;
                    }
                    try {
                        try {
                            bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            bgopacity = 1.0;
                        }
                        try {
                            fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            fgopacity = 1.0;
                        }
                        ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                        tv.setBackgroundColor(new Color(ncolor, true));
                        ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                        tv.setForegroundColor(new Color(ncolor, true));
                        fo = tv.getFontObject(EditableFonts.FO_TITLE);
                        fo.setColor(textColor);
                        if (fsize == null) continue;
                        fontSize = fsize.intValue();
                        fo.setFont(fo.getFont().deriveFont(fontSize));
                    }
                    catch (Exception e) {
                        Logger.error(e);
                        tv.setBackgroundColor(new Color(bcol));
                        tv.setForegroundColor(new Color(fcol));
                    }
                    continue;
                }
                if (!"RELATION".equalsIgnoreCase(type)) continue;
                name = job.getString("name");
                name = Token.getName(name);
                sourceID = job.getString("sourceID");
                targetID = job.getString("targetID");
                stv = (ContainerView)map.get(sourceID);
                ttv = (ContainerView)map.get(targetID);
                fk = (FKIndexAssociation)rm.getFKIndexAssociationSet().getByName(name);
                if (fk == null || stv == null || ttv == null) continue;
                try {
                    fk.setSourceTVTable(stv);
                    fk.setTargetTVTable(ttv);
                }
                catch (Exception e) {
                    Logger.error(e);
                }
                tv = fk.getViewFor(dpv);
                if (tv != null && !dpv.getTopviewsList().contains(tv)) {
                    dpv.add(tv);
                }
                if ((fkv = (TVFKRelation)fk.getViewFor(dpv)) == null) continue;
                try {
                    fkv.setUseCustomFormat(true);
                    fkv.setUseDefaultColor(false);
                    bcol = job.getJsonNumber("color").intValue();
                    width = job.getJsonNumber("width").intValue();
                    try {
                        opacity = job.getJsonNumber("opacity").doubleValue();
                    }
                    catch (Exception e) {
                        opacity = 1.0;
                    }
                    c = DiagramToSVG.ColorUtil.getColor(bcol, (int)(opacity * 255.0));
                    fkv.setForegroundColor(c);
                    fkv.setLineWidth(width);
                }
                catch (Exception e) {
                    Logger.error(e);
                }
                points = fkv.getEdgePoints();
                sp = job.getJsonObject("sourcePort");
                if (sp != null) {
                    x = sp.getJsonNumber("x").doubleValue();
                    y = sp.getJsonNumber("y").doubleValue();
                    p = new Point2D.Double(x + (double)d, y + (double)d);
                    points.add(p);
                }
                if ((jv = job.getJsonArray("vertices")) != null) {
                    for (k = 0; k < jv.size(); ++k) {
                        jp = jv.getJsonObject(k);
                        x = jp.getJsonNumber("x").doubleValue();
                        y = jp.getJsonNumber("y").doubleValue();
                        p = new Point2D.Double(x + (double)d, y + (double)d);
                        points.add(p);
                    }
                }
                if ((sp = job.getJsonObject("targetPort")) == null) continue;
                x = sp.getJsonNumber("x").doubleValue();
                y = sp.getJsonNumber("y").doubleValue();
                p = new Point2D.Double(x + (double)d, y + (double)d);
                points.add(p);
                stv.addConnection(p, fkv);
                ttv.addConnection(p, fkv);
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl276:
        // 4 sources

        TimeLog.log("createDiagram end");
        return dpv;
    }

    static void dtmProcessTable(DiagramToSVG.DiagramThumbnailModel dm, JsonObject job, int d) {
        String name = job.getString("name");
        String schema = job.getString("schema");
        name = Token.getName(name);
        schema = Token.getName(schema);
        boolean ext = job.getBoolean("external", false);
        DiagramToSVG.Shape tv = null;
        JsonObject jbounds = job.getJsonObject("bounds");
        if (jbounds != null) {
            JsonNumber jnum = jbounds.getJsonNumber("x");
            int x = jnum.intValue();
            jnum = jbounds.getJsonNumber("y");
            int y = jnum.intValue();
            jnum = jbounds.getJsonNumber("width");
            int width = jnum.intValue();
            jnum = jbounds.getJsonNumber("height");
            int height = jnum.intValue();
            tv = new DiagramToSVG.Shape();
            tv.name = name;
            tv.schema = schema;
            tv.bounds = new Rectangle(x + d, y + d, width, height);
            dm.shapes.add(tv);
        }
        if (tv != null) {
            int bcol;
            JsonNumber jn;
            int vnum;
            JsonNumber jvn = job.getJsonNumber("viewNum");
            if (jvn != null && (vnum = jvn.intValue()) > 0) {
                tv.vnum = vnum;
            }
            if ((jn = job.getJsonNumber("bgColor")) != null) {
                bcol = jn.intValue();
                tv.bgCol = new Color(bcol);
            } else {
                tv.bgCol = Color.yellow;
            }
            jn = job.getJsonNumber("fgColor");
            if (jn != null) {
                int fcol = jn.intValue();
                tv.fgCol = new Color(fcol);
            } else {
                tv.fgCol = Color.blue;
            }
            bcol = job.getJsonNumber("bgColor").intValue();
            int fcol = job.getJsonNumber("fgColor").intValue();
            try {
                double fgopacity;
                double bgopacity;
                try {
                    bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                }
                catch (Exception e) {
                    bgopacity = 1.0;
                }
                try {
                    fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                }
                catch (Exception e) {
                    fgopacity = 1.0;
                }
                int ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                tv.bgCol = new Color(ncolor, true);
                ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                tv.fgCol = new Color(ncolor, true);
            }
            catch (Exception e) {
                Logger.error(e);
                tv.bgCol = new Color(bcol);
                tv.fgCol = new Color(fcol);
            }
        }
    }

    static void processRelation(DiagramToSVG.DiagramThumbnailModel dm, JsonObject job, int d, String type) {
        JsonArray jv;
        Point2D.Double p;
        double x;
        String style22;
        DiagramToSVG.Line line = new DiagramToSVG.Line();
        dm.lines.add(line);
        List<Point2D> points = line.points;
        String name = job.getString("name");
        line.name = name = Token.getName(name);
        if (!"REFERENCE".equalsIgnoreCase(type)) {
            String sourceID = job.getString("sourceID");
            String targetID = job.getString("targetID");
            line.sourceID = sourceID;
            line.targetID = targetID;
        }
        String sourceViewID = job.getString("sourceViewID");
        String targetViewID = job.getString("targetViewID");
        line.sourceViewID = sourceViewID;
        line.targetViewID = targetViewID;
        try {
            double topacity;
            int tcol = 0;
            JsonNumber jn1 = job.getJsonNumber("color");
            if (jn1 != null) {
                tcol = jn1.intValue();
                line.fgCol = new Color(tcol);
            } else {
                line.fgCol = Color.BLACK;
            }
            try {
                topacity = job.getJsonNumber("opacity").doubleValue();
            }
            catch (Exception e) {
                topacity = 1.0;
            }
            int tcolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(tcol, (int)(topacity * 255.0));
            line.fgCol = new Color(tcolor, true);
        }
        catch (Exception tcol) {
            // empty catch block
        }
        JsonValue st = (JsonValue)job.get((Object)"style");
        if (st != null && (style22 = ((JsonString)st).getString()) != null) {
            line.dashed = "dash".equalsIgnoreCase(style22);
        }
        if ("REFERENCE".equalsIgnoreCase(type)) {
            line.dashed = true;
            line.dashArray = "2,6";
        }
        try {
            line.width = job.getJsonNumber("width").intValue();
        }
        catch (Exception style22) {
            // empty catch block
        }
        JsonObject sp = null;
        sp = "REFERENCE".equalsIgnoreCase(type) ? job.getJsonObject("targetPort") : job.getJsonObject("sourcePort");
        if (sp != null) {
            x = sp.getJsonNumber("x").doubleValue();
            double y = sp.getJsonNumber("y").doubleValue();
            p = new Point2D.Double(x + (double)d, y + (double)d);
            points.add(p);
        }
        if ((jv = job.getJsonArray("vertices")) != null) {
            for (int k = 0; k < jv.size(); ++k) {
                JsonObject jp = jv.getJsonObject(k);
                x = jp.getJsonNumber("x").doubleValue();
                double y = jp.getJsonNumber("y").doubleValue();
                p = new Point2D.Double(x + (double)d, y + (double)d);
                points.add(p);
            }
        }
        if ((sp = "REFERENCE".equalsIgnoreCase(type) ? job.getJsonObject("sourcePort") : job.getJsonObject("targetPort")) != null) {
            x = sp.getJsonNumber("x").doubleValue();
            double y = sp.getJsonNumber("y").doubleValue();
            p = new Point2D.Double(x + (double)d, y + (double)d);
            points.add(p);
        }
    }

    static DiagramToSVG.DiagramThumbnailModel createDiagramThumbnailModel(String layout) {
        DiagramToSVG.DiagramThumbnailModel dm = new DiagramToSVG.DiagramThumbnailModel();
        if (layout != null && !layout.isEmpty()) {
            int d = 5;
            ByteArrayInputStream stream = new ByteArrayInputStream(layout.getBytes(StandardCharsets.UTF_8));
            JsonObject jo = Json.createReader((InputStream)stream).readObject();
            JsonArray ja = jo.getJsonArray("items");
            if (ja != null) {
                int size = ja.size();
                for (int i = 0; i < size; ++i) {
                    double topacity;
                    int vnum;
                    JsonObject job = ja.getJsonObject(i);
                    String type = job.getString("type");
                    if ("TABLE".equalsIgnoreCase(type)) {
                        DiagramProcessor.dtmProcessTable(dm, job, d);
                        continue;
                    }
                    if ("VIEW".equalsIgnoreCase(type)) {
                        int vnum2;
                        String name = job.getString("name");
                        String schema = job.getString("schema");
                        name = Token.getName(name);
                        schema = Token.getName(schema);
                        DiagramToSVG.Shape tv = null;
                        JsonObject jbounds = job.getJsonObject("bounds");
                        if (jbounds != null) {
                            JsonNumber jnum = jbounds.getJsonNumber("x");
                            int x = jnum.intValue();
                            jnum = jbounds.getJsonNumber("y");
                            int y = jnum.intValue();
                            jnum = jbounds.getJsonNumber("width");
                            int width = jnum.intValue();
                            jnum = jbounds.getJsonNumber("height");
                            int height = jnum.intValue();
                            tv = new DiagramToSVG.Shape();
                            tv.name = name;
                            tv.schema = schema;
                            tv.type = DiagramToSVG.SHAPE_TYPE_VIEW;
                            tv.bounds = new Rectangle(x + d, y + d, width, height);
                            dm.shapes.add(tv);
                        }
                        if (tv == null) continue;
                        JsonNumber jvn = job.getJsonNumber("viewNum");
                        if (jvn != null && (vnum2 = jvn.intValue()) > 0) {
                            tv.vnum = vnum2;
                        }
                        int bcol = 0;
                        int fcol = 0;
                        JsonNumber jn = job.getJsonNumber("bgColor");
                        if (jn != null) {
                            bcol = jn.intValue();
                            tv.bgCol = new Color(bcol);
                        } else {
                            tv.bgCol = Color.green;
                        }
                        jn = job.getJsonNumber("fgColor");
                        if (jn != null) {
                            fcol = jn.intValue();
                            tv.fgCol = new Color(fcol);
                        } else {
                            tv.fgCol = Color.blue;
                        }
                        try {
                            double fgopacity;
                            double bgopacity;
                            try {
                                bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                bgopacity = 1.0;
                            }
                            try {
                                fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                fgopacity = 1.0;
                            }
                            int ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                            tv.bgCol = new Color(ncolor, true);
                            ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                            tv.fgCol = new Color(ncolor, true);
                        }
                        catch (Exception e) {
                            Logger.error(e);
                        }
                        continue;
                    }
                    if ("RELATION".equalsIgnoreCase(type) || "REFERENCE".equalsIgnoreCase(type)) {
                        DiagramProcessor.processRelation(dm, job, d, type);
                        continue;
                    }
                    if (!"NOTE".equalsIgnoreCase(type)) continue;
                    DiagramToSVG.Shape tv = null;
                    String viewID = job.getString("viewID");
                    String text = job.getString("text");
                    JsonNumber fsize = job.getJsonNumber("fontSize");
                    JsonObject jbounds = job.getJsonObject("bounds");
                    if (jbounds != null) {
                        JsonNumber jnum = jbounds.getJsonNumber("x");
                        int x = jnum.intValue();
                        jnum = jbounds.getJsonNumber("y");
                        int y = jnum.intValue();
                        jnum = jbounds.getJsonNumber("width");
                        int width = jnum.intValue();
                        jnum = jbounds.getJsonNumber("height");
                        int height = jnum.intValue();
                        tv = new DiagramToSVG.Shape();
                        tv.name = null;
                        tv.schema = null;
                        tv.viewID = viewID;
                        tv.text = text;
                        if (fsize != null) {
                            tv.textFontSize = fsize.intValue();
                        }
                        tv.type = DiagramToSVG.SHAPE_TYPE_NOTE;
                        tv.bounds = new Rectangle(x + d, y + d, width, height);
                        dm.shapes.add(tv);
                    }
                    if (tv == null) continue;
                    JsonNumber jvn = job.getJsonNumber("viewNum");
                    if (jvn != null && (vnum = jvn.intValue()) > 0) {
                        tv.vnum = vnum;
                    }
                    int tcol = 0;
                    JsonNumber jn1 = job.getJsonNumber("textColor");
                    if (jn1 != null) {
                        tcol = jn1.intValue();
                        tv.textColor = new Color(tcol);
                    } else {
                        tv.textColor = Color.BLACK;
                    }
                    try {
                        topacity = job.getJsonNumber("textOpacity").doubleValue();
                    }
                    catch (Exception e) {
                        topacity = 1.0;
                    }
                    int tcolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(tcol, (int)(topacity * 255.0));
                    tv.textColor = new Color(tcolor, true);
                    int bcol = 0;
                    int fcol = 0;
                    JsonNumber jn = job.getJsonNumber("bgColor");
                    if (jn != null) {
                        bcol = jn.intValue();
                        tv.bgCol = new Color(bcol);
                    } else {
                        tv.bgCol = Color.green;
                    }
                    jn = job.getJsonNumber("fgColor");
                    if (jn != null) {
                        fcol = jn.intValue();
                        tv.fgCol = new Color(fcol);
                    } else {
                        tv.fgCol = Color.blue;
                    }
                    try {
                        double fgopacity;
                        double bgopacity;
                        try {
                            bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            bgopacity = 1.0;
                        }
                        try {
                            fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            fgopacity = 1.0;
                        }
                        int ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                        tv.bgCol = new Color(ncolor, true);
                        ncolor = DiagramToSVG.ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                        tv.fgCol = new Color(ncolor, true);
                        continue;
                    }
                    catch (Exception e) {
                        Logger.error(e);
                    }
                }
            }
        }
        return dm;
    }

    private static String getLayoutFromDB(Connection conn, String id) {
        return DiagramProcessor.getDiagramHelperFromDB((Connection)conn, (String)id).layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DHelper getDiagramHelperFromDB(Connection conn, String id) {
        DHelper dhelper = new DHelper();
        String layout = null;
        long lid = -1L;
        try {
            lid = Long.parseLong(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sql = "select name,description, last_update, layout from osddmw_diagrams where id = ?";
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(sql);
            st.setLong(1, lid);
            try (ResultSet rs = st.executeQuery();){
                if (rs != null && rs.next()) {
                    String name;
                    dhelper.name = name = rs.getString(1);
                    String descr = rs.getString(2);
                    String ts = rs.getString(3);
                    Blob clob = rs.getBlob(4);
                    dhelper.layout = layout = DiagramProcessor.blobToString(clob);
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    Logger.error(e);
                }
            }
        }
        return dhelper;
    }

    private static void getObjectsFomLayout(String layout, List<String> tables, List<String> views, List<String> ext_tables) {
    }

    private static void getObjectsFomLayout(String layout, List<String> tables, List<String> views, List<String> ext_tables, List<DiagramToSVG.Line> lines, List<JoinsHolder> jholders) {
        DiagramProcessor.getObjectsFomLayout(layout, tables, views, ext_tables, true, true, lines, jholders);
    }

    private static void getObjectsFomLayout(String layout, List<String> tables, List<String> views, List<String> ext_tables, boolean inclTables, boolean inclViews, List<DiagramToSVG.Line> lines, List<JoinsHolder> jholders) {
        if (layout != null && !layout.isEmpty()) {
            DiagramToSVG.DiagramThumbnailModel dm = new DiagramToSVG.DiagramThumbnailModel();
            int d = 40;
            dm.lines = lines;
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            ByteArrayInputStream stream = new ByteArrayInputStream(layout.getBytes(StandardCharsets.UTF_8));
            JsonObject jo = Json.createReader((InputStream)stream).readObject();
            JsonArray ja = jo.getJsonArray("items");
            if (ja != null) {
                for (int i = 0; i < ja.size(); ++i) {
                    Object lname;
                    String schema;
                    String name;
                    JsonObject job = ja.getJsonObject(i);
                    String type = job.getString("type");
                    if (inclTables && "TABLE".equalsIgnoreCase(type)) {
                        name = job.getString("name");
                        schema = job.getString("schema");
                        name = Token.getName(name);
                        schema = Token.getName(schema);
                        lname = name;
                        if (schema != null) {
                            lname = schema + "." + name;
                        }
                        if (map.get(lname) == null) {
                            map.put(lname, lname);
                            boolean ext = job.getBoolean("external", false);
                            if (ext) {
                                ext_tables.add(schema + "." + name);
                            } else {
                                tables.add(schema + "." + name);
                            }
                        }
                        if (jholders == null) continue;
                        DiagramProcessor.processImpliedFKeys(job, type, jholders, schema, name);
                        continue;
                    }
                    if (inclViews && "VIEW".equalsIgnoreCase(type)) {
                        name = job.getString("name");
                        schema = job.getString("schema");
                        name = Token.getName(name);
                        schema = Token.getName(schema);
                        lname = name;
                        if (schema != null) {
                            lname = schema + "." + name;
                        }
                        if (map.get(lname) == null) {
                            map.put(lname, lname);
                            views.add(schema + "." + name);
                        }
                        if (jholders == null) continue;
                        DiagramProcessor.processImpliedFKeys(job, type, jholders, schema, name);
                        continue;
                    }
                    if (!"REFERENCE".equalsIgnoreCase(type) && !"RELATION".equalsIgnoreCase(type)) continue;
                    DiagramProcessor.processRelation(dm, job, d, type);
                }
            }
        }
    }

    private static void processImpliedFKeys(JsonObject job, String type, List<JoinsHolder> jholders, String owner, String container) {
        JsonArray ja;
        if (jholders != null && (ja = job.getJsonArray("impliedForeignKeys")) != null && ja.size() > 0) {
            JoinsHolder jh = new JoinsHolder();
            jholders.add(jh);
            jh.type = type;
            jh.schema = owner;
            jh.table = container;
            for (int i = 0; i < ja.size(); ++i) {
                JsonObject ifk = ja.getJsonObject(i);
                String schema = ifk.getString("schema");
                String tname = ifk.getString("tableName");
                tname = Token.getName(tname);
                schema = Token.getName(schema);
                String cname = ifk.getString("columnName");
                cname = Token.getName(cname);
                String rschema = ifk.getString("refSchema");
                String rtname = ifk.getString("refTable");
                rtname = Token.getName(rtname);
                rschema = Token.getName(rschema);
                String rcname = ifk.getString("refColumnName");
                rcname = Token.getName(rcname);
                String discoverySource = ifk.getString("discoverySource");
                Join join = new Join(schema, tname, cname, rschema, rtname, rcname);
                join.setDiscoverySource(discoverySource);
                jh.joins.add(join);
            }
        }
    }

    public static String getObjectsFomLayout(String layout) {
        if (layout != null && !layout.isEmpty()) {
            ArrayList<String> tables = new ArrayList<String>();
            ArrayList<String> views = new ArrayList<String>();
            ArrayList<String> fkeys = new ArrayList<String>();
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            ByteArrayInputStream stream = new ByteArrayInputStream(layout.getBytes(StandardCharsets.UTF_8));
            JsonObject jo = Json.createReader((InputStream)stream).readObject();
            JsonArray ja = jo.getJsonArray("items");
            if (ja != null) {
                for (int i = 0; i < ja.size(); ++i) {
                    Object lname;
                    String schema;
                    String name;
                    JsonObject job = ja.getJsonObject(i);
                    String type = job.getString("type");
                    if ("TABLE".equalsIgnoreCase(type)) {
                        name = job.getString("name");
                        schema = job.getString("schema");
                        name = Token.getName(name);
                        schema = Token.getName(schema);
                        lname = name;
                        if (schema != null) {
                            lname = schema + "." + name;
                        }
                        if (map.get(lname) != null) continue;
                        map.put(lname, lname);
                        tables.add((String)lname);
                        continue;
                    }
                    if ("VIEW".equalsIgnoreCase(type)) {
                        name = job.getString("name");
                        schema = job.getString("schema");
                        name = Token.getName(name);
                        schema = Token.getName(schema);
                        lname = name;
                        if (schema != null) {
                            lname = schema + "." + name;
                        }
                        if (map.get(lname) != null) continue;
                        map.put(lname, lname);
                        views.add((String)lname);
                        continue;
                    }
                    if (!"RELATION".equalsIgnoreCase(type)) continue;
                    name = job.getString("name");
                    String lname2 = name = Token.getName(name);
                    if (map.get(lname2) != null) continue;
                    map.put(lname2, lname2);
                    fkeys.add(lname2);
                }
            }
            return DiagramProcessor.getObjectsJSON(tables, views, fkeys);
        }
        return "{}";
    }

    private static String getObjectsJSON(List<String> tables, List<String> views, List<String> fkeys) {
        boolean sfirst;
        Object res = "{";
        boolean first = true;
        if (tables.size() > 0) {
            first = false;
            res = (String)res + "\"tables\":[";
            sfirst = true;
            for (String s : tables) {
                if (!sfirst) {
                    res = (String)res + ",";
                }
                sfirst = false;
                res = (String)res + "\"" + s + "\"";
            }
            res = (String)res + "]";
        }
        if (views.size() > 0) {
            if (!first) {
                res = (String)res + ",";
            }
            first = false;
            res = (String)res + "\"views\":[";
            sfirst = true;
            for (String s : views) {
                if (!sfirst) {
                    res = (String)res + ",";
                }
                sfirst = false;
                res = (String)res + "\"" + s + "\"";
            }
            res = (String)res + "]";
        }
        if (fkeys.size() > 0) {
            if (!first) {
                res = (String)res + ",";
            }
            first = false;
            res = (String)res + "\"fkeys\":[";
            sfirst = true;
            for (String s : fkeys) {
                if (!sfirst) {
                    res = (String)res + ",";
                }
                sfirst = false;
                res = (String)res + "\"" + s + "\"";
            }
            res = (String)res + "]";
        }
        res = (String)res + "}";
        return res;
    }

    public static String blobToString(Blob blob) {
        try {
            StringBuffer result = new StringBuffer();
            if (blob != null) {
                int read = 0;
                InputStreamReader reader = null;
                char[] buffer = new char[4096];
                try {
                    reader = new InputStreamReader(blob.getBinaryStream(), "UTF-8");
                    while ((read = reader.read(buffer)) != -1) {
                        result.append(buffer, 0, read);
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("Unable to read layout data.", ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to read layout data.", ex);
                }
                finally {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            return result.toString();
        }
        catch (Exception e) {
            Logger.error(e);
            return "";
        }
    }

    private static String getLayoutFromFile(String fileName) {
        Object res = "";
        try {
            String s;
            FileReader fr = new FileReader(fileName);
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                res = (String)res + s;
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            Logger.error(e);
        }
        catch (IOException e) {
            Logger.error(e);
        }
        return res;
    }

    public static void returnReport(Connection conn, OutputStream outStream, String id, boolean createTOC, boolean inclTables, boolean inclViews, boolean createDiagram, boolean inclSelect, boolean dmwdef) {
        try {
            DHelper dh = DiagramProcessor.getDiagramHelperFromDB(conn, id);
            String layout = dh.layout;
            ArrayList<String> tables = new ArrayList<String>();
            ArrayList<String> views = new ArrayList<String>();
            ArrayList<String> ext_tables = new ArrayList<String>();
            ArrayList<DiagramToSVG.Line> lines = new ArrayList<DiagramToSVG.Line>();
            ArrayList<JoinsHolder> jholders = new ArrayList<JoinsHolder>();
            DiagramProcessor.getObjectsFomLayout(layout, tables, views, ext_tables, inclTables, inclViews, lines, jholders);
            RelationalDesign relModel = DiagramProcessor.importObjects(conn, tables, views, ext_tables, true);
            relModel.addJoins(jholders);
            Settings set = relModel.getDesign().getSettings();
            set.setGenerateHTMLReportTOCInSeparateFile(false);
            set.setIncludeSelectStatementInViewReport(inclSelect);
            DPVRelational dpv = null;
            if (createDiagram) {
                DiagramToSVG.initNumIDs(relModel);
                dpv = DiagramProcessor.createDiagram(relModel, layout);
            }
            DiagramProcessor.returnReport(conn, outStream, relModel, dpv, createTOC, inclTables, inclViews, dmwdef, "Report for diagram " + dh.name, lines);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    static RelationalDesign importObjects(Connection conn, List<String> tables, List<String> views, List<String> ext_tables, boolean importComments) {
        Design.dmInternalsDistDir = webPath;
        MetaFileLoader.DMWEB = true;
        Design des = DiagramProcessor.getDesign(false, false, false);
        RelationalDesign relModel = des.getRelationalDesign();
        Settings settings = des.getSettings();
        settings.setImportPartitions(false);
        settings.setImportSecondaryTables(false);
        settings.setImportColumnDetails(false);
        settings.setImportSpatialProperties(false);
        settings.setImportTriggers(false);
        settings.setScanForUsedStructuredTypes(false);
        settings.setIncludeDefaultSettingsInDDL(false);
        settings.setIncludeStorageInDDL(false);
        settings.setIncludeTablespaceInDDL(false);
        settings.setIncludeLoggingInDDL(false);
        settings.setImportCommentsInRDBMS(importComments);
        DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
        handler.init(conn);
        relModel.setSelectedRDBMSSite(handler.getRDBMSSite());
        StorageDesign sd = relModel.getStorageDesign();
        sd.openStorageDesign();
        List objects = DiagramProcessor.getObjectToImport(tables, views, ext_tables, false);
        ImportLogger importLog = new ImportLogger();
        try {
            handler.generateDesign(conn, objects, importLog);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return relModel;
    }

    static RelationalDesign importObjects(Connection conn, Design des, List<String> schemas, boolean itables, boolean iviews, boolean importComments) {
        return DiagramProcessor.importObjects(conn, des, schemas, itables, iviews, importComments, null);
    }

    static RelationalDesign importObjects(Connection conn, Design des, List<String> schemas, boolean itables, boolean iviews, boolean importComments, List names) {
        Design.dmInternalsDistDir = webPath;
        MetaFileLoader.DMWEB = true;
        RelationalDesign relModel = des.getRelationalDesign();
        Settings settings = des.getSettings();
        settings.setImportPartitions(false);
        settings.setImportSecondaryTables(false);
        settings.setImportColumnDetails(false);
        settings.setImportSpatialProperties(false);
        settings.setImportTriggers(false);
        settings.setScanForUsedStructuredTypes(false);
        settings.setIncludeDefaultSettingsInDDL(false);
        settings.setIncludeStorageInDDL(false);
        settings.setIncludeTablespaceInDDL(false);
        settings.setIncludeLoggingInDDL(false);
        settings.setImportCommentsInRDBMS(importComments);
        DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
        handler.init(conn);
        relModel.setSelectedRDBMSSite(handler.getRDBMSSite());
        StorageDesign sd = relModel.getStorageDesign();
        sd.openStorageDesign();
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (String s : schemas) {
            list.add(new DBObject(true, s));
        }
        ArrayList<DBObject> objects = new ArrayList<DBObject>();
        ImportLogger importLog = new ImportLogger();
        try {
            if (itables) {
                List l = handler.getDBObjects(conn, list, "TABLE");
                if (names != null && names.size() > 0) {
                    for (DBObject dbo : l) {
                        if (!names.contains(dbo.getName())) continue;
                        objects.add(dbo);
                    }
                } else {
                    objects.addAll(l);
                }
            }
            if (iviews) {
                objects.addAll(handler.getDBObjects(conn, list, "VIEW"));
            }
            handler.generateDesign(conn, objects, importLog);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return relModel;
    }

    static void returnReport(Connection conn, OutputStream outStream, RelationalDesign relModel, DPVRelational dpv, boolean createTOC, boolean tables, boolean views, boolean dmwdef, String reportTitle, List<DiagramToSVG.Line> lines) {
        TimeLog.log("Report started!");
        try {
            StandardReportTemplate srt = new StandardReportTemplate(" ", null, "0", true);
            srt.setUseDescriptionInfo(true);
            srt.setUseQuantitativeInfo(true);
            srt.setUseTableColumns(true);
            srt.setUseTableColumnsComments(true);
            srt.setUseTableConstraints(true);
            srt.setUseTableFKReferredFrom(true);
            srt.setUseTableFKReferringTo(true);
            srt.setUseTableIndexes(true);
            srt.setUseDiagrams(false);
            HashMap<String, Object> extraParams = new HashMap<String, Object>();
            extraParams.put("out_format", "HTML");
            extraParams.put("reports_path", "D:/A_Reports");
            extraParams.put("reportCustomFilenName", "all_tables" + System.currentTimeMillis());
            extraParams.put("reportCaption", reportTitle);
            extraParams.put("report_template", srt);
            extraParams.put("addTables", true);
            extraParams.put("addViews", true);
            extraParams.put("cssFiles", "osddm_main.css");
            ReportsGenerator g = new ReportsGenerator();
            relModel.getDesign().getSettings().setGenerateHTMLReportTOCInSeparateFile(false);
            ArrayList list = new ArrayList();
            relModel.getTableSet().addAllElementsTo(list);
            if (relModel.getTableViewSet().size() > 0) {
                relModel.getTableViewSet().addAllElementsTo(list);
                g.createReport(Label.class, relModel, list, extraParams, outStream, dpv, createTOC, dmwdef, lines);
            } else {
                g.createReport(Table.class, relModel, list, extraParams, outStream, dpv, createTOC, dmwdef, lines);
            }
            TimeLog.log("Report generated!");
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    static Design getDesign(boolean allDetails, boolean triggers, boolean spatial) {
        Design des = new Design();
        LogicalDataTypesReader lr = new LogicalDataTypesReader();
        lr.recreateLogicalTypes(des);
        RelationalDesign relModel = des.addRelationalDesign();
        des.setRelationalDesign(relModel);
        des.setPropagatePKChahges(false);
        des.setImporting(true);
        des.setLoading(true);
        Settings s = des.getSettings();
        if (!allDetails) {
            s.setImportPartitions(false);
            s.setImportTriggers(false);
            s.setScanForUsedStructuredTypes(false);
            s.setImportSpatialProperties(false);
            s.setImportSecondaryTables(false);
        } else {
            s.setImportPartitions(true);
            s.setImportTriggers(triggers);
            s.setScanForUsedStructuredTypes(true);
            s.setImportSpatialProperties(spatial);
            s.setImportSecondaryTables(false);
        }
        return des;
    }

    static List getObjectToImport(List<String> tables, List<String> views, List<String> ext_tables, boolean skipViews) {
        ArrayList objects = new ArrayList();
        objects.addAll(DiagramProcessor.getDBobjects(tables, "TABLE"));
        objects.addAll(DiagramProcessor.getDBobjects(ext_tables, "EXTERNAL TABLE"));
        if (!skipViews) {
            objects.addAll(DiagramProcessor.getDBobjects(views, "VIEW"));
        }
        return objects;
    }

    static List getDBobjects(List<String> objs, String type) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (objs != null) {
            for (String s : objs) {
                int ind = s.indexOf(46);
                if (ind <= 0) continue;
                String schema = s.substring(0, ind);
                String name = s.substring(ind + 1);
                list.add(new DBObject(true, name, type, schema));
            }
        }
        return list;
    }

    static boolean getBoolean(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        boolean bval = false;
        try {
            bval = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bval;
    }

    static boolean getBoolean(String value, boolean def) {
        if (value == null || value.isEmpty()) {
            return def;
        }
        boolean bval = def;
        try {
            bval = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bval;
    }

    public static class JoinsHolder {
        public String type = "TABLE";
        public String schema;
        public String table;
        public List<Join> joins = new ArrayList<Join>();
    }

    static class DHelper {
        String layout;
        String name;

        DHelper() {
        }
    }
}

