/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.odbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.odbc.MOHForeignKeyODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHTableODBC;
import oracle.dbtools.crest.imports.metadata.odbc.MOHViewODBC;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.util.logging.ImportLogger;

public final class DBMExtractionHandlerODBC
extends AbstractDBMExtractionHandler {
    private static final String DB_NAME_UDB = "UDB";
    private static final String DB_NAME_ORACLE = "ORACLE";
    private static final String DB_NAME_SQL_SERVER = "SQL SERVER";
    private List mohObjects = null;

    public DBMExtractionHandlerODBC(Design design) {
        super(design);
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        boolean schemaInTable = false;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (conn != null) {
            DatabaseMetaData dbmd = conn.getMetaData();
            try {
                dbmd.isCatalogAtStart();
                String sch = dbmd.getSchemaTerm();
                schemaInTable = "schema".equalsIgnoreCase(sch) ? true : dbmd.supportsSchemasInTableDefinitions();
                dbmd.getCatalogTerm();
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
            ResultSet resultSet = null;
            boolean isFirst = true;
            if (schemaInTable) {
                try {
                    resultSet = dbmd.getSchemas();
                    if (!resultSet.next()) {
                        resultSet = dbmd.getCatalogs();
                        this.setSchemaBased(false);
                    } else {
                        isFirst = false;
                        this.setSchemaBased(true);
                    }
                }
                catch (SQLException e) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    resultSet = dbmd.getCatalogs();
                    this.setSchemaBased(false);
                }
                int colnum = 1;
                try {
                    colnum = resultSet.getMetaData().getColumnCount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.isSchemaBased()) {
                    String catalog;
                    DBObject dbo;
                    String schema;
                    if (!isFirst) {
                        schema = resultSet.getString(1);
                        dbo = new DBObject(false, schema);
                        if (colnum > 1) {
                            catalog = resultSet.getString(2);
                            dbo.setCatalog(catalog);
                        }
                        list.add(dbo);
                    }
                    while (resultSet.next()) {
                        schema = resultSet.getString(1);
                        dbo = new DBObject(false, schema);
                        if (colnum > 1) {
                            catalog = resultSet.getString(2);
                            dbo.setCatalog(catalog);
                        }
                        list.add(dbo);
                    }
                } else {
                    DBObject dbo;
                    String schema;
                    if (!isFirst) {
                        schema = resultSet.getString(1);
                        dbo = new DBObject(false, schema);
                        list.add(dbo);
                    }
                    while (resultSet.next()) {
                        schema = resultSet.getString(1);
                        dbo = new DBObject(false, schema);
                        list.add(dbo);
                    }
                }
                resultSet.close();
            } else {
                DBObject dbo;
                String schema;
                try {
                    resultSet = dbmd.getCatalogs();
                    if (!resultSet.next()) {
                        resultSet = dbmd.getSchemas();
                        this.setSchemaBased(true);
                    } else {
                        isFirst = false;
                        this.setSchemaBased(false);
                    }
                }
                catch (SQLException e) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    resultSet = dbmd.getSchemas();
                    this.setSchemaBased(true);
                }
                if (!isFirst) {
                    schema = resultSet.getString(1);
                    dbo = new DBObject(false, schema);
                    list.add(dbo);
                }
                while (resultSet.next()) {
                    schema = resultSet.getString(1);
                    dbo = new DBObject(false, schema);
                    list.add(dbo);
                }
                resultSet.close();
            }
        }
        return list;
    }

    @Override
    public List getMOHObjects() {
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHTableODBC(this));
            this.mohObjects.add(new MOHForeignKeyODBC(this));
            this.mohObjects.add(new MOHViewODBC(this));
        }
        return this.mohObjects;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        if (this.dbMajorVersion == -1) {
            String version = this.dbProductVersion.indexOf(46) > -1 ? this.dbProductVersion.substring(0, this.dbProductVersion.indexOf(46)) : this.dbProductVersion;
            try {
                this.dbMajorVersion = Integer.parseInt(version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RDBMSSiteSet rdbmsSiteSet = this.getDesign().getRDBMSSiteSet();
        if (this.dbProductName.toUpperCase().indexOf(DB_NAME_ORACLE) > -1 || this.dbProductName.toUpperCase().indexOf("HIVE") > -1 || this.dbProductName.toUpperCase().indexOf("IMPALA") > -1) {
            switch (this.dbMajorVersion) {
                case 8: 
                case 9: {
                    return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
                }
                case 10: {
                    return rdbmsSiteSet.get(StorageDesignOraclev10g.RDBMS_TYPE);
                }
                case 11: {
                    return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
                }
                case 20: 
                case 21: {
                    return rdbmsSiteSet.get(StorageDesignOraclev20c.RDBMS_TYPE);
                }
                case 12: {
                    if (this.dbMinorVersion < 2) {
                        return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
                    }
                    return rdbmsSiteSet.get(StorageDesignOraclev12cR2.RDBMS_TYPE);
                }
            }
            if (this.dbProductName.toUpperCase().indexOf("HIVE") > -1 || this.dbProductName.toUpperCase().indexOf("IMPALA") > -1) {
                return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
            }
            return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
        }
        return rdbmsSiteSet.get(StorageDesignOraclev12cR2.RDBMS_TYPE);
    }

    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog) throws Exception {
        if (!this.isNullStorageDesign(this.getDesign().getRelationalDesign().getStorageDesign())) {
            super.generateDesign(conn, selectedObjects, importLog);
        }
    }
}

