/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.app.Format;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.oracle.DDLOptions;
import oracle.dbtools.crest.model.UpdatableStatus;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.util.Closeables;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;

public class DBMS_MD_DDL_Extractor
implements DDLOptions {
    public static Map<String, String> PARAM_NAMES = new TreeMap<String, String>();
    public static Map<String, String> PARAM_PLSQL_NAMES;
    public static Map PARAM_DEFALTS;
    boolean removeAllSnapshotNotNulls = false;
    boolean useSchema = true;
    static char DOT;
    private static final String[] objTypes;
    private static List<String> types_order;
    public static List<String> PARAM_LIST;
    static String[] tpref;
    static String[] vpref;

    public static void main(String[] args) throws SQLException {
        boolean tbl = false;
        boolean sch = true;
        HashMap<String, Boolean> emptyOptions = new HashMap<String, Boolean>();
        emptyOptions.put("tables", false);
        emptyOptions.put("views", false);
        emptyOptions.put("clust", true);
        emptyOptions.put("types", true);
        emptyOptions.put("mviews", true);
        emptyOptions.put("mvnnconst", true);
        emptyOptions.put("indexes", true);
        emptyOptions.put("all_dependent", true);
        emptyOptions.put("constraints", true);
        emptyOptions.put("pack", false);
        emptyOptions.put("func", true);
        emptyOptions.put("proc", true);
        emptyOptions.put("comments", true);
        emptyOptions.put("obj_grants", true);
        emptyOptions.put("partitions", false);
        emptyOptions.put("storage", false);
        emptyOptions.put("triggers", true);
        emptyOptions.put("seq", true);
        emptyOptions.put("syn", true);
        emptyOptions.put("psyn", true);
        emptyOptions.put("showschema", true);
        DBMS_MD_DDL_Extractor ext = new DBMS_MD_DDL_Extractor();
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/pdb1.osddm", "system", "system");
        if (!tbl) {
            ArrayList<String> schemas = new ArrayList<String>();
            schemas.add("DMWTEST");
            String ddl = "";
            if (sch) {
                ddl = ext.getSchemaDDL(conn, schemas, emptyOptions, null);
            } else {
                ArrayList<String> tables = new ArrayList<String>();
                tables.add("TEST.T1");
                tables.add("DMWTEST.A");
                ArrayList<String> views = new ArrayList<String>();
                views.add("DMWTEST.PROFITS");
                ddl = ext.getDDL(conn, null, null, views, emptyOptions);
            }
            System.out.print(ddl);
        } else {
            Statement st = conn.createStatement();
            ArrayList<String> tables = new ArrayList<String>();
            ArrayList<String> views = new ArrayList<String>();
            String sql = "select owner, view_name from all_views where owner in ('HR','SH')";
            try (ResultSet rs = st.executeQuery(sql);){
                if (rs != null) {
                    while (rs.next()) {
                        String owner = rs.getString(1);
                        String name = rs.getString(2);
                        views.add(owner + "." + name);
                    }
                }
                rs.close();
            }
            String ddl = ext.getDDL(conn, null, tables, views, emptyOptions);
            System.out.print(ddl);
        }
    }

    private static List<String> getOrderredByTypes(List<String> generationList, List<String> types, boolean all_dependent) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (String key : generationList) {
            int ind = key.indexOf(95);
            if (ind > 0) {
                String mkey = key.substring(0, ind);
                if (key.startsWith("DB_LINK")) {
                    mkey = "DB_LINK";
                } else if (key.startsWith("MATERIALIZED_VIEW")) {
                    mkey = "MATERIALIZED_VIEW";
                } else if (key.startsWith("MATERIALIZED_VIEW_LOG")) {
                    mkey = "MATERIALIZED_VIEW_LOG";
                } else if (key.startsWith("REF_CONSTRAINT")) {
                    mkey = "REF_CONSTRAINT";
                }
                ArrayList<String> l = (ArrayList<String>)map.get(mkey);
                if (l == null) {
                    l = new ArrayList<String>();
                    map.put(mkey, l);
                }
                l.add(key);
                continue;
            }
            if (!all_dependent || !key.equals("CONSTRAINT") && !key.equals("COMMENT")) continue;
            ArrayList<String> l = (ArrayList<String>)map.get(key);
            if (l == null) {
                l = new ArrayList<String>();
                map.put(key, l);
            }
            l.add(key);
        }
        for (String type : types) {
            List l = (List)map.get(type);
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }

    static boolean getBoolean(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        boolean bval = false;
        try {
            bval = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bval;
    }

    private String getcorrectDDL(String type, String metadataDDL) {
        if ("VIEW".equals(type)) {
            String mddl = metadataDDL.trim();
            String ddl = mddl.substring(0, mddl.length() - 1);
            String end = mddl.substring(mddl.length() - 2);
            if (!"\n;".equals(end) && !"\r;".equals(end)) {
                return ddl + "\n;";
            }
        } else if ("SYNONYM".equals(type)) {
            String mddl = metadataDDL.trim();
            if (!mddl.endsWith(";")) {
                return mddl + ";";
            }
        } else if ("MATERIALIZED_VIEW_LOG".equals(type)) {
            metadataDDL = metadataDDL.replaceFirst("\n \n", "\n");
        }
        return metadataDDL.trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSchemaDDL(Connection conn, List<String> schemas, Map options, UpdatableStatus upst) {
        boolean mv_nnc = this.removeAllSnapshotNotNulls;
        boolean all_dependent = false;
        Object obj = options.get("showschema");
        if (obj != null && obj instanceof Boolean) {
            this.useSchema = (Boolean)obj;
        }
        mv_nnc = (Boolean)options.get("mvnnconst");
        all_dependent = (Boolean)options.get("all_dependent");
        this.removeAllSnapshotNotNulls = !mv_nnc;
        StringBuffer sb = new StringBuffer();
        Statement st = null;
        try {
            ArrayList<DDL_Row> statements = new ArrayList<DDL_Row>();
            if (schemas != null && schemas.size() > 0) {
                String opt = DBMS_MD_DDL_Extractor.getDBMS_MD_Options(options);
                Object sql = "select schema,name,type,pschema, pname,ddl from table(OSDDM_DBMS_MD_DDL.get_md_schema_ddl(schema=>?";
                sql = (String)sql + opt + "))";
                int count = 0;
                st = conn.prepareStatement((String)sql);
                for (String s : schemas) {
                    st.setString(1, s);
                    ResultSet rs = st.executeQuery();
                    try {
                        if (rs == null) continue;
                        while (rs.next()) {
                            int k;
                            DDL_Row r = new DDL_Row();
                            r.schema = rs.getString(1);
                            r.name = rs.getString(2);
                            r.type = rs.getString(3);
                            r.pschema = rs.getString(4);
                            r.pname = rs.getString(5);
                            r.ddl = this.getcorrectDDL(r.type, rs.getString(6));
                            statements.add(r);
                            if (upst == null || ++count % 20 != 0) continue;
                            Object name = "";
                            if (r.schema != null) {
                                name = r.schema + ".";
                            }
                            if (r.name != null) {
                                name = (String)name + r.name;
                            }
                            if (((String)name).isEmpty()) {
                                name = "...";
                            }
                            if (r.ddl != null && !r.ddl.isEmpty()) {
                                k = Math.min(50, r.ddl.length());
                                name = (String)name + "- " + r.ddl.substring(0, k);
                            }
                            name = "DBMS_METADATA - processed " + (String)name;
                            k = Math.min(100, ((String)name).length());
                            upst.updateStatus(count, 0L, ((String)name).substring(0, k));
                            if (!upst.isCancelled()) continue;
                            ((OracleConnection)conn).cancel();
                            String string = "cancelled";
                            return string;
                        }
                        rs.close();
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
            }
            boolean tables = true;
            boolean views = true;
            boolean mviews = true;
            Boolean val = (Boolean)options.get("tables");
            if (val != null) {
                tables = val;
            }
            this.processStatements(sb, statements, all_dependent);
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        if (st == null) return sb.toString();
        try {
            st.close();
            return sb.toString();
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDDL(Connection conn, List<String> schemas, List<String> tables, List<String> views, Map options) {
        options.put("types", Boolean.FALSE);
        Object obj = options.get("showschema");
        if (obj != null && obj instanceof Boolean) {
            this.useSchema = (Boolean)obj;
        }
        StringBuffer sb = new StringBuffer();
        Statement st = null;
        try {
            ArrayList<DDL_Row> statements = new ArrayList<DDL_Row>();
            if (schemas != null && schemas.size() > 0) {
                String opt = this.getOptionsParameters(options, null, true);
                Object sql = "select schema,name,type,pschema,pname,ddl from table(OSDDM_DBMS_MD_DDL.get_md_tables_views_ddl(inschema=>?";
                sql = (String)sql + opt + "))";
                st = conn.prepareStatement((String)sql);
                for (String s : schemas) {
                    st.setString(1, s);
                    ResultSet rs = st.executeQuery();
                    try {
                        if (rs == null) continue;
                        while (rs.next()) {
                            DDL_Row r = new DDL_Row();
                            r.schema = rs.getString(1);
                            r.name = rs.getString(2);
                            r.type = rs.getString(3);
                            r.pschema = rs.getString(4);
                            r.pname = rs.getString(5);
                            r.ddl = this.getcorrectDDL(r.type, rs.getString(6));
                            statements.add(r);
                        }
                        rs.close();
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
            } else {
                HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
                HashMap<String, List<String>> vmap = new HashMap<String, List<String>>();
                ArrayList<String> schList = new ArrayList<String>();
                this.processObjects(tmap, vmap, schList, tables, views);
                for (String s : schList) {
                    int tsize = 0;
                    boolean vsize = false;
                    List t = (List)tmap.get(s);
                    String texpr = null;
                    if (t != null) {
                        texpr = DBMS_MD_DDL_Extractor.getTExpression(t, tpref);
                        tsize = texpr.length();
                    }
                    List v = (List)vmap.get(s);
                    this.getDDLfromDBnew(conn, statements, s, t, v, options);
                }
            }
            this.processStatements(sb, statements, false);
        }
        catch (SQLException e) {
            Logger.error(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    Logger.error(e);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDDLforSingleObject(Connection conn, String type, String schema, String name, Map options) {
        StringBuffer sb = new StringBuffer();
        boolean error = false;
        Statement st = null;
        ResultSet rs = null;
        try {
            ArrayList<DDL_Row> statements = new ArrayList<DDL_Row>();
            st = conn.createStatement();
            if (schema != null) {
                String opt = this.getOptionsParameters(options, name, false);
                Object sql = "select schema,name,type,pschema,pname,ddl from table(OSDDM_DBMS_MD_DDL.get_md_object_ddl(oschema=>";
                rs = st.executeQuery((String)(sql = (String)sql + "'" + schema + "',oname=>'" + name + "',otype=>'" + type + "'" + opt + "))"));
                if (rs != null) {
                    while (rs.next()) {
                        DDL_Row r = new DDL_Row();
                        r.schema = rs.getString(1);
                        r.name = rs.getString(2);
                        r.type = rs.getString(3);
                        r.pschema = rs.getString(4);
                        r.pname = rs.getString(5);
                        r.ddl = this.getcorrectDDL(r.type, rs.getString(6));
                        statements.add(r);
                    }
                    rs.close();
                }
                this.processStatements(sb, statements, false);
            }
        }
        catch (SQLException e) {
            String err = e.getMessage();
            sb.setLength(0);
            Object errmes = "";
            if (err != null) {
                if (err.indexOf("06598") > -1 || err.toUpperCase().indexOf("INHERIT") > -1) {
                    errmes = "ORA-06598: insufficient INHERIT PRIVILEGES privilege";
                } else if (err.indexOf("06553") > -1 || err.indexOf("PLS-306") > -1) {
                    errmes = err + "--Probably wrong version of ORDS schema";
                }
            }
            sb.append("--ERROR ").append((String)errmes);
            error = true;
            Logger.error(e);
        }
        finally {
            Closeables.close(rs);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    Logger.error(e);
                }
            }
        }
        if (!error && "DIMENSION".equalsIgnoreCase(type)) {
            return DBMS_MD_DDL_Extractor.formatSQL(sb.toString());
        }
        return sb.toString();
    }

    public static String formatSQL(String input) {
        Format format = new Format();
        format.setRethrowSyntaxError(false);
        String formattedOutput = input;
        try {
            formattedOutput = format.format(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedOutput;
    }

    private static String getDBMS_MD_Options(Map options) {
        Object res = "";
        for (String par : PARAM_LIST) {
            Boolean val;
            String par_name = PARAM_NAMES.get(par);
            if (par_name == null) {
                par_name = par;
            }
            if ((val = (Boolean)options.get(par_name)) == null) continue;
            String pname = PARAM_PLSQL_NAMES.get(par_name);
            if (pname == null) {
                pname = par_name;
            }
            if (val.booleanValue()) {
                res = (String)res + "," + pname + "=>'true'";
                continue;
            }
            res = (String)res + "," + pname + "=>'false'";
        }
        return res;
    }

    private String getOptionsParameters(Map options, String name, boolean selection) {
        Object res = "";
        Boolean val = (Boolean)options.get("storage");
        if (val != null) {
            res = ",fstorage=>'" + String.valueOf(val) + "'";
        }
        if ((val = (Boolean)options.get("partitions")) != null) {
            res = (String)res + ",fpartitions=>'" + String.valueOf(val) + "'";
        }
        if ((val = (Boolean)options.get("comments")) != null) {
            res = (String)res + ",fcomments=>'" + String.valueOf(val) + "'";
        }
        if ((val = (Boolean)options.get("triggers")) != null) {
            res = (String)res + ",ftriggers=>'" + String.valueOf(val) + "'";
        }
        if (name == null && (val = (Boolean)options.get("types")) != null) {
            res = (String)res + ",ftypes=>'" + String.valueOf(val) + "'";
        }
        if ((val = (Boolean)options.get("obj_grants")) != null) {
            res = (String)res + ",fobj_grants=>'" + String.valueOf(val) + "'";
        }
        if (!selection) {
            val = (Boolean)options.get("psyn");
            if (val != null) {
                res = (String)res + ",fpsyn=>'" + String.valueOf(val) + "'";
            }
            if ((val = (Boolean)options.get("syn")) != null) {
                res = (String)res + ",fsyn=>'" + String.valueOf(val) + "'";
            }
        }
        if ((val = (Boolean)options.get("bytesize")) != null) {
            res = (String)res + ",fbytesize=>'" + String.valueOf(val) + "'";
        }
        if ((val = (Boolean)options.get("indexes")) != null) {
            res = (String)res + ",findexes=>'" + String.valueOf(val) + "'";
        }
        if ((val = (Boolean)options.get("constraints")) != null) {
            res = (String)res + ",fconstraints=>'" + String.valueOf(val) + "'";
        }
        if ((val = (Boolean)options.get("showschema")) != null) {
            res = (String)res + ",fschema=>'" + String.valueOf(val) + "'";
        }
        if (name == null && (val = (Boolean)options.get("views")) != null) {
            res = (String)res + ",fviews=>'" + String.valueOf(val) + "'";
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDDLfromDBnew(Connection conn, List<DDL_Row> statements, String schema, List<String> tables, List<String> views, Map options) {
        Statement st = null;
        ResultSet rs = null;
        try {
            String opt;
            Object sql = "select schema,name,type,pschema,pname,ddl from table(OSDDM_DBMS_MD_DDL.get_md_tables_views_ddl(inschema=>?";
            if (tables != null && tables.size() > 0) {
                sql = (String)sql + ",tables=>?";
            }
            if (views != null && views.size() > 0) {
                sql = (String)sql + ",tviews=>?";
            }
            sql = !(opt = this.getOptionsParameters(options, null, true)).isEmpty() ? (String)sql + opt + "))" : (String)sql + "))";
            try {
                Array array;
                st = conn.prepareStatement((String)sql);
                st.setString(1, schema);
                int k = 1;
                if (tables != null && tables.size() > 0) {
                    array = ((OracleConnection)conn).createOracleArray("ORDS_METADATA.DM_VARCHAR_TABLE", (Object)tables.toArray(new String[0]));
                    st.setArray(++k, array);
                }
                if (views != null && views.size() > 0) {
                    array = ((OracleConnection)conn).createOracleArray("ORDS_METADATA.DM_VARCHAR_TABLE", (Object)views.toArray(new String[0]));
                    st.setArray(++k, array);
                }
                if ((rs = st.executeQuery()) != null) {
                    while (rs.next()) {
                        DDL_Row r = new DDL_Row();
                        r.schema = rs.getString(1);
                        r.name = rs.getString(2);
                        r.type = rs.getString(3);
                        r.pschema = rs.getString(4);
                        r.pname = rs.getString(5);
                        r.ddl = this.getcorrectDDL(r.type, rs.getString(6));
                        statements.add(r);
                    }
                }
                rs.close();
            }
            catch (SQLException e) {
                Logger.error(e);
            }
        }
        catch (Exception exception) {
        }
        finally {
            Closeables.close(rs);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void processObjects(Map<String, List<String>> tmap, Map<String, List<String>> vmap, List<String> schList, List<String> tables, List<String> views) {
        List<String> list;
        String name;
        String schema;
        int ind;
        if (tables != null) {
            for (String s : tables) {
                ind = s.indexOf(46);
                if (ind <= 0) continue;
                schema = s.substring(0, ind);
                schema = Token.getName(schema);
                name = s.substring(ind + 1);
                name = Token.getName(name);
                list = tmap.get(schema);
                if (list == null) {
                    list = new ArrayList<String>();
                    tmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
        }
        if (views != null) {
            for (String s : views) {
                ind = s.indexOf(46);
                if (ind <= 0) continue;
                schema = s.substring(0, ind);
                schema = Token.getName(schema);
                name = s.substring(ind + 1);
                name = Token.getName(name);
                list = vmap.get(schema);
                if (list == null) {
                    list = new ArrayList<String>();
                    vmap.put(schema, list);
                }
                list.add(name);
                if (schList.contains(schema)) continue;
                schList.add(schema);
            }
        }
    }

    private static void parseSchemaAndName(DDL_Row r) {
        String name;
        if (r.name != null && !r.name.isEmpty()) {
            return;
        }
        String objTypeKey = r.type;
        String type = r.type;
        if (type.equals("REF_CONSTRAINT") || type.equals("COMMENT")) {
            return;
        }
        if (type.equals("MATERIALIZED_VIEW_LOG")) {
            objTypeKey = "ON";
        }
        if (type.equals("DB_LINK")) {
            return;
        }
        if (type.equals("MATERIALIZED_VIEW")) {
            objTypeKey = "MATERIALIZED VIEW";
        }
        if ((name = Token.getNameAfterToken(r.ddl, objTypeKey, '\"', '\"').trim()).indexOf(DOT) > -1) {
            String schema = Token.getValBeforeCharacter(name, DOT);
            name = Token.getValAfterCharacter(name, DOT);
            r.schema = schema;
        }
        r.name = name;
    }

    /*
     * WARNING - void declaration
     */
    private void processStatements(StringBuffer sb, List<DDL_Row> list, boolean all_dependent) {
        HashMap<String, List<String>> ddlMap = new HashMap<String, List<String>>();
        List<String> generationList = new ArrayList<String>();
        for (DDL_Row dDL_Row : list) {
            void var8_24;
            List mapDDLs;
            List mapDDLs2;
            DBMS_MD_DDL_Extractor.parseSchemaAndName(dDL_Row);
            if (dDL_Row.type.equals("REF_CONSTRAINT")) {
                String string = dDL_Row.type;
                List mapDDLs22 = (List)ddlMap.get(string);
                if (mapDDLs22 == null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(dDL_Row.ddl);
                    ddlMap.put(string, arrayList);
                    generationList.add(string);
                    continue;
                }
                mapDDLs22.add(dDL_Row.ddl);
                continue;
            }
            if (dDL_Row.type.equals("COMMENT")) {
                int lastDotIndex;
                String string;
                String string2 = Token.getStringAfter(dDL_Row.ddl, "COMMENT ON");
                String commentType = Token.getFirstToken(string2);
                if (commentType.equals("MATERIALIZED")) {
                    commentType = "MATERIALIZED VIEW";
                    if (dDL_Row.ddl.indexOf("snapshot table for snapshot ") > -1) continue;
                }
                String objName = string = Token.getNameAfterToken(string2, commentType, '\"', '\"');
                if (commentType.equals("TABLE") && (objName.indexOf(".MLOG$_") > -1 || objName.indexOf("MLOG$_") == 0)) continue;
                if (commentType.equals("COLUMN") && (lastDotIndex = objName.lastIndexOf(46)) > -1) {
                    objName = objName.substring(0, lastDotIndex);
                }
                if ((mapDDLs2 = this.findDDLsForTableViewOrMV(ddlMap, objName)) != null) {
                    mapDDLs2.add((String)dDL_Row.ddl);
                    continue;
                }
                if (!all_dependent) {
                    sb.append("-- Error: No object found for COMMENT ON: ").append(string).append("\n");
                    continue;
                }
                String objKey2 = dDL_Row.type;
                mapDDLs2 = (List)ddlMap.get(objKey2);
                if (mapDDLs2 == null) {
                    ArrayList<String> ddls2 = new ArrayList<String>();
                    ddls2.add(dDL_Row.ddl);
                    ddlMap.put(objKey2, ddls2);
                    generationList.add(objKey2);
                    continue;
                }
                mapDDLs2.add(dDL_Row.ddl);
                continue;
            }
            if (dDL_Row.type.equals("INDEX")) {
                void var8_15;
                if (dDL_Row.name.startsWith("I_SNAP$_") || dDL_Row.name.startsWith("SYS_C_SNAP$") || dDL_Row.name.startsWith("I_MLOG$_")) continue;
                String string = Token.getNameAfterToken(dDL_Row.ddl, "ON", '\"', '\"');
                if ("CLUSTER".equals(string)) {
                    String string3 = Token.getNameAfterToken(dDL_Row.ddl, "CLUSTER", '\"', '\"');
                }
                if ((mapDDLs = this.findDDLsForTableViewOrMV(ddlMap, (String)var8_15)) != null) {
                    mapDDLs.add((String)dDL_Row.ddl);
                    continue;
                }
                if (dDL_Row.name.startsWith("SYS_")) continue;
                String string4 = dDL_Row.type + "_" + dDL_Row.name;
                mapDDLs = (List)ddlMap.get(string4);
                if (mapDDLs == null) {
                    ArrayList<String> ddls3 = new ArrayList<String>();
                    ddls3.add(dDL_Row.ddl);
                    ddlMap.put(string4, ddls3);
                    generationList.add(string4);
                    continue;
                }
                mapDDLs.add(dDL_Row.ddl);
                continue;
            }
            if (dDL_Row.type.equals("CONSTRAINT")) {
                String string;
                if (dDL_Row.name.startsWith("SYS_C_SNAP$")) continue;
                String string5 = "";
                mapDDLs = null;
                if (!dDL_Row.ddl.startsWith("ALTER ")) continue;
                String string6 = dDL_Row.ddl.substring(6);
                String objType = Token.getFirstToken(string6);
                if (objType.equals("MATERIALIZED")) {
                    objType = "MATERIALIZED VIEW";
                }
                if ((mapDDLs = this.findDDLsForTableViewOrMV(ddlMap, string = Token.getNameAfterToken(string6, objType, '\"', '\"'))) != null) {
                    mapDDLs.add((String)dDL_Row.ddl);
                    continue;
                }
                if (!all_dependent) {
                    sb.append("-- Error: No object found for ALTER for: ").append(string).append("\n");
                    continue;
                }
                String objKey4 = dDL_Row.type;
                mapDDLs = (List)ddlMap.get(objKey4);
                if (mapDDLs == null) {
                    ArrayList<String> ddls4 = new ArrayList<String>();
                    ddls4.add(dDL_Row.ddl);
                    ddlMap.put(objKey4, ddls4);
                    generationList.add(objKey4);
                    continue;
                }
                mapDDLs.add(dDL_Row.ddl);
                continue;
            }
            if (dDL_Row.type.equals("OBJECT_GRANT")) {
                void var8_20;
                String string;
                String temp = string = Token.getStringAfter(dDL_Row.ddl, "ON");
                while (!temp.isEmpty()) {
                    if ((temp = Token.getStringAfter(temp, "ON")).isEmpty()) continue;
                    String string7 = temp;
                }
                String string8 = Token.getFirstName((String)var8_20, '\"', '\"');
                String onObjectKey = this.findObjKeyForObject(ddlMap, string8);
                List list2 = mapDDLs2 = onObjectKey != null ? (List)ddlMap.get(onObjectKey) : null;
                if (mapDDLs2 != null) {
                    mapDDLs2.add(dDL_Row.ddl);
                    continue;
                }
                this.addOtherObjects(dDL_Row, ddlMap, generationList);
                continue;
            }
            if (dDL_Row.type.equals("TABLE") && dDL_Row.name != null && (dDL_Row.name.startsWith("MLOG$_") || dDL_Row.name.startsWith("RUPD$_"))) continue;
            if (this.useSchema) {
                String string = dDL_Row.type + "_" + dDL_Row.schema + "." + dDL_Row.name;
            } else {
                String string = dDL_Row.type + "_" + dDL_Row.name;
            }
            mapDDLs = (List)ddlMap.get(var8_24);
            if (mapDDLs == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(dDL_Row.ddl);
                ddlMap.put((String)var8_24, arrayList);
                if (dDL_Row.type.equals("SEQUENCE")) {
                    generationList.add(0, (String)var8_24);
                } else {
                    generationList.add((String)var8_24);
                }
                if (!dDL_Row.type.equals("MATERIALIZED_VIEW") || dDL_Row.ddl.indexOf("ON PREBUILT TABLE") != -1) continue;
                if (this.useSchema) {
                    ddlMap.remove("TABLE_" + dDL_Row.schema + "." + dDL_Row.name);
                    continue;
                }
                ddlMap.remove("TABLE_" + dDL_Row.name);
                continue;
            }
            mapDDLs.add((String)dDL_Row.ddl);
        }
        generationList = DBMS_MD_DDL_Extractor.getOrderredByTypes(generationList, types_order, all_dependent);
        HashMap<String, List<String>> dependencyMap = new HashMap<String, List<String>>();
        for (String string : generationList) {
            List<String> dependencies = this.findDependencies(string, ddlMap);
            if (dependencies == null) continue;
            dependencyMap.put(string, dependencies);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : generationList) {
            arrayList.clear();
            this.generateObject(sb, string, ddlMap, hashMap, dependencyMap, arrayList, false);
        }
    }

    private void addOtherObjects(DDL_Row r, Map<String, List<String>> ddlMap, List<String> generationList) {
        String objKey = r.type;
        List<String> mapDDLs = ddlMap.get(objKey);
        if (mapDDLs != null) {
            mapDDLs.add(r.ddl);
        } else {
            ArrayList<String> ddls = new ArrayList<String>();
            ddls.add(r.ddl);
            ddlMap.put(objKey, ddls);
            generationList.add(objKey);
        }
    }

    private boolean generateObject(StringBuffer sb, String objKey, Map<String, List<String>> ddlMap, Map<String, String> generatedMap, Map<String, List<String>> dependencyMap, List<String> cyclicCheckList, boolean abandonIfCyclic) {
        if (!generatedMap.containsKey(objKey)) {
            List<String> ddls;
            List<String> dependencies = dependencyMap.get(objKey);
            if (dependencies != null) {
                cyclicCheckList.add(objKey);
                for (String dependencyKey : dependencies) {
                    boolean isRef = false;
                    String key = dependencyKey;
                    if (dependencyKey.startsWith("REF TYPE_")) {
                        key = dependencyKey.substring(4);
                        isRef = true;
                    }
                    if (cyclicCheckList.contains(key)) {
                        if (!abandonIfCyclic) continue;
                        cyclicCheckList.remove(objKey);
                        return false;
                    }
                    boolean ok = this.generateObject(sb, key, ddlMap, generatedMap, dependencyMap, cyclicCheckList, isRef || abandonIfCyclic);
                    if (ok) continue;
                    if (abandonIfCyclic) {
                        cyclicCheckList.remove(objKey);
                        return false;
                    }
                    if (!isRef || generatedMap.containsKey(dependencyKey)) continue;
                    generatedMap.put(dependencyKey, dependencyKey);
                    this.generateIncompleteType(sb, key);
                }
            }
            if ((ddls = ddlMap.get(objKey)) != null) {
                for (String ddl : ddls) {
                    sb.append(ddl.trim()).append("\n\n");
                }
            }
            generatedMap.put(objKey, objKey);
        }
        return true;
    }

    private void generateIncompleteType(StringBuffer sb, String objKey) {
        String longName;
        int dotIndex;
        if (objKey.startsWith("TYPE_") && (dotIndex = (longName = objKey.substring(5)).indexOf(46)) != -1) {
            String schemaName = longName.substring(0, dotIndex);
            sb.append("CREATE OR REPLACE TYPE \"");
            if (!schemaName.isEmpty() && !schemaName.equals("null")) {
                sb.append(schemaName);
                sb.append("\".\"");
            }
            sb.append(longName.substring(dotIndex + 1));
            sb.append("\";\n/\n\n");
        }
    }

    private List<String> findDependencies(String objKey, Map<String, List<String>> ddlMap) {
        Object underObjName;
        String afterUnder;
        Object mainDDL;
        List<String> ddls;
        ArrayList<String> returnList = null;
        if ((objKey.startsWith("TABLE_") || objKey.startsWith("VIEW_") || objKey.startsWith("MATERIALIZED VIEW_") || objKey.startsWith("TYPE_") || objKey.startsWith("FUNCTION_") || objKey.startsWith("PROCEDURE_") || objKey.startsWith("PACKAGE_")) && (ddls = ddlMap.get(objKey)) != null && !ddls.isEmpty()) {
            mainDDL = ddls.get(0);
            if (objKey.startsWith("VIEW_")) {
                afterUnder = Token.getStringAfter((String)(mainDDL = "CREATE VIEW " + Token.getStringAfter((String)mainDDL, "VIEW")), "UNDER");
                if (!afterUnder.isEmpty()) {
                    String underObjKey;
                    int dotIndex;
                    underObjName = Token.getFirstName(afterUnder, '\"', '\"');
                    if (!afterUnder.startsWith("\"")) {
                        underObjName = ((String)underObjName).toUpperCase(Locale.ROOT);
                    }
                    if (((String)underObjName).indexOf(46) == -1 && (dotIndex = objKey.indexOf(46, 5)) != -1) {
                        underObjName = objKey.substring(5, dotIndex + 1) + (String)underObjName;
                    }
                    if (ddlMap.containsKey(underObjKey = "VIEW_" + (String)underObjName)) {
                        if (returnList == null) {
                            returnList = new ArrayList();
                        }
                        returnList.add(underObjKey);
                    }
                }
            } else if (objKey.startsWith("MATERIALIZED VIEW_")) {
                if (((String)(mainDDL = Token.getStringAfter((String)mainDDL, "AS"))).startsWith("(")) {
                    mainDDL = Token.getValBetweenBrackets((String)mainDDL, 1);
                }
                mainDDL = "SELECT " + Token.getStringAfter((String)mainDDL, "SELECT");
            }
            List<SQLAnalyzer.PDescriptor> PDescrList = SQLAnalyzer.getTablesAndFunctions((String)mainDDL);
            for (SQLAnalyzer.PDescriptor descr : PDescrList) {
                String ownerSchema = null;
                int underScoreIndex = objKey.indexOf(95);
                int dotIndex = objKey.indexOf(46);
                if (underScoreIndex != -1 && dotIndex > underScoreIndex) {
                    ownerSchema = objKey.substring(underScoreIndex + 1, dotIndex);
                }
                Object longName = null;
                if (this.useSchema) {
                    String schema = descr.schema;
                    if (schema == null) {
                        schema = ownerSchema;
                    }
                    longName = schema != null ? schema + "." + descr.name : descr.name;
                } else {
                    longName = descr.name;
                }
                String key = null;
                if (descr.type.equals("table")) {
                    key = "MATERIALIZED VIEW_" + (String)longName;
                    if (!ddlMap.containsKey(key) && !ddlMap.containsKey(key = "TABLE_" + (String)longName)) {
                        key = "VIEW_" + (String)longName;
                    }
                } else if (descr.type.equals("type")) {
                    key = "TYPE_" + (String)longName;
                } else if (descr.type.equals("ref type")) {
                    key = "REF TYPE_" + (String)longName;
                } else if (descr.type.equals("function")) {
                    if (descr.pack != null) {
                        key = this.useSchema ? "PACKAGE_" + descr.schema + "." + descr.pack : "PACKAGE_" + descr.pack;
                    } else {
                        key = "FUNCTION_" + (String)longName;
                        if (!ddlMap.containsKey(key) && !ddlMap.containsKey(key = "PROCEDURE_" + (String)longName)) {
                            key = null;
                            if (descr.schema != null) {
                                key = "PACKAGE_" + ownerSchema + "." + descr.schema;
                            }
                        }
                    }
                }
                if (key == null || !ddlMap.containsKey(key)) continue;
                if (returnList == null) {
                    returnList = new ArrayList();
                }
                returnList.add(key);
            }
        }
        if (objKey.startsWith("TYPE_")) {
            ddls = ddlMap.get(objKey);
            if (ddls != null && !ddls.isEmpty()) {
                mainDDL = ddls.get(0);
                afterUnder = Token.getStringAfter((String)mainDDL, "UNDER");
                if (!afterUnder.isEmpty()) {
                    String underObjKey;
                    int dotIndex;
                    underObjName = Token.getFirstName(afterUnder, '\"', '\"');
                    if (!afterUnder.startsWith("\"")) {
                        underObjName = ((String)underObjName).toUpperCase(Locale.ROOT);
                    }
                    if (((String)underObjName).indexOf(46) == -1 && (dotIndex = objKey.indexOf(46, 5)) != -1) {
                        underObjName = objKey.substring(5, dotIndex + 1) + (String)underObjName;
                    }
                    if (ddlMap.containsKey(underObjKey = "TYPE_" + (String)underObjName)) {
                        if (returnList == null) {
                            returnList = new ArrayList();
                        }
                        returnList.add(underObjKey);
                    }
                } else {
                    String beforeOf = Token.getStringBeforeToken((String)mainDDL, "OF");
                    if (beforeOf.endsWith("TABLE") || beforeOf.contains("VARRAY") || beforeOf.contains("ARRAY")) {
                        String ofObjKey;
                        int dotIndex;
                        String afterOf = Token.getStringAfter((String)mainDDL, "OF");
                        String firstToken = Token.getFirstToken(afterOf);
                        boolean isRef = firstToken.equalsIgnoreCase("REF");
                        if (isRef) {
                            afterOf = Token.cutTokenFromFront(afterOf, firstToken);
                        }
                        Object ofObjName = Token.getFirstName(afterOf, '\"', '\"');
                        if (!afterOf.startsWith("\"")) {
                            ofObjName = ((String)ofObjName).toUpperCase(Locale.ROOT);
                        }
                        if (((String)ofObjName).indexOf(46) == -1 && (dotIndex = objKey.indexOf(46, 5)) != -1) {
                            ofObjName = objKey.substring(5, dotIndex + 1) + (String)ofObjName;
                        }
                        if (ddlMap.containsKey(ofObjKey = "TYPE_" + (String)ofObjName)) {
                            if (returnList == null) {
                                returnList = new ArrayList();
                            }
                            if (isRef) {
                                ofObjKey = "REF TYPE" + (String)ofObjName;
                            }
                            returnList.add(ofObjKey);
                        }
                    }
                }
            }
        } else if (objKey.startsWith("SYNONYM_")) {
            String forObjectName;
            String refObjKey;
            ddls = ddlMap.get(objKey);
            if (ddls != null && !ddls.isEmpty() && (refObjKey = this.findObjKeyForObject(ddlMap, forObjectName = Token.getNameAfterToken((String)(mainDDL = ddls.get(0)), "FOR", '\"', '\"'))) != null) {
                if (returnList == null) {
                    returnList = new ArrayList();
                }
                returnList.add(refObjKey);
            }
        } else if (objKey.startsWith("TABLE_")) {
            ddls = ddlMap.get(objKey);
            if (ddls != null && !ddls.isEmpty() && ((String)(mainDDL = ddls.get(0))).indexOf("ORGANIZATION INDEX") > -1) {
                this.removePK(ddls);
            }
        } else if (objKey.startsWith("MATERIALIZED VIEW_")) {
            if (returnList == null) {
                returnList = new ArrayList<String>();
            }
            this.removeUnwantedSnapshotPKs(objKey, ddlMap, returnList);
            this.removeUnwantedSnapshotNotNulls(objKey, ddlMap, returnList);
        }
        return returnList;
    }

    private void removeUnwantedSnapshotNotNulls(String objKey, Map<String, List<String>> ddlMap, List<String> dependencies) {
        List<String> dependentNotNullColNames = null;
        List<String> ddls = ddlMap.get(objKey);
        if (ddls != null) {
            block0: for (int i = ddls.size() - 1; i > 0; --i) {
                String modifyClause;
                String ddl = ddls.get(i);
                if (!ddl.startsWith("ALTER ") || ddl.indexOf(" MODIFY") <= -1 || (modifyClause = Token.getValBetweenBrackets(Token.getStringAfter(ddl, "MODIFY"), 1)).indexOf(" NOT NULL ") <= -1) continue;
                if (this.removeAllSnapshotNotNulls) {
                    ddls.remove(i);
                    continue;
                }
                String columnName = Token.getFirstName(modifyClause, '\"', '\"');
                if (dependentNotNullColNames == null) {
                    dependentNotNullColNames = this.getDependentNotNullColNames(ddlMap, dependencies);
                }
                for (String dependentNotNullColName : dependentNotNullColNames) {
                    if (!columnName.equals(dependentNotNullColName) || columnName.isEmpty()) continue;
                    ddls.remove(i);
                    continue block0;
                }
            }
        }
    }

    private List<String> getDependentNotNullColNames(Map<String, List<String>> ddlMap, List<String> dependencies) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (String dependency : dependencies) {
            List<String> ddls;
            if (!dependency.startsWith("TABLE_") && !dependency.startsWith("MATERIALIZED VIEW_") || (ddls = ddlMap.get(dependency)) == null) continue;
            for (int i = 1; i < ddls.size(); ++i) {
                String modifyClause;
                String ddl = ddls.get(i);
                if (!ddl.startsWith("ALTER ")) continue;
                if (ddl.indexOf(" PRIMARY KEY") > -1) {
                    if (ddl.indexOf(" ADD ") <= -1) continue;
                    String afterPK = Token.getStringAfter(ddl, "PRIMARY KEY");
                    String columnList = Token.getValBetweenBrackets(afterPK, 1);
                    String[] pkColumns = columnList.split(",");
                    for (int j = 0; j < pkColumns.length; ++j) {
                        String columnName = Token.getFirstName(pkColumns[j], '\"', '\"');
                        colNames.add(columnName);
                    }
                    continue;
                }
                if (ddl.indexOf(" MODIFY") <= -1 || (modifyClause = Token.getValBetweenBrackets(Token.getStringAfter(ddl, "MODIFY"), 1)).indexOf(" NOT NULL ") <= -1) continue;
                String columnName = Token.getFirstName(modifyClause, '\"', '\"');
                colNames.add(columnName);
            }
        }
        return colNames;
    }

    private void removeUnwantedSnapshotPKs(String objKey, Map<String, List<String>> ddlMap, List<String> dependencies) {
        List<String> ddls = ddlMap.get(objKey);
        if (ddls != null && ddls.size() > 1) {
            String tablePKDDL;
            String mvPKDDL;
            String mainDDL = ddls.get(0).toUpperCase(Locale.ROOT);
            if (mainDDL.indexOf("ORGANIZATION INDEX") > -1) {
                this.removePK(ddls);
                return;
            }
            if (mainDDL.indexOf(" WITH ROWID ") > -1 || mainDDL.indexOf(" GROUP BY ") > -1) {
                return;
            }
            String tableObjKey = null;
            for (String dependency : dependencies) {
                if (dependency.startsWith("TABLE_")) {
                    if (tableObjKey != null) {
                        return;
                    }
                    tableObjKey = dependency;
                    continue;
                }
                if (!dependency.startsWith("VIEW_") && !dependency.startsWith("MATERIALIZED VIEW_")) continue;
                return;
            }
            if (tableObjKey != null && (mvPKDDL = this.getPKDDL(objKey, ddlMap)) != null && (tablePKDDL = this.getPKDDL(tableObjKey, ddlMap)) != null) {
                String mvPKName = Token.getQuotedNameAfterToken(mvPKDDL, "CONSTRAINT");
                String tablePKName = Token.getQuotedNameAfterToken(tablePKDDL, "CONSTRAINT");
                if (tablePKName.length() > 27) {
                    tablePKName = tablePKName.substring(0, 27);
                }
                if (!tablePKName.isEmpty() && mvPKName.startsWith(tablePKName)) {
                    this.removePK(ddls);
                }
            }
        }
    }

    private void removePK(List<String> ddls) {
        String pkName = null;
        String[] pkColumns = new String[]{};
        boolean modifyNotNullFound = false;
        block0: for (int i = ddls.size() - 1; i > 0; --i) {
            String ddl = ddls.get(i);
            if (ddl.startsWith("ALTER ")) {
                String modifyClause;
                int j;
                if (ddl.indexOf(" PRIMARY KEY") > -1) {
                    if (ddl.indexOf(" ADD ") > -1) {
                        pkName = Token.getQuotedNameAfterToken(ddl, "CONSTRAINT");
                        String afterPK = Token.getStringAfter(ddl, "PRIMARY KEY");
                        String columnList = Token.getValBetweenBrackets(afterPK, 1);
                        pkColumns = columnList.split(",");
                        for (j = 0; j < pkColumns.length; ++j) {
                            pkColumns[j] = Token.getFirstName(pkColumns[j], '\"', '\"');
                        }
                    }
                    ddls.remove(i);
                    if (!modifyNotNullFound) continue;
                    i = ddls.size();
                    continue;
                }
                if (ddl.indexOf(" MODIFY") <= -1 || (modifyClause = Token.getValBetweenBrackets(Token.getStringAfter(ddl, "MODIFY"), 1)).indexOf(" NOT NULL ") <= -1) continue;
                modifyNotNullFound = true;
                String columnName = Token.getFirstName(modifyClause, '\"', '\"');
                for (j = 0; j < pkColumns.length; ++j) {
                    if (!columnName.equals(pkColumns[j]) || columnName.isEmpty()) continue;
                    ddls.remove(i);
                    continue block0;
                }
                continue;
            }
            if (pkName == null || !ddl.startsWith("CREATE UNIQUE")) continue;
            String indexName = Token.getQuotedNameAfterToken(ddl, "INDEX");
            if (!(indexName = indexName.substring(indexName.indexOf(46) + 1)).equals(pkName)) continue;
            ddls.remove(i);
        }
    }

    private String getPKDDL(String objKey, Map<String, List<String>> ddlMap) {
        List<String> ddls = ddlMap.get(objKey);
        if (ddls != null) {
            for (int i = 1; i < ddls.size(); ++i) {
                String ddl = ddls.get(i);
                if (!ddl.startsWith("ALTER ") || ddl.indexOf(" PRIMARY KEY ") <= -1 || ddl.indexOf(" ENABLE") <= -1) continue;
                return ddl;
            }
        }
        return null;
    }

    private List<String> findDDLsForTableViewOrMV(Map<String, List<String>> ddlMap, String objName) {
        String objKey = "TABLE_" + objName;
        List<String> mapDDLs = ddlMap.get(objKey);
        if (mapDDLs == null && (mapDDLs = ddlMap.get(objKey = "VIEW_" + objName)) == null && (mapDDLs = ddlMap.get(objKey = "MATERIALIZED_VIEW_" + objName)) == null && (mapDDLs = ddlMap.get(objKey = "CLUSTER_" + objName)) == null) {
            objKey = "SYNONYM_" + objName;
            mapDDLs = ddlMap.get(objKey);
        }
        return mapDDLs;
    }

    private String findObjKeyForObject(Map<String, List<String>> ddlMap, String objName) {
        for (int i = 0; i < objTypes.length; ++i) {
            String objKey = objTypes[i] + "_" + objName;
            if (!ddlMap.containsKey(objKey)) continue;
            return objKey;
        }
        return null;
    }

    private static String getCondition(List<String> list) {
        String res = null;
        if (list.size() == 1) {
            res = "'" + list.get(0) + "'";
        } else if (list.size() > 1) {
            res = "' = ''" + list.get(0) + "'''";
        }
        return res;
    }

    private static String getInElements(List<String> list) {
        String res = null;
        for (String name : list) {
            if (res == null) {
                res = "''" + name + "''";
                continue;
            }
            res = res + ",''" + name + "''";
        }
        return res;
    }

    private static String getTExpression(List<String> list, String[] pref) {
        Object res = "";
        if (list.size() > 0) {
            int k = 0;
            int cl = 0;
            boolean first = true;
            Object tres = null;
            for (String name : list) {
                String tname = "''" + StringUtilities.fixSingleQuoteInName(name) + "''";
                if (cl + tname.length() > 4000) {
                    res = (String)res + tres;
                    tres = null;
                    ++k;
                    first = true;
                }
                if (tres == null) {
                    tres = pref[k];
                }
                if (first) {
                    first = false;
                    tres = (String)tres + tname;
                } else {
                    tres = (String)tres + "," + tname;
                }
                cl = ((String)tres).length();
            }
            res = (String)res + tres + "'";
        }
        return res;
    }

    static {
        PARAM_NAMES.put("basicDefinitionsOnly", "basicDefinitionsOnly");
        PARAM_NAMES.put("types", "types");
        PARAM_NAMES.put("partitions", "partitions");
        PARAM_NAMES.put("triggers", "triggers");
        PARAM_NAMES.put("spatial", "spatial");
        PARAM_NAMES.put("comments", "comments");
        PARAM_NAMES.put("includeDefaultSettings", "includeDefaultSettings");
        PARAM_NAMES.put("storage", "storage");
        PARAM_NAMES.put("obj_grants", "obj_grants");
        PARAM_NAMES.put("constraints", "constraints");
        PARAM_NAMES.put("tables", "tables");
        PARAM_NAMES.put("views", "views");
        PARAM_NAMES.put("mviews", "mviews");
        PARAM_NAMES.put("mvlogs", "mvlogs");
        PARAM_NAMES.put("proc", "proc");
        PARAM_NAMES.put("func", "func");
        PARAM_NAMES.put("pack", "pack");
        PARAM_NAMES.put("seq", "seq");
        PARAM_NAMES.put("syn", "syn");
        PARAM_NAMES.put("psyn", "psyn");
        PARAM_NAMES.put("dim", "dim");
        PARAM_NAMES.put("clust", "clust");
        PARAM_NAMES.put("indexes", "indexes");
        PARAM_NAMES.put("bytesize", "bytesize");
        PARAM_NAMES.put("showschema", "showschema");
        PARAM_NAMES.put("all_dependent", "all_dependent");
        PARAM_NAMES.put("systemNames", "systemNames");
        PARAM_NAMES.put("useDBMetadataDDL", "useDBMetadataDDL");
        PARAM_NAMES.put("quoted", "quoted");
        PARAM_PLSQL_NAMES = new TreeMap<String, String>();
        PARAM_PLSQL_NAMES.put("basicDefinitionsOnly", "basicDefinitionsOnly");
        PARAM_PLSQL_NAMES.put("types", "ftypes");
        PARAM_PLSQL_NAMES.put("partitions", "fpartitions");
        PARAM_PLSQL_NAMES.put("triggers", "ftriggers");
        PARAM_PLSQL_NAMES.put("spatial", "spatial");
        PARAM_PLSQL_NAMES.put("comments", "fcomments");
        PARAM_PLSQL_NAMES.put("includeDefaultSettings", "includeDefaultSettings");
        PARAM_PLSQL_NAMES.put("storage", "fstorage");
        PARAM_PLSQL_NAMES.put("obj_grants", "fobj_grants");
        PARAM_PLSQL_NAMES.put("constraints", "fconstraints");
        PARAM_PLSQL_NAMES.put("tables", "ftables");
        PARAM_PLSQL_NAMES.put("views", "fviews");
        PARAM_PLSQL_NAMES.put("mviews", "fmviews");
        PARAM_PLSQL_NAMES.put("mvlogs", "fmvlog");
        PARAM_PLSQL_NAMES.put("proc", "fproc");
        PARAM_PLSQL_NAMES.put("func", "ffunc");
        PARAM_PLSQL_NAMES.put("pack", "fpack");
        PARAM_PLSQL_NAMES.put("seq", "fseq");
        PARAM_PLSQL_NAMES.put("syn", "fsyn");
        PARAM_PLSQL_NAMES.put("psyn", "fpsyn");
        PARAM_PLSQL_NAMES.put("dim", "fdim");
        PARAM_PLSQL_NAMES.put("clust", "fclust");
        PARAM_PLSQL_NAMES.put("indexes", "findexes");
        PARAM_PLSQL_NAMES.put("bytesize", "fbytesize");
        PARAM_PLSQL_NAMES.put("showschema", "fschema");
        PARAM_PLSQL_NAMES.put("all_dependent", "all_dependent");
        PARAM_PLSQL_NAMES.put("systemNames", "systemNames");
        PARAM_PLSQL_NAMES.put("useDBMetadataDDL", "useDBMetadataDDL");
        PARAM_PLSQL_NAMES.put("quoted", "quoted");
        PARAM_DEFALTS = new TreeMap();
        PARAM_DEFALTS.put("basicDefinitionsOnly", "basicDefinitionsOnly");
        PARAM_DEFALTS.put("tables", "true");
        PARAM_DEFALTS.put("views", "true");
        PARAM_DEFALTS.put("indexes", "true");
        PARAM_DEFALTS.put("triggers", "true");
        PARAM_DEFALTS.put("mviews", "true");
        PARAM_DEFALTS.put("mvlogs", "true");
        PARAM_DEFALTS.put("types", "true");
        PARAM_DEFALTS.put("partitions", "true");
        PARAM_DEFALTS.put("spatial", "false");
        PARAM_DEFALTS.put("comments", "true");
        PARAM_DEFALTS.put("includeDefaultSettings", "false");
        PARAM_DEFALTS.put("storage", "true");
        PARAM_DEFALTS.put("obj_grants", "true");
        PARAM_DEFALTS.put("constraints", "true");
        PARAM_DEFALTS.put("proc", "true");
        PARAM_DEFALTS.put("func", "true");
        PARAM_DEFALTS.put("pack", "true");
        PARAM_DEFALTS.put("seq", "true");
        PARAM_DEFALTS.put("syn", "true");
        PARAM_DEFALTS.put("psyn", "true");
        PARAM_DEFALTS.put("dim", "true");
        PARAM_DEFALTS.put("clust", "true");
        PARAM_DEFALTS.put("bytesize", "false");
        PARAM_DEFALTS.put("all_dependent", "true");
        PARAM_DEFALTS.put("systemNames", "false");
        PARAM_DEFALTS.put("useDBMetadataDDL", "false");
        PARAM_DEFALTS.put("quoted", "false");
        DOT = (char)46;
        objTypes = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "SEQUENCE", "PROCEDURE", "FUNCTION", "PACKAGE", "TYPE", "SYNONYM", "DB_LINK"};
        types_order = new ArrayList<String>();
        types_order.add("TYPE");
        types_order.add("TYPE BODY");
        types_order.add("SEQUENCE");
        types_order.add("CLUSTER");
        types_order.add("TABLE");
        types_order.add("MATERIALIZED_VIEW");
        types_order.add("VIEW");
        types_order.add("COMMENT");
        types_order.add("CONSTRAINT");
        types_order.add("REF_CONSTRAINT");
        types_order.add("MATERIALIZED_VIEW_LOG");
        types_order.add("DIMENSION");
        types_order.add("FUNCTION");
        types_order.add("PROCEDURE");
        types_order.add("PACKAGE");
        types_order.add("DB_LINK");
        types_order.add("SYNONYM");
        types_order.add("INDEX");
        types_order.add("TRIGGER");
        types_order.add("PACKAGE_BODY");
        PARAM_LIST = new ArrayList<String>();
        PARAM_LIST.add("tables");
        PARAM_LIST.add("views");
        PARAM_LIST.add("indexes");
        PARAM_LIST.add("triggers");
        PARAM_LIST.add("constraints");
        PARAM_LIST.add("mviews");
        PARAM_LIST.add("mvlogs");
        PARAM_LIST.add("types");
        PARAM_LIST.add("seq");
        PARAM_LIST.add("syn");
        PARAM_LIST.add("psyn");
        PARAM_LIST.add("pack");
        PARAM_LIST.add("proc");
        PARAM_LIST.add("func");
        PARAM_LIST.add("clust");
        PARAM_LIST.add("dim");
        PARAM_LIST.add("obj_grants");
        PARAM_LIST.add("partitions");
        PARAM_LIST.add("comments");
        PARAM_LIST.add("storage");
        PARAM_LIST.add("bytesize");
        PARAM_LIST.add("showschema");
        PARAM_LIST.add("all_dependent");
        tpref = new String[]{",table_expr1=>'", "',tbl2=>'", "',tbl3=>'", "',tbl4=>'", "',tbl5=>'", "',tbl6=>'", "',tbl7=>'", "',tbl8=>'"};
        vpref = new String[]{",view_expr1=>'", "',vw2=>'", "',vw3=>'", "',vw4=>'", "',vw5=>'", "',vw6=>'", "',vw7=>'", "',vw8=>'"};
    }

    class DDL_Row {
        String schema;
        String name;
        String type;
        String pschema;
        String pname;
        String ptype;
        String ddl;

        DDL_Row() {
        }
    }
}

