/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.SchemaDDLGenerator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.util.Closeables;

public class MOHSynonymOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SYNONYM";
    private static final Logger LOGGER = new Logger(MOHSynonymOracle.class);
    protected boolean dbaUser;

    public MOHSynonymOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHSynonymOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract Synonym begin");
        PreparedStatement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        TreeMap<String, DBObject> map = new TreeMap<String, DBObject>();
        try {
            int ver = this.getDbmeHandler().getDBMajorVersion();
            if (ver == 12 && this.getDbmeHandler().getDbMinorVersion() > 1) {
                ver = 13;
            }
            ver = 11;
            Settings s = this.getDesign().getSettings();
            boolean syn = s.isImportSynonyms();
            boolean psyn = s.isImportPublicSynonyms();
            ArrayList cschemas = new ArrayList(schemas);
            for (DBObject dboNext : cschemas) {
                if (!dboNext.isSelected()) continue;
                if (statement == null) {
                    String filterCondition = this.getFilterConditionOracle("SYNONYM_NAME");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("SYNONYM_NAME").append(',');
                    buffer.append("TABLE_OWNER").append(',');
                    buffer.append("TABLE_NAME").append(',');
                    buffer.append("DB_LINK").append(',');
                    if (ver >= 12) {
                        buffer.append("OWNER").append(',');
                        if (ver > 12) {
                            buffer.append("EDITIONABLE").append(',');
                            buffer.append("sharing").append(' ');
                        } else {
                            buffer.append("EDITIONABLE").append(' ');
                        }
                    } else {
                        buffer.append("OWNER").append(' ');
                    }
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? "dba_synonyms" : "all_synonyms").append(' ');
                    buffer.append("WHERE").append(' ');
                    if (syn) {
                        if (psyn) {
                            buffer.append('(');
                        }
                        buffer.append("OWNER").append('=').append('?').append(' ');
                        if (psyn) {
                            buffer.append("OR");
                        }
                    }
                    if (psyn) {
                        buffer.append(' ').append("OWNER").append('=').append("'PUBLIC' and ").append("TABLE_OWNER").append('=').append('?');
                        if (syn) {
                            buffer.append(')');
                        }
                        buffer.append(' ');
                    }
                    buffer.append(" and synonym_name not like '/%' ");
                    if (filterCondition != null) {
                        buffer.append("AND").append(' ').append(filterCondition).append(' ');
                    }
                    buffer.append("ORDER BY").append(' ').append("SYNONYM_NAME");
                    String sql = buffer.toString();
                    if (this.getDbmeHandler().getLimit() > 0) {
                        sql = this.getDbmeHandler().getPaginatedQuery(sql);
                    }
                    statement = sqlConnection.prepareStatement(sql);
                }
                ResultSet rs = null;
                try {
                    if (syn && psyn) {
                        statement.setString(1, dboNext.getName());
                        statement.setString(2, dboNext.getName());
                    } else {
                        statement.setString(1, dboNext.getName());
                    }
                    rs = statement.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            String sName = rs.getString(1);
                            String table_owner = rs.getString(2);
                            String table_name = rs.getString(3);
                            String db_link = rs.getString(4);
                            String syn_owner = rs.getString(5);
                            DBObject dboSynonym = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), sName, OBJECT_TYPE, syn_owner);
                            String key = dboSynonym.toString();
                            Object dbo = map.get(key);
                            if (dbo != null) continue;
                            map.put(key, dboSynonym);
                            SchemaDDLGenerator.SynonymDescriptor ds = new SchemaDDLGenerator.SynonymDescriptor();
                            ds.tname = table_name;
                            ds.towner = table_owner;
                            ds.db_link = db_link;
                            if (ver >= 12) {
                                ds.editionable = rs.getString(6);
                                if (ver > 12) {
                                    ds.sharing = rs.getString(7);
                                }
                            }
                            dboSynonym.setDescrptiveObject(ds);
                            list.add(dboSynonym);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHSynonymOracle.extract():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
        map.clear();
        TimeLog.log("Extract Synonym end");
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        TimeLog.log("Synonyms begin");
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            if (storageDesign != null) {
                SchemaDDLGenerator.SynonymDescriptor ds;
                SynonymOracle synonym = storageDesign.getSynonymSet().createSynonym();
                String name = dbo.getName();
                String owner = dbo.getSchema();
                if ("PUBLIC".equalsIgnoreCase(owner)) {
                    synonym.setPublic("YES");
                } else {
                    this.setUser(synonym, storageDesign, owner);
                }
                synonym.setName(name);
                if (!name.equals(name.toUpperCase())) {
                    synonym.setNameHasQuotes(true);
                }
                if ((ds = (SchemaDDLGenerator.SynonymDescriptor)dbo.getDescrptiveObject()) != null) {
                    UserOracle user;
                    synonym.setDBLink(ds.db_link);
                    synonym.setObject(ds.tname);
                    if (!ds.tname.equals(ds.tname.toUpperCase())) {
                        synonym.setObjNameHasQuotes(true);
                    }
                    if ((user = (UserOracle)storageDesign.getUserSet().getByName(ds.towner)) == null) {
                        user = (UserOracle)storageDesign.getUserSet().createElement(null);
                        user.setName(ds.towner);
                        this.stampModelObject((ModelObject)user, "", ds.towner);
                    }
                    synonym.setObjectUser(user);
                    this.stampModelObject(synonym, dbo);
                } else {
                    SchemaDDLGenerator.SynonymDescriptor d = SchemaDDLGenerator.getSynonymDescriptor(sqlConnection, owner, name);
                    if (d != null) {
                        UserOracle user;
                        synonym.setDBLink(d.db_link);
                        synonym.setObject(d.tname);
                        if (!d.tname.equals(d.tname.toUpperCase())) {
                            synonym.setObjNameHasQuotes(true);
                        }
                        if ((user = (UserOracle)storageDesign.getUserSet().getByName(d.towner)) == null) {
                            user = (UserOracle)storageDesign.getUserSet().createElement(null);
                            user.setName(d.towner);
                            this.stampModelObject((ModelObject)user, "", d.towner);
                        }
                        synonym.setObjectUser(user);
                        this.stampModelObject(synonym, dbo);
                    }
                }
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        TimeLog.log("Synonyms end");
    }

    private void setUser(SynonymOracle synonym, StorageDesignOracle storageDesign, String userName) {
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        if (user == null) {
            user = (UserOracle)storageDesign.getUserSet().createElement(null);
            user.setName(userName);
            this.stampModelObject((ModelObject)user, "", userName);
        }
        synonym.setUser(user);
    }

    public static String getSynonymObjectName(DBObject dbo) {
        SchemaDDLGenerator.SynonymDescriptor ds = (SchemaDDLGenerator.SynonymDescriptor)dbo.getDescrptiveObject();
        if (ds != null) {
            return ds.tname;
        }
        return "";
    }

    public static String getSynonymObjectOwner(DBObject dbo) {
        SchemaDDLGenerator.SynonymDescriptor ds = (SchemaDDLGenerator.SynonymDescriptor)dbo.getDescrptiveObject();
        if (ds != null) {
            return ds.towner;
        }
        return "";
    }

    static class DescSyn {
        String dblink;
        String tablename;
        String tableowner;

        DescSyn() {
        }
    }
}

