/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.lang.invoke.CallSite;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class Columns12c
implements DBMOConstants {
    private PreparedStatement xmlTypeCols_st = null;
    private PreparedStatement identityCols_st = null;
    private Map colMap = null;
    private StorageDesign sd;
    private boolean dbaUser;
    private static final Logger LOGGER = new Logger(Columns12c.class);
    AbstractDBMExtractionHandler handler;
    protected static final String SIZE = "size";
    protected static final String SCALE = "scale";
    protected static final String PRECISION = "precision";

    public Columns12c(StorageDesign sd, boolean dbaUser, AbstractDBMExtractionHandler handler, Map colMap) {
        this.sd = sd;
        this.dbaUser = dbaUser;
        this.handler = handler;
        this.colMap = colMap;
    }

    public void initColumns12(Connection sqlConnection, List<DBObject> dbos, StorageDesign sd) throws Exception {
        this.colMap.clear();
        if (dbos.size() == 0) {
            return;
        }
        this.xmlTypeCols_st = null;
        HashMap<CallSite, DBObject> nmap = new HashMap<CallSite, DBObject>();
        String schema = "";
        for (DBObject dbo : dbos) {
            if (dbo.getTable() == null) continue;
            schema = dbo.getSchema();
            String name = dbo.getName();
            nmap.put((CallSite)((Object)(schema + "." + name)), dbo);
        }
        StorageDesign storageDesign = this.getStorageDesign();
        boolean oraclev11g = storageDesign instanceof StorageDesignOraclev11g;
        boolean oraclev12c = storageDesign instanceof StorageDesignOraclev12c;
        boolean importEncryption = oraclev11g && storageDesign.getDesign().getSettings().isIncludeEncryptionInDDL();
        TreeMap<Object, TypeHolder> map = new TreeMap<Object, TypeHolder>();
        String sql = this.getSQL(this.dbaUser, importEncryption, dbos);
        PreparedStatement statement = sqlConnection.prepareStatement(sql);
        ResultSet rs = null;
        try {
            statement.setString(1, schema);
            statement.setString(2, schema);
            int k = 3;
            for (DBObject dbo : dbos) {
                if (dbo.getTable() == null) continue;
                statement.setString(k, dbo.getName());
                ++k;
            }
            rs = statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOraclev9i.initColumns():", e);
        }
        RDBMSType dbtype = storageDesign.getRDBMSType();
        if (rs != null) {
            boolean hasXMLTypeColumns = false;
            boolean hasIdentityColumn = false;
            while (rs.next()) {
                String[] cols;
                schema = rs.getString(1);
                String name = rs.getString(2);
                DBObject dbo = (DBObject)nmap.get(schema + "." + name);
                Table table = (Table)dbo.getTable();
                TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                Clob clob = rs.getClob(3);
                String text = clob.getSubString(1L, (int)clob.length());
                for (String cc : cols = text.split("&&&&\r\n")) {
                    ColumnProxyOracle columnProxy;
                    TypeHolder th;
                    Column column;
                    boolean nameNeedsQuotes;
                    String char_used;
                    String[] ctext = cc.split("[|]{3}");
                    String colName = ctext[0];
                    String colDatatype = ctext[1];
                    String ref = ctext[2];
                    String dt_owner = ctext[3];
                    String clength = ctext[4];
                    String pres = ctext[5];
                    int colSize = 0;
                    int colPrecision = 0;
                    if (clength != null) {
                        try {
                            colSize = Integer.valueOf(clength);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (pres != null) {
                        try {
                            colPrecision = Integer.valueOf(pres);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String scale = ctext[6];
                    int colScale = 0;
                    if (scale != null) {
                        try {
                            colScale = Integer.valueOf(scale);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    char_used = (char_used = ctext[7]) == null ? "" : (char_used.equalsIgnoreCase("C") ? " CHAR" : (char_used.equalsIgnoreCase("B") ? " BYTE" : ""));
                    String chrl = ctext[8];
                    int charLength = 0;
                    if (chrl != null) {
                        try {
                            charLength = Integer.valueOf(chrl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String allowNull = ctext[9];
                    String colid = ctext[10];
                    int columnSeqNo = 0;
                    if (oraclev12c) {
                        colid = ctext[16];
                        if (importEncryption) {
                            colid = ctext[19];
                        }
                    }
                    if (colid != null) {
                        try {
                            columnSeqNo = Integer.valueOf(colid);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String virtualCol = ctext[11];
                    String encryptionAlg = importEncryption ? ctext[16] : null;
                    String salt = importEncryption ? ctext[17] : null;
                    String hiddenColumn = oraclev12c ? ctext[12] : "";
                    String userGenerated = oraclev12c ? ctext[13] : "YES";
                    String defaultOnNull = oraclev12c ? ctext[14] : "";
                    String identityColumn = oraclev12c ? ctext[15] : "";
                    String integrityAlg = oraclev12c && importEncryption ? ctext[18] : null;
                    int defind = importEncryption ? 20 : 17;
                    String colDefault = null;
                    if (ctext.length == defind + 1) {
                        colDefault = importEncryption ? ctext[20] : ctext[17];
                    }
                    boolean bl = nameNeedsQuotes = !colName.equals(colName.toUpperCase());
                    if ("NO".equals(userGenerated) && "YES".equals(hiddenColumn)) {
                        if ("YES".equals(virtualCol) && "NUMBER".equals(colDatatype) && !colName.startsWith("SYS_")) {
                            ValidTimeDimension validTimeDimension = table.createValidTimeDimension();
                            validTimeDimension.setName(colName);
                            validTimeDimension.setNameHasQuotes(nameNeedsQuotes);
                            this.stampModelObject(validTimeDimension, table.getName(), colName);
                            continue;
                        }
                        if (!"ORA_ARCHIVE_STATE".equals(colName) || !"VARCHAR2".equals(colDatatype)) continue;
                        table.setRowArchival(true);
                        continue;
                    }
                    if (table.isBST()) {
                        column = (Column)table.getElementByName(colName);
                        if (column == null) {
                            continue;
                        }
                    } else {
                        column = table.createColumn(colName);
                        column.setNameHasQuotes(nameNeedsQuotes);
                        this.stampModelObject(column, table.getName(), colName);
                    }
                    colDatatype = this.removeBrackets(colDatatype).trim();
                    Object nativeType = colDatatype;
                    if (dt_owner != null) {
                        if (colDatatype.equals("XMLTYPE")) {
                            if ("REF".equalsIgnoreCase(ref)) {
                                nativeType = "REF XMLTYPE";
                            } else {
                                hasXMLTypeColumns = true;
                            }
                        } else {
                            if (!colDatatype.equals(colDatatype.toUpperCase())) {
                                nativeType = "\"" + colDatatype + "\"";
                            }
                            nativeType = dt_owner + "." + (String)nativeType;
                            if ("REF".equalsIgnoreCase(ref)) {
                                nativeType = "REF " + (String)nativeType;
                            }
                        }
                    }
                    if ((th = (TypeHolder)map.get(colDatatype)) == null) {
                        th = new TypeHolder();
                        map.put(nativeType, th);
                        boolean st_col_used = false;
                        if (dt_owner != null) {
                            StructuredType st = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(colDatatype);
                            if (st != null) {
                                th.strDT = true;
                                th.strdt = st;
                                st_col_used = true;
                            } else {
                                CollectionType ct = (CollectionType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(colDatatype);
                                if (ct != null) {
                                    th.colDT = true;
                                    th.coldt = ct;
                                    st_col_used = true;
                                }
                            }
                        }
                        if (!st_col_used) {
                            String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
                            LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, usedDatatype);
                            if (logDatatype == null) {
                                NativeDBType nt = StandardDatatypeNames.getNativeDBType(dbtype, usedDatatype);
                                if (nt == null && dt_owner != null) {
                                    nt = StandardDatatypeNames.getNativeDBType(dbtype, dt_owner + "." + usedDatatype);
                                }
                                if (nt != null) {
                                    logDatatype = nt.getLogicalDatatype();
                                }
                            }
                            if (logDatatype == null) {
                                logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
                            }
                            if (logDatatype != null && !"UNKNOWN".equalsIgnoreCase(usedDatatype)) {
                                th.ldt = logDatatype;
                                th.logicalDT = true;
                            } else {
                                th.ukndt = logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByName("UNKNOWN");
                                th.unknownDT = true;
                            }
                        }
                    }
                    if (th.logicalDT) {
                        colDatatype = colDatatype.toUpperCase();
                        column.setUse((short)1);
                        column.setLogicalDatatype(th.ldt);
                        if (colDatatype.startsWith("TIMESTAMP")) {
                            column.setDataTypeParameter(PRECISION, String.valueOf(colScale));
                        } else {
                            if (colDatatype.equals("CHAR") || colDatatype.equals("VARCHAR2") || colDatatype.equals("VARCHAR")) {
                                this.setParameter(column, SIZE, Integer.toString(charLength) + char_used);
                            } else if (colDatatype.equals("NCHAR") || colDatatype.equals("NVARCHAR2") || colDatatype.equals("NVARCHAR")) {
                                this.setParameter(column, SIZE, Integer.toString(charLength));
                            } else if (colSize != 0) {
                                column.setDataTypeParameter(SIZE, String.valueOf(colSize));
                            }
                            if (pres != null && !pres.isEmpty()) {
                                column.setDataTypeParameter(PRECISION, String.valueOf(colPrecision));
                                if (scale != null && !scale.isEmpty()) {
                                    column.setDataTypeParameter(SCALE, String.valueOf(colScale));
                                }
                                column.setDataTypeSize(null);
                            } else if (scale != null && !scale.isEmpty()) {
                                this.setParameter(column, PRECISION, "*");
                                this.setParameter(column, SCALE, scale);
                                column.setDataTypeSize(null);
                            } else if (colDatatype.startsWith("NUM")) {
                                column.setDataTypeSize(null);
                            }
                        }
                        if (colDatatype.equals("BLOB") || colDatatype.equals("CLOB") || colDatatype.equals("NCLOB")) {
                            dbo.hasLOBs = true;
                        }
                        nativeType = column.getDatatypeString(storageDesign.getRDBMSType().getName());
                    } else if (th.strDT) {
                        if ("REF".equalsIgnoreCase(ref)) {
                            column.setUse((short)3);
                            column.setReference(true);
                            column.setStructuredType(th.strdt);
                        } else if (colDatatype.equalsIgnoreCase("XMLTYPE")) {
                            column.setUse((short)1);
                            column.setLogicalDatatype(this.getDesign().getLogicalDatatypeSet().getLogTypeByName("XMLTYPE"));
                            hasXMLTypeColumns = true;
                        } else {
                            column.setUse((short)3);
                            column.setStructuredType(th.strdt);
                            dbo.hasLOBs = true;
                        }
                    } else if (th.colDT) {
                        column.setUse((short)4);
                        column.setCollectionType(th.coldt);
                        dbo.hasLOBs = true;
                    } else {
                        column.setUse((short)1);
                        column.setLogicalDatatype(th.ukndt);
                    }
                    column.setNativeDataType((String)nativeType);
                    column.setNullsAllowed("Y".equalsIgnoreCase(allowNull));
                    if (hiddenColumn.equals("YES") && (columnProxy = this.getColumnProxy(column)) instanceof ColumnProxyOraclev12c) {
                        ((ColumnProxyOraclev12c)columnProxy).setInvisible("YES");
                    }
                    if (identityColumn.equals("YES")) {
                        hasIdentityColumn = true;
                        column.setAutoIncrementColumn(true);
                        column.setIdentityColumn(true);
                        columnProxy = this.getColumnProxy(column);
                        if (columnProxy != null) {
                            columnProxy.setAutoIncrementDDL("IDENTITY_CLAUSE");
                        }
                    } else if (colDefault != null) {
                        boolean identCol = false;
                        colDefault = colDefault.trim();
                        if ("YES".equalsIgnoreCase(virtualCol)) {
                            column.setComputed(true);
                            column.setFormulaDesc(colDefault);
                            column.setSourceType("Derived");
                        } else {
                            ColumnProxyOracle columnProxy2;
                            String unquotedName;
                            int lastDotIndex = colDefault.lastIndexOf(46);
                            if (lastDotIndex > -1 && colDefault.substring(lastDotIndex).equalsIgnoreCase(".NEXTVAL") && (unquotedName = Token.getFirstName(colDefault, '\"', '\"')).length() >= colDefault.length() - 4 && (columnProxy2 = this.getColumnProxy(column)) instanceof ColumnProxyOraclev12c) {
                                column.setAutoIncrementColumn(true);
                                column.setIdentityColumn(true);
                                column.setSourceType("System");
                                identCol = true;
                                columnProxy2.setAutoIncrementDDL("DEFAULT_CLAUSE");
                                String seqName = unquotedName.substring(0, unquotedName.length() - 8);
                                String seqUser = "";
                                int dotIndex = seqName.lastIndexOf(46);
                                if (dotIndex > -1) {
                                    seqUser = seqName.substring(0, dotIndex);
                                    seqName = seqName.substring(dotIndex + 1);
                                }
                                column.setAutoIncrementSequenceName(seqName);
                                if (!seqUser.isEmpty()) {
                                    UserOracle user = (UserOracle)((StorageDesignOracle)storageDesign).getUserSet().getByName(seqUser);
                                    if (user == null) {
                                        user = ((StorageDesignOracle)storageDesign).getUserSet().createUser();
                                        user.setName(seqUser);
                                    }
                                    columnProxy2.setAutoIncrementUser(user);
                                }
                            }
                            if (!identCol) {
                                column.setDefaultValue(colDefault);
                            }
                        }
                    }
                    if (defaultOnNull.equals("YES")) {
                        column.setDefaultOnNull(true);
                        columnProxy = this.getColumnProxy(column);
                        if (columnProxy instanceof ColumnProxyOraclev12c) {
                            ((ColumnProxyOraclev12c)columnProxy).setDefaultOnNull("YES");
                        }
                    }
                    if (encryptionAlg != null && !encryptionAlg.isEmpty() && (columnProxy = this.getColumnProxy(column)) instanceof ColumnProxyOraclev11g) {
                        ColumnProxyOraclev11g columnProxy11g = (ColumnProxyOraclev11g)columnProxy;
                        columnProxy11g.setEncrypt("YES");
                        if (encryptionAlg.equalsIgnoreCase("AES 192 bits key")) {
                            columnProxy11g.setEncryptionAlgorithm("AES192");
                        } else if (encryptionAlg.equalsIgnoreCase("AES 128 bits key")) {
                            columnProxy11g.setEncryptionAlgorithm("AES128");
                        } else if (encryptionAlg.equalsIgnoreCase("AES 256 bits key")) {
                            columnProxy11g.setEncryptionAlgorithm("AES256");
                        } else if (encryptionAlg.equalsIgnoreCase("3 Key Triple DES 168 bits key")) {
                            columnProxy11g.setEncryptionAlgorithm("3DES168");
                        }
                        if ("SHA-1".equalsIgnoreCase(integrityAlg)) {
                            columnProxy11g.setIntegrityAlgorithm("SHA-1");
                        } else if ("NOMAC".equalsIgnoreCase(integrityAlg)) {
                            columnProxy11g.setIntegrityAlgorithm("NOMAC");
                        }
                        if (salt != null && !salt.isEmpty()) {
                            columnProxy11g.setUseSalt(salt);
                        }
                    }
                    if (tableProxy == null || !tableProxy.getOrganization().equals("INDEX")) continue;
                    if (this.colMap == null) {
                        this.colMap = new TreeMap();
                    }
                    String colMapKey = dbo.getSchema() + ":" + dbo.getName() + ":" + Integer.toString(columnSeqNo);
                    this.colMap.put(colMapKey, column.getObjectID());
                }
            }
            rs.close();
            for (DBObject dbo : dbos) {
                if (hasXMLTypeColumns && dbo != null) {
                    this.initXMLTypeColumns(sqlConnection, dbo);
                }
                if (!hasIdentityColumn || dbo == null) continue;
                this.initIdentityColumn(sqlConnection, dbo);
            }
        }
        if (this.xmlTypeCols_st != null) {
            this.xmlTypeCols_st.close();
            this.xmlTypeCols_st = null;
        }
        if (this.identityCols_st != null) {
            this.identityCols_st.close();
            this.identityCols_st = null;
        }
        statement.close();
    }

    private AbstractDBMExtractionHandler getDbmeHandler() {
        return this.handler;
    }

    private StorageDesign getStorageDesign() {
        return this.sd;
    }

    private Design getDesign() {
        return this.sd.getDesign();
    }

    public void stampModelObject(ModelObject obj, String schemaName, String objectName) {
        RelationalDesign rel = this.getRelationalDesign();
        if (obj instanceof DesignObject) {
            if (((DesignObject)obj).getDesignPart() instanceof RelationalDesign) {
                rel = (RelationalDesign)((DesignObject)obj).getDesignPart();
            }
        } else if (obj instanceof StorageObject) {
            rel = ((StorageObject)obj).getStorageDesign().getPhysicalDesign();
        }
        if (!rel.getImportConnectionStamps().isEmpty() && rel.getImportConnectionStampIndex() > -1) {
            int index = rel.getImportConnectionStampIndex();
            DBConnectionStamp importConnStamp = rel.getImportConnectionStamp(index);
            obj.setSourceConnName(importConnStamp.getConnName());
            obj.setSourceObjSchema(schemaName != null ? schemaName : "");
            obj.setSourceObjName(objectName);
        }
    }

    protected void setParameter(Column column, String param, String value) {
        column.setDataTypeParameter(param, value);
    }

    private RelationalDesign getRelationalDesign() {
        if (this.sd != null) {
            return this.sd.getPhysicalDesign();
        }
        return null;
    }

    private ColumnProxyOracle getColumnProxy(Column column) {
        return (ColumnProxyOracle)this.getStorageDesign().getColumnProxySet().getProxy(column.getObjectID());
    }

    protected String removeBrackets(String input) {
        Object result;
        int length = input.length();
        int ind = input.indexOf(40);
        if (ind > 0) {
            result = input.substring(0, ind);
            int close_ind = input.indexOf(41);
            if (close_ind > 0 && close_ind < length - 1) {
                String rest = input.substring(close_ind + 1, length);
                result = ((String)result).trim() + " " + this.removeBrackets(rest).trim();
            }
        } else {
            result = input;
        }
        return result;
    }

    String getSQL(boolean dbaUser, boolean includeEncription, List<DBObject> dbos) {
        String sql = "with\r\nfunction mf1(schema in varchar2, name in varchar2) return clob is\r\ncl1 clob;\r\ncrlf  VARCHAR2(2) := chr(13)||chr(10); \r\nc varchar2(3) := '|||';\r\n cursor ss(sh varchar2, n varchar2) is\r\n SELECT\r\n    A.OWNER,\r\n    A.TABLE_NAME,\r\n    A.COLUMN_NAME,\r\n    DATA_TYPE,\r\n    DATA_TYPE_MOD,\r\n    DATA_TYPE_OWNER,\r\n    DATA_LENGTH,\r\n    DATA_PRECISION,\r\n    DATA_SCALE,\r\n    CHAR_USED,\r\n    CHAR_LENGTH,\r\n    NULLABLE,\r\n    COLUMN_ID,\r\n    VIRTUAL_COLUMN,\r\n    HIDDEN_COLUMN,\r\n    USER_GENERATED,\r\n    DEFAULT_ON_NULL,\r\n    IDENTITY_COLUMN,\r\n" + (includeEncription ? "    ENCRYPTION_ALG,\r\n    SALT,\r\n" : "") + (includeEncription ? "    INTEGRITY_ALG,\r\n" : "") + "    INTERNAL_COLUMN_ID,\r\n    DATA_DEFAULT\r\nFROM\r\n" + (dbaUser ? "DBA_TAB_COLS" : "ALL_TAB_COLS") + " A" + (String)(includeEncription ? "," + (dbaUser ? "DBA_ENCRYPTED_COLUMNS C" : "ALL_ENCRYPTED_COLUMNS C") : "") + "\r\nWHERE\r\n        A.OWNER = sh\r\n    AND A.TABLE_NAME = n\r\n";
        if (includeEncription) {
            sql = sql + "    AND A.OWNER = C.OWNER (+)\r\n    AND A.TABLE_NAME = C.TABLE_NAME (+)\r\n    AND A.COLUMN_NAME = C.COLUMN_NAME (+)\r\n";
        }
        sql = sql + "ORDER BY\r\n    INTERNAL_COLUMN_ID;\r\n--  select TEXT  from dba_source \r\n--   where owner = sh and ORIGIN_CON_ID = c and type = t and name = n order by line;\r\n--ssrec  ss%ROWTYPE;\r\nbegin\r\n cl1 :='';\r\n for sr in ss(schema,name)\r\n  loop\r\n   cl1 := cl1 --|| c || sr.OWNER || c || sr.TABLE_NAME || c \r\n   || sr.COLUMN_NAME || c || sr.DATA_TYPE || c || sr.DATA_TYPE_MOD || c || sr.DATA_TYPE_OWNER || c || sr.DATA_LENGTH || c || sr.DATA_PRECISION \r\n|| c || sr.DATA_SCALE || c || sr.CHAR_USED || c || sr.CHAR_LENGTH || c || sr.NULLABLE || c || sr.COLUMN_ID || c || sr.VIRTUAL_COLUMN \r\n|| c || sr.HIDDEN_COLUMN || c || sr.USER_GENERATED || c || sr.DEFAULT_ON_NULL || c || sr.IDENTITY_COLUMN  ";
        if (includeEncription) {
            sql = sql + "|| c || sr.ENCRYPTION_ALG || c || sr.SALT || c || sr.INTEGRITY_ALG \r\n";
        }
        sql = sql + "|| c  || sr.INTERNAL_COLUMN_ID || c || sr.DATA_DEFAULT || c|| '&&&&'|| crlf;\r\n  end loop;\r\n return cl1;\r\nend;\r\nselect ?, name, mf1(?,name) from (";
        Object s = "";
        for (DBObject dbo : dbos) {
            if (dbo.getTable() == null) continue;
            if (((String)s).isEmpty()) {
                s = "select ? as name from dual ";
                continue;
            }
            s = (String)s + "\nUNION \nselect ? from dual ";
        }
        sql = sql + (String)s + ")";
        return sql;
    }

    protected void initXMLTypeColumns(Connection sqlConnection, DBObject dbo) throws Exception {
        boolean oraclev11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        Table table = (Table)dbo.getTable();
        if (this.xmlTypeCols_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("XMLSCHEMA").append(',');
            buffer.append("ELEMENT_NAME").append(',');
            buffer.append("STORAGE_TYPE");
            if (oraclev11g) {
                buffer.append(',');
                buffer.append("ANYSCHEMA").append(',');
                buffer.append("NONSCHEMA");
            }
            buffer.append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_xml_tab_cols" : "all_xml_tab_cols").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("TABLE_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.xmlTypeCols_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.xmlTypeCols_st.setString(1, dbo.getSchema());
            this.xmlTypeCols_st.setString(2, table.getName());
            rs = this.xmlTypeCols_st.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOraclev9i.initXMLTypeColumns():", e);
        }
        if (rs != null) {
            TableProxyOracle tableProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            while (rs.next()) {
                ColumnProxyOraclev9i columnProxy;
                String colName = rs.getString("COLUMN_NAME");
                String xmlSchema = rs.getString("XMLSCHEMA");
                String xmlElementName = rs.getString("ELEMENT_NAME");
                String xmlStorageType = rs.getString("STORAGE_TYPE");
                String anySchema = null;
                String nonSchema = null;
                if (oraclev11g) {
                    anySchema = rs.getString("ANYSCHEMA");
                    nonSchema = rs.getString("NONSCHEMA");
                }
                if ((columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxyByName(colName)) == null) continue;
                if (xmlSchema != null) {
                    columnProxy.setXmlSchemaUrl(xmlSchema);
                }
                if (xmlElementName != null) {
                    columnProxy.setXmlSchemaElement(xmlElementName);
                }
                if (xmlStorageType != null) {
                    if (xmlStorageType.equals("BINARY")) {
                        xmlStorageType = "BINARY XML";
                    } else if (xmlStorageType.equals("OBJECT-RELATIONAL")) {
                        xmlStorageType = "OBJECT RELATIONAL";
                    }
                    columnProxy.setStoreAs(xmlStorageType);
                }
                if (anySchema != null) {
                    ((ColumnProxyOraclev11g)columnProxy).setAllowAnySchema(anySchema);
                }
                if (nonSchema == null) continue;
                ((ColumnProxyOraclev11g)columnProxy).setAllowNonSchema(nonSchema);
            }
            rs.close();
        }
    }

    protected void initIdentityColumn(Connection sqlConnection, DBObject dbo) throws Exception {
        Table table = (Table)dbo.getTable();
        if (this.identityCols_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("GENERATION_TYPE").append(',');
            buffer.append("IDENTITY_OPTIONS").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_tab_identity_cols" : "all_tab_identity_cols").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("TABLE_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.identityCols_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.identityCols_st.setString(1, dbo.getSchema());
            this.identityCols_st.setString(2, table.getName());
            rs = this.identityCols_st.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOraclev9i.initIdentityColumn():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                Column column = (Column)table.getElementByName(colName);
                if (column == null) continue;
                String generationType = rs.getString("GENERATION_TYPE");
                column.setAutoIncrementGenerateAlways(generationType.equals("ALWAYS"));
                String identityOptions = rs.getString("IDENTITY_OPTIONS");
                StringTokenizer tok = new StringTokenizer(identityOptions, ",");
                while (tok.hasMoreElements()) {
                    String option = tok.nextToken();
                    int colonIndex = option.indexOf(58);
                    if (colonIndex <= -1) continue;
                    String optName = option.substring(0, colonIndex).trim();
                    String optValue = option.substring(colonIndex + 1).trim();
                    try {
                        if (optName.equals("START WITH")) {
                            column.setAutoIncrementStartWith(optValue);
                            continue;
                        }
                        if (optName.equals("INCREMENT BY")) {
                            column.setAutoIncrementIncrementBy(Integer.parseInt(optValue));
                            continue;
                        }
                        if (optName.equals("MAX_VALUE")) {
                            if (optValue.equals("9999999999999999999999999999") && column.getAutoIncrementIncrementBy() > 0) continue;
                            column.setAutoIncrementMaxValue(optValue);
                            continue;
                        }
                        if (optName.equals("MIN_VALUE")) {
                            if (optValue.equals("1") && column.getAutoIncrementIncrementBy() > 0 || optValue.equals("-999999999999999999999999999") && column.getAutoIncrementIncrementBy() < 0) continue;
                            column.setAutoIncrementMinValue(optValue);
                            continue;
                        }
                        if (optName.equals("CYCLE_FLAG")) {
                            column.setAutoIncrementCycle(optValue.equals("Y"));
                            continue;
                        }
                        if (optName.equals("CACHE_SIZE")) {
                            int cacheSize = Integer.parseInt(optValue);
                            column.setAutoIncrementCache(cacheSize);
                            column.setAutoIncrementDisableCache(cacheSize == 0);
                            continue;
                        }
                        if (!optName.equals("ORDER_FLAG")) continue;
                        column.setAutoIncrementOrder(optValue.equals("Y"));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            rs.close();
        }
    }

    public static void main(String[] args) {
    }

    class TypeHolder {
        boolean logicalDT = false;
        boolean strDT = false;
        boolean colDT = false;
        boolean unknownDT = false;
        LogicalDatatype ldt;
        LogicalDatatype ukndt;
        StructuredType strdt;
        CollectionType coldt;

        TypeHolder() {
        }
    }
}

