/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerFileWatcher;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerJob;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerJobClass;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerProgram;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerSchedule;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerWindow;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerWindowGroup;
import oracle.dbtools.crest.model.scheduling.SchedulerFileWatcher;
import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerJobClass;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;
import oracle.dbtools.crest.model.scheduling.SchedulerSchedule;
import oracle.dbtools.crest.model.scheduling.SchedulerWindow;
import oracle.dbtools.crest.model.scheduling.SchedulerWindowGroup;
import oracle.dbtools.util.Closeables;

public class DBMExtractionHandlerScheduling {
    int release = 0;
    int version = 11;
    double dbVersion = 11.0;
    private Boolean dba = null;

    public DBMExtractionHandlerScheduling(Connection conn) {
        this.init(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void init(Connection conn) {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            String sql = "with\nfunction ver return number is\nbegin\n return dbms_db_version.version;\nend;\nfunction rel return number is\nbegin \n return dbms_db_version.release;\nend;\nselect ver version , rel release from dual";
            statement = null;
            rs = null;
            try {
                statement = conn.prepareStatement(sql);
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) break block4;
                this.version = rs.getInt(1);
                this.release = rs.getInt(2);
                this.dbVersion = (double)this.version + (double)this.release / 10.0;
                rs.close();
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                catch (Throwable throwable2) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable2;
                }
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDbaAccess(Connection conn, List<String> names) {
        if (this.getDBVersion() >= 12.2 && names.size() > 0) {
            ResultSet rs;
            PreparedStatement statement;
            block7: {
                boolean bl;
                String sql1 = "WITH\n    FUNCTION HAS_DBA_ACCESS RETURN VARCHAR2 AS\n        NAME VARCHAR2(200);\n        TYPE TNAMES IS\n            VARRAY(40) OF VARCHAR2(128);\n        NAMES TNAMES := TNAMES(";
                String sql2 = ");\n    BEGIN\n        FOR I IN 1..NAMES.COUNT LOOP\n            NAME := SYS.DBMS_ASSERT.SQL_OBJECT_NAME(NAMES(I));\n        END LOOP;\n        RETURN 'true';\n    EXCEPTION\n        WHEN OTHERS THEN\n            RETURN 'false';\n    END;\nSELECT HAS_DBA_ACCESS FROM DUAL";
                String sql = null;
                for (String name : names) {
                    if (sql == null) {
                        sql = sql1 + "'" + name + "'";
                        continue;
                    }
                    sql = (String)sql + ",'" + name + "'";
                }
                sql = sql + sql2;
                statement = null;
                rs = null;
                try {
                    statement = conn.prepareStatement(sql);
                    rs = statement.executeQuery();
                    if (rs == null || !rs.next()) break block7;
                    String dba = rs.getString(1);
                    rs.close();
                    bl = "TRUE".equalsIgnoreCase(dba);
                }
                catch (Throwable e) {
                    try {
                        e.printStackTrace();
                        System.out.println(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                return bl;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
        return false;
    }

    public boolean hasDbaAccess(Connection conn) {
        if (this.dba == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("SYS.DBA_SOURCE");
            list.add("SYS.DBA_SCHEDULER_JOBS");
            list.add("SYS.DBA_SCHEDULER_PROGRAMS");
            this.dba = this.hasDbaAccess(conn, list) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.dba;
    }

    public static void main(String[] args) {
    }

    public int getRelease() {
        return this.release;
    }

    public int getVersion() {
        return this.version;
    }

    public double getDBVersion() {
        return this.dbVersion;
    }

    public SchedulerJob getSchedulerJob(Connection conn, String owner, String name) {
        MOHSchedulerJob moh = new MOHSchedulerJob(this);
        DBObject dbo = new DBObject(true, name, "SCHEDULER_JOB", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<SchedulerObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (SchedulerJob)res.get(0);
        }
        return null;
    }

    public SchedulerProgram getSchedulerProgram(Connection conn, String owner, String name) {
        MOHSchedulerProgram moh = new MOHSchedulerProgram(this);
        DBObject dbo = new DBObject(true, name, "SCHEDULER_PROGRAM", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<SchedulerObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (SchedulerProgram)res.get(0);
        }
        return null;
    }

    public SchedulerSchedule getSchedulerSchedule(Connection conn, String owner, String name) {
        MOHSchedulerSchedule moh = new MOHSchedulerSchedule(this);
        DBObject dbo = new DBObject(true, name, "SCHEDULER_SCHEDULE", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<SchedulerObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (SchedulerSchedule)res.get(0);
        }
        return null;
    }

    public SchedulerFileWatcher getSchedulerFileWatcher(Connection conn, String owner, String name) {
        MOHSchedulerFileWatcher moh = new MOHSchedulerFileWatcher(this);
        DBObject dbo = new DBObject(true, name, "SCHEDULER_FILE_WATCHER", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<SchedulerObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (SchedulerFileWatcher)res.get(0);
        }
        return null;
    }

    public SchedulerWindow getSchedulerWindow(Connection conn, String owner, String name) {
        MOHSchedulerWindow moh = new MOHSchedulerWindow(this);
        DBObject dbo = new DBObject(true, name, "SCHEDULER_WINDOW", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<SchedulerObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (SchedulerWindow)res.get(0);
        }
        return null;
    }

    public SchedulerWindowGroup getSchedulerWindowGroup(Connection conn, String owner, String name) {
        MOHSchedulerWindowGroup moh = new MOHSchedulerWindowGroup(this);
        DBObject dbo = new DBObject(true, name, "SCHEDULER_WINDOW_GROUP", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<SchedulerObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (SchedulerWindowGroup)res.get(0);
        }
        return null;
    }

    public SchedulerJobClass getSchedulerJobClass(Connection conn, String owner, String name) {
        MOHSchedulerJobClass moh = new MOHSchedulerJobClass(this);
        DBObject dbo = new DBObject(true, name, "SCHEDULER_JOB_CLASS", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<SchedulerObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (SchedulerJobClass)res.get(0);
        }
        return null;
    }

    public SchedulerObject getSchedulerObject(Connection conn, String type, String owner, String name) {
        if (type != null) {
            switch (type.toUpperCase()) {
                case "SCHEDULER_JOB": {
                    return this.getSchedulerJob(conn, owner, name);
                }
                case "SCHEDULER_PROGRAM": {
                    return this.getSchedulerProgram(conn, owner, name);
                }
                case "SCHEDULER_SCHEDULE": {
                    return this.getSchedulerSchedule(conn, owner, name);
                }
                case "SCHEDULER_FILE_WATCHER": {
                    return this.getSchedulerFileWatcher(conn, owner, name);
                }
                case "SCHEDULER_WINDOW": {
                    return this.getSchedulerWindow(conn, owner, name);
                }
                case "SCHEDULER_WINDOW_GROUP": {
                    return this.getSchedulerWindowGroup(conn, owner, name);
                }
                case "SCHEDULER_JOB_CLASS": {
                    return this.getSchedulerJobClass(conn, owner, name);
                }
            }
        }
        return null;
    }
}

