/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.json.JsonObject;
import oracle.dbtools.crest.exports.ddl.scheduling.SchedulerDDLMaker;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.SchedulerCDDLMaker;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerChainAll;
import oracle.dbtools.crest.model.scheduling.JSONToSchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerFileWatcher;
import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerJobClass;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;
import oracle.dbtools.crest.model.scheduling.SchedulerSchedule;
import oracle.dbtools.crest.model.scheduling.SchedulerWindow;
import oracle.dbtools.crest.model.scheduling.SchedulerWindowGroup;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerJobCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerProgramCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerWindowGroupCompare;

public class SDW_SchedUtil {
    public static String CHAIN_ALL_JSON = "chain_all_json";
    public static String CHAIN_RULES = "chain_rules";

    public static boolean isSupportedType(String type) {
        return type != null && "scheduler_job".equalsIgnoreCase(type) || "scheduler_program".equalsIgnoreCase(type) || "scheduler_schedule".equalsIgnoreCase(type) || "scheduler_file_watcher".equalsIgnoreCase(type) || "scheduler_window".equalsIgnoreCase(type) || "scheduler_job_class".equalsIgnoreCase(type) || "scheduler_window_group".equalsIgnoreCase(type) || CHAIN_ALL_JSON.equalsIgnoreCase(type) || CHAIN_RULES.equalsIgnoreCase(type);
    }

    public static String getNewObjectDDL(Connection conn, String objectType, JsonObject jdoc) {
        SchedulerObject obj = SDW_SchedUtil.createObject(objectType);
        JSONToSchedulerObject tr = new JSONToSchedulerObject();
        tr.processProperties(obj, jdoc);
        ArrayList<SchedulerObject> objects = new ArrayList<SchedulerObject>();
        objects.add(obj);
        SchedulerDDLMaker ddlm = new SchedulerDDLMaker();
        ddlm.generateDDLContent(objects);
        return ddlm.getContent();
    }

    static SchedulerObject createObject(String type) {
        SchedulerObject obj = null;
        if (type.equals("scheduler_job")) {
            return new SchedulerJob();
        }
        if (type.equals("scheduler_program")) {
            return new SchedulerProgram();
        }
        if (type.equals("scheduler_schedule")) {
            return new SchedulerSchedule();
        }
        if (type.equals("scheduler_file_watcher")) {
            return new SchedulerFileWatcher();
        }
        if (type.equals("scheduler_window")) {
            return new SchedulerWindow();
        }
        if (type.equals("scheduler_job_class")) {
            return new SchedulerJobClass();
        }
        if (type.equals("scheduler_window_group")) {
            return new SchedulerWindowGroup();
        }
        return obj;
    }

    static SchedulerObjectCompare createObjectCompare(String type, SchedulerObject source, SchedulerObject target) {
        SchedulerObjectCompare obj = null;
        if (type.equals("scheduler_job")) {
            return new SchedulerJobCompare(source, target);
        }
        if (type.equals("scheduler_program")) {
            return new SchedulerProgramCompare(source, target);
        }
        if (type.equals("scheduler_schedule")) {
            return new SchedulerObjectCompare(source, target);
        }
        if (type.equals("scheduler_file_watcher")) {
            return new SchedulerObjectCompare(source, target);
        }
        if (type.equals("scheduler_window")) {
            return new SchedulerObjectCompare(source, target);
        }
        if (type.equals("scheduler_window_group")) {
            return new SchedulerWindowGroupCompare(source, target);
        }
        if (type.equals("scheduler_job_class")) {
            return new SchedulerObjectCompare(source, target);
        }
        return obj;
    }

    public static String getExistingObjectDDL(Connection conn, String type, String schema, String name, Logger log) {
        DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
        SchedulerObject job = handler.getSchedulerObject(conn, type, schema, name);
        ArrayList<SchedulerObject> objects = new ArrayList<SchedulerObject>();
        objects.add(job);
        SchedulerDDLMaker ddlc = new SchedulerDDLMaker();
        ddlc.generateDDLContent(objects);
        return ddlc.getContent();
    }

    public static String getCompareObjectDDL(Connection conn, String objectType, JsonObject jdoc, String schemaName, String objectName) {
        SchedulerObject source = SDW_SchedUtil.createObject(objectType);
        JSONToSchedulerObject tr = new JSONToSchedulerObject();
        tr.processProperties(source, jdoc);
        DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
        SchedulerObject job = handler.getSchedulerObject(conn, objectType, schemaName, objectName);
        SchedulerObjectCompare comp = SDW_SchedUtil.createObjectCompare(objectType, source, job);
        ArrayList<SchedulerObjectCompare> objects = new ArrayList<SchedulerObjectCompare>();
        objects.add(comp);
        SchedulerCDDLMaker ddlc = new SchedulerCDDLMaker();
        ddlc.generateDDLContent(objects);
        return ddlc.getContent();
    }

    public static boolean addObjectDetails(Connection conn, PrintWriter wr, String type, String schema, String name, Logger log) {
        if (!(schema == null || schema.isEmpty() || name == null || name.isEmpty() || type == null || type.isEmpty())) {
            DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
            if (CHAIN_ALL_JSON.equalsIgnoreCase(type)) {
                MOHSchedulerChainAll moh = new MOHSchedulerChainAll(handler);
                wr.print(moh.getChainAllJSON(conn, schema, name));
                return true;
            }
            if (CHAIN_RULES.equalsIgnoreCase(type)) {
                MOHSchedulerChainAll moh = new MOHSchedulerChainAll(handler);
                wr.print(moh.getChainValidationRules(conn, schema, name));
                return true;
            }
            SchedulerObject job = handler.getSchedulerObject(conn, type, schema, name);
            if (job != null) {
                wr.print(job.toJSONString(true));
                return true;
            }
            return false;
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

