/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.awt.Color;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.format.DefaultFCClassificationType;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class ClassificationType {
    private String typeName;
    private String typeID = "";
    private boolean readOnly = false;
    private String typePrefix;
    private boolean preferred;
    private DefaultFontAndColor defaultFCObject = new DefaultFCClassificationType("Classification Type", new Color(255, 255, 180), Color.BLUE);
    public static final String TYPE_FACT_ID = "1";
    public static final String TYPE_DIMENSION_ID = "2";
    public static final String TYPE_LOGGING_ID = "3";
    public static final String TYPE_SUMMARY_ID = "4";
    public static final String TYPE_TEMPORARY_ID = "5";
    public static final String TYPE_EXTERNAL_ID = "6";

    public String getTypePrefix() {
        return this.typePrefix;
    }

    public void setTypePrefix(String typePrefix) {
        this.typePrefix = typePrefix;
    }

    public ClassificationType(String name, Color typeColor, Color foregroundColor, String prefix) {
        this.typeName = name;
        this.setBackgroundColor(typeColor);
        this.setForegroundColor(foregroundColor);
        this.typeID = new GUID().toString();
        this.typePrefix = prefix;
    }

    public ClassificationType(String name, Color typeColor, Color foregroundColor, String id, String prefix) {
        this.typeName = name;
        this.setBackgroundColor(typeColor);
        this.setForegroundColor(foregroundColor);
        this.typeID = id;
        this.typePrefix = prefix;
    }

    public ClassificationType(String name, Color typeColor, Color foregroundColor, String id, boolean readOnly, String prefix, boolean preferred) {
        this(name, typeColor, foregroundColor, id, prefix);
        this.readOnly = readOnly;
        this.preferred = preferred;
    }

    public String getTypeName() {
        if (this.typeID.equals(TYPE_FACT_ID)) {
            return "Fact";
        }
        if (this.typeID.equals(TYPE_DIMENSION_ID)) {
            return "Dimension";
        }
        if (this.typeID.equals(TYPE_LOGGING_ID)) {
            return "Logging";
        }
        if (this.typeID.equals(TYPE_SUMMARY_ID)) {
            return "Summary";
        }
        if (this.typeID.equals(TYPE_TEMPORARY_ID)) {
            return "Temporary";
        }
        if (this.typeID.equals(TYPE_EXTERNAL_ID)) {
            return "External";
        }
        return this.typeName;
    }

    public void setTypeName(String newName) {
        this.typeName = newName;
    }

    public Color getTypeColor() {
        return this.getDefaultFCObject().getBackgroundColor();
    }

    public void setTypeColor(Color newColor) {
        this.setBackgroundColor(newColor);
    }

    public void setBackgroundColor(Color newColor) {
        this.getDefaultFCObject().setBackgroundColor(newColor);
    }

    public Color getForegroundColor() {
        return this.getDefaultFCObject().getForegroundColor();
    }

    public void setForegroundColor(Color newColor) {
        this.getDefaultFCObject().setForegroundColor(newColor);
    }

    public ClassificationType copy() {
        ClassificationType cf = new ClassificationType(this.typeName, this.getTypeColor(), this.getForegroundColor(), this.typeID, this.readOnly, this.typePrefix, this.preferred);
        cf.setDefaultFCObject(this.getDefaultFCObject().copy());
        return cf;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setTypeID(String id) {
        this.typeID = id;
    }

    public String toString() {
        return this.getTypeName();
    }

    public boolean equalID(String id) {
        return this.getTypeID().equalsIgnoreCase(id);
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    public DefaultFontAndColor getDefaultFCObject() {
        if (this.defaultFCObject == null) {
            this.defaultFCObject = new DefaultFCClassificationType("Classification Type", new Color(255, 255, 180), Color.BLUE);
        }
        return this.defaultFCObject;
    }

    public void setDefaultFCObject(DefaultFontAndColor defaultFCObject) {
        this.defaultFCObject = defaultFCObject;
    }
}

