/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.MaskTemplateSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SensitiveTypeSet;
import oracle.dbtools.crest.model.TSDPPolicySet;
import oracle.dbtools.crest.model.TSDPSubPolicySet;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.oracle.v10g.MDDataTypeFactoryOraclev10g;
import oracle.dbtools.crest.model.datatype.oracle.v12c.MDDataTypeFactoryOraclev12c;
import oracle.dbtools.crest.model.datatype.oracle.v20c.MDDataTypeFactoryOraclev20c;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDDataTypeFactoryOraclev9i;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class Design
extends ModelIDObject {
    public static final String TYPE_NAME = "Design";
    public static final int CURRENT_OPERATION_NONE = -1;
    public static final int CURRENT_OPERATION_OPEN = 1;
    public static final int CURRENT_OPERATION_CLOSE = 2;
    public static final int CURRENT_OPERATION_SAVE = 3;
    public static final int CURRENT_OPERATION_SAVE_AS = 4;
    public static final int CURRENT_OPERATION_EXPORT_TO = 5;
    private static final String SYSTEM_DESIGN = "System";
    private MaskTemplateSet maskTemplateSet = null;
    private SensitiveTypeSet sensitiveTypeSet = null;
    private TSDPPolicySet tsdpPolicySet;
    private TSDPSubPolicySet tsdpSubPolicySet;
    public static String dmInternalsDistDir;
    private boolean compressedDesign = false;
    public static String systemTypesDir;
    public static String settingsFileName;
    private boolean capitalNames;
    private boolean importing;
    private String designId;
    private float loadedVersion = 3.5f;
    private List designStorageDescriptors;
    private List defaultDBSites;
    private List designLevelDBSites;
    private List defaultDomains;
    private List designLevelDomains;
    private static RDBMSTypeSet defauttRdbmsTypeSet;
    private RDBMSSiteSet rdbmsSiteSet = null;
    private DomainSet domainSet;
    private final Map idMap = new TreeMap();
    private Map correspondenceMap;
    private RelationalDesignSet pdesignSet;
    private boolean newDesign = true;
    private boolean applyNameSubstitution;
    private boolean loadFromDB = false;
    private boolean loading;
    private boolean applyNameStandardization;
    private boolean usePreferredAbbreviation = false;
    private boolean cleaning;
    private boolean closing;
    private boolean propagatePKChahges;
    private boolean engineerCoordinates;
    private boolean engineerGenerated;
    private String oldDesignPath = null;
    private List tempProxiesToDelete = new ArrayList();
    private int currentOperation = -1;
    private String fileName;
    private String exportFileName = "";
    private String designPath = "";
    private String exportDesignPath = "";
    private String sysTypesPath;
    private LogicalDatatypeSet logicalDatatypeSet;
    private LogicalDesign logicalDesign;
    private DataTypesDesign dataTypesDesign;
    MDPreferences preferences = MDPreferences.getDefaultInstance();
    private RelationalDesign relationalDesign;
    public static boolean USE_DROP_DEPENDENCY;
    private boolean oldRepositoryType;
    public static int PERS_MODEL_IN_ONE_FILE;
    public static int PERS_MODEL_IN_MANY_FILES;
    public static int PERS_MODEL_MIXED_MODE;
    private int modelPersistence = PERS_MODEL_IN_MANY_FILES;
    private int loadedModelPersistence = PERS_MODEL_IN_MANY_FILES;
    private final Set listeners = new HashSet();
    private final TreeMap<String, List> comparatorFilterListMap = new TreeMap();
    private final TreeMap<String, List> dynamicPropsFilterListMap = new TreeMap();
    public static boolean DROP_GENERATED_OBJECTS_ONLY;
    private Settings settings;
    private String unloadDirectory = "";
    private String defDateFormat = "YYYY/MM/DD HH24:MI:SS";
    private String defTimestampFormat = "YYYY/MM/DD HH24:MI:SS.FF";
    private String defTimestampWTZFormat = "YYYY/MM/DD HH24:MI:SS.FFTZH:TZM";
    private String engDateFormat = "YYYY/MM/DD HH24:MI:SS";
    private String engTimestampFormat = "YYYY/MM/DD HH24:MI:SS.FF";
    private String engTimestampWTZFormat = "YYYY/MM/DD HH24:MI:SS.FFTZH:TZM";
    private CompareModelToModel modelComparator;
    private NamingStandardRule namingRule;
    private boolean tempVar = false;
    protected Map dtFactoryInstances = new TreeMap();
    private Set importedDesigns = null;
    private final Map expDesPartsMap = new TreeMap();
    private final Map expPartialDesPartsMap = new TreeMap();
    private final Map expDesObjectsMap = new TreeMap();
    public static boolean OPEN_FAILED;
    private DesignLevelSettings designLevelSettings;

    public Design() {
        this(null, true);
    }

    public Design(Design oldDesign, boolean hidden) {
        this.createRelationalDesignSet();
        this.setDesign(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public static String getSystemDesignName() {
        return SYSTEM_DESIGN;
    }

    public String getFileName() {
        if (this.currentOperation == 5) {
            return this.exportFileName;
        }
        if (this.fileName == null) {
            this.fileName = this.getName();
        }
        return this.fileName;
    }

    public int getModelPersistence() {
        return this.modelPersistence;
    }

    public void setModelPersistence(int modelPersistence) {
        this.modelPersistence = modelPersistence;
    }

    public boolean isCapitalNames() {
        return this.capitalNames;
    }

    public void setCapitalNames(boolean capitalNames) {
        this.capitalNames = capitalNames;
    }

    public String getDesignID() {
        return this.designId;
    }

    public void setDesignID(String designId) {
        this.designId = designId;
    }

    public RDBMSSite createRDBMSSite() {
        return this.getRDBMSSiteSet().createSite("", this.design);
    }

    public List getDefaultRDBMSSites() {
        if (this.defaultDBSites == null) {
            this.defaultDBSites = new ArrayList();
        }
        return this.defaultDBSites;
    }

    public List getDL_RDBMSSites() {
        if (this.designLevelDBSites == null) {
            this.designLevelDBSites = new ArrayList();
        }
        return this.designLevelDBSites;
    }

    public List getDefaultDomainsList() {
        if (this.defaultDomains == null) {
            this.defaultDomains = new ArrayList();
        }
        return this.defaultDomains;
    }

    public Domain createDomain() {
        return this.getDomainSet().createDomain();
    }

    public Domain getDomainByID(String id) {
        return (Domain)this.getDesignObject(id);
    }

    public void sortDomains() {
        this.getDomainSet().sort();
    }

    public List getDL_DomainsList() {
        if (this.designLevelDomains == null) {
            this.designLevelDomains = new ArrayList();
        }
        return this.designLevelDomains;
    }

    public ChangeRequest createChangeRequest() {
        ChangeRequest changeRequest = new ChangeRequest(this.getLogicalDesign());
        changeRequest.setDesign(this);
        return changeRequest;
    }

    public RelationalDesignSet getRelationalDesigns() {
        if (this.pdesignSet == null) {
            this.pdesignSet = new RelationalDesignSet(this);
            this.pdesignSet.setDesign(this.getDesign());
        }
        return this.pdesignSet;
    }

    public static RDBMSTypeSet getDefaultRDBMSTypeSet() {
        if (defauttRdbmsTypeSet == null) {
            defauttRdbmsTypeSet = new RDBMSTypeSet();
            defauttRdbmsTypeSet.add(StorageDesignOraclev20c.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev12cR2.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev12c.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev11g.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev10g.RDBMS_TYPE);
            defauttRdbmsTypeSet.add(StorageDesignOraclev9i.RDBMS_TYPE);
        }
        return defauttRdbmsTypeSet;
    }

    public RDBMSSiteSet getRDBMSSiteSet() {
        boolean empty;
        boolean bl = empty = this.rdbmsSiteSet != null && this.rdbmsSiteSet.size() == 0;
        if (this.rdbmsSiteSet != null && this.rdbmsSiteSet.isLoadFromRepository()) {
            empty = false;
        }
        if (this.rdbmsSiteSet == null || empty) {
            this.rdbmsSiteSet = new RDBMSSiteSet(this);
            this.rdbmsSiteSet.add(StorageDesignOraclev20c.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev12cR2.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev12c.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev11g.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev10g.RDBMS_SITE);
            this.rdbmsSiteSet.add(StorageDesignOraclev9i.RDBMS_SITE);
        }
        return this.rdbmsSiteSet;
    }

    public DomainSet getDomainSet() {
        if (this.domainSet == null) {
            this.domainSet = new DomainSet(null);
            this.domainSet.setDesign(this);
            this.domainSet.setName("Domains");
            this.domainSet.createUnknownDomain();
            this.domainSet.setParent(this);
        }
        return this.domainSet;
    }

    public static final String getRelationalModelsSetName() {
        return "Relational Models";
    }

    private void createRelationalDesignSet() {
        this.pdesignSet = new RelationalDesignSet(this);
        this.pdesignSet.setName(Design.getRelationalModelsSetName());
        this.pdesignSet.setElementDescriptor(RelationalDesign.class);
        this.pdesignSet.setDesign(this);
        this.pdesignSet.setParent(this);
    }

    public void addDesignObject(DesignObject object) {
        if (object.isDesignLevelAccessibleObject()) {
            this.registerAndAssignIDIfNull(object);
            String id = object.getObjectID();
            if (id != null && !id.isEmpty()) {
                this.idMap.put(object.getObjectID(), object);
                if (object.hasProxyToDelete() && this.tempProxiesToDelete.contains(object.getObjectID())) {
                    this.tempProxiesToDelete.remove(object.getObjectID());
                }
            }
        } else {
            throw new RuntimeException("trying to add object that is not design level accessible.");
        }
    }

    public void removeDesignObject(DesignObject object) {
        if (object != null && object.getObjectID() != null) {
            if (object.hasProxyToDelete() && !this.tempProxiesToDelete.contains(object.getObjectID())) {
                this.tempProxiesToDelete.add(object.getObjectID());
            }
            this.idMap.remove(object.getObjectID());
        }
    }

    private void registerAndAssignIDIfNull(DesignObject object) {
        String id = object.getObjectID();
        if (id == null || id.isEmpty()) {
            String nid = object.createGlobalID();
            object.setObjectID(nid);
        }
    }

    public DesignObject getDesignObject(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        if (id.indexOf(35) > -1) {
            DesignObject top = this.getTopDesignObject(id);
            if (top != null) {
                return top;
            }
            top = this.getTopDesignObject(this.getTopDesignObjectId(id));
            if (top != null) {
                if (top instanceof ContainerObject) {
                    return (DesignObject)((ContainerObject)top).getLocalObject(id);
                }
                if (top instanceof StructuredType) {
                    DesignObject elm = ((StructuredType)top).getElementByID(id);
                    if (elm == null) {
                        elm = ((StructuredType)top).getMethodByID(id);
                    }
                    return elm;
                }
                return null;
            }
            return null;
        }
        return this.getTopDesignObject(id);
    }

    public void updateDesignObjectId(String oldId, String newId) {
        ContainerObject top;
        if (oldId == null || "".equalsIgnoreCase(oldId)) {
            return;
        }
        Object object = this.idMap.get(oldId);
        if (object != null) {
            this.idMap.remove(oldId);
            if (newId != null && !"".equalsIgnoreCase(newId)) {
                this.idMap.put(newId, object);
            }
        } else if (oldId.indexOf(35) > -1 && (top = (ContainerObject)this.getTopDesignObject(this.getTopDesignObjectId(oldId))) != null) {
            top.updateLocalObjectId(oldId, newId);
        }
    }

    public String getTopDesignObjectId(String localId) {
        int index = -1;
        index = localId.indexOf(35);
        if (index > -1) {
            return localId.substring(0, index);
        }
        return localId;
    }

    public DesignObject getTopDesignObject(String id) {
        return (DesignObject)this.idMap.get(id);
    }

    public boolean isLoadFromDB() {
        return this.loadFromDB;
    }

    public void setLoadFromDB(boolean loadFromDB) {
        this.loadFromDB = loadFromDB;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = currentOperation;
    }

    public Map getDesignObjectsMap() {
        return this.idMap;
    }

    public Map getCorrespondenceMap() {
        return this.correspondenceMap;
    }

    public void setCorrespondenceMap(Map correspondenceMap) {
        this.correspondenceMap = correspondenceMap;
    }

    @Override
    public void setDirty(boolean dirty) {
        if (dirty && this.isNewDesign()) {
            return;
        }
        super.setDirty(dirty);
    }

    public String getDesignStoragePath(String designID) {
        if (designID != null) {
            if (designID.equals(this.getObjectID())) {
                try {
                    String desName = this.getFileName();
                    if (desName != null) {
                        return new File(this.getDesignPath(), desName).getCanonicalPath();
                    }
                }
                catch (IOException desName) {}
            } else {
                DesignStorageDesc desc = this.getDesignStorageDesc(designID);
                if (desc != null) {
                    try {
                        return new File(desc.getDesignStoragePath()).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public String getDesignPath() {
        if (this.currentOperation == 5) {
            return this.exportDesignPath;
        }
        return this.designPath;
    }

    public void setDesignPath(String designPath) {
        this.designPath = designPath;
    }

    public String getExportDesignPath() {
        return this.exportDesignPath;
    }

    public void setExportDesignPath(String exportDesignPath) {
        this.exportDesignPath = exportDesignPath;
    }

    public List getDesignStorageDescriptors() {
        if (this.designStorageDescriptors == null) {
            this.designStorageDescriptors = new ArrayList();
        }
        return this.designStorageDescriptors;
    }

    public DesignStorageDesc createDesignStorageDesc() {
        return new DesignStorageDesc();
    }

    public DesignStorageDesc getDesignStorageDesc(String designID) {
        if (designID != null && !"".equals(designID)) {
            for (DesignStorageDesc desc : this.designStorageDescriptors) {
                if (!designID.equals(desc.getDesignID())) continue;
                return desc;
            }
        }
        return null;
    }

    public void addDesignStorageDesc(DesignStorageDesc desc) {
        DesignStorageDesc d = this.getDesignStorageDesc(desc.getDesignID());
        if (d == null) {
            this.designStorageDescriptors.add(desc);
            this.setDirty(true);
        } else {
            d.setDesignStoragePath(desc.getDesignStoragePath());
        }
    }

    public void addDesignStorageDesc(Design design) {
        DesignStorageDesc d = this.getDesignStorageDesc(design.getObjectID());
        if (d == null) {
            DesignStorageDesc desc = new DesignStorageDesc();
            desc.setDesignID(design.getObjectID());
            desc.setDesignStoragePath(design.getStoragePath());
            this.designStorageDescriptors.add(desc);
            this.setDirty(true);
        }
    }

    public boolean isNewDesign() {
        return this.newDesign;
    }

    public void setNewDesign(boolean newDesign) {
        this.newDesign = newDesign;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    public boolean isApplyNameSubstitution() {
        return this.applyNameSubstitution;
    }

    public void setApplyNameSubstitution(boolean applyNameSubstitution) {
        this.applyNameSubstitution = applyNameSubstitution;
    }

    public void setDefaultSystemTypesPath(String sysTypesPath) {
        this.sysTypesPath = sysTypesPath;
    }

    public String getDefaultSystemTypesPath() {
        return this.sysTypesPath;
    }

    public LogicalDatatypeSet getLogicalDatatypeSet() {
        if (this.logicalDatatypeSet == null) {
            this.logicalDatatypeSet = new LogicalDatatypeSet(this.getLogicalDesign());
            this.logicalDatatypeSet.setDesign(this);
            this.logicalDatatypeSet.createUnknownType();
            this.logicalDatatypeSet.setParent(this);
        }
        return this.logicalDatatypeSet;
    }

    @Override
    public MDPreferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(MDPreferences preferences) {
        this.preferences = preferences;
    }

    public LogicalDesign getLogicalDesign() {
        if (this.logicalDesign == null) {
            this.logicalDesign = new LogicalDesign();
            this.logicalDesign.setObjectID(new GUID().toString());
            this.logicalDesign.setDesign(this);
            this.logicalDesign.setParent(this);
            this.logicalDesign.setName(Messages.getString("Design.LogicalModel"));
        }
        return this.logicalDesign;
    }

    public boolean isUsePreferredAbbreviation() {
        return this.usePreferredAbbreviation;
    }

    public void setUsePreferredAbbreviation(boolean usePreferredAbbreviation) {
        this.usePreferredAbbreviation = usePreferredAbbreviation;
    }

    public boolean isApplyNameStandardization() {
        return this.applyNameStandardization;
    }

    public void setApplyNameStandardization(boolean applyNameStandardization) {
        this.applyNameStandardization = applyNameStandardization;
    }

    public boolean isCleaning() {
        return this.cleaning;
    }

    public void setCleaning(boolean cleaning) {
        this.cleaning = cleaning;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
    }

    public DataTypesDesign getDataTypesDesign() {
        if (this.dataTypesDesign == null) {
            this.dataTypesDesign = new DataTypesDesign();
            this.dataTypesDesign.setObjectID(new GUID().toString());
            this.dataTypesDesign.setDesign(this);
            this.dataTypesDesign.setName(Messages.getString("Design.DataTypes"));
            this.dataTypesDesign.setParent(this);
        }
        return this.dataTypesDesign;
    }

    public boolean isEngineerCoordinates() {
        return this.engineerCoordinates;
    }

    public void setEngineerCoordinates(boolean engineerCoordinates) {
        this.engineerCoordinates = engineerCoordinates;
    }

    public boolean isPropagatePKChahges() {
        return this.propagatePKChahges;
    }

    public void setPropagatePKChahges(boolean propagatePKChahges) {
        this.propagatePKChahges = propagatePKChahges;
    }

    public boolean isEngineerGenerated() {
        return this.engineerGenerated;
    }

    public void setEngineerGenerated(boolean engineerGenerated) {
        this.engineerGenerated = engineerGenerated;
    }

    public RelationalDesign getRelationalDesign() {
        if (this.relationalDesign == null) {
            this.relationalDesign = this.addRelationalDesign(null);
        }
        return this.relationalDesign;
    }

    public void setRelationalDesign(RelationalDesign design) {
        this.relationalDesign = design;
    }

    public RelationalDesign addRelationalDesign() {
        RelationalDesign rdes;
        this.relationalDesign = rdes = this.addRelationalDesign(null);
        return rdes;
    }

    public RelationalDesign addRelationalDesign(String name) {
        RelationalDesign design = (RelationalDesign)this.pdesignSet.createElement(null);
        design.setDesign(this);
        if (this.relationalDesign == null) {
            this.relationalDesign = design;
        }
        if (name != null) {
            RelationalDesign oldDes = (RelationalDesign)this.getRelationalDesigns().getByName(name);
            if (oldDes != null && oldDes != design) {
                Object tempName = name;
                int p = 1;
                while (oldDes != null && oldDes != design) {
                    tempName = name + "(" + ++p + ")";
                    oldDes = (RelationalDesign)this.getRelationalDesigns().getByName((String)tempName);
                }
                name = tempName;
            }
            design.setName(name);
        }
        return design;
    }

    public void setOldRepositoryType(boolean oldRepositoryType) {
        this.oldRepositoryType = oldRepositoryType;
    }

    public boolean isOldRepositoryType() {
        return this.oldRepositoryType;
    }

    public boolean deleteDirectory(File dir) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
            return dir.delete();
        }
        return false;
    }

    public boolean deleteFiles(List files) {
        boolean result = false;
        System.gc();
        for (int i = 0; i < files.size(); ++i) {
            File file;
            String filePath = (String)files.get(i);
            if (filePath == null || !(file = new File(this.fixFilePath(filePath))).exists()) continue;
            if (file.isDirectory()) {
                result = this.deleteDirectory(file);
                continue;
            }
            result = file.delete();
            if (result) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            result = file.delete();
        }
        return result;
    }

    public String fixFilePath(String path) {
        int pos = path.indexOf(92);
        if (pos == -1) {
            return path;
        }
        return path.replaceAll("[\\\\]", "/");
    }

    public void addDesignListener(DesignListener listener) {
        this.listeners.add(listener);
    }

    public void removeDesignListener(DesignListener listener) {
        this.listeners.remove(listener);
    }

    public int getLoadedModelPersistence() {
        return this.loadedModelPersistence;
    }

    public void setLoadedModelPersistence(int loadedModelPersistence) {
        this.loadedModelPersistence = loadedModelPersistence;
    }

    public void addImportedDesignName(String name) {
        this.getImportedDesignsSet().add(name);
    }

    private Set getImportedDesignsSet() {
        if (this.importedDesigns == null) {
            this.importedDesigns = new TreeSet();
        }
        return this.importedDesigns;
    }

    public String[] getImportedDesignNames() {
        int size = this.getImportedDesignsSet().size();
        return this.getImportedDesignsSet().toArray(new String[size]);
    }

    public StorageDesign getStorageDesign(RDBMSSite site) {
        if (this.getRelationalDesign() != null) {
            return this.getRelationalDesign().getStorageDesign(site);
        }
        return null;
    }

    public StorageDesign getStorageDesign(RDBMSSite site, FKContainer table) {
        if ((RelationalDesign)table.getDesignPart() != null) {
            return ((RelationalDesign)table.getDesignPart()).getStorageDesign(site);
        }
        return null;
    }

    public Settings getSettings() {
        if (this.settings == null) {
            File dir;
            this.settings = new Settings();
            if (settingsFileName != null && !"".equalsIgnoreCase(settingsFileName)) {
                File file = new File(settingsFileName);
                this.settings.loadSettings(file);
            } else if (systemTypesDir != null && !"".equalsIgnoreCase(systemTypesDir) && (dir = new File(systemTypesDir)).exists()) {
                File file = new File(dir, "settings.xml");
                this.settings.loadSettings(file);
            }
        }
        return this.settings;
    }

    public MaskTemplateSet getMaskTemplateSet() {
        if (this.maskTemplateSet == null) {
            this.maskTemplateSet = new MaskTemplateSet();
            this.maskTemplateSet.setName(Messages.getString("ApplicationView.MaskTemplates"));
            this.maskTemplateSet.setParent(this);
        }
        return this.maskTemplateSet;
    }

    public SensitiveTypeSet getSensitiveTypeSet() {
        if (this.sensitiveTypeSet == null) {
            this.sensitiveTypeSet = new SensitiveTypeSet();
            this.sensitiveTypeSet.setName(Messages.getString("ApplicationView.SensitiveTypes"));
            this.sensitiveTypeSet.setParent(this);
        }
        return this.sensitiveTypeSet;
    }

    public TSDPPolicySet getTSDPPolicySet() {
        if (this.tsdpPolicySet == null) {
            this.tsdpPolicySet = new TSDPPolicySet();
            this.tsdpPolicySet.setName(Messages.getString("ApplicationView.TSDPPolicies"));
            this.tsdpPolicySet.setParent(this);
        }
        return this.tsdpPolicySet;
    }

    public TSDPSubPolicySet getTSDPSubPolicySet() {
        if (this.tsdpSubPolicySet == null) {
            this.tsdpSubPolicySet = new TSDPSubPolicySet();
            this.tsdpSubPolicySet.setName(Messages.getString("ApplicationView.TSDPSubPolicies"));
            this.tsdpSubPolicySet.setParent(this);
        }
        return this.tsdpSubPolicySet;
    }

    public boolean isImporting() {
        return this.importing;
    }

    public void setImporting(boolean importing) {
        this.importing = importing;
    }

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        if (this.getRelationalDesign() != null && this.getRelationalDesign().getSelectedRDBMSSite() != null) {
            return this.getRelationalDesign().getSelectedRDBMSSite();
        }
        return this.getRDBMSSiteSet().getDefaultRDBMSSite();
    }

    public void setSelectedRDBMSSite(RDBMSSite site) {
        if (this.getRelationalDesign() != null) {
            this.getRelationalDesign().setSelectedRDBMSSite(site);
        }
    }

    public void setFileName(String fileName) {
        if (this.isNewDesign()) {
            this.setDirty(true);
        }
        this.fileName = fileName;
        this.setName(fileName);
    }

    public boolean isVersioned() {
        return false;
    }

    public boolean shouldExportFull(DesignPart designPart) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        return this.expDesPartsMap.get(designPart.getObjectID()) != null;
    }

    public boolean shouldExportPartial(DesignPart designPart) {
        return this.expPartialDesPartsMap.get(designPart.getObjectID()) != null;
    }

    public boolean shouldExport(DesignObject designObject) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        if (this.shouldExportFull(designObject.getDesignPart())) {
            return true;
        }
        return this.expDesObjectsMap.get(designObject.getObjectID()) != null;
    }

    public void setCompressedDesign(boolean compressedDesign) {
        this.compressedDesign = compressedDesign;
    }

    public boolean isCompressedDesign() {
        return this.compressedDesign;
    }

    public static void openFailed() {
        OPEN_FAILED = true;
    }

    public String getOldDesignPath() {
        return this.oldDesignPath;
    }

    public void setOldDesignPath(String oldDesignPath) {
        this.oldDesignPath = oldDesignPath;
    }

    @Override
    public String getStoragePath() {
        try {
            String desName = this.getFileName();
            if (desName != null) {
                return new File(this.getDesignPath(), desName).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            String desName = this.getFileName();
            if (desName != null) {
                return new File(this.getDesignPath(), desName + ".dmd").getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public float getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setLoadedVersion(float loadedVersion) {
        this.loadedVersion = loadedVersion;
    }

    public float getVersion() {
        return 3.5f;
    }

    public MDDataTypeFactory getDTFactoryInstance() {
        return this.getDTFactoryInstance("Oracle Database 11g");
    }

    public MDDataTypeFactory getDTFactoryInstance(String rdbms) {
        RDBMSType dbtype = Design.getRDBMSType(rdbms);
        return this.getDTFactoryInstance(dbtype);
    }

    static RDBMSType getRDBMSType(String rdbms) {
        if (rdbms.equalsIgnoreCase("Oracle9i")) {
            return StorageDesignOraclev9i.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 10g")) {
            return StorageDesignOraclev10g.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 11g")) {
            return StorageDesignOraclev11g.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 12c")) {
            return StorageDesignOraclev12c.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 12cR2")) {
            return StorageDesignOraclev12cR2.RDBMS_TYPE;
        }
        if (rdbms.equalsIgnoreCase("Oracle Database 21c")) {
            return StorageDesignOraclev20c.RDBMS_TYPE;
        }
        return StorageDesignOraclev12c.RDBMS_TYPE;
    }

    public MDDataTypeFactory getDTFactoryInstance(RDBMSType rdbms) {
        Settings settings = this.getSettings();
        MDDataTypeFactoryOraclev9i instance = null;
        if (this.dtFactoryInstances.containsKey(rdbms)) {
            return (MDDataTypeFactory)this.dtFactoryInstances.get(rdbms);
        }
        instance = rdbms == StorageDesignOraclev9i.RDBMS_TYPE ? new MDDataTypeFactoryOraclev9i(settings) : (rdbms == StorageDesignOraclev10g.RDBMS_TYPE || rdbms == StorageDesignOraclev11g.RDBMS_TYPE ? new MDDataTypeFactoryOraclev10g(settings) : (rdbms == StorageDesignOraclev12c.RDBMS_TYPE || rdbms == StorageDesignOraclev12cR2.RDBMS_TYPE ? new MDDataTypeFactoryOraclev12c(settings) : (rdbms == StorageDesignOraclev20c.RDBMS_TYPE ? new MDDataTypeFactoryOraclev20c(settings) : new MDDataTypeFactoryOraclev12c(settings))));
        instance.dbtype = rdbms;
        this.dtFactoryInstances.put(rdbms, instance);
        return instance;
    }

    public DesignLevelSettings getDesignLevelSettings() {
        return this.getDesignLevelSettings(false);
    }

    public DesignLevelSettings getDesignLevelSettings(boolean defaultsOnly) {
        if (this.designLevelSettings == null) {
            this.designLevelSettings = new DesignLevelSettings(this);
        }
        return this.designLevelSettings;
    }

    public List getPropertiesFilterList(Class comparatorClass, boolean updatable) {
        String comparatorName = comparatorClass.getName();
        return this.getFilterList(comparatorName, updatable, false);
    }

    public List getPropertiesFilterList(String comparatorName, boolean updatable) {
        return this.getFilterList(comparatorName, updatable, false);
    }

    public List getStoragePropertiesFilterList(Class comparatorClass, boolean updatable) {
        String comparatorName = comparatorClass.getName();
        return this.getFilterList(comparatorName, updatable, true);
    }

    private List getFilterList(String comparatorName, boolean updatable, boolean storageTemplate) {
        ArrayList propsFilterList;
        if (storageTemplate) {
            comparatorName = (String)comparatorName + "Storage";
        }
        if ((propsFilterList = this.comparatorFilterListMap.get(comparatorName)) == null) {
            if (updatable) {
                propsFilterList = new ArrayList();
                this.comparatorFilterListMap.put((String)comparatorName, propsFilterList);
            } else {
                propsFilterList = Collections.EMPTY_LIST;
            }
        }
        return propsFilterList;
    }

    public List getDynamicPropertiesFilterList(String comparatorClassName, boolean updatable) {
        ArrayList propsFilterList = this.dynamicPropsFilterListMap.get(comparatorClassName);
        if (propsFilterList == null) {
            if (updatable) {
                propsFilterList = new ArrayList();
                this.dynamicPropsFilterListMap.put(comparatorClassName, propsFilterList);
            } else {
                propsFilterList = Collections.EMPTY_LIST;
            }
        }
        return propsFilterList;
    }

    public void clearPropertiesAndStoragePropsFilters() {
        this.comparatorFilterListMap.clear();
    }

    public String getUnloadDirectory() {
        return this.unloadDirectory;
    }

    public void setUnloadDirectory(String unloadDirectory) {
        this.unloadDirectory = unloadDirectory;
    }

    public String getEngDateFormat() {
        if ("".equals(this.engDateFormat)) {
            return this.defDateFormat;
        }
        return this.engDateFormat;
    }

    public void setEngDateFormat(String engDateFormat) {
        this.engDateFormat = engDateFormat;
    }

    public String getEngTimestampFormat() {
        if ("".equals(this.engTimestampFormat)) {
            return this.defTimestampFormat;
        }
        return this.engTimestampFormat;
    }

    public void setEngTimestampFormat(String engTimestampFormat) {
        this.engTimestampFormat = engTimestampFormat;
    }

    public String getEngTimestampWTZFormat() {
        if ("".equals(this.engTimestampWTZFormat)) {
            return this.defTimestampWTZFormat;
        }
        return this.engTimestampWTZFormat;
    }

    public void setEngTimestampWTZFormat(String engTimestampWTZFormat) {
        this.engTimestampWTZFormat = engTimestampWTZFormat;
    }

    public CompareModelToModel getModelComparator() {
        return this.modelComparator;
    }

    public void setModelComparator(CompareModelToModel modelComparator) {
        this.modelComparator = modelComparator;
    }

    public boolean isTempVar() {
        return this.tempVar;
    }

    public void setTempVar(boolean tempVar) {
        this.tempVar = tempVar;
    }

    public NamingStandardRule getNamingStandardRule() {
        this.namingRule = this.getDesignLevelSettings().getNamingStandardRule();
        return this.namingRule;
    }

    public void loadDefaultDomains() {
        File domainsFile;
        File dir;
        if (systemTypesDir != null && (dir = new File(systemTypesDir)).exists() && (domainsFile = new File(dir, "defaultdomains.xml")).exists()) {
            XMLTransformationManager.getInstance().loadDomainFile(domainsFile, this);
        }
    }

    static {
        systemTypesDir = "";
        settingsFileName = "";
        USE_DROP_DEPENDENCY = true;
        PERS_MODEL_IN_ONE_FILE = 2;
        PERS_MODEL_IN_MANY_FILES = 1;
        PERS_MODEL_MIXED_MODE = 3;
        DROP_GENERATED_OBJECTS_ONLY = true;
        OPEN_FAILED = false;
    }

    public static class DesignStorageDesc {
        String designID;
        String designStoragePath;

        public String getDesignID() {
            return this.designID;
        }

        public void setDesignID(String designID) {
            this.designID = designID;
        }

        public String getDesignStoragePath() {
            return this.designStoragePath;
        }

        public void setDesignStoragePath(String designStoragePath) {
            this.designStoragePath = designStoragePath;
        }
    }
}

