/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.TableComparator;

public class TableSelection
extends CompareObjectSelection {
    public static String NONE = Messages.getString("TableSelection.None");
    public static String BACKUP_RENAME = Messages.getString("TableSelection.Rename");
    public static String BACKUP_UNLOAD = Messages.getString("TableSelection.Unload");
    public static String BACKUP_UNLOAD_PARTITION = Messages.getString("TableSelection.UnloadPerPartition");
    public static String RESTORE = Messages.getString("TableSelection.Restore");
    public static String CONTINUE = Messages.getString("TableSelection.Continue");
    public static String STOP_BEFORE_BACKUP = Messages.getString("TableSelection.StopBeforeBackup");
    public static String STOP_AFTER_BACKUP = Messages.getString("TableSelection.StopAfterBackup");
    public static String STOP_AFTER_RECREATE = Messages.getString("TableSelection.StopAfterRecreate");
    private static String[] executeOptions = new String[]{CONTINUE, STOP_BEFORE_BACKUP, STOP_AFTER_BACKUP, STOP_AFTER_RECREATE};
    private static String[] backupOptions = new String[]{BACKUP_RENAME, BACKUP_UNLOAD, BACKUP_UNLOAD_PARTITION, NONE};
    private static String[] restoreOptions = new String[]{RESTORE, NONE};
    private String backupOption = BACKUP_RENAME;
    private String scriptExecuteOption = CONTINUE;
    private String restoreOption = RESTORE;
    private String unloadDirectory = "";

    public static String[] getScriptExecuteOptions() {
        return executeOptions;
    }

    public static String[] getBackupOptions() {
        return backupOptions;
    }

    public TableSelection(ModelIDObject object) {
        super(object);
    }

    public TableSelection(String name) {
        super(name);
    }

    public boolean isRecreateTable() {
        return super.canBeRename();
    }

    public String getBackupOption() {
        return this.backupOption;
    }

    public void setBackupOption(String backupOption) {
        TableComparator comp = (TableComparator)this.getPropertiesComparator();
        comp.getTargetTableProxy().setBackupOption(backupOption);
        this.backupOption = backupOption;
    }

    public String getScriptExecuteOption() {
        return this.scriptExecuteOption;
    }

    public void setScriptExecuteOption(String scriptExecuteOption) {
        this.scriptExecuteOption = scriptExecuteOption;
    }

    public String getRestoreOption() {
        return this.restoreOption;
    }

    public void setRestoreOption(String restoreOption) {
        TableComparator comp = (TableComparator)this.getPropertiesComparator();
        comp.getTargetTableProxy().setRestoreOption(restoreOption);
        this.restoreOption = restoreOption;
    }

    public static String[] getRestoreOptions() {
        return restoreOptions;
    }

    public String getUnloadDirectory() {
        return this.unloadDirectory;
    }

    public void setUnloadDirectory(String unloadDirectory) {
        this.unloadDirectory = unloadDirectory;
    }
}

