/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.List;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSequence;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SequenceComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;

public class CSSBSequence
extends AbstractCSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sourceSeqSel = (CompareObjectSelection)object;
        SequenceOracle sourceSequence = (SequenceOracle)sourceSeqSel.getObject();
        this.storageDesign = sourceSequence.getStorageDesign();
        if (sourceSeqSel.canBeCreate()) {
            this.appendComment(oldbuffer, sourceSequence);
            StringBuffer buffer = new StringBuffer();
            CSSBSequence.appendStringWithSpace(buffer, "CREATE");
            CSSBSequence.appendStringWithSpace(buffer, "SEQUENCE");
            CSSBSequence.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(sourceSequence));
            String advancedComment = buffer.toString();
            boolean includeDefault = this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL();
            this.appendStartWith(buffer, sourceSequence);
            this.appendIncrementBy(buffer, sourceSequence, includeDefault);
            this.appendMaxValue(buffer, sourceSequence, includeDefault);
            this.appendMinValue(buffer, sourceSequence, includeDefault);
            this.appendCycle(buffer, sourceSequence, includeDefault);
            this.appendCache(buffer, sourceSequence, sourceSequence, includeDefault);
            this.appendOrder(buffer, sourceSequence, includeDefault);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBSequence.appendNewLine(buffer, prettyPrint, 0);
            CSSBSequence.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementCreateSequence();
            CSSBSequence.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendPermissions(oldbuffer, sourceSequence, prettyPrint);
        } else {
            boolean needAlter = false;
            boolean needRecreate = false;
            SequenceComparatorOracle propsComparator = (SequenceComparatorOracle)sourceSeqSel.getPropertiesComparator();
            List propsList = propsComparator.getPropertiesList();
            for (EngPropertyHolder ph : propsList) {
                if (!ph.isModified() || !ph.isSelected() || ph.isFiltered()) continue;
                if (ph.getName().equals(PropertyNames.NAME) || ph.getName().equals(PropertyNames.START_WITH)) {
                    needRecreate = true;
                    continue;
                }
                if (ph.getName().equals(PropertyNames.USER_NAME)) {
                    if (!this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) continue;
                    needRecreate = true;
                    continue;
                }
                needAlter = true;
            }
            if (needRecreate) {
                SequenceOracle seqForUser;
                UserOracle user;
                CSSBDropSequence cssbDropSequence = new CSSBDropSequence();
                cssbDropSequence.doAppend(oldbuffer, object, prettyPrint);
                this.appendComment(oldbuffer, sourceSequence);
                StringBuffer buffer = new StringBuffer();
                CSSBSequence.appendStringWithSpace(buffer, "CREATE");
                CSSBSequence.appendStringWithSpace(buffer, "SEQUENCE");
                if (this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL() && (user = (seqForUser = propsComparator.getSequenceForProperty(PropertyNames.USER_NAME)).getUser()) != null) {
                    CSSBSequence.appendString(buffer, this.storageDesign.getFormatedName(user));
                    CSSBSequence.appendString(buffer, '.');
                }
                CSSBSequence.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(propsComparator.getSequenceForProperty(PropertyNames.NAME)));
                String advancedComment = buffer.toString();
                boolean includeDefault = this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL();
                this.appendStartWith(buffer, propsComparator.getSequenceForProperty(PropertyNames.START_WITH));
                this.appendIncrementBy(buffer, propsComparator.getSequenceForProperty(PropertyNames.INCREMENT_BY), includeDefault);
                this.appendMaxValue(buffer, propsComparator.getSequenceForProperty(PropertyNames.MAX_VALUE), includeDefault);
                this.appendMinValue(buffer, propsComparator.getSequenceForProperty(PropertyNames.MIN_VALUE), includeDefault);
                this.appendCycle(buffer, propsComparator.getSequenceForProperty(PropertyNames.CYCLE), includeDefault);
                this.appendCache(buffer, propsComparator.getSequenceForProperty(PropertyNames.NOCACHE), propsComparator.getSequenceForProperty(PropertyNames.CACHE), includeDefault);
                this.appendOrder(buffer, propsComparator.getSequenceForProperty(PropertyNames.ORDER), includeDefault);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBSequence.appendNewLine(buffer, prettyPrint, 0);
                CSSBSequence.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementCreateSequence();
                CSSBSequence.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendPermissions(oldbuffer, sourceSequence, prettyPrint);
            } else if (needAlter) {
                SequenceOracle targetSequence = (SequenceOracle)sourceSeqSel.getCorrespondentNode().getObject();
                StringBuffer buffer = new StringBuffer();
                CSSBSequence.appendStringWithSpace(buffer, "ALTER");
                CSSBSequence.appendStringWithSpace(buffer, "SEQUENCE");
                CSSBSequence.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(targetSequence));
                String advancedComment = buffer.toString();
                boolean cacheDone = false;
                for (EngPropertyHolder ph : propsList) {
                    if (!ph.isModified() || !ph.isSelected() || ph.isFiltered()) continue;
                    if (ph.getName().equals(PropertyNames.INCREMENT_BY)) {
                        this.appendIncrementBy(buffer, sourceSequence, true);
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.MAX_VALUE)) {
                        this.appendMaxValue(buffer, sourceSequence, true);
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.MIN_VALUE)) {
                        this.appendMinValue(buffer, sourceSequence, true);
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.CYCLE)) {
                        this.appendCycle(buffer, sourceSequence, true);
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.NOCACHE) || ph.getName().equals(PropertyNames.CACHE)) {
                        if (cacheDone) continue;
                        this.appendCache(buffer, propsComparator.getSequenceForProperty(PropertyNames.NOCACHE), propsComparator.getSequenceForProperty(PropertyNames.CACHE), true);
                        cacheDone = true;
                        continue;
                    }
                    if (!ph.getName().equals(PropertyNames.ORDER)) continue;
                    this.appendOrder(buffer, sourceSequence, true);
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBSequence.appendNewLine(buffer, prettyPrint, 0);
                CSSBSequence.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementAlterSequence();
                CSSBSequence.appendNewLine(oldbuffer, prettyPrint, 0);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof SequenceOracle;
    }

    private void appendStartWith(StringBuffer buffer, SequenceOracle sequence) {
        if (this.isNotEmpty(sequence.getStartWith())) {
            buffer.append(NEWLINE).append("    ");
            buffer.append("START WITH ").append(sequence.getStartWith());
        }
    }

    private void appendIncrementBy(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault) {
        if (this.isNotEmpty(sequence.getIncrementBy())) {
            buffer.append(NEWLINE).append("    ");
            buffer.append("INCREMENT BY ").append(sequence.getIncrementBy());
        } else if (includeDefault) {
            buffer.append(NEWLINE).append("    ");
            buffer.append("INCREMENT BY 1");
        }
    }

    private void appendMaxValue(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault) {
        if (this.isNotEmpty(sequence.getMaxValue())) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "MAXVALUE");
            CSSBSequence.appendStringWithSpace(buffer, sequence.getMaxValue());
        } else if (includeDefault) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "NOMAXVALUE");
        }
    }

    private void appendMinValue(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault) {
        if (this.isNotEmpty(sequence.getMinValue())) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "MINVALUE");
            CSSBSequence.appendStringWithSpace(buffer, sequence.getMinValue());
        } else if (includeDefault) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "NOMINVALUE");
        }
    }

    private void appendCycle(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault) {
        if ("YES".equalsIgnoreCase(sequence.getCycle())) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "CYCLE");
        } else if (includeDefault) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "NOCYCLE");
        }
    }

    private void appendCache(StringBuffer buffer, SequenceOracle sequenceNoCache, SequenceOracle sequenceCache, boolean includeDefault) {
        if ("YES".equals(sequenceNoCache.getNoCache())) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "NOCACHE");
        } else if (this.isNotEmpty(sequenceCache.getCache())) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "CACHE");
            CSSBSequence.appendStringWithSpace(buffer, sequenceCache.getCache());
        } else if (includeDefault) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "CACHE");
            CSSBSequence.appendStringWithSpace(buffer, "20");
        }
    }

    private void appendOrder(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault) {
        if ("YES".equalsIgnoreCase(sequence.getOrder())) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "ORDER");
        } else if (includeDefault) {
            buffer.append(NEWLINE).append("    ");
            CSSBSequence.appendStringWithSpace(buffer, "NOORDER");
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, SequenceOracle sequence, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        for (PermissionsOraclev9i permissions : ((StorageDesignOracle)this.storageDesign).getPermissionsSet()) {
            if (permissions.getSequence() == null || !permissions.getSequence().equals(sequence)) continue;
            if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                CSSBSequence.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBSequence.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                CSSBSequence.appendStringWithSpace(buffer, "GRANT");
                CSSBSequence.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions, prettyPrint);
                this.appendTo(buffer, permissions, this.storageDesign);
                advancedComment = buffer.toString();
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBSequence.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                CSSBSequence.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            CSSBSequence.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBSequence.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendComment(oldbuffer, permissions);
            CSSBSequence.appendStringWithSpace(buffer, "GRANT");
            CSSBSequence.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions, prettyPrint);
            this.appendTo(buffer, permissions, this.storageDesign);
            this.appendGrantOption(buffer, permissions);
            advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBSequence.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBSequence.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev9i permissions, boolean prettyPrint) {
        CSSBSequence.appendNewLine(buffer, prettyPrint, 1);
        CSSBSequence.appendStringWithSpace(buffer, "ON");
        if (permissions.getSequence() != null) {
            CSSBSequence.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getSequence()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getRole() == null) {
            CSSBSequence.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

