/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.util.GUID;

public class Attribute
extends ContainedObjectWithDomain {
    public static final String DEFAULT_NAME = "Attribute";
    public static boolean propagateFKName = true;
    protected Attribute delegate;
    private String preferredAbbreviation = "";
    private String source = "";
    private Relation.Connection connection = null;

    public Attribute(DesignPart designPart) {
        super(designPart);
    }

    public Attribute(DesignPart designPart, Relation.Connection connection, Attribute referenced) {
        super(designPart);
        this.connection = connection;
        this.setDelegate(referenced);
    }

    @Override
    public String getObjectTypeName() {
        return DEFAULT_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("attribute id prefix");
    }

    public boolean isFKAttribute() {
        return this.connection != null;
    }

    @Override
    public boolean isFKElement() {
        return this.isFKAttribute();
    }

    public boolean hasAliveGenerator() {
        DesignObject obj;
        ColumnSet set = this.getDesign().getRelationalDesign().getColumnSet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void copy(DesignObject desObject) {
        Attribute attribute = (Attribute)desObject;
        super.copy(attribute);
        attribute.setDesignObjectSet(this.getDesignObjectSet());
        attribute.setUnique(this.isUnique());
        attribute.setNullsAllowed(this.getNullsAllowed());
        attribute.setReference(this.isReference());
        attribute.setUse(this.getUse());
        if (this.getUse() == 0) {
            Domain remoteDomain = this.getDomain();
            if (remoteDomain != null) {
                if (attribute.isBackup()) {
                    attribute.setDomain(remoteDomain);
                } else if (this.getDesign() == attribute.getDesign()) {
                    attribute.setDomain(remoteDomain);
                } else if (!remoteDomain.isDefault()) {
                    String domainID = remoteDomain.getObjectID();
                    Domain newDomain = (Domain)attribute.getDesign().getDomainSet().getObjectByID(domainID);
                    if (newDomain == null && remoteDomain.isRemoteObject()) {
                        domainID = remoteDomain.getRemoteObjectID();
                        newDomain = (Domain)attribute.getDesign().getDomainSet().getByRemoteObjectId(domainID);
                    }
                    if (newDomain == null) {
                        newDomain = attribute.getDesign().getDomainSet().createDomain();
                        newDomain.setObjectID(new GUID().toString());
                        remoteDomain.copyTo(newDomain);
                        newDomain.setOwnerDesignName(attribute.getDesign().getName());
                        newDomain.setFileName(attribute.getDesign().getName());
                        if (remoteDomain.isRemoteObject()) {
                            newDomain.setRemoteObjectID(remoteDomain.getRemoteObjectID());
                            newDomain.setRemoteDesignID(remoteDomain.getRemoteDesignID());
                            newDomain.setRemoteObjectRelativeStorageName(remoteDomain.getRemoteObjectRelativeStorageName());
                        } else {
                            newDomain.setRemoteObjectID(remoteDomain.getObjectID());
                            newDomain.setRemoteDesignID(this.getDesign().getObjectID());
                            newDomain.setRemoteObjectRelativeStorageName(remoteDomain.getRelativeStorageName());
                        }
                    }
                    attribute.setDomain(newDomain);
                } else {
                    Domain dom = (Domain)attribute.getDesign().getDomainSet().getObjectByID(remoteDomain.getObjectID());
                    if (dom != null) {
                        remoteDomain = dom;
                    }
                    attribute.setDomain(remoteDomain);
                }
            }
        } else if (this.getUse() == 1) {
            if (attribute.isBackup() || this.getDesign() == attribute.getDesign()) {
                attribute.setLogicalDatatype(this.getLogicalDatatype());
            } else {
                LogicalDatatype lt = this.getLogicalDatatype();
                if (lt != null) {
                    LogicalDatatype nlt = (LogicalDatatype)attribute.getDesign().getLogicalDatatypeSet().getObjectByID(lt.getObjectID());
                    if (nlt == null) {
                        nlt = (LogicalDatatype)attribute.getDesign().getLogicalDatatypeSet().getByName(lt.getName(), false);
                    }
                    if (nlt != null) {
                        attribute.setLogicalDatatype(nlt);
                    }
                }
            }
            attribute.setDataTypeParameter("size", this.getSize());
            attribute.setDataTypeParameter("precision", this.getPrecision());
            attribute.setDataTypeParameter("scale", this.getScale());
        } else if (this.getUse() == 3) {
            attribute.setStructuredType(this.getStructuredType());
            List list = attribute.getPermittedSubTypes();
            list.clear();
            list.addAll(this.getPermittedSubTypes());
        } else if (this.getUse() == 4) {
            attribute.setCollectionType(this.getCollectionType());
        } else if (this.getUse() == 2) {
            attribute.setDistinctType(this.getDistinctType());
        }
        attribute.setUsesDefaultValue(this.getUsesDefaultValue());
        attribute.setUseDomainConstraints(this.getUseDomainConstraints());
        attribute.setDefaultValue(this.getDefaultValue());
        attribute.setSourceType(this.getSourceType());
        attribute.setSource(this.getSource());
        attribute.setFormulaDesc(this.getFormulaDesc());
        attribute.setScopeId(this.getScopeId());
        attribute.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        attribute.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        attribute.setSynonym(this.getSynonym());
        attribute.setPreferredAbbreviation(this.getPreferredAbbreviation());
        attribute.setSensitiveType(this.getSensitiveType());
        attribute.setSensitiveTypeDescription(this.getSensitiveTypeDescription());
        block0: for (Attribute sourceNestedAtt : this.getNestedObjects()) {
            String sourceStructAttID = sourceNestedAtt.getStructAttributeID();
            if (sourceStructAttID.equals("")) continue;
            for (Attribute targetNestedAtt : attribute.getNestedObjects()) {
                if (!sourceStructAttID.equals(targetNestedAtt.getStructAttributeID())) continue;
                sourceNestedAtt.copy(targetNestedAtt);
                continue block0;
            }
        }
    }

    public void importAttribute(DesignObject desObject) {
        Attribute attribute = (Attribute)desObject;
        super.copy(attribute);
        attribute.setDesignObjectSet(this.getDesignObjectSet());
        attribute.setUnique(this.isUnique());
        attribute.setNullsAllowed(this.getNullsAllowed());
        attribute.setUse(this.getUse());
        attribute.setReference(this.isReference());
        if (this.getDomain() != null) {
            Domain sourceDomain = this.getDomain();
            Domain targetDomain = (Domain)attribute.getDesign().getDomainSet().getByName(sourceDomain.getName());
            if (targetDomain != null) {
                attribute.setDomain(targetDomain);
            } else {
                targetDomain = sourceDomain;
                targetDomain.copy(sourceDomain);
                targetDomain.setDesign(attribute.getDesign());
                targetDomain.setOwnerDesign(attribute.getDesign());
                targetDomain.setDirty(true);
                attribute.getDesign().getDomainSet().add(targetDomain);
                attribute.setDomain(targetDomain);
            }
        }
        attribute.setLogicalDatatype(this.getLogicalDatatype());
        attribute.setDataTypeParameter("size", this.getSize());
        attribute.setDataTypeParameter("precision", this.getPrecision());
        attribute.setDataTypeParameter("scale", this.getScale());
        attribute.setUsesDefaultValue(this.getUsesDefaultValue());
        attribute.setUseDomainConstraints(this.getUseDomainConstraints());
        attribute.setDefaultValue(this.getDefaultValue());
        attribute.setSourceType(this.getSourceType());
        attribute.setFormulaDesc(this.getFormulaDesc());
        attribute.setScopeId(this.getScopeId());
        attribute.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        attribute.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        attribute.setImportedId(this.getObjectID());
    }

    public List getAlldelegates() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Attribute delegate = this.getDelegate(); delegate != null && !list.contains(delegate); delegate = delegate.getDelegate()) {
            list.add(delegate);
        }
        return list;
    }

    public Attribute getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Attribute value) {
        if (this.delegate != value) {
            if (this.delegate != null) {
                this.delegate.removeObjectListener(this);
            }
            this.delegate = value;
            if (this.delegate != null && !this.hasCircularRef()) {
                this.delegate.addObjectListener(this);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean setName(String name) {
        if (name != null && name.equals(this.name)) {
            return true;
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        propagateFKName = this.getDesign().getSettings().isKeepFKNamesSynchronized();
        boolean result = super.setName(name);
        if (!this.getDesign().isLoading() && result && propagateFKName) {
            list.add(this);
            this.propagateNameToDependent(name, list);
        }
        return result;
    }

    public void propagateNameToFKAttributes(String name) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        propagateFKName = this.getDesign().getSettings().isKeepFKNamesSynchronized();
        if (propagateFKName) {
            list.add(this);
            this.propagateNameToDependent(name, list);
        }
    }

    private boolean setPropagatedName(String name, List list) {
        if (!list.contains(this)) {
            boolean result = super.setName(name);
            if (result && propagateFKName) {
                list.add(this);
                this.propagateNameToDependent(name, list);
            }
            return result;
        }
        return false;
    }

    private void propagateNameToDependent(String name, List list) {
        List dependent = ((LogicalDesign)this.getDesignPart()).getAttributeSet().getDependentOnDelegate(this);
        for (Attribute attr : dependent) {
            attr.setPropagatedName(name, list);
        }
    }

    public String getPreferredAbbreviation() {
        return this.preferredAbbreviation;
    }

    public void setPreferredAbbreviation(String preferredAbbreviation) {
        this.preferredAbbreviation = preferredAbbreviation;
    }

    public String getLogicalRepresentationName() {
        String name = "";
        if (this.getUse() == 0) {
            return this.getDomain().getLogicalRepresentationName(this.getDesign().getDesignLevelSettings().isLogicalTypeForDomainPresentation());
        }
        if (this.getUse() == 1) {
            name = this.getLogicalDatatype().getName();
            String size = this.getDataTypeParameter("size");
            if (size != null && !"".equals(size)) {
                int ind = size.indexOf(" BYTE");
                if (ind > 0) {
                    size = size.substring(0, ind);
                }
                if ((ind = size.indexOf(" CHAR")) > 0) {
                    size = size.substring(0, ind);
                }
                if (!"".equals(size) && !"0".equals(size)) {
                    return name + " (" + size + ")";
                }
                return name;
            }
            String precision = this.getDataTypeParameter("precision");
            if (precision != null && !"".equals(precision)) {
                if (!"".equals(precision) && !"0".equals(precision)) {
                    String scale = this.getDataTypeParameter("scale");
                    if (!(scale == null || "".equals(scale) && !"*".equals(precision) || "0".equals(scale) && !"*".equals(precision))) {
                        return name + " (" + precision + "," + scale + ")";
                    }
                    return name + " (" + precision + ")";
                }
                return name;
            }
            return name;
        }
        if (this.getUse() == 3) {
            if (this.isReference()) {
                return "REF " + this.getStructuredType().getName();
            }
            return this.getStructuredType().getName();
        }
        if (this.getUse() == 2) {
            return this.getDistinctType().getName();
        }
        if (this.getUse() == 4) {
            return this.getCollectionType().getName();
        }
        return name;
    }

    @Override
    public void addAVT(AVT avt) {
        if (!this.getUseDomainConstraints()) {
            super.addAVT(avt);
        }
    }

    @Override
    public Set getAVTs() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getAVTs();
        }
        return super.getAVTs();
    }

    @Override
    public void removeAVT(AVT avt) {
        if (!this.getUseDomainConstraints()) {
            super.removeAVT(avt);
        }
    }

    @Override
    public void clearAVTs() {
        if (!this.getUseDomainConstraints()) {
            super.clearAVTs();
        }
    }

    @Override
    public void setValueList(ConstraintEnumeration valueList) {
        if (!this.getUseDomainConstraints()) {
            super.setValueList(valueList);
        }
    }

    @Override
    public CheckConstraint getCheck() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getCheck();
        }
        return super.getCheck();
    }

    @Override
    public void setCheck(CheckConstraint check) {
        if (!this.getUseDomainConstraints()) {
            super.setCheck(check);
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public Domain getDomain() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getDomain();
        }
        return super.getDomain();
    }

    protected String getOriginatingTableName() {
        ArrayList<DesignObject> processed = new ArrayList<DesignObject>();
        processed.add(this);
        processed.add(this.getContainerWithKeyObject());
        String tName = this.getContainerWithKeyObject().getName();
        Attribute delg = this.delegate;
        while (delg != null) {
            processed.add(delg);
            ContainerWithKeyObject cont = delg.getContainerWithKeyObject();
            if (cont != null) {
                tName = cont.getName();
                if (processed.contains(cont)) {
                    delg = null;
                    continue;
                }
                processed.add(cont);
                if (delg.isFKAttribute()) {
                    if (!processed.contains(delg = delg.getDelegate())) continue;
                    delg = null;
                    continue;
                }
                delg = null;
                continue;
            }
            delg = null;
        }
        return tName;
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    @Override
    public ContainedObject getDelegateElement() {
        return this.getDelegate();
    }

    @Override
    public void setDomain(Domain domain) {
        if (this.getDelegate() == null) {
            super.setDomain(domain);
        }
    }

    @Override
    public Datatype getDataType() {
        if (this.getDesign().getSettings().isAllowSimilarTypesFK() && !this.getParameters().isEmpty()) {
            return super.getDataType();
        }
        if (this.isReference() || this.getDelegate() == null || this.getDelegate() != null && this.hasCircularRef()) {
            return super.getDataType();
        }
        return this.getDelegate().getDataType();
    }

    @Override
    public LogicalDatatype getLogicalDatatype() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getLogicalDatatype();
        }
        return super.getLogicalDatatype();
    }

    private String getOriginatingAttributeName() {
        ArrayList<Attribute> processed = new ArrayList<Attribute>();
        processed.add(this);
        String tName = this.getName();
        Attribute delg = this.delegate;
        while (delg != null) {
            processed.add(delg);
            if (delg.isFKAttribute()) {
                if (!processed.contains(delg = delg.getDelegate())) continue;
                delg = null;
                continue;
            }
            tName = delg.getName();
            delg = null;
        }
        return tName;
    }

    public Attribute getOriginatingAttribute() {
        if (!this.isFKAttribute()) {
            return null;
        }
        ArrayList<Attribute> processed = new ArrayList<Attribute>();
        processed.add(this);
        Attribute delg = this.delegate;
        boolean found = false;
        while (!found) {
            processed.add(delg);
            if (delg != null && delg.isFKAttribute()) {
                if (!processed.contains(delg = delg.getDelegate())) continue;
                delg = null;
                found = true;
                continue;
            }
            found = true;
        }
        return delg;
    }

    public boolean hasCircularRef() {
        if (this.delegate == null) {
            return false;
        }
        ArrayList<Attribute> processed = new ArrayList<Attribute>();
        processed.add(this);
        Attribute delg = this.delegate;
        boolean found = false;
        while (!found) {
            processed.add(delg);
            if (delg != null && delg.isFKAttribute()) {
                if (!processed.contains(delg = delg.getDelegate())) continue;
                return true;
            }
            found = true;
        }
        return false;
    }

    @Override
    public String toString() {
        Object longName;
        if (!this.isFKAttribute()) {
            return this.getName();
        }
        String tName = this.getOriginatingTableName();
        String atName = this.getOriginatingAttributeName();
        if (this.getRelation() != null) {
            String rName = this.getRelation().getName();
            longName = !tName.equals("") ? tName + "." + atName + "," + rName : atName + "," + rName;
        } else {
            longName = !tName.equals("") ? tName + "." + atName : super.getName();
        }
        return longName;
    }

    @Override
    public String getDataTypeParameter(String key) {
        String res = "";
        boolean superProcessed = false;
        if (this.getDesign().getSettings().isAllowSimilarTypesFK()) {
            res = super.getDataTypeParameter(key);
            superProcessed = true;
        }
        if (res.isEmpty() && this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getDataTypeParameter(key);
        }
        if (superProcessed) {
            return res;
        }
        return super.getDataTypeParameter(key);
    }

    public Relation.Connection getConnection() {
        return this.connection;
    }

    public void setConnectionIfNull(Relation.Connection connection) {
        if (this.connection == null) {
            this.connection = connection;
        }
    }

    public Relation getRelation() {
        if (this.hasRelation()) {
            return this.connection.getRelation();
        }
        return null;
    }

    public boolean hasRelation() {
        return this.getConnection() != null;
    }

    public boolean isValid() {
        return this.hasDelegate() && this.hasRelation();
    }

    private int getPositionInPKOfDelegate() {
        return this.getDelegate().getPositionInPK();
    }

    public int getPositionInRelation() {
        return this.getPositionInPKOfDelegate();
    }

    @Override
    public boolean getNullsAllowed() {
        if (!this.isFKAttribute()) {
            return super.getNullsAllowed();
        }
        return !this.isPKElement() && this.isValid() && this.getConnection().isOptional();
    }

    @Override
    public void setNullsAllowed(boolean value) {
        if (!this.isFKAttribute()) {
            super.setNullsAllowed(value);
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
    }

    public void setDefaultName() {
        if (this.isValid()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getDelegate().getContainerWithKeyObject().getName());
            buffer.append('.');
            String name = this.getDelegate().getName();
            if (name.indexOf(46) > 0) {
                name = name.substring(name.indexOf(46) + 1);
            }
            buffer.append(name);
            int count = 0;
            while (this.connection.getEntity().getElementByName(buffer.toString()) != null) {
                buffer.append(++count);
            }
            this.setName(buffer.toString());
        }
    }

    public void setConnection(Relation.Connection connection) {
        this.connection = connection;
    }

    @Override
    public short getUse() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getUse();
        }
        return super.getUse();
    }

    @Override
    public void setUse(short use) {
        short oldUse = super.getUse();
        if (use != oldUse) {
            Entity entity;
            super.setUse(use);
            if (!(this.getDesign().isLoading() || use != 3 && oldUse != 3 || (entity = (Entity)this.getContainer()) == null)) {
                entity.createNestedAttributes(this.getStructuredType(), this);
            }
        }
    }

    @Override
    public void setReference(boolean reference) {
        if (this.isReference() != reference) {
            Entity entity;
            super.setReference(reference);
            if (!this.getDesign().isLoading() && (entity = (Entity)this.getContainer()) != null) {
                entity.createNestedAttributes(this.getStructuredType(), this);
            }
        }
    }

    @Override
    public void setStructuredType(StructuredType structuredType) {
        StructuredType old = this.getStructuredType();
        if (old != structuredType) {
            if (old != null) {
                old.removeObjectListener(this);
            }
            super.setStructuredType(structuredType);
            Entity entity = (Entity)this.getContainer();
            if (entity != null) {
                if (!this.getDesign().isLoading()) {
                    entity.createNestedAttributes(structuredType, this);
                }
                if (structuredType != null) {
                    structuredType.addObjectListener(this);
                }
            }
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        Entity entity;
        super.changed(object, event);
        if (object instanceof StructuredType && (entity = (Entity)this.getContainerWithKeyObject()) != null) {
            entity.createNestedAttributes(this.getStructuredType(), this);
        }
    }

    public Entity getEntity() {
        return (Entity)this.getContainerWithKeyObject();
    }

    public Relation getContainerRelation() {
        if (this.getEntity() != null) {
            return this.getEntity().getContainerRelation();
        }
        return null;
    }
}

