/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;

public class JSONObjToStreamTransformer
extends MDTransformer
implements MDXMLConstants {
    private static final String SLASH_CLOSE_CHAR = "/>";
    private static final String CLOSE_CHAR = "}";
    private static final String INNER_CLASS = "innerClass";
    public static boolean includeLoggingProps = true;
    public static boolean includeID = true;
    public static String header = "<?xml version = '1.0' encoding = 'UTF-8'?>";
    public static Collection POPERTIES_TO_SKIP = new HashSet();
    private boolean skipDefaults = false;
    public static final HashMap<String, String> refContained = new HashMap();
    public static final HashMap<String, String> nameAsID = new HashMap();
    public static final HashMap<String, String> namesWithQuotes = new HashMap();

    public void transformFromObject(Object object, Writer sb) {
        this.transformFromObject(object, sb, false, null);
    }

    public void transformFromObject(Object object, Writer sb, boolean processExternals, Collection excludeProps_Collections) {
        this.transformFromObject(object, null, sb, processExternals, excludeProps_Collections, true);
    }

    public void transformFromObject(Object object, Writer sb, boolean processExternals, Collection excludeProps_Collections, boolean first) {
        this.transformFromObject(object, null, sb, processExternals, excludeProps_Collections, first);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformFromListOfObjects(List list, Writer sb, boolean processExternals, Collection excludeProps_Collections) {
        try {
            sb.write("{\"objects\":[");
        }
        catch (IOException e) {
            Logger.error(e);
        }
        boolean first = true;
        for (Object object : list) {
            MDTransformationManager.TrObjects tr = this.getTransformationManager().getTransformersFor(object.getClass());
            if (tr != null && tr.getFromObjectToJsonStreamTransformer() != null && tr.getFromObjectToJsonStreamTransformer() instanceof JSONObjToStreamTransformer) {
                JSONObjToStreamTransformer xmltr = (JSONObjToStreamTransformer)tr.getFromObjectToJsonStreamTransformer();
                boolean skipDefaults = xmltr.isSkipDefaults();
                try {
                    xmltr.setSkipDefaults(this.isSkipDefaults());
                    xmltr.transformFromObject(object, null, sb, processExternals, excludeProps_Collections, first);
                }
                finally {
                    xmltr.setSkipDefaults(skipDefaults);
                }
            }
            first = false;
        }
        try {
            sb.write("]}");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformFromListOfObjects(List<List> masterList, List<String> objectTypes, Writer sb, boolean processExternals, Collection excludeProps_Collections) {
        try {
            sb.write("{");
        }
        catch (IOException e) {
            Logger.error(e);
        }
        int ind = 0;
        for (List list : masterList) {
            String type = objectTypes.get(ind);
            try {
                if (ind > 0) {
                    sb.write(",");
                }
                sb.write("\n\"" + type + "\":[");
            }
            catch (IOException e) {
                Logger.error(e);
            }
            ++ind;
            boolean first = true;
            for (Object object : list) {
                MDTransformationManager.TrObjects tr = this.getTransformationManager().getTransformersFor(object.getClass());
                if (tr != null && tr.getFromObjectToJsonStreamTransformer() != null && tr.getFromObjectToJsonStreamTransformer() instanceof JSONObjToStreamTransformer) {
                    JSONObjToStreamTransformer xmltr = (JSONObjToStreamTransformer)tr.getFromObjectToJsonStreamTransformer();
                    boolean skipDefaults = xmltr.isSkipDefaults();
                    try {
                        xmltr.setSkipDefaults(this.isSkipDefaults());
                        xmltr.transformFromObject(object, null, sb, processExternals, excludeProps_Collections, first);
                    }
                    finally {
                        xmltr.setSkipDefaults(skipDefaults);
                    }
                }
                first = false;
            }
            try {
                sb.write("]");
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
        try {
            sb.write(CLOSE_CHAR);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public void transformFromObject(Object object, String tagName, Writer sb, boolean processExternals, Collection excludeProps_Collections, boolean first) {
        String name = this.transformFromObject(object, tagName, sb, processExternals, false, excludeProps_Collections, first);
    }

    public String transformFromObject(Object object, String tagName, Writer sb, boolean processExternals, boolean skipClassName) {
        return this.transformFromObject(object, tagName, sb, processExternals, skipClassName, null, false);
    }

    public String transformFromObject(Object object, String tagName, Writer sb, boolean processExternals, boolean skipClassName, Collection excludeProps_Collections, boolean first) {
        return this.transformFromObject(object, tagName, sb, processExternals, skipClassName, excludeProps_Collections, first, true);
    }

    public String transformFromObject(Object object, String tagName, Writer sb, boolean processExternals, boolean skipClassName, Collection excludeProps_Collections, boolean first, boolean inBrackets) {
        boolean cfirst = true;
        String name = "";
        try {
            Index index;
            ClassDescription cd = this.getClassDescription();
            String xmlName = "";
            if (tagName != null) {
                if (inBrackets) {
                    this.addOpenObjectChar(sb, first);
                } else {
                    this.addObjectName(tagName, sb, first);
                }
            } else {
                boolean innerClass = false;
                xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                if (inBrackets) {
                    this.addOpenObjectChar(sb, first);
                } else {
                    this.addObjectName(xmlName, sb, first);
                }
                if (innerClass) {
                    this.addAttribute(INNER_CLASS, "true", sb, first, true);
                    first = false;
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                this.addAttribute("class", cd.getClassName(), sb, cfirst, false);
                cfirst = false;
            }
            if (object instanceof ModelIDObject && !excludeProps_Collections.contains("objectType")) {
                this.addAttribute("objectType", ((ModelIDObject)object).getObjectTypeName().toUpperCase(), sb, cfirst, false);
                cfirst = false;
            }
            if (object instanceof ContainedObjectWithDomain) {
                ContainedObjectWithDomain co = (ContainedObjectWithDomain)object;
                cfirst = false;
                if (!co.getDesign().getSettings().isImportColumnsOnly()) {
                    this.addAttribute("pkElement", String.valueOf(co.isPKElement()), sb, cfirst, true);
                    this.addAttribute("ukElement", String.valueOf(co.isUnique()), sb, cfirst, true);
                    this.addAttribute("fkElement", String.valueOf(co.isFKElement()), sb, cfirst, true);
                }
            }
            if (object instanceof Index && (index = (Index)object).isOutsideContainer() && !index.isPK() && !index.isUnique()) {
                this.addAttribute("tableSchema", String.valueOf(index.getContainerWithKeyObject().getSchema()), sb, cfirst, false);
                cfirst = false;
                this.addAttribute("tableName", String.valueOf(index.getContainerWithKeyObject().getName()), sb, cfirst, false);
            }
            this.invokeMethod(object, cd.beforeTransform);
            if (processExternals) {
                this.invokeMethod(object, cd.beforeTransformExt);
            }
            ArrayList<ClassDescription.PropertyDescription> properties = new ArrayList<ClassDescription.PropertyDescription>();
            ArrayList<ClassDescription.PropertyDescription> afterCollectionsProcessing = new ArrayList<ClassDescription.PropertyDescription>();
            ArrayList<ClassDescription.PropertyDescription> collectionDependentProcessing = new ArrayList<ClassDescription.PropertyDescription>();
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                if (pd.isExternalProperty && !processExternals || excludeProps_Collections != null && excludeProps_Collections.contains(pd.name)) continue;
                if (pd.isAfterCollectionProcessing) {
                    afterCollectionsProcessing.add(pd);
                    continue;
                }
                if (pd.beforeCollection != null && !"".equals(pd.beforeCollection) || pd.afterCollection != null && !"".equals(pd.afterCollection)) {
                    collectionDependentProcessing.add(pd);
                    continue;
                }
                properties.add(pd);
            }
            cfirst = this.processProperties(object, sb, cd, properties, processExternals, excludeProps_Collections, cfirst);
            cfirst = this.processClassPropertyMap(object, sb, cd, cfirst);
            cfirst = this.processProxyProperties(object, sb, cd, processExternals, excludeProps_Collections, cfirst);
            this.processCollections(object, sb, cd, processExternals, skipClassName, collectionDependentProcessing, afterCollectionsProcessing, excludeProps_Collections, cfirst);
            this.addCloseChar(sb);
            if (inBrackets) {
                // empty if block
            }
            name = tagName != null ? tagName : xmlName;
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return name;
    }

    private boolean processProxyProperties(Object object, Writer sb, ClassDescription cd, boolean processExternals, Collection excludeProps_Collections, boolean first) {
        for (ClassDescription.ProxyProperties pp : cd.proxyProperties) {
            Object obj;
            if (pp.proxyGetter == null || (obj = JSONObjToStreamTransformer.getObject(object, pp.proxyGetter)) == null) continue;
            for (ClassDescription.PropertyDescription pd : pp.proxyProperties) {
                first = this.processProperty(obj, pd, sb, processExternals, excludeProps_Collections, first);
            }
        }
        return first;
    }

    public void transformFromObjectAttributesOnly(Object object, String tagName, Writer sb, boolean processExternals, boolean skipClassName, boolean skipDefaults) {
        String name = "";
        try {
            ClassDescription cd = this.getClassDescription();
            String xmlName = "";
            if (tagName != null) {
                this.addOpenTag(tagName, sb);
            } else {
                boolean innerClass = false;
                xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                this.addOpenTag(xmlName, sb);
                if (innerClass) {
                    this.addAttribute(INNER_CLASS, "true", sb);
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                this.addAttribute("class", cd.getClassName(), sb);
            }
            this.invokeMethod(object, cd.beforeTransform);
            if (processExternals) {
                this.invokeMethod(object, cd.beforeTransformExt);
            }
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                String value;
                if (!pd.isAttribute() || pd.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals || (value = this.getProperty(object, pd)) == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
                this.addAttribute(pd.xmlName, value, sb);
            }
            name = tagName != null ? tagName : xmlName;
            this.addCloseSlashChar(sb);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private void addAttribute(String name, String value, Writer sb) {
        this.addAttribute(name, value, sb, false);
    }

    private void addAttribute(String name, String value, Writer sb, boolean first) {
        this.addAttribute(name, value, sb, first, false);
    }

    private void addAttribute(String name, String value, Writer sb, boolean first, boolean numOrbool) {
        try {
            String code = name;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n\"");
            sb.write(code);
            if (!numOrbool) {
                sb.write("\":\"");
                sb.write(value);
                sb.write("\"");
            } else {
                sb.write("\":");
                sb.write(value);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addOpenTag(String tagname, Writer sb) {
        try {
            String code = tagname;
            sb.write("{\"");
            sb.write(code);
            sb.write("\":");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addOpenObjectChar(Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            sb.write("{");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addObjectOpenTag(String tagname, Writer sb, boolean first) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n");
            sb.write("{\"");
            sb.write(code);
            sb.write("\":{");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addObjectName(String tagname, Writer sb, boolean first) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n");
            sb.write("\"");
            sb.write(code);
            sb.write("\":{");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addKeyValueObject(String key, String value, Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            sb.write("\n");
            sb.write("{\"");
            sb.write(StringUtilities.encodeAttributeValueJSON(key));
            sb.write("\":\"");
            sb.write(StringUtilities.encodeAttributeValueJSON(value));
            sb.write("\"}");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCollectionOpenTag(String tagname, Writer sb, boolean first) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n\"");
            sb.write(code);
            sb.write("\":[");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCollectionOpenChar(Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(",\n");
            }
            sb.write("[");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCollectionCloseChar(String tagname, Writer sb) {
        try {
            sb.write("\n]");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCollectionCloseTag(String tagname, Writer sb) {
        try {
            sb.write("\n]");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void addListOfObjectsInArrays(List<String[]> list, Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(",");
            }
            sb.write("[");
            boolean mfirst = true;
            for (String[] obj : list) {
                JSONObjToStreamTransformer.addObjectInArray(obj, sb, mfirst);
                mfirst = false;
            }
            if (list.size() > 0) {
                sb.write("\n");
            }
            sb.write("]");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void addObjectInArray(String[] pairs, Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(",");
            }
            sb.write("{");
            for (int i = 0; i < pairs.length - 1; i += 2) {
                if (i > 0) {
                    sb.write(",");
                }
                sb.write("\n\"");
                String name = StringUtilities.encodeAttributeValueJSON(pairs[i]);
                String value = pairs[i + 1];
                sb.write(name);
                sb.write("\":");
                sb.write(value);
            }
            sb.write("\n}");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addElement(String tagname, String value, Writer sb, boolean first) {
        this.addElement(tagname, value, sb, first, false);
    }

    private void addElement(String tagname, String value, Writer sb, boolean first, boolean numOrbool) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(",");
            }
            sb.write("\n\"");
            sb.write(code);
            if (!numOrbool) {
                sb.write("\":\"");
                sb.write(value);
                sb.write("\"");
            } else {
                sb.write("\":");
                sb.write(value);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addArrayOfStrings(String tagname, List<String> list, Writer sb, boolean first) {
        this.addArrayOfStrings(tagname, list, sb, first, false);
    }

    private void addArrayOfStrings(String tagname, List<String> list, Writer sb, boolean first, boolean includeEmptyArray) {
        try {
            if (list.size() > 0 || includeEmptyArray) {
                String code = tagname;
                if (!first) {
                    sb.write(",");
                }
                sb.write("\n\"");
                sb.write(code);
                boolean lfirst = true;
                sb.write("\":[");
                for (String value : list) {
                    if (!lfirst) {
                        sb.write(",");
                    } else {
                        lfirst = false;
                    }
                    sb.write("\"");
                    sb.write(value);
                    sb.write("\"");
                }
                sb.write("]");
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCloseChar(Writer sb) {
        try {
            sb.write(CLOSE_CHAR);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void addCloseSlashChar(Writer sb) {
        try {
            sb.write(SLASH_CLOSE_CHAR);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private boolean processProperties(Object object, Writer sb, ClassDescription cd, List properties, boolean processExternals, Collection excludeProps_Collections, boolean first) {
        List<String> list;
        for (ClassDescription.PropertyDescription pd : properties) {
            String value;
            if (!pd.isAttribute() || excludeProps_Collections != null && excludeProps_Collections.contains(pd.xmlName) || pd.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals || (value = this.getProperty(object, pd)) == null || this.skipDefaults && value.equalsIgnoreCase(pd.defaultValue)) continue;
            value = StringUtilities.encodeAttributeValueJSON(value);
            this.addAttribute(pd.xmlName, value, sb, first, pd.isBoolean || pd.isNumeric);
            first = false;
        }
        for (ClassDescription.PropertyDescription pd : properties) {
            if (pd.isAttribute()) continue;
            first = this.processProperty(object, pd, sb, processExternals, excludeProps_Collections, first);
        }
        if (object instanceof ContainerObject) {
            list = ((ContainerObject)object).getExistingTablespaces();
            if (list != null) {
                TableSpaceOracle tblsp = null;
                if (object instanceof Table) {
                    tblsp = ((Table)object).getTableSpace();
                } else if (object instanceof Index) {
                    tblsp = ((Index)object).getTableSpace();
                }
                if (tblsp != null && !list.contains(tblsp.getName())) {
                    list.add(tblsp.getName());
                }
            }
            if (list != null) {
                this.addArrayOfStrings("existingTablespaces", list, sb, first, true);
                first = false;
            }
        }
        if (object instanceof TableView) {
            list = ((TableView)object).getUsedTablesAndViewsList();
            if (list != null && list.size() > 0) {
                this.addArrayOfStrings("usedTablesAndViews", list, sb, first);
                first = false;
            }
        } else if (object instanceof Table) {
            this.addAttribute("partitioned", String.valueOf(((Table)object).isPartitioned()), sb, first, true);
            first = false;
            if (((Table)object).isMaterializedQueryTable() && (list = ((Table)object).getUsedTablesAndViewsList()) != null && list.size() > 0) {
                this.addArrayOfStrings("usedTablesAndViews", list, sb, first);
                first = false;
            }
        }
        return first;
    }

    public static boolean isJSONNested(ClassDescription.PropertyDescription pd) {
        return refContained.get(pd.name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processProperty(Object object, ClassDescription.PropertyDescription pd, Writer sb, boolean processExternals, Collection excludeProps_Collections, boolean first) {
        boolean isnameAsID;
        if (pd.isAttribute()) {
            return first;
        }
        if (pd.isLoggingProp && !includeLoggingProps) {
            return first;
        }
        if (!includeID && "id".equalsIgnoreCase(pd.xmlName)) {
            return first;
        }
        if (pd.isExternalProperty && !processExternals) {
            return first;
        }
        boolean isnested = JSONObjToStreamTransformer.isJSONNested(pd);
        boolean bl = isnameAsID = nameAsID.get(pd.name) != null;
        if (pd.isRectangle) {
            Object obj = JSONObjToStreamTransformer.getObjectForProperty(object, pd);
            if (obj != null && obj instanceof Rectangle) {
                this.appendBounds(sb, pd.xmlName, (Rectangle)obj);
            }
        } else if (pd.isPropertyMap) {
            first = this.processPropertyAsPropertyMap(object, sb, pd, first);
        } else if (pd.isMap) {
            first = this.processMapProperty(object, sb, pd, first);
        } else if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred() && !isnested) {
            String value = this.getProperty(object, pd, isnameAsID);
            if (!(value == null || this.skipDefaults && value.equalsIgnoreCase(pd.defaultValue))) {
                if (!"jsonDataGuide".equalsIgnoreCase(pd.xmlName)) {
                    value = StringUtilities.encodeAttributeValueJSON(value);
                    if (!pd.isAttribute()) {
                        this.addElement(pd.xmlName, value, sb, first, pd.isBoolean || pd.isNumeric);
                        first = false;
                    }
                } else {
                    if (!(value = StringUtilities.encodeAttributeValueJSON(value)).isEmpty()) {
                        this.addElement(pd.xmlName, value, sb, first, false);
                    } else {
                        this.addElement(pd.xmlName, "", sb, first, false);
                    }
                    first = false;
                }
            }
        } else {
            MDTransformationManager.TrObjects tr;
            Object nested = JSONObjToStreamTransformer.getObjectForProperty(object, pd);
            if (nested != null && (tr = this.getTransformationManager().getTransformersFor(nested.getClass())) != null && tr.getFromObjectToJsonStreamTransformer() != null && tr.getFromObjectToJsonStreamTransformer() instanceof JSONObjToStreamTransformer) {
                JSONObjToStreamTransformer xmltr = (JSONObjToStreamTransformer)tr.getFromObjectToJsonStreamTransformer();
                boolean skipDefaults = xmltr.isSkipDefaults();
                try {
                    xmltr.setSkipDefaults(this.isSkipDefaults());
                    xmltr.transformFromObject(nested, pd.xmlName, sb, processExternals, pd.skipClassName, excludeProps_Collections, first, false);
                }
                finally {
                    xmltr.setSkipDefaults(skipDefaults);
                }
                first = false;
            }
        }
        return first;
    }

    private boolean processPropertyAsPropertyMap(Object object, Writer sb, ClassDescription.PropertyDescription pd, boolean first) {
        Object obj;
        boolean res = first;
        if (pd.isPropertyMap && (obj = JSONObjToStreamTransformer.getObjectForProperty(object, pd)) != null && obj instanceof PropertyMap) {
            boolean cfirst = true;
            PropertyMap pm = (PropertyMap)obj;
            this.addObjectName(pd.xmlName, sb, first);
            boolean pmadded = false;
            Iterator it = pm.getPropertyNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = pm.getProperty(key);
                if (value == null || value == null || key == null || !(value instanceof String) || !(key instanceof String)) continue;
                String k = StringUtilities.encodeAttributeValueJSON(key);
                String v = StringUtilities.encodeAttributeValueJSON(value);
                this.addElement(k, v, sb, cfirst);
                cfirst = false;
            }
            this.addCloseChar(sb);
        }
        return res;
    }

    private boolean processMapProperty(Object object, Writer sb, ClassDescription.PropertyDescription pd, boolean first) {
        boolean res = first;
        Object obj = JSONObjToStreamTransformer.getObjectForProperty(object, pd);
        if (obj instanceof Map) {
            boolean cmfirst = true;
            this.addOpenObjectChar(sb, cmfirst);
            Map map = (Map)obj;
            if (map.entrySet().size() > 0) {
                boolean mfirst = true;
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object key = entry.getKey();
                    if (value == null || key == null || !(value instanceof String) || !(key instanceof String)) continue;
                    String k = StringUtilities.encodeAttributeValueJSON((String)key);
                    String v = StringUtilities.encodeAttributeValueJSON((String)value);
                    this.addAttribute(k, v.toString(), sb, mfirst);
                    mfirst = false;
                }
                this.addCloseChar(sb);
            }
        }
        return res;
    }

    private boolean processClassPropertyMap(Object object, Writer sb, ClassDescription cd, boolean first) {
        boolean res = first;
        if (cd.isPropertyMap && object instanceof PropertyMap) {
            boolean cfirst = true;
            PropertyMap pmap = (PropertyMap)object;
            Iterator it = pmap.getPropertyNames();
            boolean pmadded = false;
            while (it.hasNext()) {
                String key = (String)it.next();
                if (this.skipProperty(key)) continue;
                String value = pmap.getProperty(key);
                if (value == null) {
                    value = "";
                }
                if (!pmadded) {
                    this.addCollectionOpenTag("propertyMap", sb, res);
                    res = false;
                    pmadded = true;
                }
                this.addKeyValueObject(key, value, sb, cfirst);
                cfirst = false;
            }
            if (pmadded) {
                this.addCollectionCloseTag("propertyMap", sb);
            }
        }
        return res;
    }

    private boolean skipProperty(String name) {
        return false;
    }

    private void processCollections(Object object, Writer sb, ClassDescription cd, boolean processExternals, boolean skipClassName, List collectionDependent, List afterCollections, Collection excludeProps_Collections, boolean first) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            Object sourceCol;
            Collection col;
            if (excludeProps_Collections != null && excludeProps_Collections.contains(cold.name)) continue;
            this.processBeforeCollection(object, sb, cold, collectionDependent, processExternals, excludeProps_Collections);
            if (!(cold.isExternalCollection && !processExternals || (col = this.getObjectList(sourceCol = JSONObjToStreamTransformer.getCollection(object, cold), cold)) == null || !(col instanceof Collection) || this.skipDefaults && col.size() <= 0)) {
                if (cold.itemIsRef) {
                    this.processCollectionWithRefs(object, col, sb, cold, processExternals, first);
                } else {
                    this.processCollectionWithContained(col, sb, cold, processExternals, skipClassName, excludeProps_Collections, first);
                    first = false;
                }
            }
            this.processAfterCollection(object, sb, cold, collectionDependent, processExternals, excludeProps_Collections);
        }
        for (ClassDescription.PropertyDescription pd : afterCollections) {
            if (pd.isExternalProperty && !processExternals) continue;
            this.processProperty(object, pd, sb, processExternals, excludeProps_Collections, false);
        }
    }

    private void processBeforeCollection(Object container, Writer sb, ClassDescription.CollectionDescription cold, List props, boolean processExternals, Collection excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.beforeCollection == null || cold.name == null || !cold.name.equals(pd.beforeCollection)) continue;
            this.processProperty(container, pd, sb, processExternals, excludeProps, false);
        }
    }

    private void processAfterCollection(Object container, Writer sb, ClassDescription.CollectionDescription cold, List props, boolean processExternals, Collection excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.afterCollection == null || cold.name == null || !cold.name.equals(pd.afterCollection)) continue;
            this.processProperty(container, pd, sb, processExternals, excludeProps, false);
        }
    }

    private void processCollectionWithRefs(Object object, Collection col, Writer sb, ClassDescription.CollectionDescription cold, boolean processExternals, boolean colfirst) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        boolean cfirst = true;
        if (!cold.listOfRefs) {
            this.addCollectionOpenTag(cold.xmlName, sb, colfirst);
            for (Object item : col) {
                if (item == null) continue;
                String id = null;
                if (item instanceof ModelIDObject) {
                    id = ((ModelIDObject)item).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
                } else {
                    int k = 0;
                    ++k;
                }
                this.addElement(cold.itemXmlName, id, sb, cfirst);
                cfirst = false;
            }
            this.addCollectionCloseTag(cold.xmlName, sb);
        } else {
            StringBuffer sbi = new StringBuffer();
            boolean first = true;
            for (Object item : col) {
                String id = null;
                if (item instanceof ModelIDObject) {
                    id = ((ModelIDObject)item).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
                } else {
                    int k = 0;
                    ++k;
                }
                if (id == null) continue;
                if (first) {
                    sbi.append(id);
                    first = false;
                    continue;
                }
                sbi.append(' ').append(id);
            }
            String idrefs = sbi.toString();
            this.addAttribute(cold.refsXMLName, idrefs, sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCollectionWithContained(Collection col, Writer sb, ClassDescription.CollectionDescription cold, boolean processExternals, boolean skipClassName, Collection excludeProps_Collections, boolean colfirst) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        this.addCollectionOpenTag(cold.xmlName, sb, colfirst);
        if (cold.itemClassName == null || !"".equals(cold.itemClassName)) {
            // empty if block
        }
        if (cold.isEngPropertyHolderItem) {
            // empty if block
        }
        boolean cfirst = true;
        boolean first = true;
        boolean mapItem = cold.isMapItem;
        MDTransformationManager.TrObjects tr = null;
        Class<?> currentClass = null;
        if (!mapItem) {
            for (Object item : col) {
                if (item instanceof Map) {
                    mapItem = true;
                    continue;
                }
                if (first || currentClass != null && !item.getClass().equals(currentClass)) {
                    tr = this.getTransformationManager().getTransformersFor(item.getClass());
                    first = false;
                    currentClass = item.getClass();
                }
                String name = null;
                if (tr != null && tr.getFromObjectToJsonStreamTransformer() != null && tr.getFromObjectToJsonStreamTransformer() instanceof JSONObjToStreamTransformer) {
                    JSONObjToStreamTransformer xmltr = (JSONObjToStreamTransformer)tr.getFromObjectToJsonStreamTransformer();
                    boolean skipDefaults = xmltr.isSkipDefaults();
                    try {
                        xmltr.setSkipDefaults(this.isSkipDefaults());
                        name = xmltr.transformFromObject(item, cold.itemXmlName, sb, processExternals, skipClassName, excludeProps_Collections, cfirst);
                    }
                    finally {
                        xmltr.setSkipDefaults(skipDefaults);
                    }
                    cfirst = false;
                }
                if (name == null) continue;
            }
        }
        if (mapItem) {
            Iterator itc = col.iterator();
            boolean cmfirst = true;
            while (itc.hasNext()) {
                Object item = itc.next();
                if (!(item instanceof Map)) continue;
                this.addOpenObjectChar(sb, cmfirst);
                cmfirst = false;
                mapItem = true;
                Map map = (Map)item;
                if (map.entrySet().size() <= 0) continue;
                boolean mfirst = true;
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object key = entry.getKey();
                    if (value == null || key == null || !(value instanceof String) || !(key instanceof String)) continue;
                    this.addAttribute(key.toString(), value.toString(), sb, mfirst);
                    mfirst = false;
                }
                this.addCloseChar(sb);
            }
        }
        this.addCollectionCloseTag(cold.xmlName, sb);
    }

    private void appendBounds(Writer sb, String elemName, Rectangle bounds) {
        this.addOpenTag(elemName, sb);
        this.addAttribute("x", String.valueOf(bounds.x), sb);
        this.addAttribute("y", String.valueOf(bounds.y), sb);
        this.addAttribute("width", String.valueOf(bounds.width), sb);
        this.addAttribute("height", String.valueOf(bounds.height), sb);
        this.addCloseSlashChar(sb);
    }

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        return "";
    }

    public boolean isSkipDefaults() {
        return this.skipDefaults;
    }

    public void setSkipDefaults(boolean skipDefaults) {
        this.skipDefaults = skipDefaults;
    }

    @Override
    public String getQuotedNameProperty(Object object, ClassDescription.PropertyDescription pd, String value) {
        SchemaObject so;
        if ("sourceObjSchema".equalsIgnoreCase(pd.name) && object instanceof ContainerObject ? (so = ((ContainerObject)object).getSchemaObject()) != null && so.getNameHasQuotes() && so.getName().equalsIgnoreCase(value) : object instanceof ModelObject && ((ModelObject)object).getNameHasQuotes() && namesWithQuotes.containsKey(pd.name)) {
            return "\"" + value + "\"";
        }
        return value;
    }

    static {
        POPERTIES_TO_SKIP.add("directorySegmentName");
        POPERTIES_TO_SKIP.add("sourceConnName");
        POPERTIES_TO_SKIP.add("sourceDDLFile");
        POPERTIES_TO_SKIP.add("ownerDesignName");
        POPERTIES_TO_SKIP.add("remoteDesignID");
        POPERTIES_TO_SKIP.add("remoteModelID");
        POPERTIES_TO_SKIP.add("remoteObjectID");
        POPERTIES_TO_SKIP.add("remoteObjectRelativeStorageName");
        POPERTIES_TO_SKIP.add("shouldEngineer");
        POPERTIES_TO_SKIP.add("usedAsRemoteObject");
        POPERTIES_TO_SKIP.add("lineWidth");
        POPERTIES_TO_SKIP.add("deprecated");
        POPERTIES_TO_SKIP.add("ordsDropSchema");
        POPERTIES_TO_SKIP.add("ordsEnable");
        POPERTIES_TO_SKIP.add("ordsAuth");
        POPERTIES_TO_SKIP.add("useDDLTransformationScript");
        POPERTIES_TO_SKIP.add("visible");
        POPERTIES_TO_SKIP.add("additionalClassificationTypes");
        POPERTIES_TO_SKIP.add("adequatelyNormalized");
        POPERTIES_TO_SKIP.add("expectedVolumes");
        POPERTIES_TO_SKIP.add("growthPercent");
        POPERTIES_TO_SKIP.add("growthType");
        POPERTIES_TO_SKIP.add("maxVolumes");
        POPERTIES_TO_SKIP.add("minVolumes");
        POPERTIES_TO_SKIP.add("normalForm");
        POPERTIES_TO_SKIP.add("shouldGeneratescript");
        POPERTIES_TO_SKIP.add("allowColumnReorder");
        POPERTIES_TO_SKIP.add("redactionPolicyEnabled");
        POPERTIES_TO_SKIP.add("redactionPolicyGenerateInDDL");
        POPERTIES_TO_SKIP.add("isEngineerToRelation");
        POPERTIES_TO_SKIP.add("existDependencyGenerateInDDl");
        POPERTIES_TO_SKIP.add("existDependencyGenerationLevel");
        POPERTIES_TO_SKIP.add("includeSchemaNameInQuery");
        POPERTIES_TO_SKIP.add("incorrectSQL");
        POPERTIES_TO_SKIP.add("parsed");
        POPERTIES_TO_SKIP.add("validSQL");
        POPERTIES_TO_SKIP.add("nameFixed");
        POPERTIES_TO_SKIP.add("measurements");
        POPERTIES_TO_SKIP.add("usedDucuments");
        POPERTIES_TO_SKIP.add("changeRequests");
        POPERTIES_TO_SKIP.add("responsibleParties");
        POPERTIES_TO_SKIP.add("permittedStrTypes");
        POPERTIES_TO_SKIP.add("associations");
        POPERTIES_TO_SKIP.add("dependentColumns");
        POPERTIES_TO_SKIP.add("avTSortOrder");
        POPERTIES_TO_SKIP.add("constraintComment");
        POPERTIES_TO_SKIP.add("constraintNotes");
        POPERTIES_TO_SKIP.add("nullsAllowed");
        POPERTIES_TO_SKIP.add("oid");
        POPERTIES_TO_SKIP.add("structAttributeID");
        POPERTIES_TO_SKIP.add("synonym");
        POPERTIES_TO_SKIP.add("useDomainConstraints");
        POPERTIES_TO_SKIP.add("usesDefaultValue");
        POPERTIES_TO_SKIP.add("defaultdisplayAs");
        POPERTIES_TO_SKIP.add("defaultdisplayedOnForms");
        POPERTIES_TO_SKIP.add("defaultdisplayedOnReports");
        POPERTIES_TO_SKIP.add("defaultReadOnly");
        POPERTIES_TO_SKIP.add("autoIncrementGenerateAlways");
        POPERTIES_TO_SKIP.add("autoIncrementStartWith");
        POPERTIES_TO_SKIP.add("autoIncrementIncrementBy");
        POPERTIES_TO_SKIP.add("autoIncrementCycle");
        POPERTIES_TO_SKIP.add("autoIncrementDisableCache");
        POPERTIES_TO_SKIP.add("autoIncrementOrder");
        POPERTIES_TO_SKIP.add("autoIncrementGenerateTrigger");
        POPERTIES_TO_SKIP.add("generateConstraintInDDL");
        POPERTIES_TO_SKIP.add("isDiscriminatorColumn");
        POPERTIES_TO_SKIP.add("isSurrogateColumn");
        POPERTIES_TO_SKIP.add("isRelationshipColumn");
        POPERTIES_TO_SKIP.add("isDependOnFK_AsMandatory");
        POPERTIES_TO_SKIP.add("columnGroups");
        POPERTIES_TO_SKIP.add("constraintCommentInRDBMS");
        POPERTIES_TO_SKIP.add("documents");
        POPERTIES_TO_SKIP.add("generatorID");
        POPERTIES_TO_SKIP.add("relationGeneratorID");
        POPERTIES_TO_SKIP.add("usedObjects");
        POPERTIES_TO_SKIP.add("schemaObject");
        POPERTIES_TO_SKIP.add("createdBy");
        POPERTIES_TO_SKIP.add("createdTime");
        POPERTIES_TO_SKIP.add("comment");
        POPERTIES_TO_SKIP.add("notes");
        POPERTIES_TO_SKIP.add("syntaxProvider");
        POPERTIES_TO_SKIP.add("usedDucuments");
        POPERTIES_TO_SKIP.add("logicalDatatype");
        POPERTIES_TO_SKIP.add("domain");
        POPERTIES_TO_SKIP.add("dataTypePrecision");
        POPERTIES_TO_SKIP.add("dataTypeScale");
        POPERTIES_TO_SKIP.add("dataTypeSize");
        POPERTIES_TO_SKIP.add("ownDataTypeParameters");
        POPERTIES_TO_SKIP.add("referredTableID");
        POPERTIES_TO_SKIP.add("keyObject");
        POPERTIES_TO_SKIP.add("containerWithKeyObject");
        POPERTIES_TO_SKIP.add("localFKIndex");
        POPERTIES_TO_SKIP.add("columnDependencyConstraintGenerateName");
        POPERTIES_TO_SKIP.add("columnDependencyConstraintGenerateInDDL");
        POPERTIES_TO_SKIP.add("discriminatorValue");
        POPERTIES_TO_SKIP.add("referredKeyID");
        POPERTIES_TO_SKIP.add("basedOnStructuredType");
        POPERTIES_TO_SKIP.add("structuredType");
        POPERTIES_TO_SKIP.add("collectionType");
        POPERTIES_TO_SKIP.add("startTimeColumn");
        POPERTIES_TO_SKIP.add("endTimeColumn");
        POPERTIES_TO_SKIP.add("spatialColumn");
        POPERTIES_TO_SKIP.add("spatialIndex");
        POPERTIES_TO_SKIP.add("having");
        POPERTIES_TO_SKIP.add("where");
        POPERTIES_TO_SKIP.add("layoutSQL");
        POPERTIES_TO_SKIP.add("useObjectsOnlyFrom");
        POPERTIES_TO_SKIP.add("originalTableID");
        POPERTIES_TO_SKIP.add("usedContainers");
        POPERTIES_TO_SKIP.add("id");
        POPERTIES_TO_SKIP.add("nameHasQuotes");
        POPERTIES_TO_SKIP.add("objectUser");
        POPERTIES_TO_SKIP.add("referredObjectID");
        POPERTIES_TO_SKIP.add("objNameHasQuotes");
        POPERTIES_TO_SKIP.add("storableNullInstance");
        POPERTIES_TO_SKIP.add("nullInstance");
        POPERTIES_TO_SKIP.add("rawObject");
        POPERTIES_TO_SKIP.add("nameChanged");
        POPERTIES_TO_SKIP.add("checkConstraint");
        refContained.put("segment", "segment");
        refContained.put("rollbackSegment", "rollbackSegment");
        refContained.put("lobStorage", "lobStorage");
        nameAsID.put("tableSpace", "tableSpace");
        nameAsID.put("tablespace", "tablespace");
        nameAsID.put("temporaryTablespace", "temporaryTablespace");
        nameAsID.put("xmlTypeTableSpace", "xmlTypeTableSpace");
        nameAsID.put("defTableSpace", "defTableSpace");
        nameAsID.put("temptableSpace", "temptableSpace");
        nameAsID.put("indexTablespace", "indexTablespace");
        nameAsID.put("workTablespace", "workTablespace");
        nameAsID.put("undoTablespace", "undoTablespace");
        nameAsID.put("catalogTableSpace", "catalogTableSpace");
        nameAsID.put("temporarytableSpace", "temporarytableSpace");
        nameAsID.put("userTableSpace", "userTableSpace");
        nameAsID.put("user", "user");
        nameAsID.put("existingIndex", "existingIndex");
        nameAsID.put("owner", "owner");
        nameAsID.put("level", "level");
        nameAsID.put("onPrebuiltTable", "onPrebuiltTable");
        namesWithQuotes.put("name", "name");
        namesWithQuotes.put("sourceObjName", "sourceObjName");
    }
}

