/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.dbtools.crest.model.IDReplacer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.JSONObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSONToObjectTransformer
extends MDTransformer
implements MDXMLConstants {
    public static boolean processCreatedTime = true;
    public static boolean checkForChanges = false;
    public static boolean checkShouldMerge = false;
    private static StorageDesign sourceStorageDesign;
    private static final Logger LOGGER;

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        MDTransformationManager.TrObjects trs = this.getTransformationManager().getTransformersFor(object.getClass());
        JSONToObjectTransformer tr = (JSONToObjectTransformer)trs.getFromObjectTransformer();
        if (tr != null) {
            return tr.transformFromObjectToString(object, excludeProps);
        }
        return null;
    }

    public void transformToObject(Object object, String json, List excludeProps) {
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (stream != null) {
            this.transformToObject(object, stream, excludeProps);
        }
    }

    public void transformToObject(Object object, File file, List excludeProps) throws FileNotFoundException, UnsupportedEncodingException {
        this.transformToObject(object, file, excludeProps);
    }

    public void transformToObject(Object object, File file, boolean processExternals, List excludeProps) throws FileNotFoundException, UnsupportedEncodingException {
        try {
            FileInputStream is = new FileInputStream(file);
            if (is != null) {
                this.transformToObject(object, is, processExternals, true, excludeProps);
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public void transformToObject(Object object, InputStream is, List excludeProps) {
        this.transformToObject(object, is, false, excludeProps);
    }

    public void transformToObject(Object object, InputStream stream, boolean processExternals, List excludeProps) {
        this.transformToObject(object, stream, processExternals, false, excludeProps);
    }

    public void transformToObject(InputStream stream, boolean processExternals, List excludeProps) {
        this.transformToObject(null, stream, processExternals, processExternals, excludeProps);
    }

    public void transformToObject(Object object, InputStream stream, boolean processExternals, boolean setID, List excludeProps) {
        JsonObject jdoc = null;
        try {
            jdoc = Json.createReader((InputStream)stream).readObject();
            this.transformToObject(object, jdoc, processExternals, setID, excludeProps);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getSchemaNameID(Object object, JsonObject jdoc) {
        Object id = "";
        String name = null;
        String schema = null;
        name = JSONToObjectTransformer.getString(jdoc, "name");
        schema = JSONToObjectTransformer.getString(jdoc, "schema");
        String type = null;
        if (object instanceof ModelIDObject) {
            type = ((ModelIDObject)object).getExtendedObjectTypeName();
        }
        if (name != null) {
            id = schema != null ? schema + "." + name : name;
        }
        if (type != null && !type.isEmpty()) {
            id = type + "." + (String)id;
        }
        return id;
    }

    public void transformToObject(Object object, JsonObject jdoc, boolean processExternals, boolean setID, List excludeProps) {
        if (jdoc != null) {
            try {
                if (setID) {
                    String id = this.getID(jdoc);
                    if (id == null || id.isEmpty()) {
                        id = JSONToObjectTransformer.getSchemaNameID(object, jdoc);
                    }
                    if (object instanceof ModelIDObject && id != null && !id.isEmpty()) {
                        ((ModelIDObject)object).setObjectID(id);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in transformToObject(Object object, JsonObject jdoc, boolean processExternals, boolean setID, List excludeProps)", e);
            }
            this.transformToObject(object, jdoc, processExternals, excludeProps);
        }
    }

    public void transformToObject(Object object, JsonObject doc, List excludeProps) {
        this.transformToObject(object, doc, false, excludeProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformToObject1(Object object, JsonObject root, boolean processExternals, List excludeProps) {
        if (root != null) {
            ModelIDObject obj = null;
            String old = null;
            String newstr = null;
            String changedTime = null;
            if (!processExternals && checkForChanges && object instanceof ModelIDObject && !(obj = (ModelIDObject)object).isDirty()) {
                try {
                    MDTransformer.includeLoggingProps = false;
                    MDTransformer.includeID = false;
                    old = this.transformFromObjectToString(object, excludeProps);
                    changedTime = obj.getChangedTime();
                }
                finally {
                    MDTransformer.includeLoggingProps = true;
                    MDTransformer.includeID = true;
                }
            }
            if (object instanceof Domain) {
                this.transformToDomain((Domain)object, root, processExternals, excludeProps);
            } else {
                this.transformToObject(object, root, processExternals, excludeProps);
            }
            if (old != null && obj != null && changedTime != null) {
                try {
                    MDTransformer.includeLoggingProps = false;
                    MDTransformer.includeID = false;
                    newstr = this.transformFromObjectToString(object, excludeProps);
                    changedTime = obj.getChangedTime();
                }
                finally {
                    MDTransformer.includeLoggingProps = true;
                    MDTransformer.includeID = true;
                }
                if (old.equals(newstr)) {
                    obj.setChangedTime(changedTime);
                }
            }
        }
    }

    private void transformToDomain(Domain domain, JsonObject rootElement, boolean processExternals, List excludeProps) {
    }

    public void transformToObject(Object object, JsonObject rootElement, boolean processExternals, List excludeProps) {
        boolean process;
        Object physComparatorsMap = null;
        if (checkShouldMerge && object instanceof ModelIDObject && !(process = StorageDesign.shouldMerge((ModelIDObject)object, true))) {
            return;
        }
        ClassDescription cd = this.getClassDescription();
        Map propsMap = this.loadElements(rootElement, excludeProps);
        ArrayList<ClassDescription.PropertyDescription> loggingProps = new ArrayList<ClassDescription.PropertyDescription>();
        ArrayList<ClassDescription.PropertyDescription> afterCollectionsProcessing = new ArrayList<ClassDescription.PropertyDescription>();
        ArrayList<ClassDescription.PropertyDescription> collectionDependentProcessing = new ArrayList<ClassDescription.PropertyDescription>();
        List<ClassDescription.PropertyDescription> propsList = cd.getPropertiesList();
        for (ClassDescription.PropertyDescription pd : propsList) {
            if (pd.isExternalProperty && !processExternals) continue;
            if (pd.isLoggingProp) {
                loggingProps.add(pd);
                continue;
            }
            if (pd.isAfterCollectionProcessing) {
                afterCollectionsProcessing.add(pd);
                continue;
            }
            if (pd.beforeCollection != null && !"".equals(pd.beforeCollection) || pd.afterCollection != null && !"".equals(pd.afterCollection)) {
                collectionDependentProcessing.add(pd);
                continue;
            }
            this.processProperty(object, propsMap, rootElement, pd, processExternals, excludeProps);
        }
        this.processClassPropertyMap(object, propsMap, cd);
        if (processExternals && cd.isCreateAllExtItemsFirst) {
            this.createAllExtItemsFirst(object, propsMap, rootElement, cd, processExternals);
        }
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            if (cold.isExternalCollection && !processExternals) continue;
            if (cold.preProcess != null) {
                this.invokeMethod(object, cold.preProcess);
            }
            this.processBeforeCollection(object, propsMap, rootElement, cold, collectionDependentProcessing, processExternals, excludeProps);
            if (cold.createAllItemsFirst) {
                this.createAllItemsFirst(object, propsMap, rootElement, cold, processExternals);
            }
            this.processCollection(object, propsMap, rootElement, cold, processExternals, excludeProps);
            this.processAfterCollection(object, propsMap, rootElement, cold, collectionDependentProcessing, processExternals, excludeProps);
        }
        for (ClassDescription.PropertyDescription pd : afterCollectionsProcessing) {
            if (pd.isExternalProperty && !processExternals) continue;
            this.processProperty(object, propsMap, rootElement, pd, processExternals, excludeProps);
        }
        this.processProxyProperties(object, propsMap, rootElement, cd, processExternals, excludeProps);
        for (ClassDescription.PropertyDescription pd : loggingProps) {
            this.processProperty(object, propsMap, rootElement, pd, processExternals, excludeProps);
        }
        this.invokeMethod(object, cd.afterInit);
        if (processExternals) {
            this.invokeMethod(object, cd.afterInitExt);
        }
    }

    private void processProxyProperties(Object object, Map propsMap, JsonObject rootElement, ClassDescription cd, boolean processExternals, List excludeProps) {
        try {
            for (ClassDescription.ProxyProperties pp : cd.proxyProperties) {
                Object obj;
                if (pp.proxyGetter == null || (obj = JSONToObjectTransformer.getObject(object, pp.proxyGetter)) == null || pp.proxyClass == null || !pp.proxyClass.isAssignableFrom(obj.getClass())) continue;
                for (ClassDescription.PropertyDescription pd : pp.proxyProperties) {
                    this.processProperty(obj, propsMap, rootElement, pd, processExternals, excludeProps);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processBeforeCollection(Object container, Map propsMap, JsonObject root, ClassDescription.CollectionDescription cold, List props, boolean processExternals, List excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.beforeCollection == null || cold.name == null || !cold.name.equals(pd.beforeCollection)) continue;
            this.processProperty(container, propsMap, root, pd, processExternals, excludeProps);
        }
    }

    private void processAfterCollection(Object container, Map propsMap, JsonObject root, ClassDescription.CollectionDescription cold, List props, boolean processExternals, List excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.afterCollection == null || cold.name == null || !cold.name.equals(pd.afterCollection)) continue;
            this.processProperty(container, propsMap, root, pd, processExternals, excludeProps);
        }
    }

    private void processClassPropertyMap(Object object, Map propsMap, ClassDescription cd) {
        if (cd.isPropertyMap && object instanceof PropertyMap) {
            PropertyMap pmap = (PropertyMap)object;
            JsonValue elem = (JsonValue)propsMap.get("propertyMap");
            if (elem instanceof JsonObject) {
                JsonObject element = (JsonObject)elem;
                pmap.clearProperties();
                if (element != null) {
                    for (Map.Entry entry : element.entrySet()) {
                        String name = (String)entry.getKey();
                        String evalue = JSONToObjectTransformer.getString((JsonValue)entry.getValue());
                        if (name == null || evalue == null || "".equals(name)) continue;
                        pmap.setProperty(StringUtilities.decodeAttributeValueJSON(name), StringUtilities.decodeAttributeValueJSON(evalue));
                    }
                }
            }
        }
    }

    public static String getString(JsonValue value) {
        String res = "";
        res = value.toString();
        if (res.equals("\"\"")) {
            res = "";
        } else if (res.startsWith("\"") && res.endsWith("\"")) {
            res = res.substring(1, res.length() - 1);
        }
        return res;
    }

    private void processProperty(Object object, Map propsMap, JsonObject root, ClassDescription.PropertyDescription pd, boolean processExternals, List excludeProps) {
        if (pd.isCreatedTimeProp && !processCreatedTime) {
            return;
        }
        String value = null;
        boolean isnested = JSONObjToStreamTransformer.isJSONNested(pd);
        boolean useDefault = false;
        JsonValue node = (JsonValue)propsMap.get(pd.xmlName);
        if (node == null && pd.oldXmlName != null) {
            node = (JsonValue)propsMap.get(pd.oldXmlName);
        }
        if (node != null) {
            if (node.getValueType() != JsonValue.ValueType.OBJECT) {
                value = JSONToObjectTransformer.getString(node);
            } else {
                JsonObject element = (JsonObject)node;
                if (pd.isRectangle) {
                    this.processRectangle(element, object, pd);
                    return;
                }
                if (pd.isPropertyMap) {
                    this.processPropertyAsPropertyMap(object, element, pd);
                    return;
                }
                if (pd.isMap) {
                    this.processMapProperty(object, element, pd);
                    return;
                }
                if (!(pd.isSimpleClass() || pd.isStringClass() || pd.isReferred() && !isnested || pd.isReferred() && !isnested)) {
                    JSONToObjectTransformer tr;
                    MDTransformationManager.TrObjects trs;
                    Object nested = JSONToObjectTransformer.getObjectForProperty(object, pd);
                    if (nested == null) {
                        if (pd.createProperty != null) {
                            nested = this.createObject(object, pd.createProperty);
                        } else if ("segment".equalsIgnoreCase(pd.name) && object instanceof StorageObject) {
                            StorageObject sto = (StorageObject)object;
                            StorageDesignOracle sd = (StorageDesignOracle)sto.getStorageDesign();
                            SegmentOracle seg = sd.createSegmentOracle();
                            nested = seg;
                            Method method = pd.setter;
                            if (method != null) {
                                try {
                                    method.invoke(object, seg);
                                }
                                catch (IllegalAccessException e) {
                                    LOGGER.error("No access rights for setter method", e);
                                }
                                catch (IllegalArgumentException e) {
                                    LOGGER.error("Illegal argument for setter", e);
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                    LOGGER.error("Invocation error for setter", e);
                                }
                                catch (Exception e) {
                                    Logger.error(e);
                                }
                            }
                        }
                    }
                    if (nested != null && (trs = this.getTransformationManager().getTransformersFor(nested.getClass())) != null && trs.getFromJsonToObjectTransformer() != null && trs.getFromJsonToObjectTransformer() instanceof JSONToObjectTransformer && (tr = (JSONToObjectTransformer)trs.getFromJsonToObjectTransformer()) != null) {
                        tr.transformToObject(nested, element, processExternals, excludeProps);
                        if (pd.setter != null) {
                            this.setObjectForProperty(object, pd, nested);
                        }
                    }
                    return;
                }
            }
        } else {
            boolean bl = useDefault = !pd.isSimpleClass();
            if (pd.isStringClass()) {
                value = "";
            }
        }
        if (useDefault) {
            if (excludeProps != null) {
                if (!excludeProps.contains(pd.name)) {
                    this.setDefaultProperty(object, pd);
                }
            } else {
                this.setDefaultProperty(object, pd);
            }
        } else {
            if (value == null) {
                value = pd.defaultValue;
            } else {
                value = StringUtilities.decodeAttributeValueJSON(value);
                if (pd.isID || pd.isListOfRefs) {
                    if (object instanceof ModelIDObject) {
                        value = ((ModelIDObject)object).replaceIDsInValue(value);
                    } else if (object instanceof IDReplacer) {
                        value = ((IDReplacer)object).replaceIDsInValue(value);
                    }
                }
            }
            value = this.procesQuotedNames(object, value, pd);
            this.setProperty(object, value, pd);
        }
    }

    String procesQuotedNames(Object object, String value, ClassDescription.PropertyDescription pd) {
        if (object instanceof ModelObject) {
            ModelObject obj = (ModelObject)object;
            if ("name".equalsIgnoreCase(pd.name) || "sourceObjName".equalsIgnoreCase(pd.name) || "sourceObjSchema".equalsIgnoreCase(pd.name)) {
                String res = value;
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    res = value.substring(1, value.length() - 1);
                } else if (value.startsWith("\\\"") && value.endsWith("\\\"")) {
                    res = value.substring(2, value.length() - 2);
                }
                if (!res.equals(value) && "name".equalsIgnoreCase(pd.name)) {
                    obj.setNameHasQuotes(true);
                }
                return res;
            }
        }
        return value;
    }

    private void processPropertyAsPropertyMap(Object object, JsonObject pmElement, ClassDescription.PropertyDescription pd) {
        Object obj = JSONToObjectTransformer.getObjectForProperty(object, pd);
        boolean created = false;
        if (obj == null) {
            obj = this.createObject(object, pd.createPMap);
            created = true;
        }
        if (obj instanceof PropertyMap) {
            PropertyMap pm = (PropertyMap)obj;
            if (!created) {
                pm.clearProperties();
            }
            if (pmElement != null) {
                for (Map.Entry entry : pmElement.entrySet()) {
                    String name = (String)entry.getKey();
                    String evalue = JSONToObjectTransformer.getString((JsonValue)entry.getValue());
                    if (name == null || evalue == null || "".equals(name)) continue;
                    pm.setProperty(StringUtilities.decodeAttributeValueJSON(name), StringUtilities.decodeAttributeValueJSON(evalue));
                }
            }
            if (created) {
                this.setObjectForProperty(object, pd, obj);
            }
        }
    }

    private void processMapProperty(Object object, JsonObject pmElement, ClassDescription.PropertyDescription pd) {
        Object obj = JSONToObjectTransformer.getObjectForProperty(object, pd);
        if (obj != null && obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : pmElement.entrySet()) {
                String name = (String)entry.getKey();
                String evalue = JSONToObjectTransformer.getString((JsonValue)entry.getValue());
                if (name == null || evalue == null || "".equals(name)) continue;
                map.put(StringUtilities.decodeAttributeValueJSON(name), StringUtilities.decodeAttributeValueJSON(evalue));
            }
        }
    }

    private void processCollection(Object container, Map propsMap, JsonObject root, ClassDescription.CollectionDescription cold, boolean processExternals, List excludeProps) {
        JsonValue element = (JsonValue)propsMap.get(cold.xmlName);
        if (cold.itemIsRef && cold.listOfRefs && element instanceof JsonObject) {
            this.processListOfRefs(container, (JsonObject)element, cold, excludeProps);
        } else if (element != null && element instanceof JsonArray) {
            JsonArray array;
            if (this.canProcessCollectionItem(cold)) {
                List oldItems = this.getListWithElements(container, cold);
                ArrayList newItems = new ArrayList();
                if (!cold.itemIsRef) {
                    this.processCollectionWithContained(container, (JsonArray)element, cold, newItems, oldItems, processExternals, excludeProps);
                } else {
                    this.processCollectionWithRefs(container, (JsonArray)element, cold, newItems);
                }
                if (cold.applyList == null) {
                    JSONToObjectTransformer.orderAndClearList(container, cold, oldItems, newItems);
                } else {
                    JSONToObjectTransformer.applyList(container, cold.applyList, newItems);
                }
            } else if (cold.isMapItem && cold.applyList != null && (array = (JsonArray)element).size() > 0) {
                ArrayList list = new ArrayList();
                for (JsonValue value : array) {
                    if (!(value instanceof JsonObject)) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                        String name = (String)entry.getKey();
                        String evalue = JSONToObjectTransformer.getString((JsonValue)entry.getValue());
                        map.put(StringUtilities.decodeAttributeValueJSON(name), StringUtilities.decodeAttributeValueJSON(evalue));
                    }
                    list.add(map);
                }
                JSONToObjectTransformer.applyList(container, cold.applyList, list);
            }
        } else if (this.canProcessCollectionItem(cold)) {
            List oldItems = this.getListWithElements(container, cold);
            JSONToObjectTransformer.orderAndClearList(container, cold, oldItems, Collections.EMPTY_LIST);
        } else if (cold.isMapItem && cold.applyList != null) {
            JSONToObjectTransformer.applyList(container, cold.applyList, Collections.EMPTY_LIST);
        }
    }

    private void createAllItemsFirst(Object container, Map propsMap, JsonObject root, ClassDescription.CollectionDescription cold, boolean processExternals) {
        JsonValue element = (JsonValue)propsMap.get(cold.xmlName);
        if (element != null && element instanceof JsonArray && this.canProcessCollectionItem(cold)) {
            List oldItems = this.getListWithElements(container, cold);
            ArrayList newItems = new ArrayList();
            if (!cold.itemIsRef) {
                this.createAllContained(container, (JsonArray)element, cold, newItems, oldItems, processExternals);
            }
            if (cold.applyList == null) {
                JSONToObjectTransformer.orderAndClearList(container, cold, oldItems, newItems);
            } else {
                JSONToObjectTransformer.applyList(container, cold.applyList, newItems);
            }
        }
    }

    private void createAllExtItemsFirst(Object container, Map propsMap, JsonObject root, ClassDescription cd, boolean processExternals) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            JsonValue element;
            if (!cold.isExternalCollection || !processExternals || (element = (JsonValue)propsMap.get(cold.xmlName)) == null || !(element instanceof JsonArray) || !this.canProcessCollectionItem(cold)) continue;
            List oldItems = this.getListWithElements(container, cold);
            ArrayList newItems = new ArrayList();
            if (!cold.itemIsRef) {
                this.createAllContained(container, (JsonArray)element, cold, newItems, oldItems, processExternals);
            }
            if (cold.applyList == null) {
                JSONToObjectTransformer.orderAndClearList(container, cold, oldItems, newItems);
                continue;
            }
            JSONToObjectTransformer.applyList(container, cold.applyList, newItems);
        }
    }

    private void createAllContained(Object container, JsonArray element, ClassDescription.CollectionDescription cold, List newItems, List oldItems, boolean processExternals) {
        for (JsonValue item : element) {
            Object object;
            if (!(item instanceof JsonObject) || (object = this.getOrCreateObject(container, (JsonObject)item, cold, oldItems)) == null) continue;
            if (cold.addItem != null) {
                this.addItem(container, cold.addItem, object);
            }
            newItems.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCollectionWithContained(Object container, JsonArray element, ClassDescription.CollectionDescription cold, List newItems, List oldItems, boolean processExternals, List excludeProps) {
        JSONToObjectTransformer tr = null;
        for (JsonValue val : element) {
            JsonObject item = (JsonObject)val;
            Object object = this.getOrCreateObject(container, item, cold, oldItems);
            if (object == null) continue;
            String id = "";
            if (object instanceof ModelIDObject) {
                id = ((ModelIDObject)object).getObjectID();
            }
            try {
                if (object instanceof StorageDesign) {
                    ((StorageDesign)object).setLoading(true);
                }
                if (tr == null) {
                    MDTransformationManager.TrObjects trs = this.getTransformationManager().getTransformersFor(object.getClass());
                    tr = (JSONToObjectTransformer)trs.getFromJsonToObjectTransformer();
                }
                if (tr != null) {
                    tr.transformToObject(object, item, processExternals, excludeProps);
                }
                this.processTopView(object, item);
                if (cold.addItem != null) {
                    this.addItem(container, cold.addItem, object);
                }
                if (object instanceof ModelIDObject) {
                    String nid = ((ModelIDObject)object).getObjectID();
                    if (id != null) {
                        ((ModelIDObject)object).setObjectID(((ModelIDObject)object).getExtendedObjectTypeName() + "." + id);
                    }
                }
                newItems.add(object);
            }
            finally {
                if (!(object instanceof StorageDesign)) continue;
                ((StorageDesign)object).setLoading(false);
                ((StorageDesign)object).setOpen(true);
            }
        }
    }

    public static List<Map> getArrayAsListOfMaps(JsonArray array) {
        ArrayList<Map> list = new ArrayList<Map>();
        if (array.size() > 0) {
            for (JsonValue value : array) {
                if (!(value instanceof JsonObject)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                    String name = (String)entry.getKey();
                    String evalue = JSONToObjectTransformer.getString((JsonValue)entry.getValue());
                    map.put(StringUtilities.decodeAttributeValueJSON(name), StringUtilities.decodeAttributeValueJSON(evalue));
                }
                list.add(map);
            }
        }
        return list;
    }

    private void processTopView(Object object, JsonObject item) {
    }

    private void processRectangle(JsonObject propElement, Object object, ClassDescription.PropertyDescription pd) {
    }

    private void processPointsCollection(Element element, Object object) {
    }

    public static Element getFirstChildByTagName(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !((Element)child).getTagName().equals(tagName)) continue;
            return (Element)child;
        }
        return null;
    }

    private Object getOrCreateObject(Object container, JsonObject item, ClassDescription.CollectionDescription cold, List oldItems) {
        if (cold.isPhysicalModelItem && container instanceof RelationalDesign) {
            return this.getOrCreateStorageDesign((RelationalDesign)container, item, cold);
        }
        Object id = this.getID(item);
        Object object = null;
        if (id != null) {
            if (cold.getItemByID != null) {
                object = this.getItemByID(container, cold.getItemByID, (String)id);
            } else if (container instanceof DesignObject || container instanceof DesignPart) {
                object = ((ModelIDObject)container).getDesign().getDesignObject((String)id);
            } else if (container instanceof StorageObject) {
                ModelIDObject sourceStorageObject;
                if (checkShouldMerge && sourceStorageDesign != null && (sourceStorageObject = sourceStorageDesign.getModelIDObject((String)id)) != null && !sourceStorageObject.shouldBeMerge()) {
                    return null;
                }
                object = ((StorageObject)container).getStorageDesign().getStorageObject((String)id);
            } else {
                object = container instanceof StorageDesign ? ((StorageDesign)container).getStorageObject((String)id) : this.getItemByID(oldItems, (String)id, cold);
            }
        }
        if (id == null && container instanceof ModelIDObject) {
            String parent = ((ModelIDObject)container).getLongName(true);
            JsonString js = item.getJsonString("name");
            if (js != null) {
                id = parent + "." + js.getString();
            }
        }
        if (object == null) {
            if (cold.isProxyitem) {
                if (container instanceof ID_ObjectPropertyTranslator) {
                    String clazz = null;
                    try {
                        clazz = item.getString("class");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(clazz, (String)id);
                }
            } else {
                if (cold.getItemByID == null && container instanceof ID_ObjectPropertyTranslator) {
                    object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.itemXmlName, (String)id);
                }
                if (object == null) {
                    object = this.createItem(container, cold.createItem);
                    if (object instanceof ModelIDObject && id != null) {
                        ((ModelIDObject)object).setObjectID((String)id);
                    }
                    return object;
                }
            }
        }
        if (object instanceof TableProxyOracle) {
            ((TableProxyOracle)object).setUser(null);
        }
        if (!checkShouldMerge && object instanceof ModelIDObject && id != null) {
            ((ModelIDObject)object).setObjectID((String)id);
        }
        return object;
    }

    @Override
    Object getItemByID(List oldItems, String id, ClassDescription.CollectionDescription cold) {
        for (Object obj : oldItems) {
            if (obj instanceof ModelIDObject) {
                if (!((ModelIDObject)obj).getObjectID().equals(id)) continue;
                return obj;
            }
            return null;
        }
        return null;
    }

    public static String getString(JsonObject object, String key) {
        JsonString js = object.getJsonString(key);
        if (js != null) {
            return JSONToObjectTransformer.getString((JsonValue)js);
        }
        return null;
    }

    public static String getDecodedString(JsonObject object, String key) {
        JsonValue js = (JsonValue)object.get((Object)key);
        if (js != null && js instanceof JsonString) {
            String value = JSONToObjectTransformer.getString(js);
            if (value != null && !value.isEmpty()) {
                value = StringUtilities.decodeAttributeValueJSON(value);
            }
            return value;
        }
        if (!(js instanceof JsonObject)) {
            return JSONToObjectTransformer.getString(js);
        }
        return null;
    }

    private Object getOrCreateStorageDesign(RelationalDesign rd, JsonObject item, ClassDescription.CollectionDescription cold) {
        JsonString siteTypeElm;
        String siteID = item.getString("siteID");
        RDBMSSite site = rd.getDesign().getRDBMSSiteSet().getByObjectID(siteID);
        if (site == null && (siteTypeElm = item.getJsonString("siteType")) != null) {
            String siteType = siteTypeElm.getString();
            String siteOID = JSONToObjectTransformer.getString(item, "siteID");
            String siteName = JSONToObjectTransformer.getString(item, "siteName");
            site = rd.getDesign().getRDBMSSiteSet().createSite(siteName, rd.getDesign());
            int type = 9;
            try {
                type = Integer.parseInt(siteType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RDBMSType rdbmsType = Design.getDefaultRDBMSTypeSet().get(type);
            site.setType(rdbmsType);
            site.setObjectID(siteOID);
            site.setPathID(rd.getDesign().getRDBMSSiteSet().nextIndex());
        }
        if (site != null) {
            boolean exists = rd.getStorageDesignFactory().existStorageDesign(site);
            StorageDesign stoDes = rd.getStorageDesign(site);
            if (stoDes != null) {
                stoDes.setTempModel(false);
                if (exists && !rd.getDesign().isNewDesign()) {
                    stoDes.openStorageDesign();
                }
            }
            return stoDes;
        }
        return null;
    }

    private void processCollectionWithRefs(Object container, JsonArray element, ClassDescription.CollectionDescription cold, List newItems) {
        Object obj;
        ArrayList<String> idslist = new ArrayList<String>();
        for (int i = 0; i < element.size(); ++i) {
            JsonValue val = (JsonValue)element.get(i);
            if (val == null) continue;
            idslist.add(JSONToObjectTransformer.getString(val));
        }
        List target = null;
        if (cold.nativeList && cold.addItem == null && (obj = JSONToObjectTransformer.getCollection(container, cold)) instanceof List) {
            target = (List)obj;
        }
        for (String id : idslist) {
            Object object = this.getItemByID(container, cold.getItemByID, id);
            if (object == null && container instanceof ID_ObjectPropertyTranslator && (object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.xmlName, id)) != null) {
                if (cold.addItem != null) {
                    this.addItem(container, cold.addItem, object);
                } else if (cold.nativeList && target != null) {
                    target.add(object);
                }
            }
            if (object == null) continue;
            newItems.add(object);
        }
    }

    private void processListOfRefs(Object container, JsonObject element, ClassDescription.CollectionDescription cold, List newItems) {
        Object obj;
        String refs;
        ArrayList<String> idslist = new ArrayList<String>();
        if (cold.listOfRefs && (refs = JSONToObjectTransformer.getString(element, cold.refsXMLName)) != null && !"".equals(refs)) {
            String[] ids = refs.split(" ");
            for (int i = 0; i < ids.length; ++i) {
                idslist.add(ids[i]);
            }
        }
        List target = null;
        if (cold.nativeList && cold.addItem == null && (obj = JSONToObjectTransformer.getCollection(container, cold)) instanceof List) {
            target = (List)obj;
        }
        for (String id : idslist) {
            Object object = this.getItemByID(container, cold.getItemByID, id);
            if (object == null && container instanceof ID_ObjectPropertyTranslator && (object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.xmlName, id)) != null) {
                if (cold.addItem != null) {
                    this.addItem(container, cold.addItem, object);
                } else if (cold.nativeList && target != null) {
                    target.add(object);
                }
            }
            if (object == null) continue;
            newItems.add(object);
        }
    }

    private String getID(JsonObject element) {
        JsonString id = element.getJsonString("id");
        if ((id == null || "".equals(JSONToObjectTransformer.getString((JsonValue)id))) && (id = element.getJsonString("objectID")) != null && "".equals(JSONToObjectTransformer.getString((JsonValue)id)) && (id = element.getJsonString("IDREF")) != null && "".equals(JSONToObjectTransformer.getString((JsonValue)id))) {
            return null;
        }
        if (id != null) {
            return JSONToObjectTransformer.getString((JsonValue)id);
        }
        return null;
    }

    private Map loadElements(JsonObject root, List excludeProps) {
        HashMap map = new HashMap();
        for (Map.Entry entry : root.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static void setSourceStorageDesign(StorageDesign storageDesign) {
        sourceStorageDesign = storageDesign;
    }

    @Override
    public Object getOrCreateObjectByName(Object object, String value, ClassDescription.PropertyDescription pd) {
        if (value != null && !value.isEmpty()) {
            String pname = pd.name;
            if (object instanceof StorageObject) {
                StorageObject sto = (StorageObject)object;
                if ("user".equalsIgnoreCase(pname) || "owner".equalsIgnoreCase(pname)) {
                    return ((StorageDesignOracle)sto.getStorageDesign()).getOrCreateUserByName(value.trim());
                }
                if ("segment".equalsIgnoreCase(pname)) {
                    StorageDesignOracle sd = (StorageDesignOracle)sto.getStorageDesign();
                    return sd.createSegmentOracle();
                }
            } else if ("schema".equalsIgnoreCase(pname) && object instanceof ContainerObject) {
                UserOracle user;
                ContainerObject cob = (ContainerObject)object;
                RelationalDesign rd = (RelationalDesign)cob.getDesignPart();
                String schema = value.trim();
                SchemaObject so = (SchemaObject)rd.getSchemaObjectSet().getByName(schema);
                if (so == null) {
                    so = rd.getSchemaObjectSet().createSchemaObject(null);
                    so.setName(schema);
                }
                if ((user = ((StorageDesignOracle)rd.getStorageDesign()).getOrCreateUserByName(schema)).getSchemaObject() == null) {
                    user.setSchemaObject(so);
                }
            } else if ("tableSpace".equalsIgnoreCase(pname) && object instanceof ContainerObject) {
                ContainerObject cob = (ContainerObject)object;
                RelationalDesign rd = (RelationalDesign)cob.getDesignPart();
                String name = value.trim();
                TableSpaceOracle t = ((StorageDesignOracle)rd.getStorageDesign()).getOrCreateTablespaceByName(name);
                return t;
            }
        }
        return null;
    }

    static {
        LOGGER = new Logger(JSONToObjectTransformer.class);
    }
}

